/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.torrents;

import java.util.Set;
import org.nzbhydra.api.WrongApiKeyException;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.downloading.DownloadResult;
import org.nzbhydra.downloading.InvalidSearchResultIdException;
import org.nzbhydra.downloading.SaveOrSendResultsResponse;
import org.nzbhydra.downloading.torrents.TorrentFileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TorrentHandlingWeb {
    private static final Logger logger = LoggerFactory.getLogger(TorrentHandlingWeb.class);
    @Autowired
    private TorrentFileHandler torrentHandler;
    @Autowired
    private ConfigProvider configProvider;

    @RequestMapping(value={"/internalapi/torrent/{guid}"}, produces={"application/x-bittorrent"})
    @Secured(value={"ROLE_USER"})
    public ResponseEntity<Object> downloadTorrentInternal(@PathVariable(value="guid") long guid) throws InvalidSearchResultIdException {
        return this.torrentHandler.getTorrentByGuid(guid, this.configProvider.getBaseConfig().getDownloading().getNzbAccessType(), SearchSource.INTERNAL).getAsResponseEntity();
    }

    @RequestMapping(value={"/gettorrent/user/{guid}"})
    @Secured(value={"ROLE_USER"})
    public ResponseEntity<Object> downloadTorrentForUsers(@PathVariable(value="guid") long guid) throws InvalidSearchResultIdException {
        DownloadResult downloadResult = this.torrentHandler.getTorrentByGuid(guid, this.configProvider.getBaseConfig().getDownloading().getNzbAccessType(), SearchSource.INTERNAL);
        return downloadResult.getAsResponseEntity();
    }

    @RequestMapping(value={"/internalapi/saveOrSendTorrents"}, method={RequestMethod.PUT}, produces={"application/json"})
    @Secured(value={"ROLE_USER"})
    public SaveOrSendResultsResponse saveOrSendTorrents(@RequestBody Set<Long> searchResultIds) {
        return this.torrentHandler.saveOrSendTorrents(searchResultIds);
    }

    @RequestMapping(value={"/gettorrent/api/{guid}"}, produces={"application/x-bittorrent"})
    public ResponseEntity<Object> downloadTorrentWithApikey(@PathVariable(value="guid") long guid, @RequestParam(required=false) String apikey) throws WrongApiKeyException, InvalidSearchResultIdException {
        BaseConfig baseConfig = this.configProvider.getBaseConfig();
        if (apikey == null || !apikey.equals(baseConfig.getMain().getApiKey())) {
            logger.error("Received torrent API download call with wrong API key");
            throw new WrongApiKeyException("Wrong api key");
        }
        return this.torrentHandler.getTorrentByGuid(guid, baseConfig.getDownloading().getNzbAccessType(), SearchSource.API).getAsResponseEntity();
    }
}

