/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.emby;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.mapping.emby.EmbyItemsResponse;
import org.nzbhydra.webaccess.WebAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class EmbyWeb {
    private static final Logger logger = LoggerFactory.getLogger(EmbyWeb.class);
    @Autowired
    private WebAccess webAccess;
    @Autowired
    private ConfigProvider configProvider;

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/emby/isSeriesAvailable"}, method={RequestMethod.GET}, produces={"application/json"})
    public boolean isSeriesAvailable(@RequestParam String tvdbId) {
        String uriString = this.getUriBuilder().queryParam("IncludeItemTypes", new Object[]{"Series"}).queryParam("AnyProviderIdEquals", new Object[]{"tvdb." + tvdbId}).toUriString();
        try {
            EmbyItemsResponse response = (EmbyItemsResponse)this.webAccess.callUrl(uriString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return response.getTotalRecordCount() > 0;
        }
        catch (IOException e) {
            logger.error("Error calling Emby API", (Throwable)e);
            return false;
        }
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/emby/isMovieAvailable"}, method={RequestMethod.GET}, produces={"application/json"})
    public boolean isMovieAvailable(@RequestParam String tmdbId) {
        String uriString = this.getUriBuilder().queryParam("IncludeItemTypes", new Object[]{"Movies"}).queryParam("AnyProviderIdEquals", new Object[]{"tmdb." + tmdbId}).toUriString();
        try {
            EmbyItemsResponse response = (EmbyItemsResponse)this.webAccess.callUrl(uriString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return response.getTotalRecordCount() > 0;
        }
        catch (IOException e) {
            logger.error("Error calling Emby API", (Throwable)e);
            return false;
        }
    }

    @NotNull
    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configProvider.getBaseConfig().getEmby().getEmbyBaseUrl()).pathSegment(new String[]{"emby", "Items"}).queryParam("Recursive", new Object[]{"true"}).queryParam("api_key", new Object[]{this.configProvider.getBaseConfig().getEmby().getEmbyApiKey()});
    }
}

