/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.externaltools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.ConfigReaderWriter;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.externaltools.AddDialogInfo;
import org.nzbhydra.externaltools.AddRequest;
import org.nzbhydra.externaltools.ExternalTools;
import org.nzbhydra.externaltools.ExternalToolsSyncService;
import org.nzbhydra.externaltools.ExternalToolsWeb;
import org.nzbhydra.indexers.IndexerRepository;
import org.nzbhydra.web.UrlCalculator;
import org.nzbhydra.webaccess.WebAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExternalToolsWeb {
    private static final Logger logger = LoggerFactory.getLogger(ExternalToolsWeb.class);
    @Autowired
    private ExternalTools externalTools;
    @Autowired
    private UrlCalculator urlCalculator;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private IndexerRepository indexerRepository;
    private final ConfigReaderWriter configReaderWriter = new ConfigReaderWriter();
    @Autowired
    private ExternalToolsSyncService externalToolsSyncService;
    @Autowired
    private WebAccess webAccess;

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/externalTools/getDialogInfo"}, method={RequestMethod.GET}, produces={"application/json"})
    public AddDialogInfo getDialogInfo() {
        List indexers = this.configProvider.getBaseConfig().getIndexers();
        boolean usenetIndexersConfigured = indexers.stream().anyMatch(x -> x.getSearchModuleType() != SearchModuleType.TORZNAB);
        boolean torrentIndexersConfigured = indexers.stream().anyMatch(x -> x.getSearchModuleType() == SearchModuleType.TORZNAB);
        boolean prioritiesConfigured = indexers.stream().anyMatch(x -> x.getScore() > 0);
        return new AddDialogInfo(usenetIndexersConfigured, torrentIndexersConfigured, this.urlCalculator.getRequestBasedUriBuilder().build().toUriString(), prioritiesConfigured);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/externalTools/configure"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public Boolean configureExternalTool(@RequestBody AddRequest addRequest) throws IOException {
        return this.externalTools.addNzbhydraAsIndexer(addRequest);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/externalTools/messages"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<String> getMessages() {
        return this.externalTools.getMessages();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/externalTools/syncAll"}, method={RequestMethod.POST}, produces={"application/json"})
    public ExternalToolsSyncService.SyncResult syncAllTools() {
        return this.externalToolsSyncService.syncAllTools();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/externalTools/testConnection"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ConnectionTestResult testConnection(@RequestBody AddRequest addRequest) {
        try {
            return this.testSimpleConnection(addRequest.getXdarrHost(), addRequest.getXdarrApiKey());
        }
        catch (Exception e) {
            return new ConnectionTestResult(false, "Error: " + e.getMessage());
        }
    }

    private ConnectionTestResult testSimpleConnection(String host, String apiKey) {
        try {
            String cleanHost = host.endsWith("/") ? host.substring(0, host.length() - 1) : host;
            String apiUrl = cleanHost + "/api?apikey=" + apiKey;
            logger.debug("Testing connection to: {}", (Object)apiUrl);
            String response = this.webAccess.callUrl(URI.create(apiUrl).toString());
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(response);
            if (jsonNode.has("current")) {
                return new ConnectionTestResult(true, "Connection successful");
            }
            return new ConnectionTestResult(false, "Invalid response: missing 'current' field");
        }
        catch (Exception e) {
            logger.debug("Connection test failed", (Throwable)e);
            return new ConnectionTestResult(false, "Connection failed: " + e.getMessage());
        }
    }
}

