/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Joiner;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Strings;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerParsingException;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlItem;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="anizb")
@Scope(value="prototype")
public class Anizb
extends Indexer<NewznabXmlRoot> {
    private static final Logger logger = LoggerFactory.getLogger(Anizb.class);

    protected void completeIndexerSearchResult(NewznabXmlRoot response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        indexerSearchResult.setHasMoreResults(false);
        indexerSearchResult.setTotalResults(indexerSearchResult.getSearchResultItems().size());
        indexerSearchResult.setPageSize(100);
        indexerSearchResult.setOffset(0);
        indexerSearchResult.setTotalResultsKnown(true);
    }

    protected List<SearchResultItem> getSearchResultItems(NewznabXmlRoot rssRoot, SearchRequest searchRequest) throws IndexerParsingException {
        ArrayList<SearchResultItem> items = new ArrayList<SearchResultItem>();
        for (NewznabXmlItem rssItem : rssRoot.getRssChannel().getItems()) {
            SearchResultItem item = new SearchResultItem();
            item.setOriginalCategory("Anime");
            item.setTitle(rssItem.getTitle());
            item.setLink(rssItem.getLink());
            item.setIndexerGuid(rssItem.getRssGuid().getGuid());
            item.setSize(rssItem.getEnclosure().getLength());
            item.setPubDate(rssItem.getPubDate());
            item.setIndexerScore(Integer.valueOf(this.config.getScore()));
            item.setHasNfo(SearchResultItem.HasNfo.NO);
            item.setAgePrecise(true);
            item.setCategory(this.categoryProvider.getByInternalName("Anime"));
            item.setIndexer((Indexer)this);
            item.setDownloadType(DownloadType.NZB);
            items.add(item);
        }
        return items;
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        String query = super.generateQueryIfApplicable(searchRequest, "");
        if (Strings.isNullOrEmpty((String)(query = this.addRequiredWordsToQuery(searchRequest, query)))) {
            throw new IndexerSearchAbortedException("Anizb cannot search without a query");
        }
        query = this.cleanupQuery(query);
        return UriComponentsBuilder.fromHttpUrl((String)"https://anizb.org/api/").queryParam("q", new Object[]{query});
    }

    private String addRequiredWordsToQuery(SearchRequest searchRequest, String query) {
        List requiredWords = searchRequest.getInternalData().getRequiredWords();
        requiredWords.addAll(this.configProvider.getBaseConfig().getSearching().getRequiredWords());
        requiredWords.addAll(searchRequest.getCategory().getRequiredWords());
        if (!requiredWords.isEmpty()) {
            query = (String)query + (((String)query).isEmpty() ? "" : " ") + Joiner.on((String)" ").join((Iterable)requiredWords);
        }
        return query;
    }

    public NfoResult getNfo(String guid) {
        return NfoResult.withoutNfo();
    }

    protected NewznabXmlRoot getAndStoreResultToDatabase(URI uri, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        return (NewznabXmlRoot)this.getAndStoreResultToDatabase(uri, NewznabXmlRoot.class, apiAccessType);
    }

    protected Logger getLogger() {
        return logger;
    }
}

