/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import java.net.URI;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.nzbhydra.config.BaseConfigHandler;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.indexers.DetailsResult;
import org.nzbhydra.indexers.IndexerAccessResult;
import org.nzbhydra.indexers.IndexerApiAccessEntity;
import org.nzbhydra.indexers.IndexerApiAccessEntityShort;
import org.nzbhydra.indexers.IndexerApiAccessEntityShortRepository;
import org.nzbhydra.indexers.IndexerApiAccessRepository;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.indexers.IndexerRepository;
import org.nzbhydra.indexers.IndexerSearchResultPersistor;
import org.nzbhydra.indexers.IndexerWebAccess;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.QueryGenerator;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerAuthException;
import org.nzbhydra.indexers.exceptions.IndexerErrorCodeException;
import org.nzbhydra.indexers.exceptions.IndexerNoIdConversionPossibleException;
import org.nzbhydra.indexers.exceptions.IndexerParsingException;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.indexers.exceptions.IndexerUnreachableException;
import org.nzbhydra.indexers.status.IndexerLimitRepository;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.mediainfo.InfoProvider;
import org.nzbhydra.notifications.IndexerDisabledNotificationEvent;
import org.nzbhydra.notifications.IndexerReenabledNotificationEvent;
import org.nzbhydra.searching.CategoryProvider;
import org.nzbhydra.searching.CustomQueryAndTitleMappingHandler;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.searching.dtoseventsenums.FallbackSearchInitiatedEvent;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchFinishedEvent;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchMessageEvent;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.InternalData;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.springframework.aot.hint.annotation.Reflective;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Reflective
@Component
public abstract class Indexer<T> {
    protected static final List<Integer> DISABLE_PERIODS = Arrays.asList(0, 5, 15, 30, 60, 180);
    private static final Logger logger = LoggerFactory.getLogger(Indexer.class);
    private static final List<DateTimeFormatter> DATE_FORMATs = Arrays.asList(DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH));
    private final Object dbLock = "";
    @Autowired
    protected ConfigProvider configProvider;
    @Autowired
    protected IndexerRepository indexerRepository;
    @Autowired
    protected SearchResultRepository searchResultRepository;
    @Autowired
    protected IndexerApiAccessRepository indexerApiAccessRepository;
    @Autowired
    protected IndexerApiAccessEntityShortRepository indexerApiAccessShortRepository;
    @Autowired
    protected IndexerWebAccess indexerWebAccess;
    @Autowired
    protected SearchResultAcceptor resultAcceptor;
    @Autowired
    protected CategoryProvider categoryProvider;
    @Autowired
    protected InfoProvider infoProvider;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private QueryGenerator queryGenerator;
    @Autowired
    private CustomQueryAndTitleMappingHandler titleMapping;
    @Autowired
    protected BaseConfigHandler baseConfigHandler;
    @Autowired
    private IndexerSearchResultPersistor searchResultPersistor;
    protected IndexerEntity indexer;
    protected IndexerConfig config;
    private Pattern cleanupPattern;
    protected AutowireCapableBeanFactory beanFactory;

    protected Indexer() {
    }

    public Indexer(ConfigProvider configProvider, IndexerRepository indexerRepository, SearchResultRepository searchResultRepository, IndexerApiAccessRepository indexerApiAccessRepository, IndexerApiAccessEntityShortRepository indexerApiAccessShortRepository, IndexerLimitRepository indexerStatusRepository, IndexerWebAccess indexerWebAccess, SearchResultAcceptor resultAcceptor, CategoryProvider categoryProvider, InfoProvider infoProvider, ApplicationEventPublisher eventPublisher, QueryGenerator queryGenerator, CustomQueryAndTitleMappingHandler titleMapping, BaseConfigHandler baseConfigHandler, IndexerSearchResultPersistor persistor) {
        this.configProvider = configProvider;
        this.indexerRepository = indexerRepository;
        this.searchResultRepository = searchResultRepository;
        this.indexerApiAccessRepository = indexerApiAccessRepository;
        this.indexerApiAccessShortRepository = indexerApiAccessShortRepository;
        this.indexerWebAccess = indexerWebAccess;
        this.resultAcceptor = resultAcceptor;
        this.categoryProvider = categoryProvider;
        this.infoProvider = infoProvider;
        this.eventPublisher = eventPublisher;
        this.queryGenerator = queryGenerator;
        this.titleMapping = titleMapping;
        this.baseConfigHandler = baseConfigHandler;
        this.searchResultPersistor = persistor;
    }

    public void initialize(IndexerConfig config, IndexerEntity indexer) {
        this.indexer = indexer;
        this.config = config;
        if (this.queryGenerator == null) {
            logger.error("Indexer {} not properly initialized. No beans autowired.", (Object)config.getName());
        }
    }

    @EventListener
    public void handleNewConfig(ConfigChangedEvent configChangedEvent) {
        this.cleanupPattern = null;
    }

    public IndexerSearchResult search(SearchRequest searchRequest, int offset, Integer limit) {
        IndexerSearchResult indexerSearchResult;
        try {
            indexerSearchResult = this.buildSearchUrlAndCall(searchRequest, offset, limit);
            if (this.isFallbackRequired(searchRequest, indexerSearchResult)) {
                this.info("No results found for ID based search. Will do a fallback search using a generated query", new Object[0]);
                this.eventPublisher.publishEvent((Object)new IndexerSearchFinishedEvent(searchRequest));
                this.eventPublisher.publishEvent((Object)new SearchMessageEvent(searchRequest, "Indexer " + this.getName() + " did not return any results. Will do a fallback search", this.getName()));
                this.eventPublisher.publishEvent((Object)new FallbackSearchInitiatedEvent(searchRequest));
                searchRequest.getInternalData().setFallbackStateByIndexer(this.getName(), InternalData.FallbackState.REQUESTED);
                indexerSearchResult = this.buildSearchUrlAndCall(searchRequest, offset, limit);
                this.eventPublisher.publishEvent((Object)new SearchMessageEvent(searchRequest, indexerSearchResult.getTotalResults() + " results via fallback search from " + this.getName(), this.getName()));
            } else {
                this.eventPublisher.publishEvent((Object)new SearchMessageEvent(searchRequest, indexerSearchResult.getTotalResults() + " results via search from " + this.getName(), this.getName()));
            }
        }
        catch (IndexerNoIdConversionPossibleException e) {
            this.info(e.getMessage(), new Object[0]);
            indexerSearchResult = new IndexerSearchResult(this, e.getMessage());
            this.eventPublisher.publishEvent((Object)new SearchMessageEvent(searchRequest, e.getMessage()));
        }
        catch (IndexerSearchAbortedException e) {
            this.warn("Unexpected error while preparing search: " + e.getMessage());
            indexerSearchResult = new IndexerSearchResult(this, e.getMessage());
            this.eventPublisher.publishEvent((Object)new SearchMessageEvent(searchRequest, "Unexpected error while preparing search for indexer " + this.getName(), this.getName()));
        }
        catch (IndexerAccessException e) {
            this.handleIndexerAccessException(e, IndexerApiAccessType.SEARCH);
            indexerSearchResult = new IndexerSearchResult(this, e.getMessage());
            this.eventPublisher.publishEvent((Object)new SearchMessageEvent(searchRequest, "Error while accessing indexer " + this.getName(), this.getName()));
        }
        catch (Exception e) {
            if (e.getCause() instanceof InterruptedException) {
                this.debug("Hydra was shut down, ignoring InterruptedException", new Object[0]);
                indexerSearchResult = new IndexerSearchResult(this, e.getMessage());
            }
            this.error("Unexpected error while searching", (Throwable)e);
            this.eventPublisher.publishEvent((Object)new SearchMessageEvent(searchRequest, "Unexpected error while searching indexer " + this.getName(), this.getName()));
            try {
                this.handleFailure(e.getMessage(), Boolean.valueOf(false), IndexerApiAccessType.SEARCH, null, IndexerAccessResult.CONNECTION_ERROR);
            }
            catch (Exception e1) {
                this.error("Error while handling indexer failure. API access was not saved to database", (Throwable)e1);
            }
            indexerSearchResult = new IndexerSearchResult(this, e.getMessage());
        }
        this.eventPublisher.publishEvent((Object)new IndexerSearchFinishedEvent(searchRequest));
        return indexerSearchResult;
    }

    private boolean isFallbackRequired(SearchRequest searchRequest, IndexerSearchResult indexerSearchResult) {
        InternalData.FallbackState fallbackStateByIndexer = searchRequest.getInternalData().getFallbackStateByIndexer(this.getName());
        if (indexerSearchResult.getTotalResults() != 0 || searchRequest.getIdentifiers().isEmpty() || fallbackStateByIndexer == InternalData.FallbackState.USED) {
            return false;
        }
        return searchRequest.meets(this.configProvider.getBaseConfig().getSearching().getIdFallbackToQueryGeneration());
    }

    protected IndexerSearchResult buildSearchUrlAndCall(SearchRequest searchRequest, int offset, Integer limit) throws IndexerSearchAbortedException, IndexerAccessException {
        UriComponentsBuilder builder = this.buildSearchUrl(searchRequest, Integer.valueOf(offset), limit);
        URI url = builder.build().encode().toUri();
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.info("Calling {}", new Object[]{url.toString()});
        Object response = this.getAndStoreResultToDatabase(url, IndexerApiAccessType.SEARCH);
        return this.processSearchResponse(searchRequest, offset, limit, stopwatch, response);
    }

    protected IndexerSearchResult processSearchResponse(SearchRequest searchRequest, int offset, Integer limit, Stopwatch stopwatch, T response) throws IndexerParsingException {
        long responseTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        stopwatch.reset();
        stopwatch.start();
        IndexerSearchResult indexerSearchResult = new IndexerSearchResult(this, true);
        List searchResultItems = this.getSearchResultItems(response, searchRequest);
        for (SearchResultItem searchResultItem : searchResultItems) {
            try {
                this.titleMapping.mapSearchResult(searchResultItem, this.configProvider.getBaseConfig().getSearching().getCustomMappings());
            }
            catch (Exception e) {
                this.error("Error mapping search result title for " + searchResultItem.getTitle(), (Throwable)e);
            }
            this.overwriteNaCategoryWithSearchTypeCategory(searchRequest, searchResultItem);
        }
        indexerSearchResult.setPageSize(searchResultItems.size());
        this.debug(LoggingMarkers.PERFORMANCE, "Parsing of results took {}ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        SearchResultAcceptor.AcceptorResult acceptorResult = this.resultAcceptor.acceptResults(searchResultItems, searchRequest, this.config);
        searchResultItems = acceptorResult.getAcceptedResults();
        indexerSearchResult.setReasonsForRejection(acceptorResult.getReasonsForRejection());
        searchResultItems = this.persistSearchResults(searchResultItems, indexerSearchResult);
        indexerSearchResult.setSearchResultItems(searchResultItems);
        indexerSearchResult.setResponseTime(responseTime);
        this.completeIndexerSearchResult(response, indexerSearchResult, acceptorResult, searchRequest, offset, limit);
        this.info("Successfully executed search call in {}ms with {} total results", new Object[]{responseTime, indexerSearchResult.getTotalResults()});
        int endIndex = Math.min(indexerSearchResult.getOffset() + indexerSearchResult.getPageSize(), indexerSearchResult.getOffset() + searchResultItems.size());
        endIndex = Math.min(indexerSearchResult.getTotalResults(), endIndex);
        this.debug("Returning results {}-{} of {} available ({} already rejected)", new Object[]{indexerSearchResult.getOffset(), endIndex, indexerSearchResult.getTotalResults(), acceptorResult.getNumberOfRejectedResults()});
        return indexerSearchResult;
    }

    private void overwriteNaCategoryWithSearchTypeCategory(SearchRequest searchRequest, SearchResultItem searchResultItem) {
        if (!this.categoryProvider.getNotAvailable().equals((Object)searchResultItem.getCategory()) || !this.configProvider.getBaseConfig().getCategoriesConfig().isOverwriteNaWithSearchCategory()) {
            this.debug(LoggingMarkers.CATEGORY_MAPPING, "Search result {} with category {} not N/A or overwriting disabled ", new Object[]{searchResultItem.getTitle(), searchResultItem.getCategory().getName()});
            return;
        }
        if (searchRequest.getSearchType() == SearchType.SEARCH) {
            this.debug(LoggingMarkers.CATEGORY_MAPPING, "Search type is SEARCH so no overwriting possible", new Object[0]);
            return;
        }
        this.debug(LoggingMarkers.CATEGORY_MAPPING, "Overwriting N/A category for {} with search category {}", new Object[]{searchResultItem.getTitle(), searchRequest.getCategory()});
        searchResultItem.setCategory(searchRequest.getCategory());
    }

    protected abstract void completeIndexerSearchResult(T var1, IndexerSearchResult var2, SearchResultAcceptor.AcceptorResult var3, SearchRequest var4, int var5, Integer var6);

    protected abstract List<SearchResultItem> getSearchResultItems(T var1, SearchRequest var2) throws IndexerParsingException;

    protected abstract UriComponentsBuilder buildSearchUrl(SearchRequest var1, Integer var2, Integer var3) throws IndexerSearchAbortedException;

    public abstract NfoResult getNfo(String var1);

    public DetailsResult getDetails(String guid, long searchResultId) throws IndexerAccessException {
        return DetailsResult.unsuccessful((String)"Unsupported");
    }

    protected String cleanupQuery(String query) {
        if (this.configProvider.getBaseConfig().getSearching().isReplaceUmlauts()) {
            return CustomQueryAndTitleMappingHandler.removeDiacriticalAndUmlauts((String)query);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResultItem> persistSearchResults(List<SearchResultItem> searchResultItems, IndexerSearchResult indexerSearchResult) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object object = this.dbLock;
        synchronized (object) {
            this.searchResultPersistor.persistSearchResults(this, searchResultItems, indexerSearchResult);
        }
        this.getLogger().debug(LoggingMarkers.PERFORMANCE, "Persisting {} search results took {}ms", (Object)searchResultItems.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return searchResultItems;
    }

    protected void handleSuccess(IndexerApiAccessType accessType, Long responseTime) {
        if (this.getConfig().getDisabledLevel() > 0) {
            this.debug("Indexer was successfully called after {} failed attempts in a row", new Object[]{this.getConfig().getDisabledLevel()});
            this.eventPublisher.publishEvent((Object)new IndexerReenabledNotificationEvent(this.getConfig().getName(), this.getConfig().getDisabledAt()));
        }
        this.getConfig().setState(IndexerConfig.State.ENABLED);
        this.getConfig().setLastError(null);
        this.getConfig().setDisabledUntil(null);
        this.getConfig().setDisabledLevel(0);
        this.getConfig().setDisabledAt(null);
        this.baseConfigHandler.save(false);
        this.saveApiAccess(accessType, responseTime, IndexerAccessResult.SUCCESSFUL, true);
    }

    protected void handleFailure(String reason, Boolean disablePermanently, IndexerApiAccessType accessType, Long responseTime, IndexerAccessResult accessResult) {
        if (disablePermanently.booleanValue()) {
            this.getLogger().warn("Because an unrecoverable error occurred {} will be permanently disabled until reenabled by the user", (Object)this.indexer.getName());
            this.getConfig().setState(IndexerConfig.State.DISABLED_SYSTEM);
        } else {
            if (this.configProvider.getBaseConfig().getSearching().isIgnoreTemporarilyDisabled()) {
                return;
            }
            this.getConfig().setState(IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY);
            this.getConfig().setDisabledLevel(this.getConfig().getDisabledLevel() + 1);
            long minutesToAdd = ((Integer)DISABLE_PERIODS.get(Math.min(DISABLE_PERIODS.size() - 1, this.getConfig().getDisabledLevel()))).intValue();
            Instant disabledUntil = Instant.now().plus(minutesToAdd, ChronoUnit.MINUTES);
            this.getConfig().setDisabledUntil(Long.valueOf(disabledUntil.toEpochMilli()));
            this.getLogger().warn("Because an error occurred {} will be temporarily disabled until {}. This is error number {} in a row", new Object[]{this.indexer.getName(), disabledUntil, this.getConfig().getDisabledLevel()});
        }
        this.getConfig().setLastError(reason);
        this.getConfig().setDisabledAt(Instant.now());
        this.baseConfigHandler.save(false);
        this.eventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(this.indexer.getName(), this.getConfig().getState(), reason));
        this.saveApiAccess(accessType, responseTime, accessResult, false);
    }

    private void saveApiAccess(IndexerApiAccessType accessType, Long responseTime, IndexerAccessResult accessResult, boolean successful) {
        IndexerApiAccessEntity apiAccess = new IndexerApiAccessEntity(this.indexer);
        apiAccess.setAccessType(accessType);
        apiAccess.setResponseTime(responseTime);
        apiAccess.setResult(accessResult);
        apiAccess.setTime(Instant.now());
        if (this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
            this.indexerApiAccessRepository.save((Object)apiAccess);
        }
        this.indexerApiAccessShortRepository.save((Object)new IndexerApiAccessEntityShort(this.indexer, successful, accessType));
    }

    protected void handleIndexerAccessException(IndexerAccessException e, IndexerApiAccessType accessType) {
        IndexerAccessResult apiAccessResult;
        boolean disablePermanently = false;
        String message = e.getMessage();
        if (e instanceof IndexerAuthException) {
            this.error("Indexer refused authentication");
            disablePermanently = true;
            apiAccessResult = IndexerAccessResult.AUTH_ERROR;
        } else if (e instanceof IndexerErrorCodeException) {
            this.error(message, (Throwable)e);
            apiAccessResult = IndexerAccessResult.API_ERROR;
        } else if (e instanceof IndexerUnreachableException) {
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            this.error(message, (Throwable)e);
            apiAccessResult = IndexerAccessResult.CONNECTION_ERROR;
        } else {
            this.saveApiAccess(accessType, null, IndexerAccessResult.HYDRA_ERROR, true);
            this.error("An unexpected error occurred while communicating with the indexer: " + e.getMessage());
            return;
        }
        this.handleFailure(e.getMessage(), Boolean.valueOf(disablePermanently), accessType, null, apiAccessResult);
    }

    protected abstract T getAndStoreResultToDatabase(URI var1, IndexerApiAccessType var2) throws IndexerAccessException;

    protected <T> T getAndStoreResultToDatabase(URI uri, Class<T> responseType, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object result = this.callInderWebAccess(uri, responseType);
        long responseTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.debug(LoggingMarkers.PERFORMANCE, "Call to {} took {}ms", new Object[]{uri, responseTime});
        this.handleSuccess(apiAccessType, Long.valueOf(responseTime));
        return (T)result;
    }

    <T> T callInderWebAccess(URI uri, Class<T> responseType) throws IndexerAccessException {
        return (T)this.indexerWebAccess.get(uri, this.config, responseType);
    }

    protected String generateQueryIfApplicable(SearchRequest searchRequest, String query) throws IndexerSearchAbortedException {
        return this.queryGenerator.generateQueryIfApplicable(searchRequest, query, this);
    }

    public String getName() {
        return this.config.getName();
    }

    public IndexerConfig getConfig() {
        return this.config;
    }

    public IndexerEntity getIndexerEntity() {
        return this.indexer;
    }

    public String cleanUpTitle(String title) {
        if (Strings.isNullOrEmpty((String)title)) {
            return title;
        }
        title = title.trim().replace("&", "");
        List<String> removeTrailing = this.configProvider.getBaseConfig().getSearching().getRemoveTrailing().stream().map(x -> x.toLowerCase().trim()).toList();
        if (removeTrailing.isEmpty()) {
            return title;
        }
        if (this.cleanupPattern == null) {
            String allPattern = "^(?<keep>.*)(" + removeTrailing.stream().map(x -> x.replace("*", "WILDCARDXXX").replaceAll("[-\\[\\]{}()*+?.,\\\\\\\\^$|#]", "\\\\$0").replace("WILDCARDXXX", ".*") + "$").collect(Collectors.joining("|")) + ")";
            this.cleanupPattern = Pattern.compile(allPattern, 2);
        }
        Matcher matcher = this.cleanupPattern.matcher(title);
        while (matcher.matches()) {
            title = matcher.replaceAll("$1").trim();
            matcher = this.cleanupPattern.matcher(title);
        }
        return title;
    }

    public Optional<Instant> tryParseDate(String dateString) {
        for (DateTimeFormatter formatter : DATE_FORMATs) {
            try {
                Instant instant = Instant.from(formatter.parse(dateString));
                return Optional.of(instant);
            }
            catch (DateTimeParseException e) {
                this.debug("Unable to parse date string " + dateString, new Object[0]);
            }
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Indexer that = (Indexer)o;
        return Objects.equal((Object)this.indexer.getName(), (Object)that.indexer.getName());
    }

    public int hashCode() {
        return this.getConfig() == null || this.getConfig().getName() == null ? 0 : this.config.getName().hashCode();
    }

    public String toString() {
        return this.config.getName();
    }

    protected void warn(String msg) {
        this.getLogger().warn(this.getName() + ": " + msg);
    }

    protected void error(String msg) {
        this.getLogger().error(this.getName() + ": " + msg);
    }

    protected void error(String msg, Throwable t) {
        this.getLogger().error(this.getName() + ": " + msg, t);
    }

    protected void info(String msg, Object ... arguments) {
        this.getLogger().info(this.getName() + ": " + msg, arguments);
    }

    protected void debug(String msg, Object ... arguments) {
        this.getLogger().debug(this.getName() + ": " + msg, arguments);
    }

    protected void debug(Marker marker, String msg, Object ... arguments) {
        this.getLogger().debug(marker, this.getName() + ": " + msg, arguments);
    }

    protected abstract Logger getLogger();
}

