/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.NzbHydraException;
import org.nzbhydra.config.category.CategoriesConfig;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.indexer.BackendType;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.indexers.DetailsResult;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.NewznabCategoryComputer;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.SearchRequestIdConverter;
import org.nzbhydra.indexers.capscheck.IndexerChecker;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerAuthException;
import org.nzbhydra.indexers.exceptions.IndexerErrorCodeException;
import org.nzbhydra.indexers.exceptions.IndexerNoIdConversionPossibleException;
import org.nzbhydra.indexers.exceptions.IndexerProgramErrorException;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.indexers.status.IndexerLimit;
import org.nzbhydra.indexers.status.IndexerLimitRepository;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.mapping.newznab.ActionAttribute;
import org.nzbhydra.mapping.newznab.xml.NewznabAttribute;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlApilimits;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlChannel;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlEnclosure;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlError;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlItem;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlResponse;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.mapping.newznab.xml.Xml;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.SearchResultIdCalculator;
import org.nzbhydra.searching.UnknownResponseException;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.InternalData;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Scope(value="prototype")
@Component(value="newznab")
public class Newznab
extends Indexer<Xml> {
    private static final Logger logger = LoggerFactory.getLogger(Newznab.class);
    static Map<MediaIdType, String> idTypeToParamValueMap = new HashMap();
    private static final List<String> LANGUAGES = Arrays.asList(" English", " Korean", " Spanish", " French", " German", " Italian", " Danish", " Dutch", " Japanese", " Cantonese", " Mandarin", " Russian", " Polish", " Vietnamese", " Swedish", " Norwegian", " Finnish", " Turkish", " Portuguese", " Flemish", " Greek", " Hungarian");
    private static Pattern GROUP_PATTERN = Pattern.compile(".*Group:<\\/b> ?([\\w\\.]+)<br ?\\/>.*");
    private static final List<String> HOSTS_NOT_SUPPORTING_MOVIE_Q_SEARCH = Arrays.asList("dognzb", "nzbplanet", "nzbgeek", "6box");
    private static final Pattern TV_PATTERN = Pattern.compile("(?<showtitle>[\\w\\.\\-_]+)S(?<season>\\d+)e(?<episode>\\d+)|(?<season2>\\d{1,2})x(?<episode2>\\d{1,2})", 2);
    @Autowired
    private Unmarshaller unmarshaller;
    @Autowired
    private IndexerLimitRepository indexerStatusRepository;
    @Autowired
    protected NewznabCategoryComputer newznabCategoryComputer;
    @Autowired
    private SearchRequestIdConverter searchRequestIdConverter;

    protected UriComponentsBuilder getBaseUri() {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.config.getHost()).path(this.config.getApiPath().orElse("/api"));
        if (!Strings.isNullOrEmpty((String)this.config.getApiKey())) {
            builder.queryParam("apikey", new Object[]{this.config.getApiKey()});
        }
        return builder;
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        UriComponentsBuilder componentsBuilder = this.getBaseUri();
        SearchType searchType = searchRequest.getSearchType();
        if (this.config.getSupportedSearchTypes().stream().noneMatch(x -> searchRequest.getSearchType().matches(x))) {
            searchType = SearchType.SEARCH;
        }
        if (searchRequest.getSearchType() == SearchType.MOVIE && searchRequest.getQuery().isPresent() && searchRequest.getQuery().isPresent() && this.isIndexerNotSupportingMovieQSearch()) {
            this.debug("Switching search type to SEARCH because this indexer doesn't allow using search type MOVIE/TVSEARCH with a query", new Object[0]);
            searchType = SearchType.SEARCH;
        }
        componentsBuilder = componentsBuilder.queryParam("t", new Object[]{searchType.name().toLowerCase()}).queryParam("extended", new Object[]{"1"});
        String query = "";
        if (searchRequest.getInternalData().getFallbackStateByIndexer(this.getName()) != InternalData.FallbackState.REQUESTED) {
            componentsBuilder = this.extendQueryUrlWithSearchIds(searchRequest, componentsBuilder);
        }
        query = this.generateQueryIfApplicable(searchRequest, query);
        this.verifyIdentifiersNotUnhandled(searchRequest, componentsBuilder, query);
        query = this.addRequiredAndforbiddenWordsToQuery(searchRequest, query);
        query = this.cleanupQuery(query);
        this.addFurtherParametersToUri(searchRequest, componentsBuilder, query);
        Integer effectiveLimit = this.config.getCustomParameters().stream().filter(x -> x.toLowerCase().startsWith("limit=")).map(x -> Integer.parseInt(x.split("=")[1])).findFirst().orElse(1000);
        componentsBuilder.queryParam("limit", new Object[]{effectiveLimit});
        if (offset != null) {
            componentsBuilder.queryParam("offset", new Object[]{offset});
        }
        return componentsBuilder;
    }

    private void verifyIdentifiersNotUnhandled(SearchRequest searchRequest, UriComponentsBuilder componentsBuilder, String query) throws IndexerNoIdConversionPossibleException {
        String currentUriString = componentsBuilder.toUriString();
        boolean noIdsOrIdWithNull = idTypeToParamValueMap.values().stream().noneMatch(s -> currentUriString.contains((CharSequence)s) && !currentUriString.contains(s + "=null"));
        if (Strings.isNullOrEmpty((String)query) && !searchRequest.getIdentifiers().isEmpty() && noIdsOrIdWithNull) {
            throw new IndexerNoIdConversionPossibleException("Aborting searching for indexer because no usable search IDs could be found and no query was generated");
        }
    }

    protected void addFurtherParametersToUri(SearchRequest searchRequest, UriComponentsBuilder componentsBuilder, String query) {
        if (!query.isEmpty()) {
            componentsBuilder.queryParam("q", new Object[]{query});
        }
        if (this.config.getSupportedSearchTypes().contains(ActionAttribute.TVSEARCH)) {
            if (searchRequest.getSeason().isPresent()) {
                componentsBuilder.queryParam("season", new Object[]{searchRequest.getSeason().get()});
            }
            if (searchRequest.getEpisode().isPresent()) {
                componentsBuilder.queryParam("ep", new Object[]{searchRequest.getEpisode().get()});
            }
        }
        if (this.config.getSupportedSearchTypes().contains(ActionAttribute.BOOK)) {
            if (searchRequest.getTitle().isPresent()) {
                componentsBuilder.queryParam("title", new Object[]{searchRequest.getTitle().get()});
            }
            if (searchRequest.getAuthor().isPresent()) {
                componentsBuilder.queryParam("author", new Object[]{searchRequest.getAuthor().get()});
            }
        }
        if (searchRequest.getMaxage().isPresent()) {
            componentsBuilder.queryParam("maxage", new Object[]{searchRequest.getMaxage().get()});
        }
        if (searchRequest.getMinsize().isPresent()) {
            componentsBuilder.queryParam("minsize", new Object[]{searchRequest.getMinsize().get()});
        }
        String passwordParameter = "password";
        if (this.config.getHost().toLowerCase().contains("omgwtf")) {
            passwordParameter = "pw";
        }
        if (!this.configProvider.getBaseConfig().getSearching().isIgnorePassworded() || searchRequest.getInternalData().isIncludePasswords()) {
            componentsBuilder.queryParam(passwordParameter, new Object[]{"1"});
        } else {
            componentsBuilder.queryParam(passwordParameter, new Object[]{"0"});
        }
        this.calculateAndAddCategories(searchRequest, componentsBuilder);
        this.config.getCustomParameters().stream().filter(x -> !x.toLowerCase().startsWith("limit=")).forEach(x -> {
            String[] split = x.split("=");
            componentsBuilder.queryParam(split[0], new Object[]{split[1]});
        });
    }

    protected void calculateAndAddCategories(SearchRequest searchRequest, UriComponentsBuilder componentsBuilder) {
        if (this.config.getCategoryMapping() == null) {
            this.error("Category mapping unknown - caps check incomplete?");
        }
        List<Object> categoryIds = new ArrayList();
        if (searchRequest.getInternalData().getNewznabCategories().isEmpty() || this.configProvider.getBaseConfig().getSearching().isTransformNewznabCategories()) {
            if (searchRequest.getCategory().getSubtype() == Category.Subtype.ANIME && this.config.getCategoryMapping().getAnime().isPresent()) {
                categoryIds = Arrays.asList((Integer)this.config.getCategoryMapping().getAnime().get());
            } else if (searchRequest.getCategory().getSubtype() == Category.Subtype.AUDIOBOOK && this.config.getCategoryMapping().getAudiobook().isPresent()) {
                categoryIds = Arrays.asList((Integer)this.config.getCategoryMapping().getAudiobook().get());
            } else if (searchRequest.getCategory().getSubtype() == Category.Subtype.COMIC && this.config.getCategoryMapping().getComic().isPresent()) {
                categoryIds = Arrays.asList((Integer)this.config.getCategoryMapping().getComic().get());
            } else if (searchRequest.getCategory().getSubtype() == Category.Subtype.EBOOK && this.config.getCategoryMapping().getEbook().isPresent()) {
                categoryIds = Arrays.asList((Integer)this.config.getCategoryMapping().getEbook().get());
            } else if (searchRequest.getCategory().getSubtype() == Category.Subtype.MAGAZINE && this.config.getCategoryMapping().getMagazine().isPresent()) {
                categoryIds = Arrays.asList((Integer)this.config.getCategoryMapping().getMagazine().get());
            } else if (!searchRequest.getCategory().getNewznabCategories().isEmpty()) {
                categoryIds = searchRequest.getCategory().getNewznabCategories().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            categoryIds = new ArrayList(categoryIds);
        } else {
            categoryIds = new ArrayList(searchRequest.getInternalData().getNewznabCategories());
        }
        if (categoryIds.isEmpty() && searchRequest.getCategory() == CategoriesConfig.allCategory && !searchRequest.getInternalData().getNewznabCategories().isEmpty()) {
            categoryIds = new ArrayList(searchRequest.getInternalData().getNewznabCategories());
        }
        if (!categoryIds.isEmpty()) {
            Collections.sort(categoryIds);
            componentsBuilder.queryParam("cat", new Object[]{Joiner.on((String)",").join(categoryIds)});
        }
    }

    private boolean isIndexerNotSupportingMovieQSearch() {
        return HOSTS_NOT_SUPPORTING_MOVIE_Q_SEARCH.stream().anyMatch(x -> this.getConfig().getHost().toLowerCase().contains((CharSequence)x));
    }

    protected boolean isSwitchToTSearchNeeded(SearchRequest request) {
        return false;
    }

    protected String addRequiredAndforbiddenWordsToQuery(SearchRequest searchRequest, String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return query;
        }
        query = this.addRequiredWords(searchRequest, query);
        return this.addForbiddenWords(searchRequest, query);
    }

    protected String addForbiddenWords(SearchRequest searchRequest, String query) {
        if (this.config.getForbiddenWordPrefix() == IndexerConfig.ForbiddenWordPrefix.UNKNOWN) {
            this.info("Forbidden word prefix unknown - running check to determine it", new Object[0]);
            this.config.setForbiddenWordPrefix(((IndexerChecker)NzbHydra.getApplicationContext().getAutowireCapableBeanFactory().getBean(IndexerChecker.class)).determineForbiddenWordPrefix(this.config));
            this.baseConfigHandler.save(false);
        }
        if (this.config.getForbiddenWordPrefix() == IndexerConfig.ForbiddenWordPrefix.UNSUPPORTED) {
            this.debug("Not adding forbidden words as this indexer doesn't support them.", new Object[0]);
            return query;
        }
        ArrayList allForbiddenWords = new ArrayList(searchRequest.getInternalData().getForbiddenWords());
        allForbiddenWords.addAll(this.configProvider.getBaseConfig().getSearching().getForbiddenWords());
        allForbiddenWords.addAll(searchRequest.getCategory().getForbiddenWords());
        List allPossibleForbiddenWords = allForbiddenWords.stream().filter(x -> !x.contains(" ") && !x.contains("-") && !x.contains(".")).collect(Collectors.toList());
        if (allForbiddenWords.size() > allPossibleForbiddenWords.size()) {
            this.debug("Not using some forbidden words in query because characters forbidden by newznab are contained.", new Object[0]);
        }
        if (!allPossibleForbiddenWords.isEmpty()) {
            if (this.config.getForbiddenWordPrefix() == IndexerConfig.ForbiddenWordPrefix.EXCLAMATION_MARK) {
                query = (String)query + (((String)query).isEmpty() ? "" : " ") + "!" + Joiner.on((String)",!").join(allPossibleForbiddenWords);
            } else if (this.config.getForbiddenWordPrefix() == IndexerConfig.ForbiddenWordPrefix.DOUBLE_DASH) {
                query = (String)query + (((String)query).isEmpty() ? "" : " ") + "--" + Joiner.on((String)" --").join(allPossibleForbiddenWords);
            }
        }
        return query;
    }

    protected String addRequiredWords(SearchRequest searchRequest, String query) {
        ArrayList allRequiredWords = new ArrayList(searchRequest.getInternalData().getRequiredWords());
        allRequiredWords.addAll(this.configProvider.getBaseConfig().getSearching().getRequiredWords());
        allRequiredWords.addAll(searchRequest.getCategory().getRequiredWords());
        List allPossibleRequiredWords = allRequiredWords.stream().filter(x -> !x.contains(" ") && !x.contains("-") && !x.contains(".")).collect(Collectors.toList());
        if (allRequiredWords.size() > allPossibleRequiredWords.size()) {
            this.debug("Not using some forbidden words in query because characters forbidden by newznab are contained", new Object[0]);
        }
        if (!allPossibleRequiredWords.isEmpty()) {
            query = (String)query + (((String)query).isEmpty() ? "" : " ") + Joiner.on((String)" ").join(allPossibleRequiredWords);
        }
        return query;
    }

    protected UriComponentsBuilder extendQueryUrlWithSearchIds(SearchRequest searchRequest, UriComponentsBuilder componentsBuilder) {
        if (searchRequest.getIdentifiers().isEmpty()) {
            return componentsBuilder;
        }
        this.searchRequestIdConverter.convertSearchIdsIfNeeded(searchRequest, this.config);
        for (Map.Entry entry : searchRequest.getIdentifiers().entrySet()) {
            if (entry.getValue() == null || !this.config.getSupportedSearchIds().contains(entry.getKey())) continue;
            this.debug("Using media ID {}={}", new Object[]{entry.getKey(), entry.getValue()});
            componentsBuilder.queryParam((String)idTypeToParamValueMap.get(entry.getKey()), new Object[]{((String)entry.getValue()).replace("tt", "")});
        }
        return componentsBuilder;
    }

    protected Xml getAndStoreResultToDatabase(URI uri, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        Xml response = (Xml)this.getAndStoreResultToDatabase(uri, Xml.class, apiAccessType);
        if (response instanceof NewznabXmlError) {
            this.handleRssError((NewznabXmlError)response, uri.toString());
        } else if (!(response instanceof NewznabXmlRoot)) {
            throw new UnknownResponseException("Indexer returned unknown response");
        }
        return response;
    }

    public NfoResult getNfo(String guid) {
        String result;
        UriComponentsBuilder baseUri = this.getBaseUri().queryParam("raw", new Object[]{"1"}).queryParam("id", new Object[]{guid});
        if (this.config.getBackend() == BackendType.NZEDB || this.config.getBackend() == BackendType.NNTMUX) {
            baseUri.queryParam("t", new Object[]{"info"});
        } else {
            baseUri.queryParam("t", new Object[]{"getnfo"});
        }
        try {
            result = (String)this.getAndStoreResultToDatabase(baseUri.build().toUri(), String.class, IndexerApiAccessType.NFO);
        }
        catch (IndexerAccessException e) {
            return NfoResult.unsuccessful((String)e.getMessage());
        }
        if (!result.contains("<?xml")) {
            return NfoResult.withNfo((String)result);
        }
        try {
            NewznabXmlRoot rssRoot;
            Xml xml = (Xml)this.unmarshaller.unmarshal((Source)new StreamSource(new StringReader(result)));
            if (xml instanceof NewznabXmlError) {
                this.handleRssError((NewznabXmlError)xml, baseUri.toUriString());
            }
            if ((rssRoot = (NewznabXmlRoot)xml).getRssChannel().getNewznabResponse() == null || rssRoot.getRssChannel().getNewznabResponse().getTotal() == 0) {
                return NfoResult.withoutNfo();
            }
            return NfoResult.withNfo((String)((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(0)).getDescription());
        }
        catch (IOException | IndexerAccessException e) {
            this.error("Error while getting NFO: " + e.getMessage());
            return NfoResult.unsuccessful((String)e.getMessage());
        }
    }

    public DetailsResult getDetails(String guid, long searchResultId) throws IndexerAccessException {
        NewznabXmlRoot rssRoot;
        List searchResultItems;
        Xml xml;
        UriComponentsBuilder baseUri = this.getBaseUri().queryParam("t", new Object[]{"details"}).queryParam("id", new Object[]{guid});
        try {
            xml = this.getAndStoreResultToDatabase(baseUri.build().toUri(), IndexerApiAccessType.DETAILS);
        }
        catch (IndexerAccessException e) {
            return DetailsResult.unsuccessful((String)e.getMessage());
        }
        if (xml instanceof NewznabXmlError) {
            this.handleRssError((NewznabXmlError)xml, baseUri.toUriString());
        }
        if ((searchResultItems = this.getSearchResultItems((Xml)(rssRoot = (NewznabXmlRoot)xml), new SearchRequest())).size() != 1) {
            return DetailsResult.unsuccessful((String)"Didn't find exactly one result for ID");
        }
        SearchResultItem item = (SearchResultItem)searchResultItems.get(0);
        item.setSearchResultId(Long.valueOf(searchResultId));
        return DetailsResult.withItem((SearchResultItem)item);
    }

    protected void handleRssError(NewznabXmlError response, String url) throws IndexerAccessException {
        if (Stream.of("100", "101", "102").anyMatch(x -> x.equals(response.getCode())) && (response.getDescription() == null || !response.getDescription().contains("Hits Limit Reached"))) {
            throw new IndexerAuthException(String.format("Indexer refused authentication. Error code: %s. Description: %s", response.getCode(), response.getDescription()));
        }
        if (Stream.of("200", "201", "202", "203").anyMatch(x -> x.equals(response.getCode()))) {
            throw new IndexerProgramErrorException(String.format("Indexer returned error code %s and description '%s' when URL %s was called", response.getCode(), response.getDescription(), url));
        }
        throw new IndexerErrorCodeException(response);
    }

    protected List<SearchResultItem> getSearchResultItems(Xml rssRoot, SearchRequest searchRequest) {
        ArrayList<SearchResultItem> searchResultItems = new ArrayList<SearchResultItem>();
        NewznabXmlRoot newznabXmlRoot = (NewznabXmlRoot)rssRoot;
        this.checkForTooManyResults(searchRequest, newznabXmlRoot);
        for (NewznabXmlItem item : newznabXmlRoot.getRssChannel().getItems()) {
            try {
                if (this.config.getSearchModuleType() == SearchModuleType.TORZNAB && item.getEnclosures().stream().noneMatch(x -> this.getEnclosureTypes().contains(x.getType()))) {
                    this.debug("Skipping result {} because it doesn't contain a torrent link", new Object[]{item.getTitle()});
                    continue;
                }
                if (this.config.getSearchModuleType() == SearchModuleType.NEWZNAB && item.getEnclosures().stream().noneMatch(x -> Objects.equals(x.getType(), "application/x-nzb"))) {
                    this.debug("Skipping result {} because it doesn't contain an NZB link", new Object[]{item.getTitle()});
                    continue;
                }
                SearchResultItem searchResultItem = this.createSearchResultItem(item);
                searchResultItems.add(searchResultItem);
            }
            catch (NzbHydraException nzbHydraException) {}
        }
        return searchResultItems;
    }

    private void checkForTooManyResults(SearchRequest searchRequest, NewznabXmlRoot newznabXmlRoot) {
        if (newznabXmlRoot.getRssChannel().getNewznabResponse() != null) {
            Integer total = newznabXmlRoot.getRssChannel().getNewznabResponse().getTotal();
            if (searchRequest.isIdBasedQuery() && !searchRequest.getInternalData().isQueryGenerated() && total >= 10000) {
                this.warn("Indexer returned " + total + " results for an ID based searched. Will interpret this as no results found");
                newznabXmlRoot.getRssChannel().getNewznabResponse().setTotal(Integer.valueOf(0));
                newznabXmlRoot.getRssChannel().getItems().clear();
            }
        }
    }

    protected void completeIndexerSearchResult(Xml response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        NewznabXmlChannel rssChannel = ((NewznabXmlRoot)response).getRssChannel();
        NewznabXmlResponse newznabResponse = rssChannel.getNewznabResponse();
        int actualNumberResults = indexerSearchResult.getSearchResultItems().size();
        if (newznabResponse != null) {
            int responseOffset;
            indexerSearchResult.setTotalResultsKnown(true);
            int n = responseOffset = newznabResponse.getOffset() != null ? newznabResponse.getOffset() : 0;
            if (newznabResponse.getTotal() != null) {
                indexerSearchResult.setTotalResults(newznabResponse.getTotal().intValue());
                indexerSearchResult.setHasMoreResults(newznabResponse.getTotal() > responseOffset + actualNumberResults + acceptorResult.getNumberOfRejectedResults());
            } else {
                indexerSearchResult.setTotalResults(actualNumberResults);
                indexerSearchResult.setHasMoreResults(false);
            }
            indexerSearchResult.setOffset(responseOffset);
            indexerSearchResult.setPageSize(((NewznabXmlRoot)response).getRssChannel().getItems().size());
        } else {
            indexerSearchResult.setTotalResultsKnown(false);
            indexerSearchResult.setHasMoreResults(false);
            indexerSearchResult.setOffset(0);
            indexerSearchResult.setPageSize(0);
        }
        if (indexerSearchResult.getTotalResults() == 0) {
            indexerSearchResult.setTotalResults(actualNumberResults);
        }
        this.checkForInvalidTotal(indexerSearchResult, rssChannel);
        NewznabXmlApilimits apiLimits = rssChannel.getApiLimits();
        if (apiLimits != null) {
            IndexerLimit indexerStatus = this.indexerStatusRepository.findByIndexer(this.indexer);
            indexerStatus.setApiHits(apiLimits.getApiCurrent() != null ? Integer.valueOf(apiLimits.getApiCurrent() + 1) : null);
            indexerStatus.setApiHitLimit(apiLimits.getApiMax());
            indexerStatus.setDownloads(apiLimits.getGrabCurrent());
            indexerStatus.setDownloadLimit(apiLimits.getGrabMax());
            indexerStatus.setOldestApiHit(apiLimits.getApiOldestTime());
            indexerStatus.setOldestDownload(apiLimits.getGrabOldestTime());
            this.indexerStatusRepository.save((Object)indexerStatus);
            this.debug(LoggingMarkers.LIMITS, "Indexer {}. Saving IndexerStatus data: {}", new Object[]{this.indexer.getName(), indexerStatus});
        } else {
            this.debug(LoggingMarkers.LIMITS, "Indexer {}. No limits provided in response.", new Object[]{this.indexer.getName()});
        }
    }

    private void checkForInvalidTotal(IndexerSearchResult indexerSearchResult, NewznabXmlChannel rssChannel) {
        int newznabItemsCount = rssChannel.getItems().size();
        NewznabXmlResponse newznabResponse = rssChannel.getNewznabResponse();
        if (newznabResponse == null || newznabResponse.getTotal() == null) {
            return;
        }
        int newznabTotal = newznabResponse.getTotal();
        int offset = newznabResponse.getOffset();
        if (offset == 0 && newznabItemsCount < newznabTotal && newznabItemsCount < 100) {
            this.warn("Indexer's response indicates a total of " + newznabTotal + " results but actually only " + newznabItemsCount + " were returned");
            indexerSearchResult.setTotalResults(newznabItemsCount);
            indexerSearchResult.setHasMoreResults(false);
        }
    }

    protected SearchResultItem createSearchResultItem(NewznabXmlItem item) throws NzbHydraException {
        SearchResultItem searchResultItem = new SearchResultItem();
        String link = this.getEnclosureUrl(item);
        searchResultItem.setLink(link);
        String guid = item.getRssGuid().getGuid();
        if (item.getRssGuid().isPermaLink()) {
            searchResultItem.setDetails(guid);
            int index = guid.lastIndexOf("id=");
            if (index > -1) {
                guid = guid.substring(index + 3);
            } else {
                index = guid.lastIndexOf("/");
                if ((index = (guid = guid.substring(index + 1)).indexOf("#")) > -1) {
                    guid = guid.substring(0, index);
                }
            }
            searchResultItem.setIndexerGuid(guid);
        } else {
            searchResultItem.setIndexerGuid(guid);
        }
        if (!Strings.isNullOrEmpty((String)item.getComments()) && Strings.isNullOrEmpty((String)searchResultItem.getDetails())) {
            searchResultItem.setDetails(item.getComments().replace("#comments", ""));
        }
        searchResultItem.setFirstFound(Instant.now());
        searchResultItem.setIndexer((Indexer)this);
        searchResultItem.setTitle(this.cleanUpTitle(item.getTitle()));
        searchResultItem.setSize(item.getEnclosure().getLength());
        searchResultItem.setPubDate(item.getPubDate());
        searchResultItem.setIndexerScore(Integer.valueOf(this.config.getScore()));
        searchResultItem.setGuid(Long.valueOf(SearchResultIdCalculator.calculateSearchResultId((SearchResultItem)searchResultItem)));
        searchResultItem.setAgePrecise(true);
        searchResultItem.setDescription(item.getDescription());
        searchResultItem.setDownloadType(DownloadType.NZB);
        searchResultItem.setCommentsLink(item.getComments());
        searchResultItem.setOriginalCategory(item.getCategory());
        this.parseAttributes(item, searchResultItem);
        return searchResultItem;
    }

    protected String getEnclosureUrl(NewznabXmlItem item) throws NzbHydraException {
        String link;
        if (item.getEnclosures().isEmpty()) {
            link = ((NewznabXmlEnclosure)item.getEnclosures().get(0)).getUrl();
        } else {
            Optional<NewznabXmlEnclosure> nzbEnclosure = item.getEnclosures().stream().filter(x -> this.getEnclosureTypes().contains(x.getType())).findAny();
            if (nzbEnclosure.isEmpty()) {
                this.warn("Unable to find URL for result " + item.getTitle() + ". Will skip it.");
                throw new NzbHydraException();
            }
            link = nzbEnclosure.get().getUrl();
        }
        return link;
    }

    protected List<String> getEnclosureTypes() {
        return List.of("application/x-nzb");
    }

    protected void parseAttributes(NewznabXmlItem item, SearchResultItem searchResultItem) {
        Matcher matcher;
        Map<String, String> attributes = item.getNewznabAttributes().stream().filter(x -> !Strings.isNullOrEmpty((String)x.getValue())).collect(Collectors.toMap(NewznabAttribute::getName, NewznabAttribute::getValue, (a, b) -> b));
        List newznabCategories = item.getNewznabAttributes().stream().filter(x -> x.getName().equals("category") && !"None".equals(x.getValue()) && !Strings.isNullOrEmpty((String)x.getValue())).map(newznabAttribute -> {
            try {
                return Integer.parseInt(newznabAttribute.getValue());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        searchResultItem.setAttributes(attributes);
        if (attributes.containsKey("usenetdate")) {
            this.tryParseDate(attributes.get("usenetdate")).ifPresent(arg_0 -> ((SearchResultItem)searchResultItem).setUsenetDate(arg_0));
        }
        if (attributes.containsKey("password")) {
            String passwordValue = attributes.get("password");
            try {
                if (Integer.parseInt(passwordValue) > 0) {
                    searchResultItem.setPassworded(true);
                }
            }
            catch (NumberFormatException e) {
                searchResultItem.setPassworded(true);
            }
        }
        if (attributes.containsKey("nfo")) {
            searchResultItem.setHasNfo(attributes.get("nfo").equals("1") ? SearchResultItem.HasNfo.YES : SearchResultItem.HasNfo.NO);
        }
        if (attributes.containsKey("info") && (this.config.getBackend() == BackendType.NNTMUX || this.config.getBackend() == BackendType.NZEDB)) {
            searchResultItem.setHasNfo(SearchResultItem.HasNfo.YES);
        }
        Arrays.asList("coverurl", "cover").forEach(x -> {
            if (attributes.containsKey(x) && !((String)attributes.get(x)).equals("not available") && !((String)attributes.get(x)).equals("no-cover") && (((String)attributes.get(x)).toLowerCase().endsWith(".jpg") || ((String)attributes.get(x)).toLowerCase().endsWith(".jpeg") || ((String)attributes.get(x)).toLowerCase().endsWith(".png") || ((String)attributes.get(x)).toLowerCase().endsWith(".webp"))) {
                searchResultItem.setCover((String)attributes.get(x));
            }
        });
        if (attributes.containsKey("poster") && !attributes.get("poster").equals("not available")) {
            searchResultItem.setPoster(attributes.get("poster"));
        }
        if (attributes.containsKey("group") && !attributes.get("group").equals("not available")) {
            searchResultItem.setGroup(attributes.get("group"));
        }
        if (attributes.containsKey("files")) {
            searchResultItem.setFiles(Integer.valueOf(attributes.get("files")));
        }
        if (attributes.containsKey("comments")) {
            searchResultItem.setCommentsCount(Integer.valueOf(attributes.get("comments")));
        }
        if (attributes.containsKey("grabs")) {
            searchResultItem.setGrabs(Integer.valueOf(attributes.get("grabs")));
        }
        if (attributes.containsKey("guid")) {
            searchResultItem.setIndexerGuid(attributes.get("guid"));
        }
        if (attributes.containsKey("size")) {
            searchResultItem.setSize(Long.valueOf(attributes.get("size")));
        }
        if (attributes.containsKey("source")) {
            searchResultItem.setSource(attributes.get("source"));
        }
        this.newznabCategoryComputer.computeCategory(searchResultItem, newznabCategories, this.config);
        if (searchResultItem.getHasNfo() == SearchResultItem.HasNfo.MAYBE && (this.config.getBackend() == BackendType.NNTMUX || this.config.getBackend() == BackendType.NZEDB)) {
            searchResultItem.setHasNfo(SearchResultItem.HasNfo.NO);
        }
        if (searchResultItem.getGroup().isEmpty() && !Strings.isNullOrEmpty((String)item.getDescription()) && item.getDescription().contains("Group:") && (matcher = GROUP_PATTERN.matcher(item.getDescription())).matches() && !Objects.equals(matcher.group(1), "not available")) {
            searchResultItem.setGroup(matcher.group(1));
        }
        try {
            if (searchResultItem.getCategory().getSearchType() == SearchType.TVSEARCH) {
                if (searchResultItem.getAttributes().containsKey("season")) {
                    searchResultItem.getAttributes().put("season", ((String)searchResultItem.getAttributes().get("season")).replaceAll("[sS]", ""));
                }
                if (searchResultItem.getAttributes().containsKey("episode")) {
                    searchResultItem.getAttributes().put("episode", ((String)searchResultItem.getAttributes().get("episode")).replaceAll("[eE]", ""));
                }
                if (searchResultItem.getAttributes().containsKey("showtitle")) {
                    searchResultItem.getAttributes().put("showtitle", (String)searchResultItem.getAttributes().get("showtitle"));
                }
                if (!(attributes.containsKey("season") && attributes.containsKey("episode") && attributes.containsKey("showtitle") || !(matcher = TV_PATTERN.matcher(item.getTitle())).find())) {
                    this.putGroupMatchIfFound(searchResultItem, matcher, "season", "season");
                    this.putGroupMatchIfFound(searchResultItem, matcher, "season2", "season");
                    this.putGroupMatchIfFound(searchResultItem, matcher, "episode", "episode");
                    this.putGroupMatchIfFound(searchResultItem, matcher, "episode2", "episode");
                    this.putGroupMatchIfFound(searchResultItem, matcher, "showtitle", "showtitle");
                }
                if (attributes.containsKey("season")) {
                    attributes.put("season", this.tryParseInt(attributes.get("season").replaceAll("\\D", "").toLowerCase()));
                }
                if (attributes.containsKey("episode")) {
                    attributes.put("episode", this.tryParseInt(attributes.get("episode").replaceAll("\\D", "").toLowerCase()));
                }
                if (attributes.containsKey("showtitle")) {
                    attributes.put("showtitle", attributes.get("showtitle").replaceAll("\\W", "").toLowerCase());
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private String tryParseInt(String string) {
        try {
            return String.valueOf(Integer.valueOf(string));
        }
        catch (NumberFormatException e) {
            return string;
        }
    }

    private void putGroupMatchIfFound(SearchResultItem searchResultItem, Matcher matcher, String groupName, String attributeName) {
        if (matcher.group(groupName) != null && !searchResultItem.getAttributes().containsKey(attributeName)) {
            searchResultItem.getAttributes().put(attributeName, matcher.group(groupName));
        }
    }

    protected Logger getLogger() {
        return logger;
    }

    @Generated
    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    @Generated
    public IndexerLimitRepository getIndexerStatusRepository() {
        return this.indexerStatusRepository;
    }

    @Generated
    public NewznabCategoryComputer getNewznabCategoryComputer() {
        return this.newznabCategoryComputer;
    }

    @Generated
    public SearchRequestIdConverter getSearchRequestIdConverter() {
        return this.searchRequestIdConverter;
    }

    @Generated
    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Generated
    public void setIndexerStatusRepository(IndexerLimitRepository indexerStatusRepository) {
        this.indexerStatusRepository = indexerStatusRepository;
    }

    @Generated
    public void setNewznabCategoryComputer(NewznabCategoryComputer newznabCategoryComputer) {
        this.newznabCategoryComputer = newznabCategoryComputer;
    }

    @Generated
    public void setSearchRequestIdConverter(SearchRequestIdConverter searchRequestIdConverter) {
        this.searchRequestIdConverter = searchRequestIdConverter;
    }

    @Generated
    public Newznab() {
    }

    static {
        idTypeToParamValueMap.put(MediaIdType.IMDB, "imdbid");
        idTypeToParamValueMap.put(MediaIdType.TVIMDB, "imdbid");
        idTypeToParamValueMap.put(MediaIdType.TMDB, "tmdbid");
        idTypeToParamValueMap.put(MediaIdType.TVRAGE, "rid");
        idTypeToParamValueMap.put(MediaIdType.TVDB, "tvdbid");
        idTypeToParamValueMap.put(MediaIdType.TVMAZE, "tvmazeid");
        idTypeToParamValueMap.put(MediaIdType.TRAKT, "traktid");
    }
}

