/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Joiner;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.mapping.nzbindex.NzbIndexRoot;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="nzbindexapi")
@Scope(value="prototype")
public class NzbIndexApi
extends Indexer<NzbIndexRoot> {
    private static final Logger logger = LoggerFactory.getLogger(NzbIndexApi.class);
    private static final Pattern NFO_PATTERN = Pattern.compile(".*<pre id=\"nfo0\">(.*)</pre>.*", 34);
    public static final int PAGE_SIZE = 250;

    protected void completeIndexerSearchResult(NzbIndexRoot response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        indexerSearchResult.setTotalResultsKnown(true);
        indexerSearchResult.setTotalResults(response.getStats().getTotal());
        indexerSearchResult.setHasMoreResults(response.getStats().isHas_next_page());
        indexerSearchResult.setOffset(response.getStats().getPage_start());
        indexerSearchResult.setPageSize(response.getStats().getPer_page());
    }

    protected List<SearchResultItem> getSearchResultItems(NzbIndexRoot rssRoot, SearchRequest searchRequest) {
        ArrayList<SearchResultItem> items = new ArrayList<SearchResultItem>();
        for (NzbIndexRoot.Result result : rssRoot.getResults()) {
            SearchResultItem item = new SearchResultItem();
            item.setIndexer((Indexer)this);
            item.setLink("https://api.nzbindex.com/api/v3/download/?key=%s&r[]=%s".formatted(this.config.getApiKey(), result.getId()));
            item.setTitle(result.getName());
            item.setPoster(result.getPoster());
            item.setPubDate(Instant.ofEpochMilli(result.getPosted()));
            item.setAgePrecise(true);
            item.setPassworded(result.isPassword());
            item.setSize(result.getSize());
            item.setIndexerGuid(String.valueOf(result.getId()));
            item.setGroup(String.join((CharSequence)", ", result.getGroup_names()));
            item.setCategory(this.categoryProvider.getNotAvailable());
            item.setOriginalCategory("N/A");
            item.setIndexerScore(Integer.valueOf(this.config.getScore()));
            item.setHasNfo(SearchResultItem.HasNfo.NO);
            item.setDownloadType(DownloadType.NZB);
            items.add(item);
        }
        return items;
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        UriComponentsBuilder componentsBuilder = this.getBaseUri().path("api/v3/search").queryParam("key", new Object[]{this.config.getApiKey()}).queryParam("max", new Object[]{250}).queryParam("hidespam", new Object[]{"1"}).queryParam("complete", new Object[]{"1"}).queryParam("p", new Object[]{offset == null ? 0 : offset / 250});
        if (searchRequest.getMinsize().isPresent()) {
            componentsBuilder.queryParam("minsize", new Object[]{searchRequest.getMinsize().get()});
        } else if (this.config.getGeneralMinSize().isPresent()) {
            componentsBuilder.queryParam("minsize", new Object[]{this.config.getGeneralMinSize().get()});
        }
        if (searchRequest.getMaxsize().isPresent()) {
            componentsBuilder.queryParam("maxsize", new Object[]{searchRequest.getMaxsize().get()});
        }
        if (searchRequest.getMinage().isPresent()) {
            componentsBuilder.queryParam("minage", new Object[]{searchRequest.getMinage().get()});
        }
        if (searchRequest.getMaxage().isPresent()) {
            componentsBuilder.queryParam("maxage", new Object[]{searchRequest.getMaxage().get()});
        }
        String query = "";
        if (Strings.isNullOrEmpty((String)(query = this.generateQueryIfApplicable(searchRequest, query)))) {
            throw new IndexerSearchAbortedException("NzbIndex cannot search without a query");
        }
        query = this.addRequiredAndforbiddenWordsToQuery(searchRequest, query);
        query = this.cleanupQuery(query);
        componentsBuilder.queryParam("q", new Object[]{query});
        return componentsBuilder;
    }

    private String addRequiredAndforbiddenWordsToQuery(SearchRequest searchRequest, String query) {
        ArrayList requiredWords = new ArrayList(searchRequest.getInternalData().getRequiredWords());
        requiredWords.addAll(this.configProvider.getBaseConfig().getSearching().getRequiredWords());
        requiredWords.addAll(searchRequest.getCategory().getRequiredWords());
        if (!requiredWords.isEmpty()) {
            if (((String)query).length() > 256) {
                logger.warn("Stopped extending query {} as it would exceed max length of 256 characters", query);
                return query;
            }
            query = (String)query + (((String)query).isEmpty() ? "" : " ") + Joiner.on((String)" ").join(requiredWords);
        }
        ArrayList forbiddenWords = new ArrayList(searchRequest.getInternalData().getForbiddenWords());
        forbiddenWords.addAll(this.configProvider.getBaseConfig().getSearching().getForbiddenWords());
        forbiddenWords.addAll(searchRequest.getCategory().getForbiddenWords());
        if (!forbiddenWords.isEmpty()) {
            if (((String)query).length() > 256) {
                logger.warn("Stopped extending query {} as it would exceed max length of 256 characters", query);
                return query;
            }
            query = (String)query + (((String)query).isEmpty() ? "" : " ") + "-" + Joiner.on((String)" -").join(forbiddenWords);
        }
        return query;
    }

    protected String generateQueryIfApplicable(SearchRequest searchRequest, String query) throws IndexerSearchAbortedException {
        query = super.generateQueryIfApplicable(searchRequest, (String)query);
        if (searchRequest.getSearchType() == SearchType.BOOK) {
            query = (String)query + " ebook | pdf | mobi | epub";
        }
        return query;
    }

    public NfoResult getNfo(String guid) {
        return NfoResult.withoutNfo();
    }

    protected NzbIndexRoot getAndStoreResultToDatabase(URI uri, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        return (NzbIndexRoot)super.getAndStoreResultToDatabase(uri, NzbIndexRoot.class, apiAccessType);
    }

    protected Logger getLogger() {
        return logger;
    }

    protected UriComponentsBuilder getBaseUri() {
        return UriComponentsBuilder.fromHttpUrl((String)this.config.getHost());
    }
}

