/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.HashSet;
import lombok.Generated;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.mediainfo.InfoProvider;
import org.nzbhydra.mediainfo.InfoProviderException;
import org.nzbhydra.mediainfo.MediaInfo;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchRequestIdConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchRequestIdConverter.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private InfoProvider infoProvider;

    public void convertSearchIdsIfNeeded(SearchRequest searchRequest, IndexerConfig config) {
        HashMap<MediaIdType, String> params = new HashMap<MediaIdType, String>();
        boolean idConversionNeeded = this.isIdConversionNeeded(searchRequest, config);
        if (idConversionNeeded) {
            log.debug("{}: Will try to convert IDs if possible", (Object)config.getName());
            boolean canConvertAnyId = this.infoProvider.canConvertAny(searchRequest.getIdentifiers().keySet(), new HashSet(config.getSupportedSearchIds()));
            if (canConvertAnyId) {
                log.debug("{}: Can convert any of provided IDs {} to at least one of supported IDs {}", new Object[]{config.getName(), searchRequest.getIdentifiers().keySet(), config.getSupportedSearchIds()});
                try {
                    MediaInfo info = this.infoProvider.convert(searchRequest.getIdentifiers());
                    if (info.getImdbId().isPresent()) {
                        if (searchRequest.getSearchType() == SearchType.MOVIE && config.getSupportedSearchIds().contains(MediaIdType.IMDB)) {
                            params.put(MediaIdType.IMDB, ((String)info.getImdbId().get()).replace("tt", ""));
                        }
                        if (searchRequest.getSearchType() == SearchType.TVSEARCH && config.getSupportedSearchIds().contains(MediaIdType.TVIMDB)) {
                            params.put(MediaIdType.TVIMDB, ((String)info.getImdbId().get()).replace("tt", ""));
                        }
                    }
                    if (info.getTmdbId().isPresent()) {
                        params.put(MediaIdType.TMDB, (String)info.getTmdbId().get());
                    }
                    if (info.getTvRageId().isPresent()) {
                        params.put(MediaIdType.TVRAGE, (String)info.getTvRageId().get());
                    }
                    if (info.getTvMazeId().isPresent()) {
                        params.put(MediaIdType.TVMAZE, (String)info.getTvMazeId().get());
                    }
                    if (info.getTvDbId().isPresent()) {
                        params.put(MediaIdType.TVDB, (String)info.getTvDbId().get());
                    }
                    log.debug("{}: Available search IDs: {}", (Object)config.getName(), params);
                }
                catch (InfoProviderException e) {
                    log.error("{}: Error while converting search ID", (Object)config.getName(), (Object)e);
                }
            } else {
                String supportedSearchIds = config.getSupportedSearchIds().isEmpty() ? "[]" : Joiner.on((String)", ").join((Iterable)config.getSupportedSearchIds());
                log.debug("{}: Unable to convert any of the provided IDs to any of these supported IDs: {}", (Object)config.getName(), (Object)supportedSearchIds);
            }
            if (params.isEmpty()) {
                log.warn("{}: Didn't find any usable IDs to add to search request", (Object)config.getName());
            }
        }
        params.forEach((key, value) -> searchRequest.getIdentifiers().putIfAbsent(key, value));
        if (searchRequest.getSearchType() == SearchType.TVSEARCH) {
            searchRequest.getIdentifiers().remove(MediaIdType.IMDB);
        }
    }

    private boolean isIdConversionNeeded(SearchRequest searchRequest, IndexerConfig config) {
        boolean indexerNeedsConversion = searchRequest.getIdentifiers().keySet().stream().noneMatch(x -> searchRequest.getIdentifiers().get(x) != null && config.getSupportedSearchIds().contains(x));
        if (indexerNeedsConversion) {
            log.debug("{}: Indexer doesn't support any of the provided search IDs: {}", (Object)config.getName(), (Object)Joiner.on((String)", ").join(searchRequest.getIdentifiers().keySet()));
            return true;
        }
        if (searchRequest.getSource().meets(this.configProvider.getBaseConfig().getSearching().getAlwaysConvertIds())) {
            log.debug("{}: Will convert IDs as ID conversion is to be always done for {}", (Object)config.getName(), (Object)this.configProvider.getBaseConfig().getSearching().getAlwaysConvertIds());
            return true;
        }
        return false;
    }

    @Generated
    public SearchRequestIdConverter() {
    }

    @Generated
    public SearchRequestIdConverter(ConfigProvider configProvider, InfoProvider infoProvider) {
        this.configProvider = configProvider;
        this.infoProvider = infoProvider;
    }
}

