/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers.capscheck;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.nzbhydra.Jackson;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.indexers.IndexerWebAccess;
import org.nzbhydra.indexers.capscheck.IndexerChecker;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.mapping.newznab.ActionAttribute;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlError;
import org.nzbhydra.mapping.newznab.xml.caps.CapsXmlRoot;
import org.nzbhydra.mapping.newznab.xml.caps.CapsXmlSearching;
import org.nzbhydra.mapping.newznab.xml.caps.jackett.JacketCapsXmlIndexer;
import org.nzbhydra.mapping.newznab.xml.caps.jackett.JacketCapsXmlRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JacketConfigRetriever {
    private static final Logger logger = LoggerFactory.getLogger(JacketConfigRetriever.class);
    @Autowired
    private IndexerWebAccess indexerWebAccess;

    public List<IndexerConfig> retrieveIndexers(IndexerConfig jackettConfig) throws Exception {
        URI uri = IndexerChecker.getBaseUri((IndexerConfig)jackettConfig).pathSegment(new String[]{"v2.0", "indexers", "all", "results", "torznab"}).queryParam("t", new Object[]{"indexers"}).queryParam("configured", new Object[]{"true"}).build().toUri();
        logger.info("Getting configured jackett trackers from {}", (Object)uri);
        Object response = this.indexerWebAccess.get(uri, jackettConfig);
        if (response instanceof NewznabXmlError) {
            NewznabXmlError error = (NewznabXmlError)response;
            throw new IndexerAccessException("Jackett report error " + error.getCode() + ": " + error.getDescription());
        }
        if (!(response instanceof JacketCapsXmlRoot)) {
            throw new IOException("Unable to parse response from jackett");
        }
        JacketCapsXmlRoot root = (JacketCapsXmlRoot)response;
        ArrayList<IndexerConfig> configs = new ArrayList<IndexerConfig>();
        for (JacketCapsXmlIndexer indexer : root.getIndexers()) {
            IndexerConfig currentConfig = (IndexerConfig)Jackson.JSON_MAPPER.readValue(Jackson.JSON_MAPPER.writeValueAsString((Object)jackettConfig), IndexerConfig.class);
            currentConfig.setHost(IndexerChecker.getBaseUri((IndexerConfig)jackettConfig).pathSegment(new String[]{"v2.0", "indexers", indexer.getId(), "results", "torznab"}).replaceQueryParam("apikey", new Object[0]).build().toUriString());
            currentConfig.setConfigComplete(true);
            currentConfig.setAllCapsChecked(true);
            currentConfig.setSearchModuleType(SearchModuleType.TORZNAB);
            currentConfig.setName(indexer.getTitle());
            logger.info("Found configured tracker {} at Jackett", (Object)indexer.getTitle());
            CapsXmlSearching searching = indexer.getCaps().getSearching();
            IndexerChecker.fillIndexerConfigFromXmlCapsResponse((IndexerConfig)currentConfig, (CapsXmlRoot)indexer.getCaps());
            currentConfig.getSupportedSearchTypes().clear();
            if (searching.getSearch() != null && searching.getSearch().isAvailable()) {
                currentConfig.getSupportedSearchTypes().add(ActionAttribute.SEARCH);
            }
            if (searching.getAudioSearch() != null && searching.getAudioSearch().isAvailable()) {
                currentConfig.getSupportedSearchTypes().add(ActionAttribute.AUDIO);
            }
            if (searching.getTvSearch() != null && searching.getTvSearch().isAvailable()) {
                currentConfig.getSupportedSearchTypes().add(ActionAttribute.TVSEARCH);
            }
            if (searching.getMovieSearch() != null && searching.getMovieSearch().isAvailable()) {
                currentConfig.getSupportedSearchTypes().add(ActionAttribute.MOVIE);
            }
            if (searching.getBookSearch() != null && searching.getBookSearch().isAvailable()) {
                currentConfig.getSupportedSearchTypes().add(ActionAttribute.BOOK);
            }
            ArrayList<String> supportedParams = new ArrayList<String>();
            if (searching.getTvSearch() != null) {
                supportedParams.addAll(Arrays.asList(searching.getTvSearch().getSupportedParams().split(",")));
            }
            if (searching.getMovieSearch() != null) {
                supportedParams.addAll(Arrays.asList(searching.getMovieSearch().getSupportedParams().split(",")));
            }
            List supportedIds = supportedParams.stream().map(arg_0 -> this.mediaIdTypeFromString(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            currentConfig.setSupportedSearchIds(supportedIds);
            configs.add(currentConfig);
            logger.debug("Determined config: {}", (Object)currentConfig);
        }
        return configs;
    }

    private MediaIdType mediaIdTypeFromString(String string) {
        if (string == null) {
            return null;
        }
        MediaIdType mediaIdType = this.getMediaIdTypeOrNull(string.toUpperCase());
        if (mediaIdType != null) {
            return mediaIdType;
        }
        mediaIdType = this.getMediaIdTypeOrNull(string.toUpperCase().replace("ID", ""));
        if (mediaIdType != null) {
            return mediaIdType;
        }
        mediaIdType = this.getMediaIdTypeOrNull(string.toUpperCase() + "ID");
        return mediaIdType;
    }

    private MediaIdType getMediaIdTypeOrNull(String string) {
        try {
            MediaIdType mediaIdType = MediaIdType.valueOf((String)string);
            return mediaIdType;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

