/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers.capscheck;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nzbhydra.Jackson;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.indexers.capscheck.ProwlarrConfigRetriever;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.webaccess.WebAccess;
import org.nzbhydra.webaccess.WebAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProwlarrConfigRetriever {
    private static final Logger logger = LoggerFactory.getLogger(ProwlarrConfigRetriever.class);
    @Autowired
    private WebAccess webAccess;

    public List<IndexerConfig> retrieveIndexers(IndexerConfig prowlarrConfig) throws Exception {
        List prowlarrIndexers;
        String host = prowlarrConfig.getHost();
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        URI uri = URI.create(host + "/api/v1/indexer?apikey=" + prowlarrConfig.getApiKey());
        logger.info("Getting configured indexers from Prowlarr at {}", (Object)host);
        try {
            prowlarrIndexers = (List)this.webAccess.callUrl(uri.toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (WebAccessException e) {
            String message = "Error accessing Prowlarr: " + e.getMessage();
            logger.error(message);
            throw new IndexerAccessException(message, (Throwable)e);
        }
        ArrayList<IndexerConfig> configs = new ArrayList<IndexerConfig>();
        for (ProwlarrIndexer indexer : prowlarrIndexers) {
            if (!indexer.enable) {
                logger.debug("Skipping disabled Prowlarr indexer: {}", (Object)indexer.name);
                continue;
            }
            if (!"usenet".equalsIgnoreCase(indexer.protocol) && !"torrent".equalsIgnoreCase(indexer.protocol)) {
                logger.debug("Skipping Prowlarr indexer with unsupported protocol {}: {}", (Object)indexer.protocol, (Object)indexer.name);
                continue;
            }
            IndexerConfig currentConfig = (IndexerConfig)Jackson.JSON_MAPPER.readValue(Jackson.JSON_MAPPER.writeValueAsString((Object)prowlarrConfig), IndexerConfig.class);
            currentConfig.setHost(host + "/" + indexer.id);
            currentConfig.setApiKey(prowlarrConfig.getApiKey());
            currentConfig.setConfigComplete(true);
            currentConfig.setAllCapsChecked(true);
            currentConfig.setName(indexer.name + " (Prowlarr)");
            if ("usenet".equalsIgnoreCase(indexer.protocol)) {
                currentConfig.setSearchModuleType(SearchModuleType.NEWZNAB);
                logger.info("Found enabled Usenet indexer {} at Prowlarr, adding as Newznab", (Object)indexer.name);
            } else {
                currentConfig.setSearchModuleType(SearchModuleType.TORZNAB);
                logger.info("Found enabled Torrent indexer {} at Prowlarr, adding as Torznab", (Object)indexer.name);
            }
            configs.add(currentConfig);
            logger.debug("Determined config: {}", (Object)currentConfig);
        }
        return configs;
    }

    public static String extractProwlarrId(String host) {
        return StringUtils.substringAfterLast((String)host, (String)"/");
    }
}

