/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiElement;
import org.springframework.boot.ansi.AnsiStyle;

public class ColorConverter
extends org.springframework.boot.logging.logback.ColorConverter {
    private static final Map<String, AnsiElement> ELEMENTS;
    private static final Map<Integer, AnsiElement> LEVELS;

    protected String transform(ILoggingEvent event, String in) {
        AnsiElement element = (AnsiElement)ELEMENTS.get(this.getFirstOption());
        if (element == null) {
            element = (AnsiElement)LEVELS.get(event.getLevel().toInteger());
            element = element == null ? AnsiColor.GREEN : element;
        }
        return this.toAnsiString(in, element);
    }

    static {
        HashMap<String, Object> elements = new HashMap<String, Object>();
        elements.put("faint", AnsiStyle.FAINT);
        elements.put("red", AnsiColor.RED);
        elements.put("green", AnsiColor.GREEN);
        elements.put("yellow", AnsiColor.YELLOW);
        elements.put("blue", AnsiColor.BLUE);
        elements.put("magenta", AnsiColor.MAGENTA);
        elements.put("cyan", AnsiColor.CYAN);
        elements.put("blue", AnsiColor.BLUE);
        ELEMENTS = Collections.unmodifiableMap(elements);
        HashMap<Integer, AnsiColor> levels = new HashMap<Integer, AnsiColor>();
        levels.put(Level.DEBUG_INTEGER, AnsiColor.BLUE);
        levels.put(Level.ERROR_INTEGER, AnsiColor.RED);
        levels.put(Level.WARN_INTEGER, AnsiColor.YELLOW);
        LEVELS = Collections.unmodifiableMap(levels);
    }
}

