/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import jakarta.annotation.PostConstruct;
import java.util.Iterator;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EceptionFilter
extends Filter<ILoggingEvent> {
    @PostConstruct
    public void updateMarkersFilter() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger logger : context.getLoggerList()) {
            Iterator appenderIterator = logger.iteratorForAppenders();
            appenderIterator.forEachRemaining(x -> x.addFilter((Filter)this));
        }
    }

    public FilterReply decide(ILoggingEvent event) {
        if (event.getMessage() != null && (event.getMessage().contains("Servlet.service() for servlet [dispatcherServlet] threw exception") || event.getMessage().contains("Exception Processing ErrorPage"))) {
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }
}

