/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.mediainfo;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.mediainfo.Imdb;
import org.nzbhydra.mediainfo.InfoProvider;
import org.nzbhydra.mediainfo.InfoProviderException;
import org.nzbhydra.mediainfo.MediaInfo;
import org.nzbhydra.mediainfo.MovieInfo;
import org.nzbhydra.mediainfo.MovieInfoRepository;
import org.nzbhydra.mediainfo.TmdbHandler;
import org.nzbhydra.mediainfo.TmdbSearchResult;
import org.nzbhydra.mediainfo.TvInfo;
import org.nzbhydra.mediainfo.TvInfoRepository;
import org.nzbhydra.mediainfo.TvMazeHandler;
import org.nzbhydra.mediainfo.TvMazeSearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class InfoProvider {
    public static Set<MediaIdType> TV_ID_TYPES = Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.TVDB, MediaIdType.TVRAGE, MediaIdType.TVMAZE, MediaIdType.TVIMDB});
    public static Set<MediaIdType> MOVIE_ID_TYPES = Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.TMDB, MediaIdType.IMDB});
    public static Set<MediaIdType> REAL_ID_TYPES = Sets.union((Set)TV_ID_TYPES, (Set)MOVIE_ID_TYPES);
    private static final Map<MediaIdType, Set<MediaIdType>> canConvertMap = new HashMap();
    private static final Logger logger;
    private final Map<Integer, MediaInfo> mediaInfoMap = ExpiringMap.builder().expiration(5L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).build();
    @Autowired
    protected TmdbHandler tmdbHandler;
    @Autowired
    private MovieInfoRepository movieInfoRepository;
    @Autowired
    protected TvMazeHandler tvMazeHandler;
    @Autowired
    private TvInfoRepository tvInfoRepository;

    public boolean canConvert(MediaIdType from, MediaIdType to) {
        return ((Set)canConvertMap.get(from)).contains(to);
    }

    public static Set<MediaIdType> getConvertibleFrom(MediaIdType from) {
        return (Set)canConvertMap.get(from);
    }

    public boolean canConvertAny(Set<MediaIdType> from, Set<MediaIdType> to) {
        return from.stream().anyMatch(x -> {
            if (!canConvertMap.containsKey(x)) return false;
            if (!((Set)canConvertMap.get(x)).stream().anyMatch(to::contains)) return false;
            return true;
        });
    }

    @Cacheable(cacheNames={"infos"}, sync=true, cacheManager="genericCacheManager")
    public MediaInfo convert(Map<MediaIdType, String> identifiers) throws InfoProviderException {
        for (MediaIdType idType : REAL_ID_TYPES) {
            if (!identifiers.containsKey(idType) || identifiers.get(idType) == null) continue;
            try {
                return this.convert(identifiers.get(idType), idType);
            }
            catch (InfoProviderException infoProviderException) {
            }
        }
        throw new InfoProviderException("Unable to find any convertable IDs");
    }

    @Cacheable(cacheNames={"infos"}, sync=true, cacheManager="genericCacheManager")
    public synchronized MediaInfo convert(String value, MediaIdType fromType) throws InfoProviderException {
        if (value == null) {
            throw new InfoProviderException("Unable to convert IDType " + String.valueOf(fromType) + " with null value");
        }
        int hash = Objects.hash(value, fromType);
        if (this.mediaInfoMap.containsKey(hash)) {
            return (MediaInfo)this.mediaInfoMap.get(hash);
        }
        logger.debug("Conversion of {} ID {} requested", (Object)fromType, value);
        try {
            MediaInfo info;
            switch (1.$SwitchMap$org$nzbhydra$config$mediainfo$MediaIdType[fromType.ordinal()]) {
                case 1: {
                    if (!((String)value).startsWith("tt")) {
                        value = "tt" + (String)value;
                    }
                }
                case 2: 
                case 3: {
                    MovieInfo movieInfo = fromType == MediaIdType.TMDB ? this.movieInfoRepository.findByTmdbId((String)value) : (fromType == MediaIdType.IMDB ? this.movieInfoRepository.findByImdbId((String)value) : this.movieInfoRepository.findByTitle((String)value));
                    if (movieInfo != null) {
                        info = new MediaInfo(movieInfo);
                        break;
                    }
                    TmdbSearchResult result = this.tmdbHandler.getInfos((String)value, fromType);
                    info = new MediaInfo(result);
                    if (fromType == MediaIdType.TMDB) {
                        info.setTmdbId((String)value);
                    } else if (fromType == MediaIdType.IMDB) {
                        info.setImdbId((String)value);
                    }
                    movieInfo = new MovieInfo((String)info.getImdbId().orElse(null), (String)info.getTmdbId().orElse(null), (String)info.getTitle().orElse(null), (Integer)info.getYear().orElse(null), (String)info.getPosterUrl().orElse(null));
                    this.movieInfoRepository.save((Object)movieInfo);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    TvInfo tvInfo = fromType == MediaIdType.TVMAZE ? this.tvInfoRepository.findByTvmazeId((String)value) : (fromType == MediaIdType.TVDB ? this.tvInfoRepository.findByTvdbId((String)value) : (fromType == MediaIdType.TVRAGE ? this.tvInfoRepository.findByTvrageId((String)value) : (fromType == MediaIdType.TVIMDB ? this.tvInfoRepository.findByImdbId(Imdb.withTt((String)value)) : this.tvInfoRepository.findByTitle((String)value))));
                    if (tvInfo != null) {
                        info = new MediaInfo(tvInfo);
                        break;
                    }
                    TvMazeSearchResult result = this.tvMazeHandler.getInfos((String)value, fromType);
                    info = new MediaInfo(result);
                    tvInfo = new TvInfo((String)info.getTvDbId().orElse(null), (String)info.getTvRageId().orElse(null), (String)info.getTvMazeId().orElse(null), (String)info.getImdbId().orElse(null), (String)info.getTitle().orElse(null), (Integer)info.getYear().orElse(null), (String)info.getPosterUrl().orElse(null));
                    this.tvInfoRepository.save((Object)tvInfo);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong IdType");
                }
            }
            logger.debug("Conversion successful: {}", (Object)info);
            this.mediaInfoMap.put(hash, info);
            return info;
        }
        catch (Exception e) {
            logger.error("Error while converting {} {}", new Object[]{fromType, value, e});
            Throwables.throwIfInstanceOf((Throwable)e, InfoProviderException.class);
            throw new InfoProviderException("Unexpected error while converting infos", (Throwable)e);
        }
    }

    public TvInfo findTvInfoInDatabase(Map<MediaIdType, String> ids) {
        Collection matchingInfos = this.tvInfoRepository.findByTvrageIdOrTvmazeIdOrTvdbIdOrImdbId(ids.getOrDefault(MediaIdType.TVRAGE, "-1"), ids.getOrDefault(MediaIdType.TVMAZE, "-1"), ids.getOrDefault(MediaIdType.TVDB, "-1"), ids.getOrDefault(MediaIdType.IMDB, "-1"));
        return matchingInfos.stream().max(TvInfo::compareTo).orElse(null);
    }

    public MovieInfo findMovieInfoInDatabase(Map<MediaIdType, String> ids) {
        Collection matchingInfos = this.movieInfoRepository.findByImdbIdOrTmdbId(ids.getOrDefault(MediaIdType.IMDB, "-1"), ids.getOrDefault(MediaIdType.TMDB, "-1"));
        return matchingInfos.stream().max(MovieInfo::compareTo).orElse(null);
    }

    @Cacheable(cacheNames={"titles"}, sync=true, cacheManager="genericCacheManager")
    public List<MediaInfo> search(String title, MediaIdType titleType) throws InfoProviderException {
        try {
            List<MediaInfo> infos;
            switch (1.$SwitchMap$org$nzbhydra$config$mediainfo$MediaIdType[titleType.ordinal()]) {
                case 7: {
                    List results = this.tvMazeHandler.search(title);
                    infos = results.stream().map(MediaInfo::new).collect(Collectors.toList());
                    for (MediaInfo mediaInfo : infos) {
                        TvInfo tvInfo = new TvInfo(mediaInfo);
                        if (this.tvInfoRepository.findByTvrageIdOrTvmazeIdOrTvdbIdOrImdbId(tvInfo.getTvrageId().orElse("-1"), tvInfo.getTvmazeId().orElse("-1"), tvInfo.getTvdbId().orElse("-1"), tvInfo.getImdbId().orElse("-1")) != null) continue;
                        this.tvInfoRepository.save((Object)tvInfo);
                    }
                    break;
                }
                case 3: {
                    List results = this.tmdbHandler.search(title, null);
                    infos = results.stream().map(MediaInfo::new).collect(Collectors.toList());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong IdType");
                }
            }
            return infos;
        }
        catch (Exception e) {
            logger.error("Error while searching for {} {}", new Object[]{titleType, title, e});
            Throwables.throwIfInstanceOf((Throwable)e, InfoProviderException.class);
            throw new InfoProviderException("Unexpected error while converting infos", (Throwable)e);
        }
    }

    static {
        canConvertMap.put(MediaIdType.TVDB, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.TVDB, MediaIdType.TVMAZE, MediaIdType.TVRAGE, MediaIdType.TVIMDB, MediaIdType.TVTITLE}));
        canConvertMap.put(MediaIdType.TVMAZE, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.TVDB, MediaIdType.TVMAZE, MediaIdType.TVRAGE, MediaIdType.TVIMDB, MediaIdType.TVTITLE}));
        canConvertMap.put(MediaIdType.TVRAGE, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.TVDB, MediaIdType.TVMAZE, MediaIdType.TVRAGE, MediaIdType.TVIMDB, MediaIdType.TVTITLE}));
        canConvertMap.put(MediaIdType.TVIMDB, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.TVIMDB, MediaIdType.TVMAZE, MediaIdType.TVRAGE, MediaIdType.TVDB, MediaIdType.TVTITLE}));
        canConvertMap.put(MediaIdType.TRAKT, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.TRAKT}));
        canConvertMap.put(MediaIdType.TVTITLE, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.TVDB, MediaIdType.TVMAZE, MediaIdType.TVRAGE, MediaIdType.TVIMDB, MediaIdType.TVTITLE}));
        canConvertMap.put(MediaIdType.TMDB, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.IMDB, MediaIdType.TMDB, MediaIdType.TVDB, MediaIdType.TVMAZE, MediaIdType.TVRAGE, MediaIdType.MOVIETITLE}));
        canConvertMap.put(MediaIdType.IMDB, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.IMDB, MediaIdType.TMDB, MediaIdType.MOVIETITLE}));
        canConvertMap.put(MediaIdType.MOVIETITLE, Sets.newHashSet((Object[])new MediaIdType[]{MediaIdType.IMDB, MediaIdType.TMDB, MediaIdType.MOVIETITLE}));
        logger = LoggerFactory.getLogger(InfoProvider.class);
    }
}

