/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.mediainfo;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.net.UrlEscapers;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.mediainfo.AutocompleteType;
import org.nzbhydra.mediainfo.InfoProvider;
import org.nzbhydra.mediainfo.InfoProviderException;
import org.nzbhydra.mediainfo.MediaInfo;
import org.nzbhydra.mediainfo.MediaInfoTO;
import org.nzbhydra.mediainfo.MediaInfoWeb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MediaInfoWeb {
    private static final Logger logger = LoggerFactory.getLogger(MediaInfoWeb.class);
    @Autowired
    private InfoProvider infoProvider;
    @Autowired
    private ConfigProvider configProvider;
    private final LoadingCache<CacheKey, List<MediaInfoTO>> autocompleteCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(7L, TimeUnit.DAYS).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    @RequestMapping(value={"/internalapi/autocomplete/{type}"}, produces={"application/json"})
    public List<MediaInfoTO> autocomplete(@PathVariable(value="type") AutocompleteType type, @RequestParam(value="input") String input) throws ExecutionException {
        try {
            List tos = (List)this.autocompleteCache.get((Object)new CacheKey(type, input));
            if (this.configProvider.getBaseConfig().getMain().isProxyImages()) {
                tos.stream().filter(to -> to.getPosterUrl() != null).forEach(to -> {
                    if (!to.getPosterUrl().startsWith("cache/")) {
                        to.setPosterUrl("cache/" + Base64.getEncoder().encodeToString(to.getPosterUrl().getBytes(StandardCharsets.UTF_8)));
                    }
                });
            }
            return tos;
        }
        catch (ExecutionException e) {
            logger.warn("Error while trying to find autocomplete data for input {}: {}", (Object)input, (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    @RequestMapping(value={"/internalapi/autocomplete/{type}/"}, produces={"application/json"})
    public List<MediaInfoTO> autocompleteTrailingSlash(@PathVariable(value="type") AutocompleteType type, @RequestParam(value="input") String input) throws ExecutionException {
        return this.autocomplete(type, input);
    }

    @RequestMapping(value={"/internalapi/redirectRid/{rid}"}, method={RequestMethod.GET}, consumes={"*/*"})
    public String redirectTvRageId(@PathVariable(value="rid") String tvRageId, HttpServletResponse response) throws IOException {
        Object url = null;
        try {
            MediaInfo mediaInfo = this.infoProvider.convert(tvRageId, MediaIdType.TVRAGE);
            if (mediaInfo != null && mediaInfo.getTvMazeId().isPresent()) {
                url = "https://www.tvmaze.com/shows/" + (String)mediaInfo.getTvMazeId().get();
                Optional derefererOptional = this.configProvider.getBaseConfig().getMain().getDereferer();
                if (derefererOptional.isPresent() && !Strings.isNullOrEmpty((String)((String)derefererOptional.get()))) {
                    url = ((String)derefererOptional.get()).replace("$s", UrlEscapers.urlFragmentEscaper().escape((String)url)).replace("$us", (CharSequence)url);
                }
            }
        }
        catch (InfoProviderException infoProviderException) {
            // empty catch block
        }
        if (url != null) {
            logger.info("Redirecting to URL {}", url);
            response.sendRedirect(url);
            return "";
        }
        return "TVMaze doesn't know this show and as TVRage doesn't exist anymore I can't provide you with infos on this show :-(";
    }

    private static MediaInfoTO from(MediaInfo info) {
        MediaInfoTO to = new MediaInfoTO();
        to.setImdbId((String)info.getImdbId().orElse(null));
        to.setTmdbId((String)info.getTmdbId().orElse(null));
        to.setTvmazeId((String)info.getTvMazeId().orElse(null));
        to.setTvrageId((String)info.getTvRageId().orElse(null));
        to.setTvdbId((String)info.getTvDbId().orElse(null));
        to.setTitle((String)info.getTitle().orElse(null));
        to.setYear((Integer)info.getYear().orElse(null));
        to.setPosterUrl((String)info.getPosterUrl().orElse(null));
        return to;
    }
}

