/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.mediainfo;

import com.google.common.base.Strings;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Optional;
import lombok.Generated;
import org.nzbhydra.mediainfo.Imdb;
import org.nzbhydra.mediainfo.MediaInfo;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
@Entity
@Table(name="movieinfo")
public final class MovieInfo
implements Comparable<MovieInfo> {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @SequenceGenerator(allocationSize=1, name="MOVIEINFO_SEQ")
    protected int id;
    private String imdbId;
    private String tmdbId;
    private String title;
    private Integer year;
    private String posterUrl;

    public MovieInfo(String imdbId, String tmdbId, String title, Integer year, String posterUrl) {
        this.imdbId = Imdb.withTt((String)imdbId);
        this.tmdbId = tmdbId;
        this.title = title;
        this.year = year;
        this.posterUrl = posterUrl;
    }

    public MovieInfo(MediaInfo mediaInfo) {
        this.imdbId = mediaInfo.getImdbId().orElse(null);
        this.tmdbId = mediaInfo.getTmdbId().orElse(null);
        this.title = mediaInfo.getTitle().orElse(null);
        this.year = mediaInfo.getYear().orElse(null);
        this.posterUrl = mediaInfo.getPosterUrl().orElse(null);
    }

    public MovieInfo() {
    }

    public Optional<String> getImdbId() {
        return Optional.ofNullable(Imdb.withTt((String)Strings.emptyToNull((String)this.imdbId)));
    }

    public Optional<String> getTmdbId() {
        return Optional.ofNullable(Strings.emptyToNull((String)this.tmdbId));
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(Strings.emptyToNull((String)this.title));
    }

    public Optional<String> getPosterUrl() {
        return Optional.ofNullable(Strings.emptyToNull((String)this.posterUrl));
    }

    @Override
    public int compareTo(MovieInfo o) {
        if (o == null) {
            return 1;
        }
        return Integer.compare(this.getNumberOfContainedIds(), o.getNumberOfContainedIds());
    }

    protected int getNumberOfContainedIds() {
        int countContainedIds = 0;
        if (this.getImdbId().isPresent()) {
            ++countContainedIds;
        }
        if (this.getTmdbId().isPresent()) {
            ++countContainedIds;
        }
        return countContainedIds;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public Integer getYear() {
        return this.year;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    @Generated
    public void setTmdbId(String tmdbId) {
        this.tmdbId = tmdbId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setYear(Integer year) {
        this.year = year;
    }

    @Generated
    public void setPosterUrl(String posterUrl) {
        this.posterUrl = posterUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MovieInfo)) {
            return false;
        }
        MovieInfo other = (MovieInfo)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        Optional this$imdbId = this.getImdbId();
        Optional other$imdbId = other.getImdbId();
        if (this$imdbId == null ? other$imdbId != null : !((Object)this$imdbId).equals(other$imdbId)) {
            return false;
        }
        Optional this$tmdbId = this.getTmdbId();
        Optional other$tmdbId = other.getTmdbId();
        if (this$tmdbId == null ? other$tmdbId != null : !((Object)this$tmdbId).equals(other$tmdbId)) {
            return false;
        }
        Optional this$title = this.getTitle();
        Optional other$title = other.getTitle();
        if (this$title == null ? other$title != null : !((Object)this$title).equals(other$title)) {
            return false;
        }
        Optional this$posterUrl = this.getPosterUrl();
        Optional other$posterUrl = other.getPosterUrl();
        return !(this$posterUrl == null ? other$posterUrl != null : !((Object)this$posterUrl).equals(other$posterUrl));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        Optional $imdbId = this.getImdbId();
        result = result * 59 + ($imdbId == null ? 43 : ((Object)$imdbId).hashCode());
        Optional $tmdbId = this.getTmdbId();
        result = result * 59 + ($tmdbId == null ? 43 : ((Object)$tmdbId).hashCode());
        Optional $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : ((Object)$title).hashCode());
        Optional $posterUrl = this.getPosterUrl();
        result = result * 59 + ($posterUrl == null ? 43 : ((Object)$posterUrl).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MovieInfo(id=" + this.getId() + ", imdbId=" + String.valueOf(this.getImdbId()) + ", tmdbId=" + String.valueOf(this.getTmdbId()) + ", title=" + String.valueOf(this.getTitle()) + ", year=" + this.getYear() + ", posterUrl=" + String.valueOf(this.getPosterUrl()) + ")";
    }
}

