/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.mediainfo;

import com.google.common.base.Strings;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Optional;
import lombok.Generated;
import org.nzbhydra.mediainfo.Imdb;
import org.nzbhydra.mediainfo.MediaInfo;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
@Entity
@Table(name="tvinfo")
public final class TvInfo
implements Comparable<TvInfo> {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @SequenceGenerator(allocationSize=1, name="TVINFO_SEQ")
    protected int id;
    @Column(unique=true)
    private String tvdbId;
    @Column(unique=true)
    private String tvrageId;
    @Column(unique=true)
    private String tvmazeId;
    @Column(unique=true)
    private String imdbId;
    private String title;
    private Integer year;
    private String posterUrl;

    public TvInfo(String tvdbId, String tvrageId, String tvmazeId, String imdbId, String title, Integer year, String posterUrl) {
        this.tvdbId = tvdbId;
        this.tvrageId = tvrageId;
        this.tvmazeId = tvmazeId;
        this.imdbId = Imdb.withTt((String)imdbId);
        this.title = title;
        this.year = year;
        this.posterUrl = posterUrl;
    }

    public TvInfo(MediaInfo mediaInfo) {
        this.tvdbId = mediaInfo.getTvDbId().orElse(null);
        this.tvrageId = mediaInfo.getTvRageId().orElse(null);
        this.tvmazeId = mediaInfo.getTvMazeId().orElse(null);
        this.imdbId = mediaInfo.getImdbId().orElse(null);
        this.title = mediaInfo.getTitle().orElse(null);
        this.year = mediaInfo.getYear().orElse(null);
        this.posterUrl = mediaInfo.getPosterUrl().orElse(null);
    }

    public TvInfo() {
    }

    public Optional<String> getTvdbId() {
        return Optional.ofNullable(Strings.emptyToNull((String)this.tvdbId));
    }

    public Optional<String> getTvrageId() {
        return Optional.ofNullable(Strings.emptyToNull((String)this.tvrageId));
    }

    public Optional<String> getTvmazeId() {
        return Optional.ofNullable(Strings.emptyToNull((String)this.tvmazeId));
    }

    public Optional<String> getImdbId() {
        return Optional.ofNullable(Imdb.withTt((String)this.imdbId));
    }

    public Optional<String> getPosterUrl() {
        return Optional.ofNullable(Strings.emptyToNull((String)this.posterUrl));
    }

    @Override
    public int compareTo(TvInfo o) {
        if (o == null) {
            return 1;
        }
        return Integer.compare(this.getNumberOfContainedIds(), o.getNumberOfContainedIds());
    }

    protected int getNumberOfContainedIds() {
        int countContainedIds = 0;
        if (this.getTvmazeId().isPresent()) {
            ++countContainedIds;
        }
        if (this.getTvrageId().isPresent()) {
            ++countContainedIds;
        }
        if (this.getTvdbId().isPresent()) {
            ++countContainedIds;
        }
        if (this.getImdbId().isPresent()) {
            ++countContainedIds;
        }
        return countContainedIds;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public Integer getYear() {
        return this.year;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setTvdbId(String tvdbId) {
        this.tvdbId = tvdbId;
    }

    @Generated
    public void setTvrageId(String tvrageId) {
        this.tvrageId = tvrageId;
    }

    @Generated
    public void setTvmazeId(String tvmazeId) {
        this.tvmazeId = tvmazeId;
    }

    @Generated
    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setYear(Integer year) {
        this.year = year;
    }

    @Generated
    public void setPosterUrl(String posterUrl) {
        this.posterUrl = posterUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TvInfo)) {
            return false;
        }
        TvInfo other = (TvInfo)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        Optional this$tvdbId = this.getTvdbId();
        Optional other$tvdbId = other.getTvdbId();
        if (this$tvdbId == null ? other$tvdbId != null : !((Object)this$tvdbId).equals(other$tvdbId)) {
            return false;
        }
        Optional this$tvrageId = this.getTvrageId();
        Optional other$tvrageId = other.getTvrageId();
        if (this$tvrageId == null ? other$tvrageId != null : !((Object)this$tvrageId).equals(other$tvrageId)) {
            return false;
        }
        Optional this$tvmazeId = this.getTvmazeId();
        Optional other$tvmazeId = other.getTvmazeId();
        if (this$tvmazeId == null ? other$tvmazeId != null : !((Object)this$tvmazeId).equals(other$tvmazeId)) {
            return false;
        }
        Optional this$imdbId = this.getImdbId();
        Optional other$imdbId = other.getImdbId();
        if (this$imdbId == null ? other$imdbId != null : !((Object)this$imdbId).equals(other$imdbId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Optional this$posterUrl = this.getPosterUrl();
        Optional other$posterUrl = other.getPosterUrl();
        return !(this$posterUrl == null ? other$posterUrl != null : !((Object)this$posterUrl).equals(other$posterUrl));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        Optional $tvdbId = this.getTvdbId();
        result = result * 59 + ($tvdbId == null ? 43 : ((Object)$tvdbId).hashCode());
        Optional $tvrageId = this.getTvrageId();
        result = result * 59 + ($tvrageId == null ? 43 : ((Object)$tvrageId).hashCode());
        Optional $tvmazeId = this.getTvmazeId();
        result = result * 59 + ($tvmazeId == null ? 43 : ((Object)$tvmazeId).hashCode());
        Optional $imdbId = this.getImdbId();
        result = result * 59 + ($imdbId == null ? 43 : ((Object)$imdbId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Optional $posterUrl = this.getPosterUrl();
        result = result * 59 + ($posterUrl == null ? 43 : ((Object)$posterUrl).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TvInfo(id=" + this.getId() + ", tvdbId=" + String.valueOf(this.getTvdbId()) + ", tvrageId=" + String.valueOf(this.getTvrageId()) + ", tvmazeId=" + String.valueOf(this.getTvmazeId()) + ", imdbId=" + String.valueOf(this.getImdbId()) + ", title=" + this.getTitle() + ", year=" + this.getYear() + ", posterUrl=" + String.valueOf(this.getPosterUrl()) + ")";
    }
}

