/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.misc;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OpenPortChecker {
    private static final Logger logger = LoggerFactory.getLogger(OpenPortChecker.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPortOpen(@Nullable String ip, String port) throws IOException {
        if (ip == null) {
            ip = this.getPublicIp();
        }
        try (WebClient webClient = new WebClient(BrowserVersion.getDefault(), false, null, -1);){
            webClient.getOptions().setThrowExceptionOnScriptError(false);
            webClient.getOptions().setCssEnabled(false);
            HtmlPage page1 = (HtmlPage)webClient.getPage("https://portchecker.co/check");
            HtmlForm form = (HtmlForm)page1.getForms().get(0);
            HtmlTextInput ipField = (HtmlTextInput)((HtmlForm)page1.getForms().get(0)).getElementsByTagName("input").get(0);
            ipField.setValue(ip);
            HtmlTextInput portField = (HtmlTextInput)((HtmlForm)page1.getForms().get(0)).getElementsByTagName("input").get(1);
            portField.setValue(port);
            HtmlButton button = (HtmlButton)((HtmlForm)page1.getForms().get(0)).getElementsByTagName("button").get(0);
            HtmlPage page2 = (HtmlPage)button.click();
            String result = page2.getElementById("results-wrapper").getTextContent();
            if (result.toLowerCase().contains("open")) {
                boolean bl = true;
                return bl;
            }
            if (result.toLowerCase().contains("closed")) {
                boolean bl = false;
                return bl;
            }
            logger.error("Unable to determine if port is open from response: {}", (Object)result);
            throw new IOException("Unable to determine if port " + port + " at public IP " + ip + " is open");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getPublicIp() {
        Scanner s = new Scanner(new URL("https://api.ipify.org").openStream(), "UTF-8").useDelimiter("\\A");
        try {
            String publicIp = s.next();
            logger.debug("Public IP: {}", (Object)publicIp);
            String string = publicIp;
            if (s != null) {
                s.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

