/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.news;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.nzbhydra.Jackson;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.news.UserNewsEntry;
import org.nzbhydra.news.UserNewsProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserNewsProvider {
    private static final String USER_NEWS_FILE = "userNews.json";
    private static final String SHOWN_USER_NEWS_KEY = "shownUserNews";
    @Autowired
    private GenericStorage genericStorage;

    public List<UserNewsEntry> getAllUserNews() {
        File userNewsFile = new File(NzbHydra.getDataFolder(), USER_NEWS_FILE);
        if (!userNewsFile.exists()) {
            return Collections.emptyList();
        }
        try {
            return (List)Jackson.JSON_MAPPER.readValue(userNewsFile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public List<UserNewsEntry> getUnreadUserNewsForUser(String username) {
        List allNews = this.getAllUserNews();
        if (allNews.isEmpty()) {
            return Collections.emptyList();
        }
        Set shownNewsIds = this.getShownNewsIdsForUser(username);
        return allNews.stream().filter(entry -> !shownNewsIds.contains(entry.getId())).collect(Collectors.toList());
    }

    public void markNewsAsShownForUser(String username, String newsId) {
        Set shownNewsIds = this.getShownNewsIdsForUser(username);
        shownNewsIds.add(newsId);
        this.genericStorage.save(this.getStorageKey(username), (Serializable)new ShownUserNewsIds(shownNewsIds));
    }

    private Set<String> getShownNewsIdsForUser(String username) {
        String key = this.getStorageKey(username);
        return this.genericStorage.get(key, ShownUserNewsIds.class).map(ShownUserNewsIds::getIds).orElse(new HashSet());
    }

    private String getStorageKey(String username) {
        return "shownUserNews-" + username;
    }
}

