/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.notifications;

import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import lombok.Generated;
import org.nzbhydra.config.notification.NotificationEventType;
import org.nzbhydra.notifications.NotificationMessageType;
import org.nzbhydra.springnative.ReflectionMarker;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@ReflectionMarker
@Entity
@Table(name="notification")
public final class NotificationEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @SequenceGenerator(allocationSize=1, name="NOTIFICATION_SEQ")
    protected int id;
    @Enumerated(value=EnumType.STRING)
    private NotificationEventType notificationEventType;
    @Enumerated(value=EnumType.STRING)
    private NotificationMessageType messageType;
    private String title;
    private String body;
    private String urls;
    @Convert(converter=Jsr310JpaConverters.InstantConverter.class)
    private Instant time;
    private boolean displayed;

    public NotificationEntity() {
    }

    public NotificationEntity(NotificationEventType notificationEventType, NotificationMessageType messageType, String title, String body, String urls, Instant time) {
        this.notificationEventType = notificationEventType;
        this.title = title;
        this.body = body;
        this.urls = urls;
        this.time = time;
        this.messageType = messageType;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public NotificationEventType getNotificationEventType() {
        return this.notificationEventType;
    }

    @Generated
    public NotificationMessageType getMessageType() {
        return this.messageType;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public String getUrls() {
        return this.urls;
    }

    @Generated
    public Instant getTime() {
        return this.time;
    }

    @Generated
    public boolean isDisplayed() {
        return this.displayed;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setNotificationEventType(NotificationEventType notificationEventType) {
        this.notificationEventType = notificationEventType;
    }

    @Generated
    public void setMessageType(NotificationMessageType messageType) {
        this.messageType = messageType;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public void setUrls(String urls) {
        this.urls = urls;
    }

    @Generated
    public void setTime(Instant time) {
        this.time = time;
    }

    @Generated
    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationEntity)) {
            return false;
        }
        NotificationEntity other = (NotificationEntity)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isDisplayed() != other.isDisplayed()) {
            return false;
        }
        NotificationEventType this$notificationEventType = this.getNotificationEventType();
        NotificationEventType other$notificationEventType = other.getNotificationEventType();
        if (this$notificationEventType == null ? other$notificationEventType != null : !this$notificationEventType.equals(other$notificationEventType)) {
            return false;
        }
        NotificationMessageType this$messageType = this.getMessageType();
        NotificationMessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$urls = this.getUrls();
        String other$urls = other.getUrls();
        if (this$urls == null ? other$urls != null : !this$urls.equals(other$urls)) {
            return false;
        }
        Instant this$time = this.getTime();
        Instant other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + (this.isDisplayed() ? 79 : 97);
        NotificationEventType $notificationEventType = this.getNotificationEventType();
        result = result * 59 + ($notificationEventType == null ? 43 : $notificationEventType.hashCode());
        NotificationMessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : $urls.hashCode());
        Instant $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotificationEntity(id=" + this.getId() + ", notificationEventType=" + String.valueOf(this.getNotificationEventType()) + ", messageType=" + String.valueOf(this.getMessageType()) + ", title=" + this.getTitle() + ", body=" + this.getBody() + ", urls=" + this.getUrls() + ", time=" + String.valueOf(this.getTime()) + ", displayed=" + this.isDisplayed() + ")";
    }
}

