/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.problemdetection;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.logging.LogContentProvider;
import org.nzbhydra.problemdetection.OutOfMemoryDetector;
import org.nzbhydra.problemdetection.ProblemDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutOfMemoryDetector
implements ProblemDetector {
    private static final Logger logger = LoggerFactory.getLogger(OutOfMemoryDetector.class);
    @Autowired
    private GenericStorage genericStorage;
    @Autowired
    private LogContentProvider logContentProvider;

    public void executeCheck() {
        try {
            AtomicReference<State> state = new AtomicReference<State>();
            state.set(State.LOOKING_FOR_OOM);
            AtomicReference lastTimeStampLine = new AtomicReference();
            File currentLogfile = this.logContentProvider.getCurrentLogfile(false);
            if (!currentLogfile.exists()) {
                return;
            }
            try (Stream<String> lines = Files.lines(currentLogfile.toPath(), StandardCharsets.ISO_8859_1);){
                lines.forEach(line -> {
                    if (line.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.*")) {
                        if (state.get() == State.LOOKING_FOR_OOM) {
                            lastTimeStampLine.set(line);
                        }
                        if (state.get() == State.LOOKING_FOR_OOM_END) {
                            state.set(State.LOOKING_FOR_OOM);
                        }
                        return;
                    }
                    if (line.contains("java.lang.OutOfMemoryError") && state.get() == State.LOOKING_FOR_OOM) {
                        String key = "outOfMemoryDetected-" + (String)lastTimeStampLine.get();
                        boolean alreadyDetected = this.genericStorage.get(key, String.class).isPresent();
                        if (!alreadyDetected) {
                            logger.warn("The log indicates that the process ran out of memory. Please increase the XMX value in the main config and restart.");
                            this.genericStorage.save(key, (Serializable)Boolean.valueOf(true));
                            this.genericStorage.save("outOfMemoryDetected", (Serializable)Boolean.valueOf(true));
                        }
                        state.set(State.LOOKING_FOR_OOM_END);
                    }
                });
            }
        }
        catch (IOException e) {
            logger.warn("Unable to read log file", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Unable to detect problems in log file", (Throwable)e);
        }
    }
}

