/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.problemdetection;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.notifications.IndexerVipExpiryNotificationEvent;
import org.nzbhydra.problemdetection.ProblemDetector;
import org.nzbhydra.problemdetection.VipExpiryDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class VipExpiryDetector
implements ProblemDetector {
    private static final String KEY = "VIP_EXPIRY";
    private static final Logger logger = LoggerFactory.getLogger(VipExpiryDetector.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private GenericStorage genericStorage;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void executeCheck() {
        List<IndexerConfig> indexersSoonExpiring = this.configProvider.getBaseConfig().getIndexers().stream().filter(x -> !Strings.isNullOrEmpty((String)x.getVipExpirationDate()) && !x.getVipExpirationDate().equals("Lifetime")).filter(x -> {
            try {
                LocalDate expiryDate = LocalDate.parse(x.getVipExpirationDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                return expiryDate.isBefore(LocalDate.now().plusDays(14L)) && expiryDate.isAfter(LocalDate.now());
            }
            catch (Exception e) {
                logger.error("Unable to parse expiry date {}", (Object)x.getVipExpirationDate(), (Object)e);
                return false;
            }
        }).toList();
        logger.debug(LoggingMarkers.VIP_EXPIRY, "Found indexers with VIP expiry data in the next 14 days: {}", (Object)indexersSoonExpiring.stream().map(x -> x.getName() + ": " + x.getVipExpirationDate()).collect(Collectors.joining(", ")));
        VipExpiryData vipExpiryData = this.genericStorage.get(KEY, VipExpiryData.class).orElse(new VipExpiryData());
        for (IndexerConfig indexerConfig : indexersSoonExpiring) {
            VipExpiryDataEntry toCheck = new VipExpiryDataEntry(indexerConfig.getName(), indexerConfig.getVipExpirationDate());
            Optional<VipExpiryDataEntry> alreadyReported = vipExpiryData.entries.stream().filter(x -> x.equals((Object)toCheck)).findFirst();
            if (alreadyReported.isPresent()) {
                logger.debug(LoggingMarkers.VIP_EXPIRY, "Already notified of {}", (Object)alreadyReported.get());
                continue;
            }
            logger.warn("VIP access for {} will expire at {}", (Object)indexerConfig.getName(), (Object)indexerConfig.getVipExpirationDate());
            this.applicationEventPublisher.publishEvent((Object)new IndexerVipExpiryNotificationEvent(indexerConfig.getName(), indexerConfig.getVipExpirationDate()));
            vipExpiryData.entries.add(new VipExpiryDataEntry(indexerConfig.getName(), indexerConfig.getVipExpirationDate()));
            this.genericStorage.save(KEY, (Serializable)vipExpiryData);
        }
    }
}

