/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.SearchSourceRestriction;
import org.nzbhydra.config.category.CategoriesConfig;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.logging.LoggingMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ConfigurationProperties
@EnableConfigurationProperties
public class CategoryProvider
implements InitializingBean {
    public static final Category naCategory = new Category("N/A");
    private static final Logger logger = LoggerFactory.getLogger(CategoryProvider.class);
    @Autowired
    protected BaseConfig baseConfig;
    private List<Category> categories;
    protected Map<String, Category> categoryMap = new HashMap();
    protected Map<Integer, Category> categoryMapByNumber = new HashMap();
    protected Map<List<Integer>, Category> categoryMapByMultipleNumber = new HashMap();

    public CategoryProvider() {
        naCategory.setApplyRestrictionsType(SearchSourceRestriction.NONE);
        naCategory.setIgnoreResultsFrom(SearchSourceRestriction.NONE);
        naCategory.setMayBeSelected(false);
        naCategory.setSearchType(null);
    }

    public void afterPropertiesSet() {
        this.initialize();
    }

    @EventListener
    public void handleNewConfigEvent(ConfigChangedEvent newConfig) {
        this.initialize();
    }

    protected void initialize() {
        this.categories = this.baseConfig.getCategoriesConfig().getCategories();
        if (this.categories != null) {
            this.categoryMap = this.categories.stream().collect(Collectors.toMap(Category::getName, Function.identity()));
            this.categoryMapByNumber.clear();
            for (Category category : this.categories) {
                for (Integer integer : category.getNewznabCategories().stream().filter(x -> x.size() == 1).map(x -> (Integer)x.get(0)).toList()) {
                    this.categoryMapByNumber.put(integer, category);
                }
                category.getNewznabCategories().stream().filter(x -> x.size() > 1).forEach(x -> this.categoryMapByMultipleNumber.put(x, category));
            }
        } else {
            logger.error("Configuration incomplete, categories not set");
            this.categoryMap = Collections.emptyMap();
            this.categoryMapByNumber = new HashMap();
        }
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public Category getByInternalName(String name) {
        if (name == null) {
            return this.getNotAvailable();
        }
        if (name.equalsIgnoreCase("all")) {
            return CategoriesConfig.allCategory;
        }
        if (!this.categoryMap.containsKey(name)) {
            return this.getNotAvailable();
        }
        return (Category)this.categoryMap.get(name);
    }

    public Category getNotAvailable() {
        return naCategory;
    }

    public Category fromSearchNewznabCategories(String cats) {
        if (Strings.isNullOrEmpty((String)cats)) {
            return this.getNotAvailable();
        }
        try {
            return this.fromSearchNewznabCategories(Arrays.stream(cats.split(",")).map(Integer::valueOf).collect(Collectors.toList()), this.getNotAvailable());
        }
        catch (NumberFormatException e) {
            logger.error("Unable to parse categories string '{}'", (Object)cats);
            return this.getNotAvailable();
        }
    }

    public Optional<Category> fromSubtype(Category.Subtype subtype) {
        return this.categories.stream().filter(x -> x.getSubtype() == subtype).findFirst();
    }

    public Category fromSearchNewznabCategories(List<Integer> cats, Category defaultCategory) {
        if (cats == null || cats.size() == 0) {
            return defaultCategory;
        }
        Category matchingCategory = this.getCategory(cats, defaultCategory);
        if (matchingCategory != null) {
            return matchingCategory;
        }
        return defaultCategory;
    }

    public Category fromResultNewznabCategories(List<Integer> cats) {
        if (cats == null || cats.isEmpty()) {
            logger.debug(LoggingMarkers.CATEGORY_MAPPING, "Empty newznab categories -> N/A");
            return naCategory;
        }
        cats.sort((o1, o2) -> Integer.compare(o2, o1));
        return this.getMatchingCategoryOrMatchingMainCategory(cats, naCategory);
    }

    protected Category getCategory(List<Integer> cats, Category defaultCategory) {
        Category category;
        if (cats == null || cats.isEmpty()) {
            return defaultCategory;
        }
        if (cats.size() == 1) {
            return this.categoryMapByNumber.getOrDefault(cats.get(0), this.getMatchingCategoryOrMatchingMainCategory(cats, defaultCategory));
        }
        Category result = null;
        cats.sort((o1, o2) -> Integer.compare(o2, o1));
        String catsString = Joiner.on((String)",").join(cats);
        List<Integer> foundMainCategories = cats.stream().filter(x -> x % 1000 == 0).toList();
        if (!foundMainCategories.isEmpty() && (category = (Category)this.categoryMapByNumber.get(foundMainCategories.get(0))) != null) {
            if (foundMainCategories.size() > 1) {
                logger.warn("Search supplied multiple main categories: {}. Will use {}", (Object)catsString, (Object)category.getName());
            } else if (cats.size() > 1) {
                logger.warn("Search supplied a general category and a subcategory: {}. Will use the category {}", (Object)catsString, (Object)category.getName());
            }
            return category;
        }
        if (cats.size() == 1) {
            result = this.getMatchingCategoryOrMatchingMainCategory(cats, defaultCategory);
        } else {
            List<Integer> matchingSubcategories = cats.stream().filter(cat -> this.categoryMapByNumber.containsKey(cat)).toList();
            if (matchingSubcategories.size() == 1) {
                result = (Category)this.categoryMapByNumber.get(matchingSubcategories.get(0));
            } else if (matchingSubcategories.size() == 0) {
                result = this.getMatchingCategoryOrMatchingMainCategory(cats, defaultCategory);
            } else if (matchingSubcategories.stream().map(x -> (Category)this.categoryMapByNumber.get(x)).distinct().count() == 1L) {
                result = (Category)this.categoryMapByNumber.get(matchingSubcategories.get(0));
            }
        }
        if (result != null) {
            logger.debug("Found category {} matching newznab categories {}", (Object)result.getName(), (Object)catsString);
            return result;
        }
        logger.debug("The supplied categories {} match multiple configured categories", (Object)catsString);
        for (Integer cat2 : cats) {
            for (Category category2 : this.categories) {
                Optional<List> matchingMainCategory = category2.getNewznabCategories().stream().filter(x -> x.size() == 1 && CategoryProvider.checkCategoryMatchingMainCategory((int)cat2, (int)((Integer)x.get(0)))).findFirst();
                if (!matchingMainCategory.isPresent()) continue;
                logger.debug("The supplied categories {} match the configured main category {} and will be assigned to that", (Object)catsString, (Object)category2.getName());
                return category2;
            }
        }
        result = this.getMatchingCategoryOrMatchingMainCategory(cats, defaultCategory);
        logger.warn("Unable to match the supplied categories {} to any specific or general category. Will use {}", (Object)catsString, (Object)(result == null ? defaultCategory : result).getName());
        return result;
    }

    public static boolean checkCategoryMatchingMainCategory(int cat, int possibleMainCat) {
        return possibleMainCat % 1000 == 0 && cat / 1000 == possibleMainCat / 1000;
    }

    public Category getMatchingCategoryOrMatchingMainCategory(List<Integer> cats, Category defaultCategory) {
        for (Map.Entry listCategoryEntry : this.categoryMapByMultipleNumber.entrySet()) {
            if (!new HashSet<Integer>(cats).containsAll((Collection)listCategoryEntry.getKey())) continue;
            logger.debug(LoggingMarkers.CATEGORY_MAPPING, "Determined {} from {} via combined categories {}", new Object[]{listCategoryEntry.getValue(), cats, listCategoryEntry.getKey()});
            return (Category)listCategoryEntry.getValue();
        }
        for (Integer cat : cats) {
            if (!this.categoryMapByNumber.containsKey(cat)) continue;
            logger.debug(LoggingMarkers.CATEGORY_MAPPING, "Determined {} matching directly {}", this.categoryMapByNumber.get(cat), (Object)cat);
            return (Category)this.categoryMapByNumber.get(cat);
        }
        Optional found = Optional.empty();
        for (Category category : this.categories) {
            List<Integer> categorySingleNewznabNumbers = category.getNewznabCategories().stream().filter(x -> x.size() == 1).map(x -> (Integer)x.get(0)).toList();
            for (Integer cat : cats) {
                if (!categorySingleNewznabNumbers.contains(cat / 1000 * 1000)) continue;
                logger.debug(LoggingMarkers.CATEGORY_MAPPING, "Determined {} matching generally {}", (Object)cat, (Object)category);
                return category;
            }
        }
        logger.debug(LoggingMarkers.CATEGORY_MAPPING, "Unable to match category to {}. Using default category {}", cats, (Object)defaultCategory);
        return defaultCategory;
    }
}

