/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.downloading.AddFilesRequest;
import org.nzbhydra.downloading.downloaders.AddNzbsResponse;
import org.nzbhydra.searching.SearchResponse;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchMetaData;
import org.nzbhydra.searching.dtoseventsenums.SearchRequestParameters;
import org.nzbhydra.searching.dtoseventsenums.SearchResultWebTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DemoDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(DemoDataProvider.class);
    private static final String[] DEMO_INDEXERS = new String[]{"DemoIndexer1", "DemoIndexer2", "DemoIndexer3"};
    private static final String[] LINUX_TITLES = new String[]{"Linux.Mint.21.3.Cinnamon.x64-LiNUX", "Ubuntu.24.04.1.LTS.Desktop.amd64-LiNUX", "Arch.Linux.2024.12.01.x86_64-LiNUX", "Fedora.Workstation.41.x86_64-LiNUX", "Debian.12.8.Bookworm.amd64-LiNUX", "openSUSE.Tumbleweed.20241201.x86_64-LiNUX", "Manjaro.24.1.KDE.Plasma.x64-LiNUX", "Linux.Mint.22.Wilma.MATE.x64-LiNUX", "Pop_OS.22.04.LTS.amd64.Nvidia-LiNUX", "Kali.Linux.2024.4.amd64-LiNUX", "Elementary.OS.7.1.Horus.amd64-LiNUX", "Zorin.OS.17.1.Core.amd64-LiNUX", "Rocky.Linux.9.4.x86_64.DVD-LiNUX", "AlmaLinux.9.4.x86_64.DVD-LiNUX", "Ubuntu.Server.24.04.1.LTS.amd64-LiNUX", "Linux.Mint.21.3.XFCE.x64-LiNUX", "EndeavourOS.Galileo.Neo.x86_64-LiNUX", "MX.Linux.23.3.Libretto.amd64-LiNUX", "Tails.6.10.amd64-LiNUX", "Slackware.15.0.x86_64.DVD-LiNUX", "Gentoo.LiveGUI.amd64.20241201-LiNUX", "Void.Linux.20241201.x86_64.XFCE-LiNUX", "NixOS.24.05.x86_64-LiNUX", "Garuda.Linux.Dragonized.241201.x86_64-LiNUX", "Ubuntu.24.04.1.LTS.Desktop.amd64-LiNUX", "Solus.4.5.Budgie.x86_64-LiNUX", "antiX.23.1.x86_64.Full-LiNUX", "Puppy.Linux.Fossapup64.9.5-LiNUX", "CentOS.Stream.9.x86_64.DVD-LiNUX", "Mageia.9.x86_64.DVD-LiNUX"};
    private static final String[] INTERSTELLAR_TITLES = new String[]{"Interstellar.2014.1080p.BluRay.x264-SPARKS", "Interstellar.2014.2160p.UHD.BluRay.x265-TERMINAL", "Interstellar.2014.720p.BluRay.x264-YIFY", "Interstellar.2014.1080p.WEB-DL.DD5.1.H.264-FGT", "Interstellar.2014.720p.WEB-DL.DD5.1.H.264-RARBG", "Interstellar.2014.HDTV.x264-LOL", "Interstellar.2014.2160p.WEB-DL.DDP5.1.HDR.x265-NOGRP", "Interstellar.2014.1080p.BluRay.REMUX.AVC.DTS-HD.MA.5.1-EPSiLON", "Interstellar.2014.3D.1080p.BluRay.x264-SPRiNTER", "Interstellar.2014.BDRip.x264.AC3-PLAYNOW", "Interstellar.2014.720p.BluRay.x264.DTS-WiKi", "Interstellar.2014.1080p.BluRay.x265.HEVC.10bit.AAC.5.1-Tigole", "Interstellar.2014.2160p.BluRay.REMUX.HEVC.DTS-HD.MA.5.1-FGT", "Interstellar.2014.IMAX.Edition.1080p.BluRay.x264-BLOW", "Interstellar.2014.DVDRip.x264.AC3-EVO", "Interstellar.2014.1080p.HDTV.x264-DIMENSION", "Interstellar.2014.720p.HDTV.x264-IMMERSE", "Interstellar.2014.2160p.UHD.BluRay.HDR.x265-GUHZER", "Interstellar.2014.1080p.WEB-DL.DD5.1.H.264-RARBG", "Interstellar.2014.720p.BRRip.x264.AAC-ETRG", "Interstellar.2014.1080p.BluRay.x264-SPARKS", "Interstellar.2014.2160p.UHD.BluRay.x265-TERMINAL", "Interstellar.2014.1080p.BluRay.x264.DTS-HD.MA.5.1-RARBG", "Interstellar.2014.720p.BluRay.x264-Felony", "Interstellar.2014.PROPER.1080p.BluRay.x264-SADPANDA"};
    private static final String[] GENERIC_TITLE_TEMPLATES = new String[]{"%s.2024.1080p.BluRay.x264-SPARKS", "%s.2024.720p.WEB-DL.DD5.1.H.264-FGT", "%s.2024.2160p.UHD.BluRay.x265-TERMINAL", "%s.S01E01.1080p.WEB-DL.DD5.1.H.264-RARBG", "%s.S01E02.720p.HDTV.x264-LOL", "%s.2024.HDTV.x264-DIMENSION", "%s.2024.BDRip.x264.AC3-EVO", "%s.2024.1080p.WEB-DL.DDP5.1.x264-NOGRP", "%s.2024.720p.BluRay.x264-YIFY", "%s.2024.2160p.WEB-DL.DDP5.1.HDR.x265-NOGRP", "%s.v2.0.x64.Repack-DARKSIIDERS", "%s.2024.1080p.AMZN.WEB-DL.DDP5.1.H.264-NTb", "%s.Complete.Series.720p.BluRay.x264-DEMAND", "%s.2024.REPACK.1080p.BluRay.x264-GECKOS", "%s.2024.720p.BRRip.x264.AAC-ETRG", "%s.Discography.FLAC.Lossless-CODA", "%s.2024.Multi.Language.PDF-TGPDF", "%s.Collection.2024.1080p.BluRay.x264-ROVERS", "%s.2024.Proper.1080p.WEB-DL.H.264-SWTYBLZ", "%s.2024.720p.HDTV.x264-FLEET", "%s.2024.DVDRip.x264.AC3-PLAYNOW", "%s.2024.1080p.BluRay.REMUX.AVC.DTS-HD.MA.5.1-EPSiLON", "%s.2024.COMPLETE.MULTi.BLURAY-SharpHD", "%s.2024.German.DL.1080p.BluRay.x264-COiNCiDENCE", "%s.2024.FRENCH.720p.BluRay.x264-UKDHD", "%s.2024.iNTERNAL.1080p.BluRay.x264-MOOVEE", "%s.2024.1080p.NF.WEB-DL.DDP5.1.x264-MZABI", "%s.2024.1080p.DSNP.WEB-DL.DDP5.1.H.264-FLUX", "%s.2024.1080p.HMAX.WEB-DL.DD5.1.H.264-PECKAN", "%s.2024.Season.1.S01.1080p.AMZN.WEB-DL.DDP5.1.H.264-MADSKY"};
    private static final long[] SIZES_BYTES = new long[]{367001600L, 734003200L, 943718400L, 0x4CCCCCCCL, 0x60000000L, 0x80000000L, 0xA0000000L, 0xC0000000L, 0x100000000L, 0x140000000L, 0x180000000L, 0x1C0000000L, 0x200000000L, 0x280000000L, 0x300000000L, 0x3C0000000L};
    private static final String[] MOVIE_CATEGORIES = new String[]{"Movies", "Movies HD", "Movies UHD", "Movies SD", "Movies BluRay"};
    private static final String[] PC_CATEGORIES = new String[]{"PC", "PC/ISO", "PC/0day"};
    private static final String[] ALL_CATEGORIES = new String[]{"TV", "TV HD", "TV SD", "Movies", "Movies HD", "PC", "Audio", "Audio/MP3", "Audio/FLAC", "Books/EBook"};
    private static final Map<String, Integer> QUALITY_MAP = new HashMap();
    private static final String[] MOCK_CATEGORIES_DOWNLOADER;
    @Autowired
    private ConfigProvider configProvider;

    public SearchResponse generateSearchResponse(SearchRequestParameters params) {
        String[] categoriesToUse;
        String[] titlesToUse;
        String query;
        Random random = new Random(42L);
        Instant now = Instant.now();
        boolean isMovieSearch = this.isMovieCategory(params.getCategory());
        String string = query = params.getQuery() != null ? params.getQuery() : "";
        if (isMovieSearch || query.toLowerCase().contains("interstellar")) {
            titlesToUse = INTERSTELLAR_TITLES;
            categoriesToUse = MOVIE_CATEGORIES;
        } else if (query.toLowerCase().contains("linux")) {
            titlesToUse = LINUX_TITLES;
            categoriesToUse = PC_CATEGORIES;
        } else {
            String formattedQuery = query.isEmpty() ? "Example" : query.replace(" ", ".");
            titlesToUse = new String[30];
            for (int i = 0; i < 30; ++i) {
                titlesToUse[i] = String.format(GENERIC_TITLE_TEMPLATES[i % GENERIC_TITLE_TEMPLATES.length], formattedQuery);
            }
            categoriesToUse = ALL_CATEGORIES;
        }
        int resultCount = Math.min(30, titlesToUse.length);
        ArrayList<SearchResultWebTO> results = new ArrayList<SearchResultWebTO>();
        int[] duplicateGroup1 = new int[]{0, 3, 10};
        int[] duplicateGroup2 = new int[]{1, 7};
        int hash1 = 111111;
        int hash2 = 222222;
        for (int i = 0; i < resultCount; ++i) {
            String string2 = titlesToUse[i % titlesToUse.length];
            String indexer = DEMO_INDEXERS[i % DEMO_INDEXERS.length];
            long size = SIZES_BYTES[random.nextInt(SIZES_BYTES.length)];
            String category = categoriesToUse[random.nextInt(categoriesToUse.length)];
            int ageMinutes = 60 + random.nextInt(43200);
            Instant pubDate = now.minus(ageMinutes, ChronoUnit.MINUTES);
            long epoch = pubDate.getEpochSecond();
            String ageStr = this.formatAge(ageMinutes);
            int hash = DemoDataProvider.contains((int[])duplicateGroup1, (int)i) ? hash1 : (DemoDataProvider.contains((int[])duplicateGroup2, (int)i) ? hash2 : 300000 + i);
            Integer qualityRating = null;
            if (isMovieSearch && this.configProvider.getBaseConfig().getSearching().isShowMovieQualityIndicator()) {
                qualityRating = this.extractQualityRating(string2);
            }
            int grabs = 10 + random.nextInt(5000);
            SearchResultWebTO result = SearchResultWebTO.builder().title(string2).indexer(indexer).indexerguid("DEMO-" + i).indexerscore(Integer.valueOf(random.nextInt(10))).size(Long.valueOf(size)).age(ageStr).age_precise(Boolean.valueOf(false)).epoch(Long.valueOf(epoch)).date(pubDate.toString()).hash(Integer.valueOf(hash)).grabs(Integer.valueOf(grabs)).category(category).link("internalapi/nzb/demo-" + i).details_link("#").downloadType("NZB").searchResultId(String.valueOf(10001 + i)).source(isMovieSearch ? this.extractSource(string2) : null).qualityRating(qualityRating).hasNfo("NO").build();
            results.add(result);
        }
        ArrayList<IndexerSearchMetaData> metaDatas = new ArrayList<IndexerSearchMetaData>();
        for (String indexerName : DEMO_INDEXERS) {
            IndexerSearchMetaData meta = new IndexerSearchMetaData();
            meta.setIndexerName(indexerName);
            meta.setDidSearch(true);
            meta.setWasSuccessful(true);
            meta.setNumberOfFoundResults(8 + random.nextInt(15));
            meta.setNumberOfAvailableResults(meta.getNumberOfFoundResults());
            meta.setResponseTime((long)(200 + random.nextInt(1800)));
            meta.setTotalResultsKnown(true);
            meta.setHasMoreResults(false);
            meta.setOffset(0);
            metaDatas.add(meta);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Duplicate", 5);
        hashMap.put("Size too small", 2);
        hashMap.put("Forbidden word in title", 1);
        SearchResponse response = new SearchResponse();
        response.setSearchResults(results);
        response.setIndexerSearchMetaDatas(metaDatas);
        response.setRejectedReasonsMap(hashMap);
        response.setNumberOfAvailableResults(resultCount + 8);
        response.setNumberOfAcceptedResults(resultCount);
        response.setNumberOfRejectedResults(8);
        response.setNumberOfProcessedResults(resultCount + 8);
        response.setNumberOfDuplicateResults(5);
        response.setOffset(0);
        response.setLimit(100);
        logger.info("Generated demo search response with {} results for query '{}'", (Object)resultCount, (Object)query);
        return response;
    }

    public AddNzbsResponse generateDownloadResponse(AddFilesRequest request) {
        int count;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ArrayList<Long> addedIds = new ArrayList<Long>();
        for (AddFilesRequest.SearchResult sr : request.getSearchResults()) {
            try {
                addedIds.add(Long.parseLong(sr.getSearchResultId()));
            }
            catch (NumberFormatException e) {
                logger.warn("Could not parse demo searchResultId '{}' to Long", (Object)sr.getSearchResultId());
                addedIds.add(0L);
            }
        }
        String message = "Successfully added " + count + " NZB" + ((count = request.getSearchResults().size()) != 1 ? "s" : "") + " to Demo Downloader";
        return new AddNzbsResponse(true, message, addedIds, Collections.emptyList());
    }

    public List<String> generateDownloaderCategories() {
        return Arrays.asList(MOCK_CATEGORIES_DOWNLOADER);
    }

    private boolean isMovieCategory(String category) {
        if (category == null) {
            return false;
        }
        String lower = category.toLowerCase();
        return lower.contains("movie") || lower.contains("film");
    }

    private Integer extractQualityRating(String title) {
        for (Map.Entry entry : QUALITY_MAP.entrySet()) {
            if (!title.contains((CharSequence)entry.getKey())) continue;
            return (Integer)entry.getValue();
        }
        return null;
    }

    private String extractSource(String title) {
        if (title.contains("BluRay") || title.contains("BLURAY")) {
            return "BluRay";
        }
        if (title.contains("WEB-DL") || title.contains("WEB.DL")) {
            return "WEB-DL";
        }
        if (title.contains("HDTV")) {
            return "HDTV";
        }
        if (title.contains("DVDRip")) {
            return "DVD";
        }
        if (title.contains("BDRip") || title.contains("BRRip")) {
            return "BluRay";
        }
        if (title.contains("REMUX")) {
            return "BluRay REMUX";
        }
        return null;
    }

    private String formatAge(int ageMinutes) {
        if (ageMinutes < 120) {
            return ageMinutes + "m";
        }
        int hours = ageMinutes / 60;
        if (hours < 48) {
            return hours + "h";
        }
        int days = hours / 24;
        return days + "d";
    }

    private static boolean contains(int[] array, int value) {
        for (int i : array) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    static {
        QUALITY_MAP.put("2160p", 10);
        QUALITY_MAP.put("1080p", 8);
        QUALITY_MAP.put("720p", 7);
        QUALITY_MAP.put("HDTV", 6);
        QUALITY_MAP.put("DVDRip", 5);
        QUALITY_MAP.put("BDRip", 4);
        QUALITY_MAP.put("BRRip", 4);
        MOCK_CATEGORIES_DOWNLOADER = new String[]{"Default", "Movies", "TV", "Audio", "Software", "Games"};
    }
}

