/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import java.security.Principal;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.nzbhydra.web.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DemoModeWeb {
    private static final Logger logger = LoggerFactory.getLogger(DemoModeWeb.class);
    private static final Set<String> usersInDemoMode = ConcurrentHashMap.newKeySet();
    private static final Map<String, Instant> activationTimes = new ConcurrentHashMap();
    private static final long TIMEOUT_MINUTES = 10L;
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "demo-mode-cleanup");
        t.setDaemon(true);
        return t;
    });

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/demomode"}, method={RequestMethod.PUT})
    public void activateDemoMode(Principal principal) {
        String username = DemoModeWeb.resolveUsername((Principal)principal);
        usersInDemoMode.add(username);
        activationTimes.put(username, Instant.now());
        logger.info("Demo mode activated for user '{}'", (Object)username);
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/demomode"}, method={RequestMethod.DELETE})
    public void deactivateDemoMode(Principal principal) {
        String username = DemoModeWeb.resolveUsername((Principal)principal);
        boolean wasActive = usersInDemoMode.remove(username);
        activationTimes.remove(username);
        if (wasActive) {
            logger.info("Demo mode deactivated for user '{}'", (Object)username);
        }
    }

    public static boolean isDemoModeActive(Principal principal) {
        String username = DemoModeWeb.resolveUsername((Principal)principal);
        return username != null && usersInDemoMode.contains(username);
    }

    static void removeUserFromDemoMode(String username) {
        usersInDemoMode.remove(username);
        activationTimes.remove(username);
    }

    static int getDemoModeUserCount() {
        return usersInDemoMode.size();
    }

    private static void cleanupExpiredSessions() {
        Instant cutoff = Instant.now().minusSeconds(600L);
        activationTimes.forEach((username, activatedAt) -> {
            if (activatedAt.isBefore(cutoff)) {
                logger.info("Demo mode auto-deactivated for user '{}' after {} minute timeout", username, (Object)10L);
                usersInDemoMode.remove(username);
                activationTimes.remove(username);
            }
        });
    }

    private static String resolveUsername(Principal principal) {
        if (principal != null) {
            return principal.getName();
        }
        String sessionUsername = (String)SessionStorage.username.get();
        return sessionUsername == null ? "AnonymousUser" : sessionUsername;
    }

    static {
        scheduler.scheduleAtFixedRate(DemoModeWeb::cleanupExpiredSessions, 1L, 1L, TimeUnit.MINUTES);
    }
}

