/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.status.IndexerLimit;
import org.nzbhydra.indexers.status.IndexerLimitRepository;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.mediainfo.InfoProvider;
import org.nzbhydra.searching.IndexerForSearchSelector;
import org.nzbhydra.searching.SearchModuleProvider;
import org.nzbhydra.searching.dtoseventsenums.IndexerSelectionEvent;
import org.nzbhydra.searching.dtoseventsenums.SearchMessageEvent;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope
public class IndexerForSearchSelector {
    private static final Logger logger = LoggerFactory.getLogger(IndexerForSearchSelector.class);
    public static final Pattern SCHEDULER_PATTERN = Pattern.compile("(?<day1>(?:mo|tu|we|th|fr|sa|su))?\\-?(?<day2>(?:mo|tu|we|th|fr|sa|su))?(?<hour1>\\d{1,2})?\\-?(?<hour2>\\d{1,2})?", 2);
    private static final Random random = new Random();
    @Autowired
    private InfoProvider infoProvider;
    @Autowired
    private SearchModuleProvider searchModuleProvider;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private IndexerLimitRepository indexerLimitRepository;
    protected Clock clock = Clock.systemUTC();
    private SearchRequest searchRequest;
    protected Map<Indexer, String> notSelectedIndersWithReason = new HashMap();

    public IndexerForSearchSelection pickIndexers(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        List<Indexer> eligibleIndexers = this.searchModuleProvider.getIndexers().stream().filter(x -> x.getConfig().getState() != IndexerConfig.State.DISABLED_USER).toList();
        if (eligibleIndexers.isEmpty()) {
            logger.warn("You don't have any enabled indexers");
            return new IndexerForSearchSelection();
        }
        ArrayList<Indexer> selectedIndexers = new ArrayList<Indexer>();
        logger.debug("Picking indexers out of " + eligibleIndexers.size());
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (Indexer indexer : eligibleIndexers) {
            if (!this.checkInternalAndNotEvenShown(indexer) || !this.checkIndexerSelected(indexer) || !this.checkIndexerConfigComplete(indexer) || !this.checkSearchSource(indexer) || !this.checkIndexerStatus(indexer) || !this.checkTorznabOnlyUsedForTorrentOrInternalSearches(indexer) || !this.checkDisabledForCategory(indexer) || !this.checkSchedule(indexer) || !this.checkLoadLimiting(indexer) || !this.checkSearchId(indexer) || !this.checkSearchType(indexer) || !this.checkIndexerHitLimit(indexer) || !this.checkTooManyFrequentHits(indexer)) continue;
            selectedIndexers.add(indexer);
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Selection of indexers took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        if (selectedIndexers.isEmpty()) {
            logger.warn("No indexers were selected for this search. You probably don't have any indexers configured which support the provided ID type or all of your indexers which do are currently disabled. You can enable query generation to work around this.");
        } else {
            logger.info("Selected {} out of {} indexers: {}", new Object[]{selectedIndexers.size(), eligibleIndexers.size(), Joiner.on((String)", ").join((Iterable)selectedIndexers.stream().map(Indexer::getName).collect(Collectors.toList()))});
        }
        this.eventPublisher.publishEvent((Object)new IndexerSelectionEvent(searchRequest, selectedIndexers.size()));
        return new IndexerForSearchSelection(this.notSelectedIndersWithReason, selectedIndexers);
    }

    protected boolean checkIndexerConfigComplete(Indexer indexer) {
        if (!indexer.getConfig().isConfigComplete()) {
            String message = "Not using " + indexer.getName() + " because configuration is not complete. Please open it in the GUI and complete the config. Call the caps check manually to make sure everything is checked.";
            return this.handleIndexerNotSelected(indexer, message, "Configuration incomplete");
        }
        return true;
    }

    protected boolean checkSearchId(Indexer indexer) {
        boolean needToSearchById;
        boolean bl = needToSearchById = !this.searchRequest.getIdentifiers().isEmpty() && this.searchRequest.getQuery().isEmpty();
        if (needToSearchById) {
            boolean canUseAnyProvidedId = !Collections.disjoint(this.searchRequest.getIdentifiers().keySet(), indexer.getConfig().getSupportedSearchIds());
            boolean cannotSearchProvidedOrConvertableId = !canUseAnyProvidedId && !this.infoProvider.canConvertAny(this.searchRequest.getIdentifiers().keySet(), (Set)Sets.newHashSet((Iterable)indexer.getConfig().getSupportedSearchIds()));
            boolean queryGenerationEnabled = this.searchRequest.meets(this.configProvider.getBaseConfig().getSearching().getGenerateQueries());
            if (cannotSearchProvidedOrConvertableId && !queryGenerationEnabled) {
                String message = String.format("Not using %s because the search did not provide any ID that the indexer can handle and query generation is disabled", indexer.getName());
                return this.handleIndexerNotSelected(indexer, message, "No usable ID");
            }
        }
        return true;
    }

    protected boolean checkSearchType(Indexer indexer) {
        boolean audioOrBookSearch;
        boolean bl = audioOrBookSearch = this.searchRequest.getSearchType() == SearchType.BOOK || this.searchRequest.getSearchType() == SearchType.MUSIC;
        if (audioOrBookSearch) {
            boolean queryGenerationEnabled = this.searchRequest.meets(this.configProvider.getBaseConfig().getSearching().getGenerateQueries());
            boolean indexerSupportsType = indexer.getConfig().getSupportedSearchTypes().stream().anyMatch(x -> this.searchRequest.getSearchType().matches(x));
            if (!indexerSupportsType && !queryGenerationEnabled) {
                String message = String.format("Not using %s because the search uses type %s which the indexer can't handle and query generation is disabled", this.searchRequest.getSearchType(), indexer.getName());
                return this.handleIndexerNotSelected(indexer, message, "Search type not supported");
            }
        }
        return true;
    }

    protected boolean checkLoadLimiting(Indexer indexer) {
        boolean preventedByLoadLimiting;
        boolean bl = preventedByLoadLimiting = indexer.getConfig().getLoadLimitOnRandom().isPresent() && random.nextInt((Integer)indexer.getConfig().getLoadLimitOnRandom().get()) + 1 != 1;
        if (preventedByLoadLimiting) {
            boolean loadLimitIgnoredForConcreteApiSearch;
            boolean loadLimitIgnoredForInternalSearch;
            boolean bl2 = loadLimitIgnoredForInternalSearch = this.configProvider.getBaseConfig().getSearching().isIgnoreLoadLimitingForInternalSearches() && this.searchRequest.getSource() == SearchSource.INTERNAL;
            if (loadLimitIgnoredForInternalSearch) {
                logger.debug("Ignoring load limiting for internal search");
                return true;
            }
            boolean hasIdentifiersOrQuery = !this.searchRequest.getIdentifiers().isEmpty() || this.searchRequest.getQuery().isPresent();
            boolean bl3 = loadLimitIgnoredForConcreteApiSearch = this.configProvider.getBaseConfig().getSearching().isIgnoreLoadLimitingForConcreteApiSearches() && this.searchRequest.getSource() == SearchSource.API && hasIdentifiersOrQuery;
            if (loadLimitIgnoredForConcreteApiSearch) {
                logger.debug("Ignoring load limiting for concrete API search");
                return true;
            }
            String message = String.format("Not using %s because load limiting prevented it. Chances of it being picked: 1/%d", indexer.getName(), indexer.getConfig().getLoadLimitOnRandom().get());
            return this.handleIndexerNotSelected(indexer, message, "Load limiting");
        }
        return true;
    }

    protected boolean checkDisabledForCategory(Indexer indexer) {
        boolean indexerDisabledForThisCategory;
        if (this.searchRequest.getCategory().getSubtype().equals((Object)Category.Subtype.ALL)) {
            return true;
        }
        boolean bl = indexerDisabledForThisCategory = !indexer.getConfig().getEnabledCategories().isEmpty() && !indexer.getConfig().getEnabledCategories().contains(this.searchRequest.getCategory().getName());
        if (indexerDisabledForThisCategory) {
            String message = String.format("Not using %s because it's disabled for category %s", indexer.getName(), this.searchRequest.getCategory().getName());
            return this.handleIndexerNotSelected(indexer, message, "Disabled for category");
        }
        return true;
    }

    protected boolean checkIndexerStatus(Indexer indexer) {
        if (indexer.getConfig().getState() == IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY) {
            if (indexer.getConfig().getDisabledUntil() == null || Instant.ofEpochMilli(indexer.getConfig().getDisabledUntil()).isBefore(this.clock.instant())) {
                return true;
            }
            String message = String.format("Not using %s because it's disabled until %s due to a previous error ", indexer.getName(), Instant.ofEpochMilli(indexer.getConfig().getDisabledUntil()));
            return this.handleIndexerNotSelected(indexer, message, "Disabled temporarily because of previous errors");
        }
        if (indexer.getConfig().getState() == IndexerConfig.State.DISABLED_SYSTEM) {
            String message = String.format("Not using %s because it's disabled due to a previous unrecoverable error", indexer.getName());
            return this.handleIndexerNotSelected(indexer, message, "Disabled permanently because of previous unrecoverable error");
        }
        return true;
    }

    protected boolean checkIndexerSelected(Indexer indexer) {
        boolean indexerNotSelected;
        if (this.searchRequest.getIndexers().isEmpty()) {
            return true;
        }
        if (((Set)this.searchRequest.getIndexers().get()).isEmpty()) {
            return true;
        }
        boolean bl = indexerNotSelected = !((Set)this.searchRequest.getIndexers().get()).contains(indexer.getName());
        if (indexerNotSelected) {
            logger.info("Not using {} because it's not in selection {}", (Object)indexer.getName(), this.searchRequest.getIndexers().get());
            this.notSelectedIndersWithReason.put(indexer, "Not selected by the user");
            return false;
        }
        return true;
    }

    protected boolean checkInternalAndNotEvenShown(Indexer indexer) {
        if (this.searchRequest.getSource() == SearchSource.API) {
            return true;
        }
        return indexer.getConfig().isEligibleForInternalSearch();
    }

    protected boolean checkIndexerHitLimit(Indexer indexer) {
        boolean limitExceeded;
        LocalDateTime comparisonTime;
        Stopwatch stopwatch = Stopwatch.createStarted();
        IndexerConfig indexerConfig = indexer.getConfig();
        if (indexerConfig.getHitLimit().isEmpty() && indexerConfig.getDownloadLimit().isEmpty()) {
            return true;
        }
        LocalDateTime now = LocalDateTime.now(this.clock);
        if (indexerConfig.getHitLimitResetTime().isPresent()) {
            comparisonTime = now.withHour((Integer)indexerConfig.getHitLimitResetTime().get());
            if (comparisonTime.isAfter(now)) {
                comparisonTime = comparisonTime.minusDays(1L);
            }
        } else {
            comparisonTime = now.minusDays(1L);
        }
        if (indexerConfig.getHitLimit().isPresent() && (limitExceeded = this.checkIfHitLimitIsExceeded(indexer, indexerConfig, comparisonTime, IndexerApiAccessType.SEARCH, ((Integer)indexerConfig.getHitLimit().get()).intValue(), "API hit"))) {
            return false;
        }
        if (indexerConfig.getDownloadLimit().isPresent() && (limitExceeded = this.checkIfHitLimitIsExceeded(indexer, indexerConfig, comparisonTime, IndexerApiAccessType.NZB, ((Integer)indexerConfig.getDownloadLimit().get()).intValue(), "download"))) {
            return false;
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Detection that hit limits were not reached for indexer {} took {}ms", (Object)indexer.getName(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return true;
    }

    private boolean checkTooManyFrequentHits(Indexer indexer) {
        if (!indexer.getConfig().getHost().equalsIgnoreCase("omgwtfnzbs.org")) {
            return true;
        }
        int limitHits = 300;
        int timespanSeconds = 300;
        List recentHitsFromShortHistory = this.getRecentHitsFromShortHistory(indexer, IndexerApiAccessType.SEARCH, 300);
        if (recentHitsFromShortHistory.isEmpty()) {
            logger.debug(LoggingMarkers.LIMITS, "Indexer {}. No recent hits found", (Object)indexer.getName());
            return true;
        }
        Instant oldestAccess = ((Timestamp)Iterables.getLast((Iterable)recentHitsFromShortHistory)).toInstant();
        long oldestSecondsAgo = Instant.now(this.clock).getEpochSecond() - oldestAccess.getEpochSecond();
        logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Oldest of {} hits was {} seconds ago while only {} hits are allowed in {} seconds", new Object[]{indexer.getName(), 300, oldestSecondsAgo, 300, 300});
        if (oldestAccess.isBefore(Instant.now(this.clock).minusSeconds(300L))) {
            return true;
        }
        logger.info("Not using {} because too many frequent hits were made: More than {} in {} seconds. Oldest of these hits was {} seconds ago", new Object[]{indexer.getName(), 300, 300, oldestSecondsAgo});
        this.notSelectedIndersWithReason.put(indexer, "Too many frequent hits");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfHitLimitIsExceeded(Indexer indexer, IndexerConfig indexerConfig, LocalDateTime comparisonTime, IndexerApiAccessType accessType, int limit, String type) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            int currentHits;
            IndexerLimit indexerStatus = this.indexerLimitRepository.findByIndexer(indexer.getIndexerEntity());
            logger.debug(LoggingMarkers.LIMITS, "Indexer {}. IndexerStatus: {}", (Object)indexer.getName(), (Object)indexerStatus);
            Instant oldestAccess = null;
            Integer apiHitLimit = indexerStatus.getApiHitLimit();
            if (apiHitLimit == null) {
                apiHitLimit = indexerConfig.getHitLimit().orElse(null);
            }
            if (indexerStatus.getApiHits() != null && accessType != IndexerApiAccessType.NZB && apiHitLimit != null && indexerStatus.getOldestApiHit() != null) {
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Current API hits: {}. Max API hits: {}. Oldest API hit: {}", new Object[]{indexer.getName(), indexerStatus.getApiHits(), apiHitLimit, indexerStatus.getOldestApiHit()});
                if (indexerStatus.getApiHits() < apiHitLimit) {
                    boolean bl = false;
                    return bl;
                }
                oldestAccess = indexerStatus.getOldestApiHit();
            } else {
                Integer downloadLimit = indexerStatus.getDownloadLimit();
                if (downloadLimit == null) {
                    downloadLimit = indexerConfig.getDownloadLimit().orElse(null);
                }
                if (indexerStatus.getDownloads() != null && accessType == IndexerApiAccessType.NZB && downloadLimit != null && indexerStatus.getOldestDownload() != null) {
                    logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Current downloads: {}. Max downloads: {}. Oldest download: {}", new Object[]{indexer.getName(), indexerStatus.getDownloads(), downloadLimit, indexerStatus.getOldestDownload()});
                    if (indexerStatus.getDownloads() < downloadLimit) {
                        boolean bl = false;
                        return bl;
                    }
                    oldestAccess = indexerStatus.getOldestDownload();
                }
            }
            if (oldestAccess != null) {
                if (oldestAccess.isBefore(Instant.now(this.clock).minus(24L, ChronoUnit.HOURS))) {
                    logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Oldest access {} is more than 24 hours old, allowing access", (Object)indexer.getName(), (Object)oldestAccess);
                    boolean downloadLimit = false;
                    return downloadLimit;
                }
                Instant nextAccess = oldestAccess.plus(24L, ChronoUnit.HOURS);
                String message = String.format("Not using %s because all %d allowed " + type + "s were already made. The next " + type + " should be possible at %s", indexerConfig.getName(), limit, nextAccess);
                logger.debug(LoggingMarkers.PERFORMANCE, "Detection that {} limit has been reached for indexer {} took {}ms", new Object[]{type, indexerConfig.getName(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                boolean bl = !this.handleIndexerNotSelected(indexer, message, type + " limit reached");
                return bl;
            }
            List resultList = this.getRecentHitsFromShortHistory(indexer, accessType, limit);
            boolean currentHitsFromApi = false;
            if (accessType != IndexerApiAccessType.NZB && indexerStatus.getApiHits() != null) {
                currentHits = indexerStatus.getApiHits();
                oldestAccess = indexerStatus.getOldestApiHit();
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Got current API hits ({}) and oldest access ({}) from indexerstatus", new Object[]{indexer.getName(), currentHits, oldestAccess});
                currentHitsFromApi = true;
            } else if (accessType == IndexerApiAccessType.NZB && indexerStatus.getDownloads() != null) {
                currentHits = indexerStatus.getDownloads();
                oldestAccess = indexerStatus.getOldestDownload();
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Got current downloads ({}) and oldest access ({}) from indexerstatus", new Object[]{indexer.getName(), currentHits, oldestAccess});
                currentHitsFromApi = true;
            } else {
                currentHits = resultList.size();
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Got current hits ({}) from database", (Object)indexer.getName(), (Object)currentHits);
            }
            if (currentHits < limit) {
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Current hits {} does not exceed limit of {}", new Object[]{indexer.getName(), currentHits, limit});
                boolean bl = false;
                return bl;
            }
            if (resultList.isEmpty() && oldestAccess == null) {
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Current hits {} exceeds limit {} but we have no results in list. We'll have to allow it", new Object[]{indexer.getName(), currentHits, limit});
                boolean bl = true;
                return bl;
            }
            if (!resultList.isEmpty() && oldestAccess == null) {
                oldestAccess = ((Timestamp)Iterables.getLast((Iterable)resultList)).toInstant();
                logger.debug(LoggingMarkers.LIMITS, "Got oldest access ({}) from database", (Object)oldestAccess);
            }
            boolean oldestAccessFromApi = oldestAccess != null;
            Instant comparisonTimeUtc = comparisonTime.toInstant(ZoneOffset.UTC);
            if (oldestAccess.isAfter(comparisonTimeUtc)) {
                Instant nextPossibleHit = this.calculateNextPossibleHit(indexerConfig, oldestAccess).toInstant(ZoneOffset.UTC);
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. oldest access {} is after {}. Not using indexer. Next possible hit at {}", new Object[]{indexer.getName(), oldestAccess, comparisonTimeUtc, nextPossibleHit});
                String message = String.format("Not using %s because all %d allowed " + type + "s were already made. The next " + type + " should be possible at %s", indexerConfig.getName(), limit, nextPossibleHit);
                boolean bl = !this.handleIndexerNotSelected(indexer, message, type + " limit reached");
                return bl;
            }
            if (oldestAccessFromApi) {
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. oldest access from API {} is before {}. Allowing access", new Object[]{indexer.getName(), oldestAccess, comparisonTimeUtc});
            } else if (currentHitsFromApi) {
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Current hits from API hits ({}) may be outdated. oldest access ({}) is after {} so we'll allow the access", new Object[]{indexer.getName(), currentHits, oldestAccess, comparisonTimeUtc});
            } else {
                logger.debug(LoggingMarkers.LIMITS, "Indexer {}. Current hits is at limit but the oldest access {} is before {}. Allowing access", new Object[]{indexer.getName(), oldestAccess, comparisonTimeUtc});
            }
            boolean bl = false;
            return bl;
        }
        finally {
            logger.debug(LoggingMarkers.PERFORMANCE, "Limit detection for indexer {} took {}ms", (Object)indexerConfig.getName(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private List getRecentHitsFromShortHistory(Indexer indexer, IndexerApiAccessType accessType, int limit) {
        String whereApiAccessType = accessType == IndexerApiAccessType.NZB ? "x.API_ACCESS_TYPE = 'NZB'" : "x.API_ACCESS_TYPE = 'NFO' OR x.API_ACCESS_TYPE = 'SEARCH'";
        Query query = this.entityManager.createNativeQuery("SELECT x.TIME FROM INDEXERAPIACCESS_SHORT x WHERE x.INDEXER_ID = (:indexerId) AND (" + whereApiAccessType + ") ORDER BY TIME DESC LIMIT (:hitLimit)");
        query.setParameter("indexerId", (Object)indexer.getIndexerEntity().getId());
        query.setParameter("hitLimit", (Object)limit);
        List resultList = query.getResultList();
        return resultList;
    }

    LocalDateTime calculateNextPossibleHit(IndexerConfig indexerConfig, Instant firstInWindowAccessTime) {
        LocalDateTime nextPossibleHit;
        if (indexerConfig.getHitLimitResetTime().isPresent()) {
            LocalDateTime now = LocalDateTime.now(this.clock);
            nextPossibleHit = now.withHour((Integer)indexerConfig.getHitLimitResetTime().get()).withMinute(0);
            if (nextPossibleHit.isBefore(now)) {
                nextPossibleHit = nextPossibleHit.plusDays(1L);
            }
        } else {
            nextPossibleHit = LocalDateTime.ofInstant(firstInWindowAccessTime, ZoneOffset.UTC).plusDays(1L);
        }
        return nextPossibleHit;
    }

    protected boolean checkSearchSource(Indexer indexer) {
        boolean wrongSearchSource;
        boolean bl = wrongSearchSource = !this.searchRequest.meets(indexer.getConfig().getEnabledForSearchSource());
        if (wrongSearchSource) {
            String message = String.format("Not using %s because the search source is %s but the indexer is only enabled for %s searches", indexer.getName(), this.searchRequest.getSource(), indexer.getConfig().getEnabledForSearchSource());
            return this.handleIndexerNotSelected(indexer, message, "Not enabled for this search context");
        }
        return true;
    }

    protected boolean checkTorznabOnlyUsedForTorrentOrInternalSearches(Indexer indexer) {
        if (this.searchRequest.getDownloadType() == DownloadType.TORRENT && indexer.getConfig().getSearchModuleType() != SearchModuleType.TORZNAB) {
            String message = String.format("Not using %s because a torrent search is requested", indexer.getName());
            return this.handleIndexerNotSelected(indexer, message, "No torrent search");
        }
        if (this.searchRequest.getDownloadType() == DownloadType.NZB && indexer.getConfig().getSearchModuleType() == SearchModuleType.TORZNAB && this.searchRequest.getSource() == SearchSource.API) {
            String message = String.format("Not using %s because torznab indexers cannot be used by API NZB searches", indexer.getName());
            return this.handleIndexerNotSelected(indexer, message, "NZB API search");
        }
        return true;
    }

    protected boolean checkSchedule(Indexer indexer) {
        if (!indexer.getConfig().getSchedule().isEmpty() && indexer.getConfig().getSchedule().stream().noneMatch(arg_0 -> this.isInTime(arg_0))) {
            String message = String.format("Not using %s because the current time is out of its schedule", indexer.getName());
            return this.handleIndexerNotSelected(indexer, message, "Out of schedule");
        }
        return true;
    }

    protected boolean isInTime(String scheduleTime) {
        DayOfWeek currentDay;
        int toDay;
        int fromDay;
        HashMap<String, Integer> days = new HashMap<String, Integer>();
        days.put("mo", 1);
        days.put("tu", 2);
        days.put("we", 3);
        days.put("th", 4);
        days.put("fr", 5);
        days.put("sa", 6);
        days.put("su", 7);
        LocalDateTime now = LocalDateTime.now(this.clock);
        Matcher matcher = SCHEDULER_PATTERN.matcher(scheduleTime.toLowerCase());
        if (!matcher.matches()) {
            logger.error("Unable to parse schedule string {}", (Object)scheduleTime);
            return false;
        }
        if (matcher.group("day1") != null && !this.inRange(fromDay = ((Integer)days.get(matcher.group("day1"))).intValue(), toDay = matcher.group("day2") == null ? fromDay : (Integer)days.get(matcher.group("day2")), (currentDay = now.getDayOfWeek()).getValue())) {
            logger.debug(LoggingMarkers.SCHEDULER, "Current date does not match scheduler string {}: Current day {} is not between {} and {}", new Object[]{scheduleTime, currentDay.getDisplayName(TextStyle.FULL, Locale.US), DayOfWeek.of(fromDay).getDisplayName(TextStyle.FULL, Locale.US), DayOfWeek.of(toDay).getDisplayName(TextStyle.FULL, Locale.US)});
            return false;
        }
        if (matcher.group("hour1") != null) {
            int toHour;
            int fromHour = Integer.parseInt(matcher.group("hour1"));
            if (fromHour > (toHour = matcher.group("hour2") != null ? Integer.parseInt(matcher.group("hour2")) : fromHour)) {
                if (now.getHour() < fromHour && now.getHour() > toHour) {
                    logger.debug(LoggingMarkers.SCHEDULER, "Current date does not match scheduler string {}: Current hour {} is not between {} and {}", new Object[]{scheduleTime, now.getHour(), toHour, fromHour});
                    return false;
                }
            } else if (now.getHour() < fromHour || now.getHour() > toHour) {
                logger.debug(LoggingMarkers.SCHEDULER, "Current date does not match scheduler string {}: Current hour {} is not between {} and {}", new Object[]{scheduleTime, now.getHour(), fromHour, toHour});
                return false;
            }
        }
        return true;
    }

    private boolean inRange(int a, int b, int val) {
        return val >= Math.min(a, b) && val <= Math.max(a, b);
    }

    private boolean handleIndexerNotSelected(Indexer indexer, String message, String reason) {
        this.notSelectedIndersWithReason.put(indexer, reason);
        if (!Strings.isNullOrEmpty((String)message)) {
            logger.info(message);
            this.eventPublisher.publishEvent((Object)new SearchMessageEvent(this.searchRequest, message));
        }
        return false;
    }
}

