/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Multiset;
import com.releaseparser.analyzer.QualityAnalyzer;
import com.releaseparser.model.ReleaseInfo;
import com.releaseparser.parser.ReleaseParser;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.downloading.FileDownloadEntity;
import org.nzbhydra.downloading.FileDownloadRepository;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.downloadurls.DownloadUrlBuilder;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.SearchResponse;
import org.nzbhydra.searching.SearchResult;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchMetaData;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.dtoseventsenums.SearchResultWebTO;
import org.nzbhydra.web.UrlCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalSearchResultProcessor {
    private static final Logger logger = LoggerFactory.getLogger(InternalSearchResultProcessor.class);
    private static final ReleaseParser releaseParser = new ReleaseParser();
    private static final QualityAnalyzer qualityAnalyzer = new QualityAnalyzer();
    @Autowired
    private FileHandler nzbHandler;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private FileDownloadRepository fileDownloadRepository;
    @Autowired
    private UrlCalculator urlCalculator;
    @Autowired
    private DownloadUrlBuilder downloadUrlBuilder;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd-MM-yyyy");

    public SearchResponse createSearchResponse(SearchResult searchResult) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setNumberOfAvailableResults(searchResult.getNumberOfTotalAvailableResults());
        searchResponse.setNumberOfRejectedResults(searchResult.getNumberOfRejectedResults());
        searchResponse.setRejectedReasonsMap(searchResult.getReasonsForRejection().entrySet().stream().collect(Collectors.toMap(Multiset.Entry::getElement, Multiset.Entry::getCount)));
        searchResponse.setIndexerSearchMetaDatas(this.createIndexerSearchMetaDatas(searchResult));
        searchResponse.setNotPickedIndexersWithReason(searchResult.getIndexerSelectionResult().getNotPickedIndexersWithReason().entrySet().stream().collect(Collectors.toMap(x -> ((Indexer)x.getKey()).getName(), Map.Entry::getValue)));
        searchResponse.setNumberOfProcessedResults(searchResult.getNumberOfProcessedResults());
        searchResponse.setNumberOfAcceptedResults(searchResult.getNumberOfAcceptedResults());
        searchResponse.setNumberOfDuplicateResults(searchResult.getNumberOfFoundDuplicates());
        List transformedSearchResults = this.transformSearchResults(searchResult.getSearchResultItems());
        searchResponse.setSearchResults(transformedSearchResults);
        searchResponse.setOffset(searchResult.getOffset());
        searchResponse.setLimit(searchResult.getLimit());
        logger.debug(LoggingMarkers.PERFORMANCE, "Creating web response for search results took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return searchResponse;
    }

    private List<IndexerSearchMetaData> createIndexerSearchMetaDatas(SearchResult searchResult) {
        ArrayList<IndexerSearchMetaData> indexerSearchMetaDatas = new ArrayList<IndexerSearchMetaData>();
        for (IndexerSearchResult indexerSearchResult : searchResult.getIndexerSearchResults()) {
            IndexerSearchMetaData indexerSearchMetaData = new IndexerSearchMetaData();
            indexerSearchMetaData.setDidSearch(true);
            indexerSearchMetaData.setErrorMessage(indexerSearchResult.getErrorMessage());
            indexerSearchMetaData.setHasMoreResults(indexerSearchResult.isHasMoreResults());
            indexerSearchMetaData.setIndexerName(indexerSearchResult.getIndexer().getName());
            indexerSearchMetaData.setNumberOfAvailableResults(indexerSearchResult.getTotalResults());
            indexerSearchMetaData.setNumberOfFoundResults(indexerSearchResult.getSearchResultItems().size());
            indexerSearchMetaData.setOffset(indexerSearchResult.getOffset());
            indexerSearchMetaData.setResponseTime(indexerSearchResult.getResponseTime());
            indexerSearchMetaData.setTotalResultsKnown(indexerSearchResult.isTotalResultsKnown());
            indexerSearchMetaData.setWasSuccessful(indexerSearchResult.isWasSuccessful());
            indexerSearchMetaDatas.add(indexerSearchMetaData);
        }
        indexerSearchMetaDatas.sort(Comparator.comparing(IndexerSearchMetaData::getIndexerName));
        return indexerSearchMetaDatas;
    }

    private List<SearchResultWebTO> transformSearchResults(List<SearchResultItem> searchResultItems) {
        ArrayList<SearchResultWebTO> transformedSearchResults = new ArrayList<SearchResultWebTO>();
        List guids = searchResultItems.stream().map(SearchResultItem::getGuid).collect(Collectors.toList());
        Collection alreadyDownloaded = this.fileDownloadRepository.findBySearchResultIdIn(guids);
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(0);
        for (SearchResultItem item : searchResultItems) {
            Optional<FileDownloadEntity> matchingDownload;
            BaseConfig baseConfig = this.configProvider.getBaseConfig();
            SearchResultWebTO.SearchResultWebTOBuilder builder = SearchResultWebTO.builder().category(baseConfig.getSearching().isUseOriginalCategories() ? item.getOriginalCategory() : item.getCategory().getName()).categorySubtype(item.getCategory().getSubtype().name()).categorySearchType(item.getCategory().getSearchType() == null ? null : item.getCategory().getSearchType().name()).comments(item.getCommentsCount()).comments_link((String)ObjectUtils.firstNonNull((Object[])new String[]{item.getCommentsLink(), item.getDetails()})).cover((String)item.getCover().map(originalUrl -> {
                if (!baseConfig.getMain().isProxyImages()) {
                    return originalUrl;
                }
                return "cache/" + Base64.getEncoder().encodeToString(originalUrl.getBytes(StandardCharsets.UTF_8));
            }).orElse(null)).details_link(item.getDetails()).downloadType(item.getDownloadType().name()).files(item.getFiles()).grabs(item.getGrabs()).seeders(item.getSeeders()).peers(item.getPeers()).hasNfo(item.getHasNfo().name()).hash(Integer.valueOf(item.getDuplicateIdentifier())).indexer(item.getIndexer().getName()).indexerguid(item.getIndexerGuid()).indexerscore(Integer.valueOf(item.getIndexer().getConfig().getScore())).link(this.downloadUrlBuilder.getDownloadLinkForResults(item.getSearchResultId(), true, item.getDownloadType())).originalCategory(item.getOriginalCategory()).poster((String)item.getPoster().map(originalUrl -> {
                if (!baseConfig.getMain().isProxyImages()) {
                    return originalUrl;
                }
                return "cache/" + URLEncoder.encode(originalUrl, StandardCharsets.UTF_8);
            }).orElse(null)).searchResultId(item.getSearchResultId().toString()).size(item.getSize()).title(item.getTitle()).source((String)item.getSource().orElse(null));
            builder = this.setSearchResultDateRelatedValues(builder, item);
            if (item.getAttributes().containsKey("season")) {
                builder.season((String)item.getAttributes().get("season"));
            }
            if (item.getAttributes().containsKey("episode")) {
                builder.episode((String)item.getAttributes().get("episode"));
            }
            if (item.getAttributes().containsKey("showtitle")) {
                builder.showtitle((String)item.getAttributes().get("showtitle"));
            }
            if (item.getAttributes().containsKey("downloadvolumefactor") && item.getAttributes().containsKey("uploadvolumefactor")) {
                float dl = Float.parseFloat((String)item.getAttributes().get("downloadvolumefactor"));
                float ul = Float.parseFloat((String)item.getAttributes().get("uploadvolumefactor"));
                if (Float.compare(dl, 0.0f) == 0) {
                    builder.torrentDownloadFactor("Freelech");
                } else {
                    int ratio = (int)(100.0f / (ul / dl));
                    if (ratio != 100) {
                        builder.torrentDownloadFactor(df.format(ratio) + "%");
                    }
                }
            }
            if ((matchingDownload = alreadyDownloaded.stream().filter(x -> x.getSearchResult().getId() == item.getSearchResultId().longValue()).findFirst()).isPresent()) {
                builder.downloadedAt(DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(matchingDownload.get().getTime(), ZoneId.of("UTC"))));
            }
            if (baseConfig.getSearching().isShowMovieQualityIndicator() && item.getCategory().getSearchType() == SearchType.MOVIE) {
                ReleaseInfo releaseInfo = releaseParser.parse(item.getTitle());
                int rating = qualityAnalyzer.getQualityRating(releaseInfo);
                ArrayList<CallSite> qualityInfo = new ArrayList<CallSite>();
                List explanations = qualityAnalyzer.getRatingExplanation(releaseInfo);
                for (String explanation : explanations) {
                    qualityInfo.add((CallSite)((Object)("[QUALITY] " + explanation)));
                }
                qualityAnalyzer.analyze(releaseInfo).forEach(w -> qualityInfo.add((CallSite)((Object)("[" + w.severity().name() + "] " + w.message()))));
                builder.qualityRating(Integer.valueOf(rating));
                builder.qualityWarnings(qualityInfo);
            }
            transformedSearchResults.add(builder.build());
        }
        transformedSearchResults.sort(Comparator.comparingLong(SearchResultWebTO::getEpoch).reversed());
        return transformedSearchResults;
    }

    protected SearchResultWebTO.SearchResultWebTOBuilder setSearchResultDateRelatedValues(SearchResultWebTO.SearchResultWebTOBuilder builder, SearchResultItem item) {
        Instant date = item.getBestDate();
        long ageInDays = date.until(Instant.now(), ChronoUnit.DAYS);
        if (ageInDays > 0L) {
            builder.age(ageInDays + "d");
        } else {
            long ageInHours = date.until(Instant.now(), ChronoUnit.HOURS);
            if (ageInHours > 0L) {
                builder.age(ageInHours + "h");
            } else {
                long ageInMinutes = date.until(Instant.now(), ChronoUnit.MINUTES);
                builder.age(ageInMinutes + "m");
            }
        }
        builder = builder.age_precise(Boolean.valueOf(item.isAgePrecise())).date(LocalDateTime.ofInstant(date, ZoneId.of("UTC")).format(item.isAgePrecise() ? DATE_TIME_FORMATTER : DATE_FORMATTER)).epoch(Long.valueOf(date.getEpochSecond()));
        return builder;
    }
}

