/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.nzbhydra.config.BaseConfigHandler;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.searching.SavedSearch;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.historystats.SavedSearchRequest;
import org.nzbhydra.searching.db.IdentifierKeyValuePairTO;
import org.nzbhydra.searching.dtoseventsenums.SearchRequestParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SavedSearchesWeb {
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private BaseConfigHandler baseConfigHandler;

    @Secured(value={"ROLE_STATS"})
    @RequestMapping(value={"/internalapi/savedsearches"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<SavedSearch> getSavedSearches() {
        return this.configProvider.getBaseConfig().getSearching().getSavedSearches();
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/savedsearches/{index}"}, method={RequestMethod.DELETE})
    public void deleteSearch(@PathVariable int index) {
        List savedSearches = this.configProvider.getBaseConfig().getSearching().getSavedSearches();
        if (index >= 0 && index < savedSearches.size()) {
            savedSearches.remove(index);
            this.baseConfigHandler.save(true);
        }
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/savedsearches"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void saveSearch(@RequestBody SavedSearchRequest request) {
        if (request == null || request.getRequest() == null) {
            return;
        }
        SearchRequestParameters parameters = request.getRequest();
        SavedSearch savedSearch = this.toSavedSearch(parameters);
        this.configProvider.getBaseConfig().getSearching().getSavedSearches().add(savedSearch);
        this.baseConfigHandler.save(true);
    }

    private SavedSearch toSavedSearch(SearchRequestParameters parameters) {
        SavedSearch savedSearch = new SavedSearch();
        savedSearch.setCategoryName(parameters.getCategory());
        savedSearch.setQuery(parameters.getQuery());
        savedSearch.setSeason(parameters.getSeason());
        savedSearch.setEpisode(parameters.getEpisode());
        savedSearch.setTitle(parameters.getTitle());
        savedSearch.setSearchType(this.resolveSearchType(parameters.getMode()));
        savedSearch.setIdentifiers(this.buildIdentifiers(parameters));
        return savedSearch;
    }

    private SearchType resolveSearchType(String mode) {
        if (Strings.isNullOrEmpty((String)mode)) {
            return SearchType.SEARCH;
        }
        try {
            return SearchType.valueOf((String)mode.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return SearchType.SEARCH;
        }
    }

    private Set<IdentifierKeyValuePairTO> buildIdentifiers(SearchRequestParameters parameters) {
        HashSet<IdentifierKeyValuePairTO> identifiers = new HashSet<IdentifierKeyValuePairTO>();
        this.addIdentifier(identifiers, "TMDB", parameters.getTmdbId());
        this.addIdentifier(identifiers, "IMDB", parameters.getImdbId());
        this.addIdentifier(identifiers, "TVDB", parameters.getTvdbId());
        this.addIdentifier(identifiers, "TVMAZE", parameters.getTvmazeId());
        this.addIdentifier(identifiers, "TVRAGE", parameters.getTvrageId());
        return identifiers;
    }

    private void addIdentifier(Set<IdentifierKeyValuePairTO> identifiers, String key, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            identifiers.add(new IdentifierKeyValuePairTO(key, value));
        }
    }
}

