/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.searching.IndexerForSearchSelector;
import org.nzbhydra.searching.IndexerSearchCacheEntry;
import org.nzbhydra.searching.db.SearchEntity;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
public class SearchCacheEntry {
    private Instant lastAccessed;
    private SearchRequest searchRequest;
    private Map<String, IndexerSearchCacheEntry> indexerCacheEntries = new HashMap();
    private List<SearchResultItem> searchResultItems = new ArrayList();
    private IndexerForSearchSelector.IndexerForSearchSelection indexerSelectionResult;
    private SearchEntity searchEntity;
    private Multiset<String> reasonsForRejection = HashMultiset.create();
    private int numberOfRemovedDuplicates;
    private Integer numberOfAvailableResults = null;

    public SearchCacheEntry(SearchRequest searchRequest, IndexerForSearchSelector.IndexerForSearchSelection indexerSelectionResult, SearchEntity searchEntity) {
        this.searchRequest = searchRequest;
        this.searchEntity = searchEntity;
        this.lastAccessed = Instant.now();
        for (Indexer indexer : indexerSelectionResult.getSelectedIndexers()) {
            IndexerSearchCacheEntry indexerSearchCacheEntry = new IndexerSearchCacheEntry(indexer);
            indexerSearchCacheEntry.setIndexer(indexer);
            indexerSearchCacheEntry.setNextResultIndex(0);
        }
        this.indexerSelectionResult = indexerSelectionResult;
    }

    public int getNumberOfRejectedResults() {
        return this.reasonsForRejection.entrySet().stream().mapToInt(Multiset.Entry::getCount).sum();
    }

    public int getNumberOfTotalAvailableResults() {
        this.numberOfAvailableResults = this.indexerCacheEntries.values().stream().filter(x -> !x.getIndexerSearchResults().isEmpty()).mapToInt(x -> {
            int totalResults = ((IndexerSearchResult)Iterables.getLast((Iterable)x.getIndexerSearchResults())).getTotalResults();
            int actualResults = x.getSearchResultItems().size();
            return Math.max(totalResults, actualResults);
        }).sum();
        return this.numberOfAvailableResults;
    }

    public int getNumberOfFoundResults() {
        this.numberOfAvailableResults = this.indexerCacheEntries.values().stream().mapToInt(x -> x.getSearchResultItems().size()).sum();
        return this.numberOfAvailableResults;
    }

    public Map<String, IndexerSearchCacheEntry> getIndexerCacheEntries() {
        return this.indexerCacheEntries;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCacheEntry other = (SearchCacheEntry)obj;
        return Objects.equal((Object)this.searchRequest.getQuery(), (Object)other.getSearchRequest().getQuery()) && Objects.equal((Object)this.searchRequest.getSeason(), (Object)other.getSearchRequest().getSeason()) && Objects.equal((Object)this.searchRequest.getEpisode(), (Object)other.getSearchRequest().getEpisode()) && Objects.equal((Object)this.searchRequest.getIdentifiers(), (Object)other.getSearchRequest().getIdentifiers()) && Objects.equal((Object)this.searchRequest.getAuthor(), (Object)other.getSearchRequest().getAuthor()) && Objects.equal((Object)this.searchRequest.getTitle(), (Object)other.getSearchRequest().getTitle()) && Objects.equal((Object)this.searchRequest.getMinage(), (Object)other.getSearchRequest().getMinage()) && Objects.equal((Object)this.searchRequest.getMaxage(), (Object)other.getSearchRequest().getMaxage()) && Objects.equal((Object)this.searchRequest.getMinsize(), (Object)other.getSearchRequest().getMinsize()) && Objects.equal((Object)this.searchRequest.getMaxsize(), (Object)other.getSearchRequest().getMaxsize());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.searchRequest.getQuery(), this.searchRequest.getSeason(), this.searchRequest.getEpisode(), this.searchRequest.getIdentifiers(), this.searchRequest.getAuthor(), this.searchRequest.getTitle(), this.searchRequest.getMinage(), this.searchRequest.getMaxage(), this.searchRequest.getMinsize(), this.searchRequest.getMaxsize()});
    }

    @Generated
    public Instant getLastAccessed() {
        return this.lastAccessed;
    }

    @Generated
    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    @Generated
    public List<SearchResultItem> getSearchResultItems() {
        return this.searchResultItems;
    }

    @Generated
    public IndexerForSearchSelector.IndexerForSearchSelection getIndexerSelectionResult() {
        return this.indexerSelectionResult;
    }

    @Generated
    public SearchEntity getSearchEntity() {
        return this.searchEntity;
    }

    @Generated
    public Multiset<String> getReasonsForRejection() {
        return this.reasonsForRejection;
    }

    @Generated
    public int getNumberOfRemovedDuplicates() {
        return this.numberOfRemovedDuplicates;
    }

    @Generated
    public Integer getNumberOfAvailableResults() {
        return this.numberOfAvailableResults;
    }

    @Generated
    public void setLastAccessed(Instant lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Generated
    public void setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
    }

    @Generated
    public void setIndexerCacheEntries(Map<String, IndexerSearchCacheEntry> indexerCacheEntries) {
        this.indexerCacheEntries = indexerCacheEntries;
    }

    @Generated
    public void setSearchResultItems(List<SearchResultItem> searchResultItems) {
        this.searchResultItems = searchResultItems;
    }

    @Generated
    public void setIndexerSelectionResult(IndexerForSearchSelector.IndexerForSearchSelection indexerSelectionResult) {
        this.indexerSelectionResult = indexerSelectionResult;
    }

    @Generated
    public void setSearchEntity(SearchEntity searchEntity) {
        this.searchEntity = searchEntity;
    }

    @Generated
    public void setReasonsForRejection(Multiset<String> reasonsForRejection) {
        this.reasonsForRejection = reasonsForRejection;
    }

    @Generated
    public void setNumberOfRemovedDuplicates(int numberOfRemovedDuplicates) {
        this.numberOfRemovedDuplicates = numberOfRemovedDuplicates;
    }

    @Generated
    public void setNumberOfAvailableResults(Integer numberOfAvailableResults) {
        this.numberOfAvailableResults = numberOfAvailableResults;
    }

    @Generated
    public String toString() {
        return "SearchCacheEntry(lastAccessed=" + String.valueOf(this.getLastAccessed()) + ", searchRequest=" + String.valueOf(this.getSearchRequest()) + ", indexerCacheEntries=" + String.valueOf(this.getIndexerCacheEntries()) + ", searchResultItems=" + String.valueOf(this.getSearchResultItems()) + ", indexerSelectionResult=" + String.valueOf(this.getIndexerSelectionResult()) + ", searchEntity=" + String.valueOf(this.getSearchEntity()) + ", reasonsForRejection=" + String.valueOf(this.getReasonsForRejection()) + ", numberOfRemovedDuplicates=" + this.getNumberOfRemovedDuplicates() + ", numberOfAvailableResults=" + this.getNumberOfAvailableResults() + ")";
    }
}

