/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.SearchSourceRestriction;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.indexer.SearchModuleType;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.CategoryProvider;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchResultAcceptor {
    private static final Logger logger = LoggerFactory.getLogger(SearchResultAcceptor.class);
    private static final Pattern TITLE_PATTERN = Pattern.compile("(\\w[\\w']*\\w|\\w)");
    private Map<String, List<String>> titleWordCache = new ConcurrentHashMap();
    private final ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    private final Validator validator = this.factory.getValidator();
    @Autowired
    private ConfigProvider configProvider;

    public AcceptorResult acceptResults(List<SearchResultItem> items, SearchRequest searchRequest, IndexerConfig indexerConfig) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        BaseConfig baseConfig = this.configProvider.getBaseConfig();
        this.titleWordCache = new HashMap();
        ArrayList<SearchResultItem> acceptedResults = new ArrayList<SearchResultItem>();
        HashMultiset reasonsForRejection = HashMultiset.create();
        HashSet<SearchResultItem> itemsWithoutActualDuplicates = new HashSet<SearchResultItem>(items);
        if (itemsWithoutActualDuplicates.size() < items.size()) {
            int removedDuplicates = items.size() - itemsWithoutActualDuplicates.size();
            logger.warn("Removed {} actual duplicates from the results returned by {}. This is likely an error in their code base", (Object)removedDuplicates, (Object)indexerConfig.getName());
            reasonsForRejection.add((Object)"Duplicate results from indexer", removedDuplicates);
        }
        for (SearchResultItem item : itemsWithoutActualDuplicates) {
            boolean applyWordAndRegexRestrictions;
            if (!this.checkForNeededAttributesSuccessfullyMapped((Multiset)reasonsForRejection, item) || !this.checkForPassword((Multiset)reasonsForRejection, item) || !this.checkForForbiddenGroup((Multiset)reasonsForRejection, item) || !this.checkForForbiddenPoster((Multiset)reasonsForRejection, item) || !this.checkForSize(searchRequest, (Multiset)reasonsForRejection, item) || !this.checkForAge(searchRequest, (Multiset)reasonsForRejection, item) || !this.checkForCategoryShouldBeIgnored(searchRequest, (Multiset)reasonsForRejection, item) || !this.checkForCategoryDisabledForIndexer(searchRequest, (Multiset)reasonsForRejection, item) || !this.checkForLanguage((Multiset)reasonsForRejection, item) || !this.checkMinSeeders(indexerConfig, (Multiset)reasonsForRejection, item) || !this.checkAttributeWhitelist(indexerConfig, (Multiset)reasonsForRejection, item) || !this.checkForForbiddenWords(indexerConfig, (Multiset)reasonsForRejection, searchRequest.getInternalData().getForbiddenWords(), item, "internal data") || !this.checkRequiredWords((Multiset)reasonsForRejection, searchRequest.getInternalData().getRequiredWords(), item, "internal data")) continue;
            boolean bl = applyWordAndRegexRestrictions = baseConfig.getSearching().getApplyRestrictions() == SearchSourceRestriction.BOTH || Objects.equals(searchRequest.getSource().name(), baseConfig.getSearching().getApplyRestrictions().name());
            if (applyWordAndRegexRestrictions && (!this.checkRegexes(item, (Multiset)reasonsForRejection, (String)baseConfig.getSearching().getRequiredRegex().orElse(null), (String)baseConfig.getSearching().getForbiddenRegex().orElse(null)) || !this.checkRequiredWords((Multiset)reasonsForRejection, baseConfig.getSearching().getRequiredWords(), item, "searching config") || !this.checkForForbiddenWords(indexerConfig, (Multiset)reasonsForRejection, baseConfig.getSearching().getForbiddenWords(), item, "searching config"))) continue;
            boolean bl2 = applyWordAndRegexRestrictions = item.getCategory().getApplyRestrictionsType() == SearchSourceRestriction.BOTH || Objects.equals(searchRequest.getSource().name(), item.getCategory().getApplyRestrictionsType().name());
            if (applyWordAndRegexRestrictions && (!this.checkRegexes(item, (Multiset)reasonsForRejection, (String)item.getCategory().getRequiredRegex().orElse(null), (String)item.getCategory().getForbiddenRegex().orElse(null)) || !this.checkRequiredWords((Multiset)reasonsForRejection, item.getCategory().getRequiredWords(), item, "category") || !this.checkForForbiddenWords(indexerConfig, (Multiset)reasonsForRejection, item.getCategory().getForbiddenWords(), item, "category"))) continue;
            acceptedResults.add(item);
        }
        if (acceptedResults.size() < items.size()) {
            logger.debug("Rejected {} out of {} search results from indexer {}", new Object[]{items.size() - acceptedResults.size(), items.size(), indexerConfig.getName()});
            for (Multiset.Entry entry : reasonsForRejection.entrySet()) {
                logger.info("Rejected {} search results from {} for the following reason: {}", new Object[]{entry.getCount(), indexerConfig.getName(), entry.getElement()});
            }
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Check of {} search results took {}ms", (Object)items.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return new AcceptorResult(acceptedResults, (Multiset)reasonsForRejection);
    }

    protected boolean checkForNeededAttributesSuccessfullyMapped(Multiset<String> reasonsForRejection, SearchResultItem item) {
        boolean accepted = true;
        Set constraintViolations = this.validator.validate((Object)item, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            HashSet<String> messages = new HashSet<String>(constraintViolations.size());
            messages.addAll(constraintViolations.stream().map(constraintViolation -> String.format("%s value '%s' %s", constraintViolation.getPropertyPath(), constraintViolation.getInvalidValue(), constraintViolation.getMessage())).toList());
            logger.error("Coding error: SearchResultItem validation messages: {}", (Object)Joiner.on((String)" ").join(messages));
            reasonsForRejection.add((Object)"Important data could not be mapped from the indexers returned response");
            return false;
        }
        if (item.getBestDate() == null) {
            logger.error("Coding error: Neither pubdate nor usenet date could be found or parsed");
            accepted = false;
        }
        if (!accepted) {
            reasonsForRejection.add((Object)"Important data could not be mapped from the indexers returned response");
            return false;
        }
        return true;
    }

    protected boolean checkForCategoryShouldBeIgnored(SearchRequest searchRequest, Multiset<String> reasonsForRejection, SearchResultItem item) {
        if (searchRequest.meets(item.getCategory().getIgnoreResultsFrom())) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "{} is in forbidden category {}", (Object)item.getTitle(), (Object)item.getCategory().getName());
            reasonsForRejection.add((Object)"In forbidden category");
            return false;
        }
        return true;
    }

    protected boolean checkForCategoryDisabledForIndexer(SearchRequest searchRequest, Multiset<String> reasonsForRejection, SearchResultItem item) {
        List enabledCategories = item.getIndexer().getConfig().getEnabledCategories();
        String categoryName = item.getCategory().getName();
        if (!(item.getCategory().equals((Object)CategoryProvider.naCategory) || enabledCategories.isEmpty() || enabledCategories.contains(categoryName))) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "{} is in category {} disabled for indexer {} (enabled are: {})", new Object[]{item.getTitle(), categoryName, item.getIndexer().getName(), enabledCategories});
            reasonsForRejection.add((Object)"In forbidden category");
            return false;
        }
        return true;
    }

    protected boolean checkForSize(SearchRequest searchRequest, Multiset<String> reasonsForRejection, SearchResultItem item) {
        boolean isApiAndLimitsShouldApply = item.getCategory().isApplySizeLimitsToApi() && searchRequest.getSource() == SearchSource.API;
        Integer minSize = searchRequest.getMinsize().orElse(isApiAndLimitsShouldApply && item.getCategory().getMinSizePreset().isPresent() ? (Integer)item.getCategory().getMinSizePreset().orElse(null) : null);
        if (minSize != null && item.getSize() != null && item.getSize() / 0x100000L < (long)minSize.intValue()) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "{} is smaller than {}", (Object)item.getTitle(), (Object)minSize);
            reasonsForRejection.add((Object)"Wrong size");
            return false;
        }
        Integer maxSize = searchRequest.getMaxsize().orElse(isApiAndLimitsShouldApply && item.getCategory().getMaxSizePreset().isPresent() ? (Integer)item.getCategory().getMaxSizePreset().orElse(null) : null);
        if (maxSize != null && item.getSize() != null && item.getSize() / 0x100000L > (long)maxSize.intValue()) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "{} is bigger than {}", (Object)item.getTitle(), (Object)maxSize);
            reasonsForRejection.add((Object)"Wrong size");
            return false;
        }
        return true;
    }

    protected boolean checkForAge(SearchRequest searchRequest, Multiset<String> reasonsForRejection, SearchResultItem item) {
        if (searchRequest.getMinage().isPresent() && item.getAgeInDays() < (long)((Integer)searchRequest.getMinage().get()).intValue()) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "{} is younger than {} days", (Object)item.getTitle(), searchRequest.getMinage().get());
            reasonsForRejection.add((Object)"Wrong age");
            return false;
        }
        if (searchRequest.getMaxage().isPresent() && item.getAgeInDays() > (long)((Integer)searchRequest.getMaxage().get()).intValue()) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "{} is older than {} days", (Object)item.getTitle(), searchRequest.getMaxage().get());
            reasonsForRejection.add((Object)"Wrong age");
            return false;
        }
        return true;
    }

    protected boolean checkForForbiddenGroup(Multiset<String> reasonsForRejection, SearchResultItem item) {
        if (item.getGroup().isPresent() && this.configProvider.getBaseConfig().getSearching().getForbiddenGroups().stream().anyMatch(x -> item.getGroup().isPresent() && ((String)item.getGroup().get()).contains((CharSequence)x))) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Found forbidden group {}", item.getGroup().get());
            reasonsForRejection.add((Object)"In forbidden group");
            return false;
        }
        return true;
    }

    protected boolean checkForForbiddenPoster(Multiset<String> reasonsForRejection, SearchResultItem item) {
        if (item.getPoster().isPresent() && this.configProvider.getBaseConfig().getSearching().getForbiddenPosters().stream().anyMatch(x -> item.getPoster().isPresent() && ((String)item.getPoster().get()).contains((CharSequence)x))) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Found forbidden poster {}", item.getPoster().get());
            reasonsForRejection.add((Object)"In forbidden poster");
            return false;
        }
        return true;
    }

    protected boolean checkRegexes(SearchResultItem item, Multiset<String> reasonsForRejection, String requiredRegex, String forbiddenRegex) {
        Pattern forbiddenPattern;
        Pattern requiredPattern;
        if (!Strings.isNullOrEmpty((String)requiredRegex) && !(requiredPattern = Pattern.compile(requiredRegex, 34)).matcher(item.getTitle()).find()) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Did not find required regex in {}", (Object)item.getTitle());
            reasonsForRejection.add((Object)"Required regex doesn't match");
            return false;
        }
        if (!Strings.isNullOrEmpty((String)forbiddenRegex) && (forbiddenPattern = Pattern.compile(forbiddenRegex, 34)).matcher(item.getTitle()).find()) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Found forbidden regex in {}", (Object)item.getTitle());
            reasonsForRejection.add((Object)"Forbidden regex matches");
            return false;
        }
        return true;
    }

    protected boolean checkRequiredWords(Multiset<String> reasonsForRejection, List<String> requiredWords, SearchResultItem item, String source) {
        if (!requiredWords.isEmpty()) {
            List titleWords = this.getTitleWords(item);
            boolean allPresent = true;
            for (String requiredWord : requiredWords) {
                if (requiredWord.contains(".") || requiredWord.contains("-")) {
                    if (item.getTitle().toLowerCase().contains(requiredWord.toLowerCase())) continue;
                    logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Did not find required word {} (from {}) in the title {}", new Object[]{requiredWord, source, item.getTitle()});
                    allPresent = false;
                    break;
                }
                if (titleWords.contains(requiredWord.toLowerCase())) continue;
                logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Did not find required word {} (from {}) in the title {}", new Object[]{requiredWord, source, item.getTitle()});
                allPresent = false;
                break;
            }
            if (!allPresent) {
                reasonsForRejection.add((Object)"No required word found");
                return false;
            }
        }
        return true;
    }

    private synchronized List<String> getTitleWords(SearchResultItem item) {
        return this.titleWordCache.computeIfAbsent(item.getTitle(), s -> {
            ArrayList<String> titleWords = new ArrayList<String>();
            Matcher matcher = TITLE_PATTERN.matcher(item.getTitle().toLowerCase());
            while (matcher.find()) {
                titleWords.add(matcher.group().toLowerCase());
            }
            return titleWords;
        });
    }

    protected boolean checkForForbiddenWords(IndexerConfig indexerConfig, Multiset<String> reasonsForRejection, List<String> forbiddenWords, SearchResultItem item, String source) {
        for (String forbiddenWord : forbiddenWords) {
            if (forbiddenWord.contains("-") || forbiddenWord.contains(".") || indexerConfig.getHost().toLowerCase().contains("nzbgeek")) {
                if (!item.getTitle().toLowerCase().contains(forbiddenWord.toLowerCase())) continue;
                reasonsForRejection.add((Object)"Forbidden word");
                logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Found forbidden word {} (from {}) in title {}", new Object[]{forbiddenWord, source, item.getTitle()});
                return false;
            }
            List titleWords = this.getTitleWords(item);
            Optional<String> found = titleWords.stream().filter(x -> x.equalsIgnoreCase(forbiddenWord)).findFirst();
            if (!found.isPresent()) continue;
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Found forbidden word (from {}) in title word {} (full title: {})", new Object[]{source, found.get(), item.getTitle()});
            reasonsForRejection.add((Object)"Forbidden word");
            return false;
        }
        return true;
    }

    protected boolean checkForPassword(Multiset<String> reasonsForRejection, SearchResultItem item) {
        if (this.configProvider.getBaseConfig().getSearching().isIgnorePassworded() && item.isPassworded()) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Ignore passworded result");
            reasonsForRejection.add((Object)"Ignore passworded");
            return false;
        }
        return true;
    }

    protected boolean checkForLanguage(Multiset<String> reasonsForRejection, SearchResultItem item) {
        List languagesToKeep = this.configProvider.getBaseConfig().getSearching().getLanguagesToKeep();
        if (languagesToKeep.isEmpty()) {
            return true;
        }
        if (!item.getAttributes().containsKey("language")) {
            return true;
        }
        String language = (String)item.getAttributes().get("language");
        if (!languagesToKeep.contains(language)) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Found language {} which is to be filtered", (Object)language);
            reasonsForRejection.add((Object)"Wrong language");
            return false;
        }
        return true;
    }

    protected boolean checkMinSeeders(IndexerConfig indexerConfig, Multiset<String> reasonsForRejection, SearchResultItem item) {
        if (indexerConfig.getSearchModuleType() != SearchModuleType.TORZNAB) {
            return true;
        }
        Integer resultSeeders = item.getSeeders();
        if (resultSeeders == null) {
            return true;
        }
        Integer indexerMinSeeders = indexerConfig.getMinSeeders();
        if (indexerMinSeeders != null && resultSeeders < indexerMinSeeders) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "At least {} seeders expected for results from indexer {} but has {}", new Object[]{indexerConfig.getName(), indexerMinSeeders, resultSeeders});
            reasonsForRejection.add((Object)"Not enough seeders");
            return false;
        }
        Integer mainMinSeeders = this.configProvider.getBaseConfig().getSearching().getMinSeeders();
        if (mainMinSeeders != null && resultSeeders < mainMinSeeders) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "At least {} seeders expected but has {}", (Object)mainMinSeeders, (Object)resultSeeders);
            reasonsForRejection.add((Object)"Not enough seeders");
            return false;
        }
        return true;
    }

    protected boolean checkAttributeWhitelist(IndexerConfig indexerConfig, Multiset<String> reasonsForRejection, SearchResultItem item) {
        Map itemAttributes;
        List whitelist = indexerConfig.getAttributeWhitelist();
        if (whitelist == null || whitelist.isEmpty()) {
            return true;
        }
        List whitelistCategories = indexerConfig.getAttributeWhitelistCategories();
        if (whitelistCategories != null && !whitelistCategories.isEmpty()) {
            String itemCategoryName;
            String string = itemCategoryName = item.getCategory() != null ? item.getCategory().getName() : null;
            if (itemCategoryName == null || !whitelistCategories.contains(itemCategoryName)) {
                return true;
            }
        }
        if ((itemAttributes = item.getAttributes()) == null || itemAttributes.isEmpty()) {
            logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Rejecting '{}' because it has no attributes but attribute whitelist is configured", (Object)item.getTitle());
            reasonsForRejection.add((Object)"No attributes but whitelist configured");
            return false;
        }
        for (String whitelistEntry : whitelist) {
            if (!this.matchesWhitelistEntry(whitelistEntry, itemAttributes)) continue;
            return true;
        }
        logger.debug(LoggingMarkers.RESULT_ACCEPTOR, "Rejecting '{}' because it doesn't match any attribute whitelist entry", (Object)item.getTitle());
        reasonsForRejection.add((Object)"Attribute whitelist not matched");
        return false;
    }

    private boolean matchesWhitelistEntry(String whitelistEntry, Map<String, String> itemAttributes) {
        int equalsIndex = whitelistEntry.indexOf(61);
        if (equalsIndex <= 0 || equalsIndex >= whitelistEntry.length() - 1) {
            logger.error("Invalid whitelist entry format: '{}'", (Object)whitelistEntry);
            return false;
        }
        String attributeName = whitelistEntry.substring(0, equalsIndex).trim().toLowerCase();
        String requiredValuesStr = whitelistEntry.substring(equalsIndex + 1).trim();
        String itemValue = null;
        for (Map.Entry<String, String> entry : itemAttributes.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(attributeName)) continue;
            itemValue = entry.getValue();
            break;
        }
        if (itemValue == null) {
            return false;
        }
        if (requiredValuesStr.contains(",")) {
            String[] requiredValues;
            for (String requiredValue : requiredValues = requiredValuesStr.split(",")) {
                if (itemValue.toLowerCase().contains(requiredValue.trim().toLowerCase())) continue;
                return false;
            }
            return true;
        }
        return itemValue.toLowerCase().contains(requiredValuesStr.toLowerCase());
    }
}

