/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import java.security.Principal;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.searching.CategoryProvider;
import org.nzbhydra.searching.CustomQueryAndTitleMappingHandler;
import org.nzbhydra.searching.DemoDataProvider;
import org.nzbhydra.searching.DemoModeWeb;
import org.nzbhydra.searching.InternalSearchResultProcessor;
import org.nzbhydra.searching.SearchResponse;
import org.nzbhydra.searching.SearchResult;
import org.nzbhydra.searching.SearchState;
import org.nzbhydra.searching.Searcher;
import org.nzbhydra.searching.SortableMessage;
import org.nzbhydra.searching.dtoseventsenums.FallbackSearchInitiatedEvent;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchFinishedEvent;
import org.nzbhydra.searching.dtoseventsenums.IndexerSelectionEvent;
import org.nzbhydra.searching.dtoseventsenums.SearchMessageEvent;
import org.nzbhydra.searching.dtoseventsenums.SearchRequestParameters;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.nzbhydra.searching.searchrequests.SearchRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SearchWeb {
    private static final Logger logger = LoggerFactory.getLogger(SearchWeb.class);
    @Autowired
    private Searcher searcher;
    @Autowired
    private CategoryProvider categoryProvider;
    @Autowired
    private SearchRequestFactory searchRequestFactory;
    @Autowired
    private InternalSearchResultProcessor searchResultProcessor;
    @Autowired
    private SimpMessageSendingOperations messagingTemplate;
    @Autowired
    private CustomQueryAndTitleMappingHandler customQueryAndTitleMappingHandler;
    @Autowired
    private DemoDataProvider demoDataProvider;
    private final Lock lock = new ReentrantLock();
    private final Map<Long, SearchState> searchStates = ExpiringMap.builder().maxSize(50).expiration(5L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/search"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public SearchResponse search(@RequestBody SearchRequestParameters parameters, Principal principal) {
        SearchState searchState;
        if (DemoModeWeb.isDemoModeActive((Principal)principal)) {
            logger.info("Demo mode active, returning mock search results for query '{}'", (Object)parameters.getQuery());
            this.sendMockSearchProgress(parameters.getSearchRequestId());
            return this.demoDataProvider.generateSearchResponse(parameters);
        }
        SearchRequest searchRequest = this.createSearchRequest(parameters);
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("New search request: {}", (Object)searchRequest);
        SearchResult searchResult = this.searcher.search(searchRequest);
        SearchResponse searchResponse = this.searchResultProcessor.createSearchResponse(searchResult);
        this.lock.lock();
        try {
            searchState = (SearchState)this.searchStates.get(searchRequest.getSearchRequestId());
            searchState.setSearchFinished(true);
        }
        finally {
            this.lock.unlock();
        }
        this.sendSearchState(searchState);
        logger.info("Web search took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return searchResponse;
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/shortcutSearch/{searchRequestId}"}, method={RequestMethod.POST})
    public void shortcutSearch(@PathVariable Long searchRequestId) {
        logger.info("Requested shortcut of search with ID {}", (Object)searchRequestId);
        this.searcher.shortcutSearch(searchRequestId);
    }

    private void sendSearchState(SearchState searchState) {
        this.messagingTemplate.convertAndSend((Object)"/topic/searchState", (Object)searchState);
    }

    private void sendMockSearchProgress(long searchRequestId) {
        String[] demoIndexerNames = new String[]{"DemoIndexer1", "DemoIndexer2", "DemoIndexer3"};
        SearchState state = new SearchState(searchRequestId);
        this.sendSearchState(state);
        state.setIndexerSelectionFinished(true);
        state.setIndexersSelected(demoIndexerNames.length);
        state.getMessages().add(new SortableMessage("Searching DemoIndexer1", "DemoIndexer1"));
        state.getMessages().add(new SortableMessage("Searching DemoIndexer2", "DemoIndexer2"));
        state.getMessages().add(new SortableMessage("Searching DemoIndexer3", "DemoIndexer3"));
        this.sendSearchState(state);
        try {
            for (int i = 0; i < demoIndexerNames.length; ++i) {
                Thread.sleep(500 + i * 200);
                state.setIndexersFinished(i + 1);
                state.getMessages().set(i, new SortableMessage(demoIndexerNames[i] + " returned results", demoIndexerNames[i]));
                this.sendSearchState(state);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Demo search progress simulation interrupted");
        }
        state.setSearchFinished(true);
        this.sendSearchState(state);
    }

    private SearchRequest createSearchRequest(@RequestBody SearchRequestParameters parameters) {
        Category category = this.categoryProvider.getByInternalName(parameters.getCategory());
        SearchType searchType = parameters.getMode() != null && category.getSubtype() == Category.Subtype.ALL ? SearchType.valueOf((String)parameters.getMode().toUpperCase()) : (category.getSearchType() == null ? SearchType.SEARCH : category.getSearchType());
        SearchRequest searchRequest = this.searchRequestFactory.getSearchRequest(searchType, SearchSource.INTERNAL, category, parameters.getSearchRequestId(), parameters.getOffset(), parameters.getLimit());
        searchRequest.setLoadAll(parameters.isLoadAll());
        searchRequest.setIndexers(parameters.getIndexers());
        searchRequest.setQuery(parameters.getQuery());
        searchRequest.setMinage(parameters.getMinage());
        searchRequest.setMaxage(parameters.getMaxage());
        searchRequest.setMinsize(parameters.getMinsize());
        searchRequest.setMaxsize(parameters.getMaxsize());
        if (!Strings.isNullOrEmpty((String)parameters.getTitle())) {
            searchRequest.setTitle(parameters.getTitle());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getImdbId())) {
            searchRequest.getIdentifiers().put(MediaIdType.IMDB, parameters.getImdbId());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getTmdbId())) {
            searchRequest.getIdentifiers().put(MediaIdType.TMDB, parameters.getTmdbId());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getTvrageId())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVRAGE, parameters.getTvrageId());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getTvdbId())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVDB, parameters.getTvdbId());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getTvmazeId())) {
            searchRequest.getIdentifiers().put(MediaIdType.TVMAZE, parameters.getTvmazeId());
        }
        if (parameters.getSeason() != null) {
            searchRequest.setSeason(parameters.getSeason());
        }
        if (!Strings.isNullOrEmpty((String)parameters.getEpisode())) {
            searchRequest.setEpisode(parameters.getEpisode());
        }
        if (!searchRequest.getIdentifiers().isEmpty() && searchRequest.getQuery().isPresent()) {
            logger.info("Moving additional search terms '{}' from query to required words", searchRequest.getQuery().get());
            searchRequest.getInternalData().getRequiredWords().addAll(Splitter.on((String)" ").splitToList((CharSequence)searchRequest.getQuery().get()));
            searchRequest.setQuery(null);
        }
        searchRequest = this.searchRequestFactory.extendWithSavedIdentifiers(searchRequest);
        searchRequest = this.customQueryAndTitleMappingHandler.mapSearchRequest(searchRequest);
        SearchState searchState = new SearchState(searchRequest.getSearchRequestId());
        this.searchStates.put(searchRequest.getSearchRequestId(), searchState);
        this.sendSearchState(searchState);
        return searchRequest;
    }

    @EventListener
    public void handleSearchMessageEvent(SearchMessageEvent event) {
        this.updateAndSendSearchState(Long.valueOf(event.getSearchRequest().getSearchRequestId()), searchState -> {
            if (!searchState.getMessages().contains(event.getMessage())) {
                searchState.getMessages().add(event.getMessage());
                searchState.getMessages().sort(Comparator.comparing(x -> x.getMessageSortValue().toLowerCase(Locale.ROOT)));
                searchState.setModified(true);
            }
        });
    }

    @EventListener
    public void handleIndexerSelectionEvent(IndexerSelectionEvent event) {
        this.updateAndSendSearchState(Long.valueOf(event.getSearchRequest().getSearchRequestId()), searchState -> {
            searchState.setIndexerSelectionFinished(true);
            searchState.setIndexersSelected(event.getIndexersSelected());
        });
    }

    @EventListener
    public void handleFallbackSearchInitatedEvent(FallbackSearchInitiatedEvent event) {
        this.updateAndSendSearchState(Long.valueOf(event.getSearchRequest().getSearchRequestId()), searchState -> searchState.setIndexersSelected(searchState.getIndexersSelected() + 1));
    }

    @EventListener
    public void handleIndexerSearchFinishedEvent(IndexerSearchFinishedEvent event) {
        this.updateAndSendSearchState(Long.valueOf(event.getSearchRequest().getSearchRequestId()), searchState -> searchState.setIndexersFinished(searchState.getIndexersFinished() + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAndSendSearchState(Long searchRequestId, Consumer<SearchState> updater) {
        SearchState searchState;
        if (!this.searchStates.containsKey(searchRequestId)) {
            return;
        }
        this.lock.lock();
        try {
            searchState = (SearchState)this.searchStates.get(searchRequestId);
            if (searchState == null) {
                return;
            }
            searchState.setModified(true);
            updater.accept(searchState);
        }
        finally {
            this.lock.unlock();
        }
        if (searchState.isModified()) {
            this.sendSearchState(searchState);
        }
    }
}

