/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerSearchEntity;
import org.nzbhydra.indexers.IndexerSearchRepository;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.logging.MdcThreadPoolExecutor;
import org.nzbhydra.searching.DuplicateDetector;
import org.nzbhydra.searching.IndexerForSearchSelector;
import org.nzbhydra.searching.IndexerSearchCacheEntry;
import org.nzbhydra.searching.SearchCacheEntry;
import org.nzbhydra.searching.SearchResult;
import org.nzbhydra.searching.Searcher;
import org.nzbhydra.searching.db.IdentifierKeyValuePair;
import org.nzbhydra.searching.db.SearchEntity;
import org.nzbhydra.searching.db.SearchRepository;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.searching.dtoseventsenums.DuplicateDetectionResult;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class Searcher {
    private static final int MAX_QUERIES_UNTIL_BREAK = 15;
    public static int LOAD_LIMIT_API = 500;
    private static final Logger logger = LoggerFactory.getLogger(Searcher.class);
    @Autowired
    protected DuplicateDetector duplicateDetector;
    @Autowired
    private IndexerSearchRepository indexerSearchRepository;
    @Autowired
    private SearchRepository searchRepository;
    @Autowired
    private SearchResultRepository searchResultRepository;
    @Autowired
    protected IndexerForSearchSelector indexerSelector;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private TransactionTemplate transactionTemplate;
    private final Set<ExecutorService> executors = Collections.synchronizedSet(new HashSet());
    private final Map<Long, List<Future<IndexerSearchResult>>> searchCallables = ExpiringMap.builder().maxSize(10).expiration(5L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).build();
    private boolean shutdownRequested = false;
    private final Map<Integer, SearchCacheEntry> searchRequestCache = ExpiringMap.builder().maxSize(20).expirationPolicy(ExpirationPolicy.ACCESSED).expiration(5L, TimeUnit.MINUTES).expirationListener((k, v) -> logger.debug("Removing expired search cache entry {}", (Object)((SearchCacheEntry)v).getSearchRequest())).build();

    public SearchResult search(SearchRequest searchRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.eventPublisher.publishEvent((Object)new SearchEvent(searchRequest));
        SearchCacheEntry searchCacheEntry = this.getSearchCacheEntry(searchRequest);
        SearchResult searchResult = new SearchResult();
        int numberOfWantedResults = searchRequest.getOffset() + searchRequest.getLimit();
        searchResult.setIndexerSelectionResult(searchCacheEntry.getIndexerSelectionResult());
        searchResult.setNumberOfRemovedDuplicates(searchCacheEntry.getNumberOfRemovedDuplicates());
        List indexersToSearch = this.getIndexersToSearch(searchCacheEntry);
        List indexersWithCachedResults = this.getIndexersWithCachedResults(searchCacheEntry);
        List searchResultItems = searchCacheEntry.getSearchResultItems();
        while (!(indexersToSearch.isEmpty() && indexersWithCachedResults.isEmpty() || searchResultItems.size() >= numberOfWantedResults && !searchRequest.isLoadAll() || searchRequest.isShortcut() || this.shutdownRequested)) {
            if (searchRequest.isLoadAll()) {
                logger.debug("Loading all {} results requested", (Object)searchCacheEntry.getNumberOfFoundResults());
                int maxResultsToLoad = searchCacheEntry.getNumberOfAvailableResults();
                if (searchResultItems.size() > maxResultsToLoad) {
                    logger.info("Aborting loading all results because more than {} results were already loaded and we don't want to hammer the indexers too much", (Object)maxResultsToLoad);
                    break;
                }
            }
            if (!indexersToSearch.isEmpty()) {
                this.callSearchModules(searchRequest, indexersToSearch, searchCacheEntry);
                indexersToSearch = this.getIndexersToSearch(searchCacheEntry);
            }
            indexersWithCachedResults = this.getIndexersWithCachedResults(searchCacheEntry);
            while (!indexersWithCachedResults.isEmpty()) {
                List<Object> newestItemsFromIndexers = indexersWithCachedResults.stream().map(IndexerSearchCacheEntry::peek).sorted(Comparator.comparingLong(x -> ((SearchResultItem)x).getBestDate().getEpochSecond()).reversed()).toList();
                SearchResultItem newestResult = (SearchResultItem)newestItemsFromIndexers.get(0);
                Indexer newestResultIndexer = newestResult.getIndexer();
                IndexerSearchCacheEntry newestIndexerSearchCacheEntry = (IndexerSearchCacheEntry)searchCacheEntry.getIndexerCacheEntries().get(newestResultIndexer.getName());
                searchResultItems.add(newestIndexerSearchCacheEntry.pop());
                indexersWithCachedResults = this.getIndexersWithCachedResults(searchCacheEntry);
                if (newestIndexerSearchCacheEntry.isMoreResultsInCache() || !newestIndexerSearchCacheEntry.isMoreResultsAvailable()) continue;
                int executedSearches = newestIndexerSearchCacheEntry.getIndexerSearchResults().size();
                if (!searchRequest.isLoadAll() && executedSearches >= 15) {
                    logger.warn("Indexer {} executed {} queries without a load-all search. Will stop now", (Object)newestIndexerSearchCacheEntry.getIndexer().getName(), (Object)executedSearches);
                    break;
                }
                indexersToSearch.add(newestIndexerSearchCacheEntry);
                break;
            }
            this.searchRequestCache.put(searchRequest.hashCode(), searchCacheEntry);
            DuplicateDetectionResult duplicateDetectionResult = this.duplicateDetector.detectDuplicates(new HashSet(searchResultItems));
            this.createOrUpdateIndexerSearchEnties(searchCacheEntry);
            if (searchRequest.getSource() == SearchSource.API) {
                int beforeDuplicateRemoval = searchResultItems.size();
                searchResultItems = this.getNewestSearchResultItemFromEachDuplicateGroup(duplicateDetectionResult.getDuplicateGroups());
                searchResult.setNumberOfRemovedDuplicates(searchResult.getNumberOfRemovedDuplicates() + (beforeDuplicateRemoval - searchResultItems.size()));
            }
            searchResult.setNumberOfFoundDuplicates(duplicateDetectionResult.getNumberOfDuplicates());
            searchCacheEntry.getReasonsForRejection().clear();
            for (IndexerSearchCacheEntry indexerSearchCacheEntry : searchCacheEntry.getIndexerCacheEntries().values()) {
                for (IndexerSearchResult indexerSearchResult : indexerSearchCacheEntry.getIndexerSearchResults()) {
                    for (Multiset.Entry rejectionEntry : indexerSearchResult.getReasonsForRejection().entrySet()) {
                        searchCacheEntry.getReasonsForRejection().add((Object)((String)rejectionEntry.getElement()), rejectionEntry.getCount());
                    }
                }
            }
            searchCacheEntry.setSearchResultItems(new ArrayList(searchResultItems));
        }
        searchResult.setNumberOfTotalAvailableResults(searchCacheEntry.getNumberOfTotalAvailableResults());
        searchResult.setIndexerSearchResults(searchCacheEntry.getIndexerCacheEntries().values().stream().filter(x -> !x.getIndexerSearchResults().isEmpty()).map(x -> (IndexerSearchResult)Iterables.getLast((Iterable)x.getIndexerSearchResults())).collect(Collectors.toList()));
        searchResult.setReasonsForRejection(searchCacheEntry.getReasonsForRejection());
        searchCacheEntry.setNumberOfRemovedDuplicates(searchResult.getNumberOfRemovedDuplicates());
        ArrayList<Object> searchResultItemsToReturn = new ArrayList<Object>(searchResultItems);
        searchResultItemsToReturn.sort(Comparator.comparingLong(x -> ((SearchResultItem)x).getBestDate().getEpochSecond()).reversed());
        this.spliceSearchResultItemsAccordingToOffsetAndLimit(searchRequest, searchResult, searchResultItemsToReturn);
        logger.debug(LoggingMarkers.PERFORMANCE, "Internal search took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return searchResult;
    }

    private List<IndexerSearchCacheEntry> getIndexersWithCachedResults(SearchCacheEntry searchCacheEntry) {
        List<IndexerSearchCacheEntry> indexerSearchCacheEntries = searchCacheEntry.getIndexerCacheEntries().values().stream().filter(IndexerSearchCacheEntry::isMoreResultsInCache).collect(Collectors.toList());
        return indexerSearchCacheEntries;
    }

    private void spliceSearchResultItemsAccordingToOffsetAndLimit(SearchRequest searchRequest, SearchResult searchResult, List<SearchResultItem> searchResultItems) {
        int offset = searchRequest.getOffset();
        int limit = searchRequest.getLimit();
        if (searchRequest.getSource() == SearchSource.INTERNAL && offset == 0 && this.configProvider.getBaseConfig().getSearching().isLoadAllCachedOnInternal()) {
            logger.debug("Will load all cached results");
            limit = searchResultItems.size();
        }
        if (searchRequest.isLoadAll()) {
            logger.info("Returning all available search results");
            searchResult.setSearchResultItems(searchResultItems);
            return;
        }
        if (offset > 0 && offset >= searchResultItems.size()) {
            logger.info("Offset {} exceeds the number of available results {}; returning empty search result", (Object)offset, (Object)searchResultItems.size());
            searchResult.setSearchResultItems(Collections.emptyList());
            return;
        }
        if (offset + limit > searchResultItems.size()) {
            logger.debug("Offset {} + limit {} exceeds the number of available results {}; returning all remaining results from cache", new Object[]{offset, limit, searchResultItems.size()});
            limit = searchResultItems.size() - offset;
        }
        if (limit != 0) {
            searchResult.setOffset(offset);
            searchResult.setLimit(limit);
            Object andRemoved = "";
            if (searchRequest.getSource() == SearchSource.API) {
                andRemoved = " and " + searchResult.getNumberOfRemovedDuplicates() + " were removed as duplicates";
            }
            logger.info("Returning results {}-{} from {} results in cache. A total of {} results is available from indexers of which {} were already rejected" + (String)andRemoved, new Object[]{offset + 1, offset + limit, searchResultItems.size(), searchResult.getNumberOfTotalAvailableResults(), searchResult.getNumberOfRejectedResults()});
            searchResult.setSearchResultItems(searchResultItems.subList(offset, offset + limit));
        }
    }

    protected List<SearchResultItem> getNewestSearchResultItemFromEachDuplicateGroup(List<LinkedHashSet<SearchResultItem>> duplicateGroups) {
        return duplicateGroups.stream().map(x -> (SearchResultItem)x.stream().sorted(Comparator.comparingInt(searchResultItem -> searchResultItem.getIndexerScore() == null ? 0 : searchResultItem.getIndexerScore()).reversed().thenComparing(Comparator.comparingLong(y -> y.getBestDate().getEpochSecond()).reversed())).iterator().next()).sorted(Comparator.comparingLong(x -> x.getBestDate().getEpochSecond()).reversed()).collect(Collectors.toList());
    }

    protected void createOrUpdateIndexerSearchEnties(SearchCacheEntry searchCacheEntry) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int countEntities = 0;
        for (IndexerSearchCacheEntry indexerSearchCacheEntry : searchCacheEntry.getIndexerCacheEntries().values()) {
            for (IndexerSearchResult indexerSearchResult : indexerSearchCacheEntry.getIndexerSearchResults()) {
                IndexerSearchEntity entity = indexerSearchCacheEntry.getIndexerSearchEntity();
                if (entity == null) {
                    entity = new IndexerSearchEntity();
                    entity.setIndexerEntity(indexerSearchResult.getIndexer().getIndexerEntity());
                    entity.setSearchEntity(searchCacheEntry.getSearchEntity());
                    entity.setResultsCount(Integer.valueOf(indexerSearchResult.getTotalResults()));
                    entity.setSuccessful(Boolean.valueOf(indexerSearchResult.isWasSuccessful()));
                    indexerSearchCacheEntry.setIndexerSearchEntity(entity);
                }
                IndexerSearchEntity finalEntity = entity;
                this.transactionTemplate.executeWithoutResult(status -> {
                    IndexerSearchEntity savedEntity = finalEntity;
                    if (this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
                        savedEntity = (IndexerSearchEntity)this.indexerSearchRepository.save((Object)finalEntity);
                        for (SearchResultEntity x : indexerSearchResult.getSearchResultEntities()) {
                            x.setIndexerSearchEntityId(Integer.valueOf(savedEntity.getId()));
                        }
                    }
                    this.searchResultRepository.saveAll((Iterable)indexerSearchResult.getSearchResultEntities());
                    ((IndexerSearchCacheEntry)searchCacheEntry.getIndexerCacheEntries().get(indexerSearchResult.getIndexer().getName())).setIndexerSearchEntity(savedEntity);
                });
                ++countEntities;
            }
        }
        logger.debug(LoggingMarkers.PERFORMANCE, "Saving {} indexer search entities took {}ms", (Object)countEntities, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    protected SearchCacheEntry getSearchCacheEntry(SearchRequest searchRequest) {
        SearchCacheEntry searchCacheEntry;
        if (searchRequest.getOffset() == 0 || !this.searchRequestCache.containsKey(searchRequest.hashCode())) {
            SearchEntity searchEntity = new SearchEntity();
            searchEntity.setSource(searchRequest.getSource());
            searchEntity.setCategoryName(searchRequest.getCategory().getName());
            searchEntity.setQuery((String)searchRequest.getQuery().orElse(null));
            searchEntity.setIdentifiers(searchRequest.getIdentifiers().entrySet().stream().filter(x -> x.getValue() != null).map(x -> new IdentifierKeyValuePair(((MediaIdType)x.getKey()).name(), (String)x.getValue())).collect(Collectors.toSet()));
            searchEntity.setSeason((Integer)searchRequest.getSeason().orElse(null));
            searchEntity.setEpisode((String)searchRequest.getEpisode().orElse(null));
            searchEntity.setSearchType(searchRequest.getSearchType());
            searchEntity.setTitle((String)searchRequest.getTitle().orElse(null));
            searchEntity.setAuthor((String)searchRequest.getAuthor().orElse(null));
            searchRequest.extractQueryAndForbiddenWords();
            if (this.configProvider.getBaseConfig().getMain().isKeepHistory()) {
                this.transactionTemplate.executeWithoutResult(status -> this.searchRepository.save((Object)searchEntity));
            }
            IndexerForSearchSelector.IndexerForSearchSelection pickingResult = this.indexerSelector.pickIndexers(searchRequest);
            searchCacheEntry = new SearchCacheEntry(searchRequest, pickingResult, searchEntity);
        } else {
            searchCacheEntry = (SearchCacheEntry)this.searchRequestCache.get(searchRequest.hashCode());
            searchCacheEntry.setLastAccessed(Instant.now());
            searchCacheEntry.setSearchRequest(searchRequest);
        }
        return searchCacheEntry;
    }

    protected List<IndexerSearchCacheEntry> getIndexersToSearch(SearchCacheEntry searchCacheEntry) {
        ArrayList<IndexerSearchCacheEntry> indexerSearchCacheEntries = new ArrayList<IndexerSearchCacheEntry>();
        for (Indexer selectedIndexer : searchCacheEntry.getIndexerSelectionResult().getSelectedIndexers()) {
            searchCacheEntry.getIndexerCacheEntries().putIfAbsent(selectedIndexer.getName(), new IndexerSearchCacheEntry(selectedIndexer));
        }
        for (IndexerSearchCacheEntry indexerSearchCacheEntry : searchCacheEntry.getIndexerCacheEntries().values()) {
            boolean cacheEmpty;
            int executedSearches = indexerSearchCacheEntry.getIndexerSearchResults().size();
            if (!searchCacheEntry.getSearchRequest().isLoadAll() && executedSearches >= 15) {
                logger.warn("Indexer {} executed {} queries without a load-all search. Will stop now", (Object)indexerSearchCacheEntry.getIndexer().getName(), (Object)executedSearches);
                continue;
            }
            if (indexerSearchCacheEntry.getIndexerSearchResults().isEmpty()) {
                indexerSearchCacheEntries.add(indexerSearchCacheEntry);
                continue;
            }
            boolean indexerHasMoreResults = indexerSearchCacheEntry.isMoreResultsAvailable();
            boolean lastRequestSuccessful = indexerSearchCacheEntry.isLastSuccessful();
            boolean bl = cacheEmpty = !indexerSearchCacheEntry.isMoreResultsInCache();
            if (!indexerHasMoreResults || !lastRequestSuccessful || !cacheEmpty) continue;
            indexerSearchCacheEntries.add(indexerSearchCacheEntry);
        }
        if (indexerSearchCacheEntries.isEmpty()) {
            logger.debug("All indexer caches exhausted");
        } else {
            String indexersToCall = indexerSearchCacheEntries.stream().map(x -> x.getIndexer().getName()).collect(Collectors.joining(", "));
            logger.debug("Going to call {} because their cache is exhausted", (Object)indexersToCall);
        }
        return indexerSearchCacheEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callSearchModules(SearchRequest searchRequest, List<IndexerSearchCacheEntry> indexersToSearch, SearchCacheEntry searchCacheEntry) {
        HashMap<Indexer, List> indexerSearchResults = new HashMap<Indexer, List>();
        for (IndexerSearchCacheEntry entry : indexersToSearch) {
            indexerSearchResults.put(entry.getIndexer(), entry.getIndexerSearchResults());
        }
        MdcThreadPoolExecutor executor = MdcThreadPoolExecutor.newWithInheritedMdc((int)indexersToSearch.size());
        this.executors.add(executor);
        List callables = this.getRegisteredCallables(searchRequest, indexersToSearch);
        try {
            ArrayList futures = new ArrayList();
            for (IndexerCallable indexerCallable : callables) {
                Future future = executor.submit(indexerCallable.callable());
                futures.add(future);
            }
            this.searchCallables.put(searchRequest.getSearchRequestId(), futures);
            for (Future future : futures) {
                try {
                    IndexerSearchResult indexerSearchResult = (IndexerSearchResult)future.get();
                    ((IndexerSearchCacheEntry)searchCacheEntry.getIndexerCacheEntries().get(indexerSearchResult.getIndexer().getName())).addIndexerSearchResult(indexerSearchResult);
                    indexerSearchResults.put(indexerSearchResult.getIndexer(), ((IndexerSearchCacheEntry)searchCacheEntry.getIndexerCacheEntries().get(indexerSearchResult.getIndexer().getName())).getIndexerSearchResults());
                }
                catch (ExecutionException e) {
                    logger.error("Unexpected error while searching", (Throwable)e);
                }
                catch (CancellationException e) {
                    logger.debug("Cancellation of call expected");
                    searchRequest.setShortcut(true);
                }
            }
        }
        catch (InterruptedException e) {
            logger.error("Unexpected error while searching", (Throwable)e);
        }
        finally {
            executor.shutdownNow();
            this.executors.remove(executor);
        }
        this.handleIndexersWithFailedFutureExecutions(indexersToSearch, indexerSearchResults);
    }

    public void shortcutSearch(Long searchRequestId) {
        for (Future x : (List)this.searchCallables.get(searchRequestId)) {
            x.cancel(true);
        }
    }

    private void handleIndexersWithFailedFutureExecutions(List<IndexerSearchCacheEntry> indexerSearchCacheEntries, Map<Indexer, List<IndexerSearchResult>> indexerSearchResults) {
        for (IndexerSearchCacheEntry toSearch : indexerSearchCacheEntries) {
            if (indexerSearchResults.containsKey(toSearch.getIndexer())) continue;
            IndexerSearchResult unknownFailureSearchResult = new IndexerSearchResult();
            unknownFailureSearchResult.setWasSuccessful(false);
            unknownFailureSearchResult.setHasMoreResults(false);
            unknownFailureSearchResult.setErrorMessage("Unexpected error. Please check the log.");
            List<IndexerSearchResult> previousIndexerSearchResults = indexerSearchResults.get(toSearch.getIndexer());
            previousIndexerSearchResults.add(unknownFailureSearchResult);
            indexerSearchResults.put(toSearch.getIndexer(), previousIndexerSearchResults);
        }
    }

    private List<IndexerCallable> getRegisteredCallables(SearchRequest searchRequest, List<IndexerSearchCacheEntry> indexersToSearch) {
        ArrayList<IndexerCallable> callables = new ArrayList<IndexerCallable>();
        for (IndexerSearchCacheEntry toSearch : indexersToSearch) {
            IndexerCallable callable = this.getIndexerCallable(searchRequest, toSearch);
            callables.add(callable);
        }
        return callables;
    }

    private IndexerCallable getIndexerCallable(SearchRequest searchRequest, IndexerSearchCacheEntry indexerSearchCacheEntry) {
        int offset;
        if (indexerSearchCacheEntry.getIndexerSearchResults().isEmpty()) {
            offset = 0;
        } else {
            IndexerSearchResult indexerToSearch = (IndexerSearchResult)Iterables.getLast((Iterable)indexerSearchCacheEntry.getIndexerSearchResults());
            offset = indexerToSearch.getOffset() + indexerToSearch.getPageSize();
        }
        int limit = LOAD_LIMIT_API;
        return new IndexerCallable(() -> indexerSearchCacheEntry.getIndexer().search(searchRequest, offset, Integer.valueOf(limit)), indexerSearchCacheEntry.getIndexer().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void onShutdown() {
        this.shutdownRequested = true;
        Set set = this.executors;
        synchronized (set) {
            if (!this.executors.isEmpty()) {
                logger.debug("Waiting up to 10 seconds for {} background tasks to finish", (Object)this.executors.size());
            }
            for (ExecutorService executorService : this.executors) {
                executorService.shutdown();
                try {
                    executorService.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    logger.warn("Waited too long for termination of task, interrupting");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

