/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching.dtoseventsenums;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
public class SearchResultItem {
    private boolean agePrecise;
    private Map<String, String> attributes = new HashMap();
    private Category category;
    private Integer commentsCount;
    private String commentsLink;
    private String cover;
    private String description;
    private String details;
    private DownloadType downloadType;
    private int duplicateIdentifier;
    private Integer files;
    private Instant firstFound;
    private Integer grabs;
    private String group = null;
    private Long guid;
    private HasNfo hasNfo = HasNfo.MAYBE;
    @NotNull
    private Indexer indexer;
    @NotNull
    private String indexerGuid;
    @NotNull
    private Integer indexerScore;
    @NotNull
    private String link;
    private String originalCategory;
    private boolean passworded;
    private Integer peers;
    private String poster;
    private Instant pubDate;
    private Long searchResultId;
    private Integer seeders;
    private Long size;
    private String source;
    @NotNull
    @NotEmpty
    private String title;
    private Instant usenetDate;

    public Optional<Instant> getUsenetDate() {
        return Optional.ofNullable(this.usenetDate);
    }

    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    public Optional<String> getPoster() {
        return Optional.ofNullable(this.poster);
    }

    public Optional<String> getCover() {
        return Optional.ofNullable(this.cover);
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this.source);
    }

    public long getAgeInDays() {
        return this.getBestDate().until(Instant.now(), ChronoUnit.DAYS);
    }

    public Instant getBestDate() {
        return this.getUsenetDate().orElse(this.getPubDate());
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public static Comparator<SearchResultItem> comparator() {
        return (o1, o2) -> {
            if (o2 == null) {
                return 1;
            }
            if (o2.pubDate == null && o1.pubDate != null) {
                return 1;
            }
            if (o1.pubDate == null && o2.pubDate != null) {
                return -1;
            }
            if (o1.pubDate == null) {
                return 0;
            }
            return o1.getBestDate().compareTo(o2.getBestDate());
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResultItem)) {
            return false;
        }
        SearchResultItem item = (SearchResultItem)o;
        return Objects.equal((Object)this.indexer, (Object)item.indexer) && Objects.equal((Object)this.indexerGuid, (Object)item.indexerGuid) && Objects.equal((Object)this.link, (Object)item.link) && Objects.equal((Object)this.title, (Object)item.title);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.indexer, this.indexerGuid, this.link, this.title});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexerName", (Object)this.indexer.getName()).add("guid", (Object)this.guid).add("title", (Object)this.title).add("pubDate", (Object)this.pubDate).add("size", (Object)this.size).toString();
    }

    @Generated
    public SearchResultItem() {
    }

    @Generated
    public boolean isAgePrecise() {
        return this.agePrecise;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public Integer getCommentsCount() {
        return this.commentsCount;
    }

    @Generated
    public String getCommentsLink() {
        return this.commentsLink;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDetails() {
        return this.details;
    }

    @Generated
    public DownloadType getDownloadType() {
        return this.downloadType;
    }

    @Generated
    public int getDuplicateIdentifier() {
        return this.duplicateIdentifier;
    }

    @Generated
    public Integer getFiles() {
        return this.files;
    }

    @Generated
    public Instant getFirstFound() {
        return this.firstFound;
    }

    @Generated
    public Integer getGrabs() {
        return this.grabs;
    }

    @Generated
    public Long getGuid() {
        return this.guid;
    }

    @Generated
    public HasNfo getHasNfo() {
        return this.hasNfo;
    }

    @Generated
    public Indexer getIndexer() {
        return this.indexer;
    }

    @Generated
    public String getIndexerGuid() {
        return this.indexerGuid;
    }

    @Generated
    public Integer getIndexerScore() {
        return this.indexerScore;
    }

    @Generated
    public String getLink() {
        return this.link;
    }

    @Generated
    public String getOriginalCategory() {
        return this.originalCategory;
    }

    @Generated
    public boolean isPassworded() {
        return this.passworded;
    }

    @Generated
    public Integer getPeers() {
        return this.peers;
    }

    @Generated
    public Instant getPubDate() {
        return this.pubDate;
    }

    @Generated
    public Long getSearchResultId() {
        return this.searchResultId;
    }

    @Generated
    public Integer getSeeders() {
        return this.seeders;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public void setAgePrecise(boolean agePrecise) {
        this.agePrecise = agePrecise;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setCommentsCount(Integer commentsCount) {
        this.commentsCount = commentsCount;
    }

    @Generated
    public void setCommentsLink(String commentsLink) {
        this.commentsLink = commentsLink;
    }

    @Generated
    public void setCover(String cover) {
        this.cover = cover;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDetails(String details) {
        this.details = details;
    }

    @Generated
    public void setDownloadType(DownloadType downloadType) {
        this.downloadType = downloadType;
    }

    @Generated
    public void setDuplicateIdentifier(int duplicateIdentifier) {
        this.duplicateIdentifier = duplicateIdentifier;
    }

    @Generated
    public void setFiles(Integer files) {
        this.files = files;
    }

    @Generated
    public void setFirstFound(Instant firstFound) {
        this.firstFound = firstFound;
    }

    @Generated
    public void setGrabs(Integer grabs) {
        this.grabs = grabs;
    }

    @Generated
    public void setGroup(String group) {
        this.group = group;
    }

    @Generated
    public void setGuid(Long guid) {
        this.guid = guid;
    }

    @Generated
    public void setHasNfo(HasNfo hasNfo) {
        this.hasNfo = hasNfo;
    }

    @Generated
    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    @Generated
    public void setIndexerGuid(String indexerGuid) {
        this.indexerGuid = indexerGuid;
    }

    @Generated
    public void setIndexerScore(Integer indexerScore) {
        this.indexerScore = indexerScore;
    }

    @Generated
    public void setLink(String link) {
        this.link = link;
    }

    @Generated
    public void setOriginalCategory(String originalCategory) {
        this.originalCategory = originalCategory;
    }

    @Generated
    public void setPassworded(boolean passworded) {
        this.passworded = passworded;
    }

    @Generated
    public void setPeers(Integer peers) {
        this.peers = peers;
    }

    @Generated
    public void setPoster(String poster) {
        this.poster = poster;
    }

    @Generated
    public void setPubDate(Instant pubDate) {
        this.pubDate = pubDate;
    }

    @Generated
    public void setSearchResultId(Long searchResultId) {
        this.searchResultId = searchResultId;
    }

    @Generated
    public void setSeeders(Integer seeders) {
        this.seeders = seeders;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setUsenetDate(Instant usenetDate) {
        this.usenetDate = usenetDate;
    }
}

