/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.searching.searchrequests;

import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.SearchingConfig;
import org.nzbhydra.config.category.Category;
import org.nzbhydra.config.mediainfo.MediaIdType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.mediainfo.Imdb;
import org.nzbhydra.mediainfo.InfoProvider;
import org.nzbhydra.mediainfo.MovieInfo;
import org.nzbhydra.mediainfo.TvInfo;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchRequestFactory {
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private InfoProvider infoProvider;

    public SearchRequest getSearchRequest(SearchType searchType, SearchSource source, Category category, long searchRequestId, Integer offset, Integer limit) {
        SearchingConfig searchingConfig = this.configProvider.getBaseConfig().getSearching();
        if (limit == null) {
            limit = source == SearchSource.INTERNAL ? searchingConfig.getLoadLimitInternal() : 100;
        }
        if (offset == null) {
            offset = 0;
        }
        SearchRequest searchRequest = new SearchRequest(source, searchType, offset, limit);
        searchRequest.setSource(source);
        searchRequest.setCategory(category);
        searchRequest.setSearchRequestId(searchRequestId);
        MDC.put((String)"SEARCH", (String)String.valueOf(searchRequestId));
        if (searchRequest.getMaxage().isEmpty() && searchingConfig.getMaxAge().isPresent()) {
            searchRequest.setMaxage((Integer)searchingConfig.getMaxAge().get());
        }
        return searchRequest;
    }

    public SearchRequest extendWithSavedIdentifiers(SearchRequest request) {
        if (!request.getIdentifiers().isEmpty()) {
            MovieInfo movieInfo;
            TvInfo tvInfo;
            if (request.getIdentifiers().keySet().stream().anyMatch(x -> InfoProvider.TV_ID_TYPES.contains(x)) && (tvInfo = this.infoProvider.findTvInfoInDatabase(request.getIdentifiers())) != null) {
                tvInfo.getTvmazeId().ifPresent(x -> request.getIdentifiers().putIfAbsent(MediaIdType.TVMAZE, x));
                tvInfo.getTvdbId().ifPresent(x -> request.getIdentifiers().putIfAbsent(MediaIdType.TVDB, x));
                tvInfo.getTvrageId().ifPresent(x -> request.getIdentifiers().putIfAbsent(MediaIdType.TVRAGE, x));
                tvInfo.getImdbId().ifPresent(x -> request.getIdentifiers().putIfAbsent(MediaIdType.TVIMDB, Imdb.withTt((String)x)));
            }
            if (request.getIdentifiers().keySet().stream().anyMatch(x -> InfoProvider.MOVIE_ID_TYPES.contains(x)) && (movieInfo = this.infoProvider.findMovieInfoInDatabase(request.getIdentifiers())) != null) {
                movieInfo.getTmdbId().ifPresent(x -> request.getIdentifiers().putIfAbsent(MediaIdType.TMDB, x));
                movieInfo.getImdbId().ifPresent(x -> request.getIdentifiers().putIfAbsent(MediaIdType.IMDB, Imdb.withTt((String)x)));
            }
        }
        return request;
    }
}

