/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.tasks;

import com.google.common.reflect.Invokable;
import jakarta.annotation.PreDestroy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.nzbhydra.ShutdownEvent;
import org.nzbhydra.tasks.HydraTask;
import org.nzbhydra.tasks.HydraTaskScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.stereotype.Component;

@Component
public class HydraTaskScheduler
implements BeanPostProcessor,
SmartInitializingSingleton {
    private static final Logger logger = LoggerFactory.getLogger(HydraTaskScheduler.class);
    @Autowired
    private ThreadPoolTaskScheduler scheduler;
    @Autowired
    private ConfigurableEnvironment environment;
    private final Map<String, TaskRuntimeInformation> runtimeInformationMap = new HashMap();
    private final ConcurrentMap<HydraTask, TaskInformation> taskInformations = new ConcurrentHashMap();
    private final Map<String, ScheduledFuture> taskSchedules = new HashMap();
    private boolean shutdownRequested;

    @EventListener
    public void handleShutdown(ShutdownEvent shutdownEvent) {
        this.onShutdown();
    }

    @PreDestroy
    public void onShutdown() {
        this.taskSchedules.values().forEach(x -> x.cancel(false));
        this.shutdownRequested = true;
        this.scheduler.shutdown();
    }

    public void afterSingletonsInstantiated() {
        this.scheduleTasks();
        this.scheduler.setWaitForTasksToCompleteOnShutdown(true);
        this.scheduler.setAwaitTerminationSeconds(5);
    }

    private void scheduleTasks() {
        for (TaskRuntimeInformation runtimeInformation : this.runtimeInformationMap.values()) {
            this.scheduleTask(runtimeInformation, true);
        }
    }

    private void scheduleTask(TaskRuntimeInformation runtimeInformation, boolean runNow) {
        HydraTask task = runtimeInformation.getMethod().getAnnotation(HydraTask.class);
        if (!this.taskSchedules.containsKey(task.name())) {
            logger.info("Scheduling task \"{}\" to be run every {}", (Object)task.name(), (Object)DurationFormatUtils.formatDurationWords((long)this.getIntervalForTask(task), (boolean)true, (boolean)true));
        }
        Runnable runnable = () -> {
            if (this.shutdownRequested) {
                return;
            }
            Thread.currentThread().setName("HT-" + task.name());
            new ScheduledMethodRunnable(runtimeInformation.getBean(), runtimeInformation.getMethod()).run();
        };
        if (runNow && !this.shutdownRequested) {
            this.scheduler.execute(runnable);
            this.scheduler.setRemoveOnCancelPolicy(true);
        }
        ScheduledFuture scheduledTask = this.scheduler.schedule(runnable, (Trigger)new /* Unavailable Anonymous Inner Class!! */);
        this.taskSchedules.put(task.name(), scheduledTask);
    }

    private long getIntervalForTask(HydraTask task) {
        String configuredInterval = this.environment.getProperty("hydraTasks." + task.configId());
        if (configuredInterval != null) {
            logger.debug("Using configured interval of {}ms instead of hardcoded {}ms for task \"{}\"", new Object[]{configuredInterval, task.interval(), task.name()});
            return Long.parseLong(configuredInterval);
        }
        return task.interval();
    }

    public List<TaskInformation> getTasks() {
        ArrayList<TaskInformation> information = new ArrayList<TaskInformation>(this.taskInformations.values());
        information.sort(Comparator.comparingLong(x -> x.nextExecutionTime.getEpochSecond()));
        return information;
    }

    public void runNow(String taskName) {
        logger.info("Running task \"{}\" now", (Object)taskName);
        ScheduledFuture scheduledFuture = (ScheduledFuture)this.taskSchedules.get(taskName);
        scheduledFuture.cancel(false);
        this.scheduleTask((TaskRuntimeInformation)this.runtimeInformationMap.get(taskName), true);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        for (Method method : targetClass.getMethods()) {
            HydraTask hydraTask = (HydraTask)Invokable.from((Method)method).getAnnotation(HydraTask.class);
            if (hydraTask == null) continue;
            this.runtimeInformationMap.put(hydraTask.name(), new TaskRuntimeInformation(bean, method));
        }
        return bean;
    }
}

