/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.update;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.Resources;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.nzbhydra.Jackson;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.backup.BackupAndRestore;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.debuginfos.DebugInfosProvider;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.mapping.SemanticVersion;
import org.nzbhydra.mapping.changelog.ChangelogChangeEntry;
import org.nzbhydra.mapping.changelog.ChangelogVersionEntry;
import org.nzbhydra.mapping.github.Asset;
import org.nzbhydra.mapping.github.Release;
import org.nzbhydra.notifications.UpdateNotificationEvent;
import org.nzbhydra.systemcontrol.SystemControl;
import org.nzbhydra.update.AutomaticUpdater;
import org.nzbhydra.update.UpdateData;
import org.nzbhydra.update.UpdateException;
import org.nzbhydra.update.UpdateManager;
import org.nzbhydra.webaccess.WebAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;

@Component
public class UpdateManager
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(UpdateManager.class);
    public static final String KEY = "UpdateData";
    public static final int CACHE_DURATION_MINUTES = 5;
    private static final Pattern GITHUB_ISSUE_PATTERN = Pattern.compile("#(\\d{3,})");
    private static final String DISABLE_UPDATE_PROPERTY = "NZBHYDRA_DISABLE_UPDATE";
    @Value(value="${nzbhydra.repositoryBaseUrl}")
    protected String repositoryBaseUrl;
    @Value(value="${nzbhydra.changelogUrl}")
    protected String changelogUrl;
    @Value(value="${nzbhydra.blockedVersionsUrl}")
    protected String blockedVersionsUrl;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private BackupAndRestore backupAndRestore;
    @Autowired
    protected WebAccess webAccess;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private GenericStorage genericStorage;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private SystemControl systemControl;
    @Value(value="${build.version:0.0.1}")
    protected String currentVersionString;
    protected SemanticVersion currentVersion;
    protected SemanticVersion latestVersion;
    private PackageInfo packageInfo;
    protected Supplier<List<Release>> releasesCache = Suppliers.memoizeWithExpiration((Supplier)this.getReleasesSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
    protected TypeReference<List<ChangelogVersionEntry>> changelogEntryListTypeReference = new /* Unavailable Anonymous Inner Class!! */;

    private void loadPackageInfo() {
        File packageFile = new File("/app/nzbhydra2/package_info");
        if (packageFile.exists()) {
            this.loadPackageInfoFile(packageFile);
        }
        if ((packageFile = new File("package_info")).exists()) {
            this.loadPackageInfoFile(packageFile);
        }
        if ((packageFile = new File("../package_info")).exists()) {
            this.loadPackageInfoFile(packageFile);
        }
    }

    private void loadPackageInfoFile(File lsioPackageFile) {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(lsioPackageFile);){
            properties.load(reader);
            this.packageInfo = new PackageInfo(properties.getProperty("ReleaseType"), properties.getProperty("PackageVersion"), properties.getProperty("PackageAuthor"));
        }
        catch (IOException e) {
            logger.error("Unable to read package info", (Throwable)e);
        }
    }

    private SemanticVersion getLatestVersion(boolean includePrerelease) throws UpdateException {
        Release latestRelease = this.getLatestRelease(includePrerelease);
        this.latestVersion = new SemanticVersion(latestRelease.getTagName());
        return this.latestVersion;
    }

    public UpdateInfo getUpdateInfo() throws UpdateException {
        SemanticVersion latestVersionWithBeta;
        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.setCurrentVersion(this.currentVersionString);
        boolean updateToPrereleases = this.configProvider.getBaseConfig().getMain().isUpdateToPrereleases();
        Release latestRelease = this.getLatestRelease(updateToPrereleases);
        SemanticVersion latestVersion = new SemanticVersion(latestRelease.getTagName());
        updateInfo.setLatestVersion(latestVersion.getAsString());
        updateInfo.setLatestVersionIsBeta(latestRelease.getPrerelease().booleanValue());
        boolean latestVersionIgnored = this.isVersionIgnored(latestVersion);
        boolean latestIsUpdateAndViable = latestVersion.isUpdateFor(this.currentVersion) && !latestVersionIgnored && this.isVersionNotBlocked(latestVersion);
        updateInfo.setUpdateAvailable(latestIsUpdateAndViable);
        updateInfo.setLatestVersionIgnored(latestVersionIgnored);
        updateInfo.setBetaVersionsEnabled(updateToPrereleases);
        if (!updateToPrereleases && (latestVersionWithBeta = new SemanticVersion(this.getLatestRelease(true).getTagName())).isUpdateFor(latestVersion)) {
            updateInfo.setBetaVersion(latestVersion.getAsString());
            boolean latestWithBetaIsUpdateAndViable = !this.isVersionIgnored(latestVersionWithBeta) && this.isVersionNotBlocked(latestVersionWithBeta);
            updateInfo.setBetaUpdateAvailable(latestWithBetaIsUpdateAndViable);
            updateInfo.setBetaVersion(latestVersionWithBeta.getAsString());
        }
        updateInfo.setPackageInfo(this.getPackageInfo());
        return updateInfo;
    }

    public boolean isUpdateAvailable() {
        try {
            return this.getUpdateInfo().isUpdateAvailable();
        }
        catch (UpdateException e) {
            logger.error("Error while checking if new version is available", (Throwable)e);
            return false;
        }
    }

    public boolean isUpdatedExternally() {
        return DebugInfosProvider.isRunInDocker() || Boolean.parseBoolean(System.getProperty(DISABLE_UPDATE_PROPERTY)) || Boolean.parseBoolean(System.getenv(DISABLE_UPDATE_PROPERTY));
    }

    private boolean isVersionIgnored(SemanticVersion version) throws UpdateException {
        Optional updateData = this.genericStorage.get(KEY, UpdateData.class);
        if (updateData.isPresent() && ((UpdateData)updateData.get()).getIgnoreVersions().contains(version)) {
            logger.debug("Version {} is in the list of ignored updates", (Object)version);
            return true;
        }
        return false;
    }

    private boolean isVersionNotBlocked(SemanticVersion version) throws UpdateException {
        if (this.getBlockedVersions().stream().anyMatch(x -> new SemanticVersion(x.getVersion()).equals((Object)version))) {
            logger.debug("Version {} is in the list of blocked updates", (Object)version);
            return false;
        }
        return true;
    }

    protected Supplier<List<Release>> getReleasesSupplier() {
        return () -> {
            try {
                return this.getReleases();
            }
            catch (UpdateException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public String getCurrentVersionString() {
        return this.currentVersionString;
    }

    public void ignore(String version) {
        SemanticVersion semanticVersion = new SemanticVersion(version);
        UpdateData updateData = this.genericStorage.get(KEY, UpdateData.class).orElse(new UpdateData());
        if (!updateData.getIgnoreVersions().contains(semanticVersion)) {
            updateData.getIgnoreVersions().add(semanticVersion);
        }
        this.genericStorage.save(KEY, (Serializable)updateData);
        logger.info("Version {} ignored. Will not show update notices for this version.", (Object)semanticVersion);
    }

    public List<ChangelogVersionEntry> getChangesBetweenCurrentVersionAnd(SemanticVersion upToVersion) throws UpdateException {
        List allChanges;
        try {
            String response = this.webAccess.callUrl(this.changelogUrl);
            allChanges = (List)Jackson.YAML_MAPPER.readValue(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new UpdateException("Error while getting changelog: " + e.getMessage());
        }
        List<ChangelogVersionEntry> collectedVersionChanges = allChanges.stream().filter(x -> {
            SemanticVersion changeVersion = new SemanticVersion(x.getVersion());
            return upToVersion.isSameOrNewer(changeVersion) && changeVersion.isUpdateFor(this.currentVersion);
        }).sorted(Comparator.reverseOrder()).toList();
        return collectedVersionChanges.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    public List<ChangelogVersionEntry> getAllVersionChangesUpToCurrentVersion() throws UpdateException {
        List changelogVersionEntries;
        try {
            String changelogYamlString = Resources.toString((URL)Resources.getResource(UpdateManager.class, (String)"/changelog.yaml"), (Charset)Charsets.UTF_8);
            changelogVersionEntries = (List)Jackson.YAML_MAPPER.readValue(changelogYamlString, this.changelogEntryListTypeReference);
        }
        catch (IOException e) {
            throw new UpdateException("Error while getting changelog: " + e.getMessage());
        }
        changelogVersionEntries.forEach(x -> x.getChanges().forEach(y -> y.setText(this.getGithubLinkedText(y))));
        Collections.sort(changelogVersionEntries);
        Collections.reverse(changelogVersionEntries);
        return changelogVersionEntries;
    }

    private String getGithubLinkedText(ChangelogChangeEntry entry) {
        Matcher matcher = GITHUB_ISSUE_PATTERN.matcher(entry.getText());
        if (matcher.find()) {
            Object link = "https://github.com/theotherp/nzbhydra2/issues/" + matcher.group(1);
            if (this.configProvider.getBaseConfig().getMain().getDereferer().isPresent()) {
                link = ((String)this.configProvider.getBaseConfig().getMain().getDereferer().get()).replace("$s", UrlEscapers.urlFragmentEscaper().escape((String)link).replace("$us", (CharSequence)link));
            }
            return entry.getText().replace(matcher.group(), "<a href=\"" + (String)link + "\" target=\"_blank\">" + matcher.group() + "</a>");
        }
        return entry.getText();
    }

    public List<ChangelogVersionEntry> getAutomaticUpdateVersionHistory() throws UpdateException {
        List changelogVersionEntries;
        Optional previousVersion = this.genericStorage.get(AutomaticUpdater.TO_NOTICE_KEY, String.class);
        if (previousVersion.isEmpty()) {
            logger.error("Unable to find the version from which the automatic update was installed");
            return Collections.emptyList();
        }
        try {
            String changelogJsonString = Resources.toString((URL)Resources.getResource(UpdateManager.class, (String)"/changelog.yaml"), (Charset)Charsets.UTF_8);
            changelogVersionEntries = (List)Jackson.YAML_MAPPER.readValue(changelogJsonString, this.changelogEntryListTypeReference);
        }
        catch (IOException e) {
            throw new UpdateException("Error while getting changelog: " + e.getMessage());
        }
        Collections.sort(changelogVersionEntries);
        Collections.reverse(changelogVersionEntries);
        SemanticVersion previousSemanticVersion = new SemanticVersion((String)previousVersion.get());
        return changelogVersionEntries.stream().filter(x -> x.getSemanticVersion().isUpdateFor(previousSemanticVersion)).collect(Collectors.toList());
    }

    public void installUpdate(String version, boolean isAutomaticUpdate) throws UpdateException {
        Optional<Release> optionalRelease = ((List)this.releasesCache.get()).stream().sorted(Comparator.comparing(x -> new SemanticVersion(((Release)x).getTagName())).reversed()).filter(x -> new SemanticVersion(x.getTagName()).isSame(new SemanticVersion(version))).findFirst();
        Release release = optionalRelease.orElseThrow(() -> new UpdateException("Unable to find release with version " + version));
        logger.info("Starting process to update to {}", (Object)release.getTagName());
        Asset asset = this.getAsset(release);
        String url = asset.getBrowserDownloadUrl();
        logger.debug("Downloading update from URL {}", (Object)url);
        try {
            File updateFolder = new File(NzbHydra.getDataFolder(), "update");
            if (!updateFolder.exists()) {
                logger.debug("Creating update folder {}", (Object)updateFolder);
                Files.createDirectory(updateFolder.toPath(), new FileAttribute[0]);
            } else {
                logger.debug("Cleaning update folder {}", (Object)updateFolder.getAbsolutePath());
                FileUtils.cleanDirectory((File)updateFolder);
            }
            File updateZip = new File(updateFolder, asset.getName());
            logger.debug("Saving update file as {}", (Object)updateZip.getAbsolutePath());
            this.applicationEventPublisher.publishEvent((Object)new UpdateEvent(UpdateEvent.State.DOWNLOADING, "Downloading update file."));
            this.webAccess.downloadToFile(url, updateZip);
        }
        catch (IOException | RestClientException e) {
            logger.error("Error while download or saving ZIP", e);
            throw new UpdateException("Error while downloading, saving or extracting update ZIP", e);
        }
        BaseConfig baseConfig = this.configProvider.getBaseConfig();
        if (baseConfig.getMain().isBackupBeforeUpdate()) {
            try {
                logger.info("Creating backup before shutting down");
                this.applicationEventPublisher.publishEvent((Object)new UpdateEvent(UpdateEvent.State.CREATING_BACKUP, "Creating backup before update."));
                this.backupAndRestore.backup(false);
            }
            catch (Exception e) {
                throw new UpdateException("Unable to create backup before update", (Throwable)e);
            }
        }
        if (isAutomaticUpdate) {
            this.genericStorage.save("automaticUpdateToNotice", (Serializable)((Object)this.getCurrentVersionString()));
        }
        logger.info("Shutting down to let wrapper execute the update");
        this.applicationEventPublisher.publishEvent((Object)new UpdateEvent(UpdateEvent.State.SHUTDOWN, "Shutting down to let wrapper execute update."));
        if (isAutomaticUpdate) {
            this.applicationEventPublisher.publishEvent((Object)new UpdateNotificationEvent(release.getName()));
        }
        this.systemControl.exitWithReturnCode(11);
    }

    protected Asset getAsset(Release latestRelease) throws UpdateException {
        boolean isCompiled;
        List assets = latestRelease.getAssets();
        if (assets.isEmpty()) {
            throw new UpdateException("No assets found for release " + latestRelease.getTagName());
        }
        String osName = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String sourceCodeLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        boolean bl = isCompiled = sourceCodeLocation.endsWith("core") || sourceCodeLocation.endsWith("core.exe");
        String assetToContain = !isCompiled ? "generic" : (osName.toLowerCase().contains("windows") ? "windows" : (arch.equals("amd64") ? "amd64" : "arm64"));
        logger.debug("Looking for asset that contains {}", (Object)assetToContain);
        Optional<Asset> optionalAsset = assets.stream().filter(x -> x.getName().toLowerCase().contains(assetToContain)).findFirst();
        if (optionalAsset.isEmpty()) {
            logger.error("Unable to find asset for platform {} in these assets: {}", (Object)assetToContain, (Object)assets.stream().map(Asset::getName).collect(Collectors.joining(", ")));
            throw new UpdateException("Unable to find asset for current platform " + assetToContain);
        }
        return optionalAsset.get();
    }

    private List<Release> getReleases() throws UpdateException {
        try {
            String url = this.repositoryBaseUrl + "/releases";
            logger.debug("Retrieving latest release from GitHub using URL {}", (Object)url);
            List releases = (List)this.webAccess.callUrl(url, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return releases;
        }
        catch (IOException e) {
            throw new UpdateException("Error while getting latest version: " + e.getMessage());
        }
    }

    private Release getLatestRelease(boolean includePrereleases) {
        return ((List)this.releasesCache.get()).stream().sorted(Comparator.comparing(x -> new SemanticVersion(((Release)x).getTagName())).reversed()).filter(release -> {
            if (includePrereleases) {
                return true;
            }
            return release.getPrerelease() == null || release.getPrerelease() == false;
        }).findFirst().orElse(null);
    }

    protected List<BlockedVersion> getBlockedVersions() throws UpdateException {
        List blockedVersions;
        logger.debug("Getting blocked versions from GitHub using URL {}", (Object)this.blockedVersionsUrl);
        try {
            String response = this.webAccess.callUrl(this.blockedVersionsUrl);
            blockedVersions = (List)Jackson.YAML_MAPPER.readValue(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new UpdateException("Error while getting blocked versions: " + e.getMessage());
        }
        return blockedVersions;
    }

    public void resetCache() {
        this.releasesCache = Suppliers.memoizeWithExpiration((Supplier)this.getReleasesSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
    }

    public void afterPropertiesSet() throws Exception {
        if (Objects.equals(this.currentVersionString, "@project.version@")) {
            this.currentVersionString = "1.0.0";
            logger.warn("Version string not found. Using 1.0.0");
        }
        this.currentVersion = new SemanticVersion(this.currentVersionString);
        this.loadPackageInfo();
        logger.info("Running version {}", (Object)this.currentVersionString);
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }
}

