/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.update;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.nzbhydra.ExceptionInfo;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.genericstorage.GenericStorage;
import org.nzbhydra.mapping.SemanticVersion;
import org.nzbhydra.mapping.changelog.ChangelogVersionEntry;
import org.nzbhydra.problemdetection.OutdatedWrapperDetector;
import org.nzbhydra.update.AutomaticUpdater;
import org.nzbhydra.update.UpdateException;
import org.nzbhydra.update.UpdateManager;
import org.nzbhydra.update.UpdatesWeb;
import org.nzbhydra.web.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UpdatesWeb {
    private static final Logger logger = LoggerFactory.getLogger(UpdatesWeb.class);
    private final List<String> updateMessages = new ArrayList();
    @Autowired
    private UpdateManager updateManager;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private OutdatedWrapperDetector outdatedWrapperDetector;
    @Autowired
    private GenericStorage genericStorage;
    protected Supplier<VersionsInfo> versionsInfoCache = Suppliers.memoizeWithExpiration((Supplier)this.versionsInfoSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/infos"}, method={RequestMethod.GET})
    public VersionsInfo getVersions() {
        if (Boolean.parseBoolean(this.environment.getProperty("alwayscheckforupdates", "false"))) {
            this.updateManager.resetCache();
            this.versionsInfoCache = Suppliers.memoizeWithExpiration((Supplier)this.versionsInfoSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
        }
        return (VersionsInfo)this.versionsInfoCache.get();
    }

    protected Supplier<VersionsInfo> versionsInfoSupplier() {
        return () -> {
            try {
                if (!this.configProvider.getBaseConfig().getMain().isUpdateCheckEnabled()) {
                    return new VersionsInfo();
                }
                UpdateManager.UpdateInfo updateInfo = this.updateManager.getUpdateInfo();
                return new VersionsInfo(updateInfo.getCurrentVersion(), updateInfo.getLatestVersion(), updateInfo.isLatestVersionIsBeta(), updateInfo.getBetaVersion(), updateInfo.isUpdateAvailable(), updateInfo.isBetaUpdateAvailable(), updateInfo.isLatestVersionIgnored(), updateInfo.isBetaVersionsEnabled(), this.updateManager.isUpdatedExternally(), this.configProvider.getBaseConfig().getMain().isShowUpdateBannerOnUpdatedExternally(), this.configProvider.getBaseConfig().getMain().isShowWhatsNewBanner(), this.outdatedWrapperDetector.isOutdatedWrapperDetected(), (String)this.genericStorage.get(AutomaticUpdater.TO_NOTICE_KEY, String.class).orElse(null), updateInfo.getPackageInfo());
            }
            catch (UpdateException e) {
                logger.error("An error occured while getting version information", (Throwable)e);
                throw new RuntimeException("Unable to get update information");
            }
        };
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/simpleInfos"}, method={RequestMethod.GET})
    public VersionsInfo getSimpleInfos() {
        VersionsInfo versionsInfo = new VersionsInfo();
        versionsInfo.setCurrentVersion(this.updateManager.getCurrentVersionString());
        versionsInfo.setPackageInfo(this.updateManager.getPackageInfo());
        return versionsInfo;
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/changesSince/{version:.+}"}, method={RequestMethod.GET})
    public List<ChangelogVersionEntry> getChangesSince(@PathVariable String version) throws Exception {
        return this.updateManager.getChangesBetweenCurrentVersionAnd(new SemanticVersion(version));
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/versionHistory"}, method={RequestMethod.GET})
    public List<ChangelogVersionEntry> getVersionHistory() throws Exception {
        return this.updateManager.getAllVersionChangesUpToCurrentVersion();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/automaticUpdateVersionHistory"}, method={RequestMethod.GET})
    public List<ChangelogVersionEntry> getVersionHistoryForAutomaticUpdate() throws Exception {
        return this.updateManager.getAutomaticUpdateVersionHistory();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/ackAutomaticUpdateVersionHistory"}, method={RequestMethod.GET})
    public void ackHistoryForAutomaticUpdateShown() {
        this.genericStorage.remove(AutomaticUpdater.TO_NOTICE_KEY);
        this.versionsInfoCache = Suppliers.memoizeWithExpiration((Supplier)this.versionsInfoSupplier(), (long)15L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/ignore/{version:.+}"}, method={RequestMethod.PUT}, consumes={"*/*"})
    public void ignore(@PathVariable String version) {
        this.updateManager.ignore(version);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/installUpdate/{version:.+}"}, method={RequestMethod.PUT})
    public GenericResponse installUpdate(@PathVariable String version) throws Exception {
        this.updateMessages.clear();
        this.updateManager.installUpdate(version, false);
        return new GenericResponse(true, null);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/messages"}, method={RequestMethod.GET})
    public List<String> getUpdateMessages() {
        return this.updateMessages;
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/isDisplayWrapperOutdated"}, method={RequestMethod.GET})
    public boolean isWrapperOutdated() {
        return this.outdatedWrapperDetector.isOutdatedWrapperDetected() && this.outdatedWrapperDetector.isOutdatedWrapperDetectedWarningNotYetShown();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/resetCache"}, method={RequestMethod.GET})
    public void resetCache() {
        this.updateManager.resetCache();
        this.versionsInfoCache = Suppliers.memoizeWithExpiration((Supplier)this.versionsInfoSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/updates/setOutdatedWrapperDetectedWarningShown"}, method={RequestMethod.PUT})
    public void setWrapperOutdatedWarningShown() {
        this.outdatedWrapperDetector.setOutdatedWrapperDetectedWarningShown();
    }

    @ExceptionHandler(value={UpdateException.class})
    protected ResponseEntity<ExceptionInfo> handleUpdateException(UpdateException ex) {
        String error = "An error occurred while updating or getting update infos: " + ex.getMessage();
        logger.error(error);
        return new ResponseEntity((Object)new ExceptionInfo(500, error, ((Object)((Object)ex)).getClass().getName(), error, (String)SessionStorage.requestUrl.get()), (HttpStatusCode)HttpStatus.valueOf((int)500));
    }

    @EventListener
    public void handleUpdateEvent(UpdateManager.UpdateEvent updateEvent) {
        this.updateMessages.add(updateEvent.getMessage());
    }
}

