/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.web;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.nzbhydra.web.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@Component
public class ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
    private static final Set<Class<? extends Exception>> EXCEPTIONS_LOG_WITHOUT_STACKTRACE = Sets.newHashSet((Object[])new Class[]{HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, MissingPathVariableException.class, MissingServletRequestParameterException.class, ServletRequestBindingException.class, ConversionNotSupportedException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, MethodArgumentNotValidException.class, MissingServletRequestPartException.class, BindException.class, NoHandlerFoundException.class, AsyncRequestTimeoutException.class});

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, MissingPathVariableException.class, MissingServletRequestParameterException.class, ServletRequestBindingException.class, IOException.class, ConversionNotSupportedException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, MethodArgumentNotValidException.class, MissingServletRequestPartException.class, BindException.class, NoHandlerFoundException.class, AsyncRequestTimeoutException.class})
    @ResponseBody
    public ResponseEntity<Object> handleConflict(Exception ex, HttpServletRequest request) {
        try {
            Object fullParametersString = "";
            String parametersString = "";
            if (!request.getParameterMap().isEmpty()) {
                parametersString = request.getParameterMap().entrySet().stream().map(arg_0 -> this.getFormattedEntry(arg_0)).collect(Collectors.joining(", "));
                fullParametersString = " and parameters " + parametersString;
            }
            String requestURI = request.getRequestURI();
            HttpStatus status = this.getStatusForException(ex);
            String message = "Unexpected error when client tried to access path " + requestURI + (String)fullParametersString + ". Error message: " + ex.getMessage();
            if (EXCEPTIONS_LOG_WITHOUT_STACKTRACE.contains(ex.getClass())) {
                logger.warn(message);
            } else if (!requestURI.contains("favicon")) {
                logger.warn("Unexpected error when client tried to access path {}{}", new Object[]{requestURI, fullParametersString, ex});
            }
            List mediaTypes = new ArrayList();
            try {
                mediaTypes = this.resolveMediaTypes(request);
            }
            catch (HttpMediaTypeNotAcceptableException e) {
                logger.error("Unable to parse Media Types of request", (Throwable)e);
            }
            Object bodyOfResponse = mediaTypes.contains(MediaType.APPLICATION_JSON) ? new JsonExceptionResponse(ExceptionUtils.getStackTrace((Throwable)ex), requestURI, parametersString, status.value(), ex.getMessage()) : message;
            return new ResponseEntity(bodyOfResponse, (MultiValueMap)new HttpHeaders(), (HttpStatusCode)status);
        }
        catch (Exception e) {
            logger.error("Error occurred while handling error (how ironic)", (Throwable)e);
            return ResponseEntity.internalServerError().body((Object)ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    protected String getFormattedEntry(Map.Entry<String, String[]> x) {
        return x.getKey() + "=" + (String)(x.getValue().length == 1 ? x.getValue()[0] : "[" + Joiner.on((String)", ").join((Object[])x.getValue()) + "]");
    }

    private HttpStatus getStatusForException(Exception ex) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        if (ex instanceof HttpRequestMethodNotSupportedException) {
            status = HttpStatus.METHOD_NOT_ALLOWED;
        } else if (ex instanceof HttpMediaTypeNotSupportedException) {
            status = HttpStatus.UNSUPPORTED_MEDIA_TYPE;
        } else if (ex instanceof HttpMediaTypeNotAcceptableException) {
            status = HttpStatus.NOT_ACCEPTABLE;
        } else if (ex instanceof MissingPathVariableException) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        } else if (ex instanceof MissingServletRequestParameterException) {
            status = HttpStatus.BAD_REQUEST;
        } else if (ex instanceof ServletRequestBindingException) {
            status = HttpStatus.BAD_REQUEST;
        } else if (ex instanceof ConversionNotSupportedException) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        } else if (ex instanceof TypeMismatchException) {
            status = HttpStatus.BAD_REQUEST;
        } else if (ex instanceof HttpMessageNotReadableException) {
            status = HttpStatus.BAD_REQUEST;
        } else if (ex instanceof HttpMessageNotWritableException) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        } else if (ex instanceof MethodArgumentNotValidException) {
            status = HttpStatus.BAD_REQUEST;
        } else if (ex instanceof MissingServletRequestPartException) {
            status = HttpStatus.BAD_REQUEST;
        } else if (ex instanceof BindException) {
            status = HttpStatus.BAD_REQUEST;
        } else if (ex instanceof NoHandlerFoundException) {
            status = HttpStatus.NOT_FOUND;
        } else if (ex instanceof AsyncRequestTimeoutException) {
            status = HttpStatus.SERVICE_UNAVAILABLE;
        }
        return status;
    }

    private List<MediaType> resolveMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        Enumeration headerValueArray = request.getHeaders("Accept");
        if (headerValueArray == null) {
            return Collections.emptyList();
        }
        ArrayList headerValues = Collections.list(headerValueArray);
        try {
            List mediaTypes = MediaType.parseMediaTypes(headerValues);
            MimeTypeUtils.sortBySpecificity((List)mediaTypes);
            return mediaTypes;
        }
        catch (InvalidMediaTypeException ex) {
            throw new HttpMediaTypeNotAcceptableException("Could not parse 'Accept' header " + String.valueOf(headerValues) + ": " + ex.getMessage());
        }
    }
}

