/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Instant;
import org.nzbhydra.misc.StackTraceFilter;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class HydraErrorController
extends AbstractErrorController
implements ErrorController {
    public HydraErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }

    @RequestMapping(value={"/error"})
    public ModelAndView handleError(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ModelAndView errorPage = new ModelAndView("error");
        errorPage.addObject("exception", (Object)StackTraceFilter.getFilteredStackTrace((Throwable)ex));
        errorPage.addObject("error", (Object)ex.getMessage());
        errorPage.addObject("status", (Object)response.getStatus());
        errorPage.addObject("timestamp", (Object)Instant.now().toString());
        return errorPage;
    }
}

