/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.web;

import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.misc.UserAgentMapper;
import org.nzbhydra.web.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class Interceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(Interceptor.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private UserAgentMapper userAgentMapper;
    private final Set<String> skipHostnameMappingFor = new HashSet();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SessionStorage.username.remove();
        SessionStorage.IP.remove();
        SessionStorage.originalIp.remove();
        SessionStorage.userAgent.remove();
        SessionStorage.requestUrl.remove();
        SessionStorage.outputType.remove();
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null) {
            ip = request.getHeader("X-Real-IP");
        }
        ip = ip != null ? ip.split(",")[0] : request.getRemoteAddr();
        if (this.configProvider.getBaseConfig().getMain().getLogging().isMapIpToHost()) {
            ip = this.getHostFromIp(ip).orElse(ip);
        }
        if (this.configProvider.getBaseConfig().getMain().getLogging().isLogIpAddresses()) {
            MDC.put((String)"IPADDRESS", (String)ip);
        }
        SessionStorage.IP.set(ip);
        if (request.getRemoteUser() != null) {
            SessionStorage.username.set(request.getRemoteUser());
        } else if (request.getParameter("username") != null) {
            SessionStorage.username.set(request.getParameter("username"));
        }
        if (this.configProvider.getBaseConfig().getMain().getLogging().isLogUsername() && !Strings.isNullOrEmpty((String)((String)SessionStorage.username.get()))) {
            MDC.put((String)"USERNAME", (String)((String)SessionStorage.username.get()));
        }
        SessionStorage.userAgent.set(this.userAgentMapper.getUserAgent(request.getHeader("User-Agent")));
        SessionStorage.requestUrl.set(request.getRequestURI());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> getHostFromIp(String ip) {
        if (this.skipHostnameMappingFor.contains(ip)) {
            return Optional.empty();
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> future = executor.submit(() -> {
            try {
                InetAddress inetAddress = InetAddress.getByName(ip);
                return inetAddress.getHostName();
            }
            catch (UnknownHostException e) {
                this.skipHostnameMappingFor.add(ip);
                return null;
            }
        });
        try {
            Optional<String> optional = Optional.of(future.get(500L, TimeUnit.MILLISECONDS));
            return optional;
        }
        catch (Exception ignored) {
            logger.debug("Cancelling mapping of IP to host after timeout");
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            executor.shutdownNow();
        }
    }
}

