/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.web;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.nzbhydra.debuginfos.DebugInfosProvider;
import org.nzbhydra.logging.LoggingMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class UrlCalculator {
    static final Logger logger = LoggerFactory.getLogger(UrlCalculator.class);
    private UriComponentsBuilder baseBuilder;
    @Value(value="${main.host}")
    private String serverAddress;
    @Value(value="${main.port}")
    private Integer serverPort;
    @Value(value="${main.urlBase}")
    private String serverContextPath;
    @Autowired
    private ConfigurableEnvironment environment;
    private final Map<HttpServletRequest, UriComponentsBuilder> builderCache = ExpiringMap.builder().maxSize(50).expirationPolicy(ExpirationPolicy.ACCESSED).expiration(1L, TimeUnit.MINUTES).entryLoader(request -> this.buildLocalBaseUriBuilder((HttpServletRequest)request)).build();

    public UriComponentsBuilder getRequestBasedUriBuilder() {
        return ((UriComponentsBuilder)this.builderCache.get(this.getCurrentRequest())).cloneBuilder();
    }

    protected HttpServletRequest getCurrentRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    protected UriComponentsBuilder buildLocalBaseUriBuilder(HttpServletRequest request) {
        String path;
        String host;
        String scheme;
        int port = -1;
        if (request.isSecure()) {
            logger.debug(LoggingMarkers.URL_CALCULATION, "Using scheme HTTPS because request is deemed secure");
            scheme = "https";
        } else if (Boolean.parseBoolean(this.environment.getProperty("server.ssl.enabled"))) {
            logger.debug(LoggingMarkers.URL_CALCULATION, "Using scheme HTTPS because header x-forwarded-proto is not set and built-in SSL is enabled");
            scheme = "https";
        } else {
            logger.debug(LoggingMarkers.URL_CALCULATION, "Using scheme HTTP because header x-forwarded-proto is not set and built-in SSL is disabled");
            scheme = "http";
        }
        String hostHeader = request.getHeader("host");
        if (hostHeader == null) {
            host = request.getServerName();
            logger.warn("Header host not set. Using {}. Please change your reverse proxy configuration. See https://github.com/theotherp/nzbhydra2/wiki/Exposing-Hydra-to-the-internet-and-using-reverse-proxies for more information", (Object)host);
        } else {
            String[] split = hostHeader.split(":");
            host = split[0];
            if (split.length > 1) {
                port = Integer.parseInt(split[1]);
                logger.debug(LoggingMarkers.URL_CALCULATION, "Using host {} and port {} from host header {}", new Object[]{host, port, hostHeader});
            } else {
                logger.debug(LoggingMarkers.URL_CALCULATION, "Using host {} from host header", (Object)hostHeader);
            }
        }
        if (port == -1) {
            port = request.getServerPort();
            logger.debug(LoggingMarkers.URL_CALCULATION, "Using port {} ", (Object)port);
        }
        if (!Strings.isNullOrEmpty((String)(path = request.getContextPath()))) {
            logger.debug(LoggingMarkers.URL_CALCULATION, "Using context path {} as path", (Object)path);
        } else {
            logger.debug(LoggingMarkers.URL_CALCULATION, "Not using any context path");
        }
        return UriComponentsBuilder.newInstance().scheme(scheme).host(host).port(port).path(path);
    }

    @JsonIgnore
    public UriComponentsBuilder getLocalBaseUriBuilder() {
        if (this.baseBuilder == null) {
            String urlBase;
            String host = this.serverAddress;
            logger.debug(LoggingMarkers.URL_CALCULATION, "Found configured host {}", (Object)host);
            if (host.equals("0.0.0.0")) {
                try {
                    logger.debug(LoggingMarkers.URL_CALCULATION, "Configured host 0.0.0.0 binds to all addresses. Attempting to find network address");
                    host = UrlCalculator.getLocalHostLANAddress().getHostAddress();
                    logger.debug(LoggingMarkers.URL_CALCULATION, "Found network address {}", (Object)host);
                }
                catch (UnknownHostException e) {
                    logger.warn("Unable to automatically determine host address. Error: {}", (Object)e.getMessage());
                }
            }
            if (Strings.isNullOrEmpty((String)host)) {
                logger.warn("Unable to determine host, will use 127.0.0.1");
                host = "127.0.0.1";
            }
            int port = this.serverPort;
            logger.debug(LoggingMarkers.URL_CALCULATION, "Using configured port {}", (Object)port);
            boolean isSsl = (Boolean)this.environment.getProperty("server.ssl.enabled", Boolean.class);
            this.baseBuilder = UriComponentsBuilder.newInstance().host(host).scheme(isSsl ? "https" : "http").port(port);
            logger.debug(LoggingMarkers.URL_CALCULATION, "Using scheme {}", (Object)(isSsl ? "https" : "http"));
            String string = urlBase = this.serverContextPath != null ? this.serverContextPath : "/";
            if (urlBase != null) {
                this.baseBuilder.path(urlBase);
                logger.debug(LoggingMarkers.URL_CALCULATION, "Using URL path {}", (Object)urlBase);
            }
            if (host.equals("::")) {
                logger.debug(LoggingMarkers.URL_CALCULATION, "Found configured host [::]. Using [::1] as host");
                this.baseBuilder = this.baseBuilder.host("[::1]");
            }
            if (DebugInfosProvider.isRunInDocker()) {
                logger.warn("The logged address is probably not correct as you're running docker. Use the host's IP and attached port");
            }
        }
        return this.baseBuilder.cloneBuilder();
    }

    protected static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            List<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(i -> Stream.of("VirtualBox", "Hyper-V", "Bluetooth", "Miniport").noneMatch(name -> i.getDisplayName() != null && i.getDisplayName().contains((CharSequence)name))).filter(i -> i.getInetAddresses().hasMoreElements()).filter(i -> !(i.getInetAddresses().nextElement() instanceof Inet6Address)).toList();
            for (NetworkInterface iface : networkInterfaces) {
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + String.valueOf(e));
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }
}

