/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.web;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import jakarta.servlet.Filter;
import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.api.stats.HistoryRequestConverter;
import org.nzbhydra.api.stats.StatsRequestConverter;
import org.nzbhydra.config.EmptyStringToNullDeserializer;
import org.nzbhydra.config.EmptyStringToNullSerializer;
import org.nzbhydra.web.Interceptor;
import org.nzbhydra.web.WebConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.CacheControl;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.resource.ResourceUrlProvider;

@Configuration(proxyBeanMethods=false)
public class WebConfiguration
extends WebMvcConfigurationSupport {
    @Autowired
    private Interceptor interceptor;
    private static final Logger logger = LoggerFactory.getLogger(WebConfiguration.class);

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String[] locations = new String[]{"classpath:/static/"};
        if (NzbHydra.getDataFolder() != null) {
            File staticFolderFile = new File(new File(NzbHydra.getDataFolder()), "static");
            try {
                if (staticFolderFile.exists()) {
                    String fileStatic = staticFolderFile.toURI().toURL().toString();
                    locations = new String[]{fileStatic};
                    logger.warn("Found folder {}. Will load UI resources from there instead", (Object)staticFolderFile.getAbsolutePath());
                } else {
                    logger.debug("Static resources folder {} does not exist - using baked in resources", (Object)staticFolderFile);
                }
            }
            catch (MalformedURLException e) {
                logger.error("Unable to build path for local static files");
            }
        }
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(locations).setCacheControl(CacheControl.noCache()).resourceChain(false);
        File additionalStatic = new File(NzbHydra.getDataFolder(), "additionalStatic");
        if (additionalStatic.exists()) {
            logger.warn("Files in the data/additionalStatic folder will be exposed");
        }
        registry.addResourceHandler(new String[]{"/additionalStatic/**"}).addResourceLocations(new String[]{additionalStatic.toURI().toURL().toString()}).setCacheControl(CacheControl.noCache()).resourceChain(false);
        registry.addResourceHandler(new String[]{"/favicon.*"}).addResourceLocations(new String[]{"classpath:/static/img/"}).setCacheControl(CacheControl.noCache()).resourceChain(false);
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/swagger-ui/4.10.3/"});
        registry.addResourceHandler(new String[]{"/bower_components/bootstrap-less/fonts/**"}).addResourceLocations(new String[]{"classpath:/static/fonts/"});
        registry.setOrder(0);
    }

    protected void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseTrailingSlashMatch(Boolean.valueOf(true));
    }

    protected void addCorsMappings(CorsRegistry registry) {
    }

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping(ContentNegotiationManager mvcContentNegotiationManager, FormattingConversionService mvcConversionService, ResourceUrlProvider mvcResourceUrlProvider) {
        RequestMappingHandlerMapping handler = super.requestMappingHandlerMapping(mvcContentNegotiationManager, mvcConversionService, mvcResourceUrlProvider);
        handler.setOrder(1);
        return handler;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        CharacterEncodingFilter characterEncodingFilter = new CharacterEncodingFilter();
        characterEncodingFilter.setForceEncoding(true);
        characterEncodingFilter.setEncoding("UTF-8");
        registrationBean.setFilter((Filter)characterEncodingFilter);
        return registrationBean;
    }

    protected void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.interceptor);
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new StatsRequestConverter());
        registry.addConverter((Converter)new HistoryRequestConverter());
    }

    @Bean
    public Jaxb2Marshaller marshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("jaxb.formatted.output", Boolean.TRUE);
        marshaller.setMarshallerProperties(map);
        marshaller.setPackagesToScan(new String[]{"org.nzbhydra"});
        return marshaller;
    }

    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter jacksonConverter = (MappingJackson2HttpMessageConverter)converter;
            jacksonConverter.setPrettyPrint(true);
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addDeserializer(String.class, (JsonDeserializer)new EmptyStringToNullDeserializer());
            simpleModule.addSerializer(String.class, (JsonSerializer)new EmptyStringToNullSerializer());
            jacksonConverter.getObjectMapper().registerModule((Module)simpleModule);
        }
        converters.add(0, (HttpMessageConverter<?>)new NewznabAndTorznabResponseNamespaceFixer(this.marshaller()));
    }
}

