/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.webaccess;

import jakarta.annotation.PostConstruct;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.tuple.Pair;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.MainConfig;
import org.nzbhydra.config.ProxyType;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.webaccess.HydraOkHttp3ClientHttpRequestFactory;
import org.nzbhydra.webaccess.OkHttp3ClientHttpRequest;
import org.nzbhydra.webaccess.Ssl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Primary
public class HydraOkHttp3ClientHttpRequestFactory
implements ClientHttpRequestFactory {
    @Value(value="${nzbhydra.connectionTimeout:10}")
    private int timeout;
    private static final Logger logger = LoggerFactory.getLogger(HydraOkHttp3ClientHttpRequestFactory.class);
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private Ssl ssl;
    private final ConnectionPool connectionPool = new ConnectionPool(10, 5L, TimeUnit.MINUTES);
    private HttpLoggingInterceptor httpLoggingInterceptor;
    private SocketFactory sockProxySocketFactory;
    private final Map<Pair<String, Integer>, OkHttpClient> clientCache = Collections.synchronizedMap(new HashMap());
    private static final IpAddressMatcher[] IP_PRIVATE_RANGES = new IpAddressMatcher[]{new IpAddressMatcher("127.0.0.0/8"), new IpAddressMatcher("10.0.0.0/8"), new IpAddressMatcher("172.16.0.0/12"), new IpAddressMatcher("192.168.0.0/16"), new IpAddressMatcher("::1/128"), new IpAddressMatcher("fc00::/7"), new IpAddressMatcher("fe80::/10")};

    @PostConstruct
    public void init() {
        MainConfig mainConfig = this.configProvider.getBaseConfig().getMain();
        this.sockProxySocketFactory = new SockProxySocketFactory(mainConfig.getProxyHost(), mainConfig.getProxyPort(), mainConfig.getProxyUsername(), mainConfig.getProxyPassword());
    }

    @EventListener
    public void handleConfigChangedEvent(ConfigChangedEvent event) {
        MainConfig mainConfig = event.getNewConfig().getMain();
        this.sockProxySocketFactory = new SockProxySocketFactory(mainConfig.getProxyHost(), mainConfig.getProxyPort(), mainConfig.getProxyUsername(), mainConfig.getProxyPassword());
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        return new OkHttp3ClientHttpRequest(this.getOkHttpClient(uri.getHost()), uri, httpMethod);
    }

    static Request buildRequest(HttpHeaders headers, byte[] content, URI uri, HttpMethod method) throws MalformedURLException {
        MediaType contentType = HydraOkHttp3ClientHttpRequestFactory.getContentType((HttpHeaders)headers);
        RequestBody body = content.length > 0 || okhttp3.internal.http.HttpMethod.requiresRequestBody((String)method.name()) ? RequestBody.create((MediaType)contentType, (byte[])content) : null;
        Request.Builder builder = new Request.Builder().url(uri.toURL()).method(method.name(), body);
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            for (String headerValue : (List)entry.getValue()) {
                builder.addHeader(headerName, headerValue);
            }
        }
        return builder.build();
    }

    private static MediaType getContentType(HttpHeaders headers) {
        String rawContentType = headers.getFirst("Content-Type");
        return StringUtils.hasText((String)rawContentType) ? MediaType.parse((String)rawContentType) : null;
    }

    protected OkHttpClient.Builder getOkHttpClientBuilder(String host) {
        OkHttpClient.Builder builder = this.getBaseBuilder();
        this.configureBuilderForSsl(builder, host);
        MainConfig main = this.configProvider.getBaseConfig().getMain();
        if (main.getProxyType() == ProxyType.NONE) {
            return builder;
        }
        if (this.isUriToBeIgnoredByProxy(host)) {
            logger.debug("Not using proxy for request to {}", (Object)host);
            return builder;
        }
        if (main.getProxyType() == ProxyType.SOCKS) {
            return builder.socketFactory(this.sockProxySocketFactory);
        }
        if (main.getProxyType() == ProxyType.HTTP) {
            builder = builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(main.getProxyHost(), main.getProxyPort())));
            if (main.getProxyUsername() != null) {
                builder = builder.proxyAuthenticator((route, response) -> {
                    if (response.request().header("Proxy-Authorization") != null) {
                        logger.warn("Authentication with proxy failed");
                        return null;
                    }
                    String credential = Credentials.basic((String)main.getProxyUsername(), (String)main.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
        return builder;
    }

    public OkHttpClient getOkHttpClient(String host) {
        return this.getOkHttpClient(host, null);
    }

    public OkHttpClient getOkHttpClient(String host, Integer timeout) {
        return this.clientCache.computeIfAbsent(Pair.of((Object)host, (Object)timeout), pair -> {
            OkHttpClient.Builder clientBuilder = this.getOkHttpClientBuilder(host);
            if (timeout == null) {
                return clientBuilder.build();
            }
            return clientBuilder.readTimeout((long)timeout.intValue(), TimeUnit.SECONDS).connectTimeout((long)timeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)timeout.intValue(), TimeUnit.SECONDS).build();
        });
    }

    void configureBuilderForSsl(OkHttpClient.Builder builder, String host) {
        Ssl.SslVerificationState verificationState = this.ssl.getVerificationStateForHost(host);
        SSLSocketFactory allTrustingSslSocketFactory = this.ssl.getAllTrustingSslSocketFactory();
        X509TrustManager allTrustingDefaultTrustManager = this.ssl.getAllTrustingDefaultTrustManager();
        if (verificationState == Ssl.SslVerificationState.ENABLED) {
            builder.sslSocketFactory(this.ssl.getDefaultSslSocketFactory(), this.ssl.getDefaultTrustManager());
        } else if (verificationState == Ssl.SslVerificationState.DISABLED_HOST) {
            builder.sslSocketFactory(allTrustingSslSocketFactory, allTrustingDefaultTrustManager).hostnameVerifier((hostname, session) -> {
                logger.debug(LoggingMarkers.HTTPS, "Not verifying host name {}", (Object)hostname);
                return true;
            });
        } else {
            builder.sslSocketFactory(allTrustingSslSocketFactory, allTrustingDefaultTrustManager);
        }
    }

    protected OkHttpClient.Builder getBaseBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder().connectionPool(this.connectionPool).readTimeout((long)this.timeout, TimeUnit.SECONDS);
        if (this.configProvider.getBaseConfig().getMain().getLogging().getMarkersToLog().contains(LoggingMarkers.HTTP.getName())) {
            try {
                if (this.httpLoggingInterceptor == null) {
                    HttpLoggingInterceptor.Logger httpLogger = message -> logger.debug(LoggingMarkers.HTTP, message);
                    this.httpLoggingInterceptor = new HttpLoggingInterceptor(httpLogger);
                    this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                    this.httpLoggingInterceptor.redactHeader("Authorization");
                    this.httpLoggingInterceptor.redactHeader("Cookie");
                }
                builder.addInterceptor((Interceptor)this.httpLoggingInterceptor);
            }
            catch (Exception e) {
                logger.error("Unable to log HTTP", (Throwable)e);
            }
        }
        return builder;
    }

    protected boolean isUriToBeIgnoredByProxy(String host) {
        MainConfig mainConfig = this.configProvider.getBaseConfig().getMain();
        if (mainConfig.isProxyIgnoreLocal() && this.isHostInLocalNetwork(host)) {
            return true;
        }
        if (mainConfig.getProxyIgnoreDomains() == null || mainConfig.getProxyIgnoreDomains().isEmpty()) {
            return false;
        }
        return mainConfig.getProxyIgnoreDomains().stream().anyMatch(x -> Ssl.isSameHost((String)x, (String)host));
    }

    private boolean isHostInLocalNetwork(String host) {
        if (host.equalsIgnoreCase("localhost")) {
            return true;
        }
        try {
            InetAddress byName = InetAddress.getByName(host);
            String ipAddress = byName.getHostAddress();
            return Arrays.stream(IP_PRIVATE_RANGES).anyMatch(matcher -> matcher.matches(ipAddress));
        }
        catch (UnknownHostException e) {
            logger.error("Error analyzing host {}", (Object)host, (Object)e);
            return false;
        }
    }

    public static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (byte octet : octets) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }
}

