-- Add ON DELETE CASCADE to foreign key constraints referencing INDEXER table
-- This ensures related data is automatically deleted when an indexer is removed

-- INDEXERAPIACCESS_SHORT: Drop existing constraint and recreate with CASCADE
ALTER TABLE INDEXERAPIACCESS_SHORT DROP CONSTRAINT IF EXISTS FKFLRMBYQ8CLDV48KDUNDZHD;
ALTER TABLE INDEXERAPIACCESS_SHORT ADD CONSTRAINT FKFLRMBYQ8CLDV48KDUNDZHD
    FOREIGN KEY (INDEXER_ID) REFERENCES INDEXER (ID) ON DELETE CASCADE;

-- INDEXERLIMIT: Drop existing constraint and recreate with CASCADE
ALTER TABLE INDEXERLIMIT DROP CONSTRAINT IF EXISTS DABCDLRMBYQ8CLDV48SWRYIY0YKD2;
ALTER TABLE INDEXERLIMIT ADD CONSTRAINT DABCDLRMBYQ8CLDV48SWRYIY0YKD2
    FOREIGN KEY (INDEXER_ID) REFERENCES INDEXER (ID) ON DELETE CASCADE;

-- INDEXERUNIQUENESSSCORE: Drop existing constraint and recreate with CASCADE
ALTER TABLE INDEXERUNIQUENESSSCORE DROP CONSTRAINT IF EXISTS MFKFLRMBYQ8CLDV48SWRYIY0YKD2;
ALTER TABLE INDEXERUNIQUENESSSCORE ADD CONSTRAINT MFKFLRMBYQ8CLDV48SWRYIY0YKD2
    FOREIGN KEY (INDEXER_ID) REFERENCES INDEXER (ID) ON DELETE CASCADE;
