import { s as store_get, u as unsubscribe_stores, b as bind_props, a as attr, c as attr_class, d as clsx, j as escape_html, e as ensure_array_like, l as rest_props, m as attributes, h as slot, k as sanitize_props, o as stringify, f as attr_style, q as await_block, n as head } from "./index.js";
import { v4 } from "uuid";
import { o as onDestroy, t as tick, g as goto } from "./client.js";
import { a as toast } from "./Toaster.svelte_svelte_type_style_lang.js";
import { Y as fallback, Z as getContext } from "./context.js";
import "clsx";
import { g as getCtx, a as generateId, s as styleToString, b as getCursorStyle, D as Drawer, P as Pane, c as Pane_group } from "./Drawer.js";
import { p as page } from "./stores.js";
import { A as AUDIO_API_BASE_URL, a as WEBUI_API_BASE_URL, W as WEBUI_BASE_URL } from "./constants.js";
import { g as tags, y as tools, z as toolServers, j as settings, m as models, c as config, u as user, A as temporaryChatEnabled, h as mobile, B as artifactContents, f as folders$1, a as chatId, i as showSidebar, C as banners, x as functions, D as showCallOverlay, T as TTSWorker, E as embed, F as showControls, G as showOverview, H as showArtifacts, I as showEmbeds, s as selectedFolder, e as chats, d as currentChatPage, k as socket, J as audioQueue, K as chatTitle, W as WEBUI_NAME, p as pinnedChats } from "./index2.js";
import { e as extractInputVariables, b as getUserPosition, d as getAge, f as getFormattedDate, h as getFormattedTime, i as getCurrentDateTime, j as getUserTimezone, k as getWeekday, l as convertHeicToJpeg, m as extractContentFromFile, n as compressImage, o as blobToFile, p as getTimeRange, s as sanitizeResponseContent, q as getCodeBlockContents, r as convertMessagesToHistory, c as createMessagesList, t as processDetails, u as getPromptVariables, v as getMessageContentParts, w as removeAllDetails, a as copyToClipboard, x as isYoutubeUrl } from "./index4.js";
import { h as getChatListByFolderId, i as getChatsByFolderId, d as getChatList, j as getChatById, n as getTagsById, o as createNewChat, p as updateChatById, l as getAllTags, u as updateChatFolderIdById, f as getPinnedChatList } from "./index5.js";
import { c as generateEmoji, d as getTaskIdsByChatId, e as generateOpenAIChatCompletion, s as stopTask, f as chatAction, h as generateMoACompletion, i as chatCompleted } from "./index6.js";
import { R as RichTextInput, F as FilesOverlay, p as processYoutubeVideo, a as processWeb } from "./RichTextInput.js";
import { u as updateUserSettings, b as getAndUpdateUserLocation } from "./Badge.js";
import { g as getUserValvesById, a as getUserValvesSpecById, b as getToolValvesById, c as getToolValvesSpecById, d as getTools } from "./index9.js";
import { u as uploadFile } from "./index10.js";
import { EventSourceParserStream } from "eventsource-parser/stream";
import { g as getUserValvesById$1, a as getUserValvesSpecById$1, b as getFunctionValvesById, c as getFunctionValvesSpecById, d as getFunctions } from "./index7.js";
import { S as Share, a as ShareChatModal, F as FolderModal, b as FolderMenu, u as updateFolderById, g as getFolderById } from "./FolderModal.js";
import "dompurify";
import { marked } from "marked";
import dayjs from "dayjs";
import "dayjs/locale/af.js";
import "dayjs/locale/am.js";
import "dayjs/locale/ar.js";
import "dayjs/locale/az.js";
import "dayjs/locale/be.js";
import "dayjs/locale/bg.js";
import "dayjs/locale/bi.js";
import "dayjs/locale/bm.js";
import "dayjs/locale/bn.js";
import "dayjs/locale/bo.js";
import "dayjs/locale/br.js";
import "dayjs/locale/bs.js";
import "dayjs/locale/ca.js";
import "dayjs/locale/cs.js";
import "dayjs/locale/cv.js";
import "dayjs/locale/cy.js";
import "dayjs/locale/da.js";
import "dayjs/locale/de.js";
import "dayjs/locale/dv.js";
import "dayjs/locale/el.js";
import "dayjs/locale/en.js";
import "dayjs/locale/eo.js";
import "dayjs/locale/es.js";
import "dayjs/locale/eu.js";
import "dayjs/locale/fa.js";
import "dayjs/locale/fi.js";
import "dayjs/locale/fo.js";
import "dayjs/locale/fr.js";
import "dayjs/locale/fy.js";
import "dayjs/locale/ga.js";
import "dayjs/locale/gd.js";
import "dayjs/locale/gl.js";
import "dayjs/locale/gu.js";
import "dayjs/locale/he.js";
import "dayjs/locale/hi.js";
import "dayjs/locale/hr.js";
import "dayjs/locale/ht.js";
import "dayjs/locale/hu.js";
import "dayjs/locale/id.js";
import "dayjs/locale/is.js";
import "dayjs/locale/it.js";
import "dayjs/locale/ja.js";
import "dayjs/locale/jv.js";
import "dayjs/locale/ka.js";
import "dayjs/locale/kk.js";
import "dayjs/locale/km.js";
import "dayjs/locale/kn.js";
import "dayjs/locale/ko.js";
import "dayjs/locale/ku.js";
import "dayjs/locale/ky.js";
import "dayjs/locale/lb.js";
import "dayjs/locale/lo.js";
import "dayjs/locale/lt.js";
import "dayjs/locale/lv.js";
import "dayjs/locale/me.js";
import "dayjs/locale/mi.js";
import "dayjs/locale/mk.js";
import "dayjs/locale/ml.js";
import "dayjs/locale/mn.js";
import "dayjs/locale/mr.js";
import "dayjs/locale/ms.js";
import "dayjs/locale/mt.js";
import "dayjs/locale/my.js";
import "dayjs/locale/nb.js";
import "dayjs/locale/ne.js";
import "dayjs/locale/nl.js";
import "dayjs/locale/nn.js";
import "dayjs/locale/pl.js";
import "dayjs/locale/pt.js";
import "dayjs/locale/ro.js";
import "dayjs/locale/ru.js";
import "dayjs/locale/rw.js";
import "dayjs/locale/sd.js";
import "dayjs/locale/se.js";
import "dayjs/locale/si.js";
import "dayjs/locale/sk.js";
import "dayjs/locale/sl.js";
import "dayjs/locale/sq.js";
import "dayjs/locale/sr.js";
import "dayjs/locale/ss.js";
import "dayjs/locale/sv.js";
import "dayjs/locale/sw.js";
import "dayjs/locale/ta.js";
import "dayjs/locale/te.js";
import "dayjs/locale/tet.js";
import "dayjs/locale/tg.js";
import "dayjs/locale/th.js";
import "dayjs/locale/tk.js";
import "dayjs/locale/tlh.js";
import "dayjs/locale/tr.js";
import "dayjs/locale/tzl.js";
import "dayjs/locale/tzm.js";
import "dayjs/locale/uk.js";
import "dayjs/locale/ur.js";
import "dayjs/locale/uz.js";
import "dayjs/locale/vi.js";
import "dayjs/locale/yo.js";
import "dayjs/locale/zh.js";
import "dayjs/locale/zh-tw.js";
import "dayjs/locale/et.js";
import "dayjs/locale/en-gb.js";
import duration from "dayjs/plugin/duration.js";
import relativeTime from "dayjs/plugin/relativeTime.js";
import { g as getSessionUser, M as Map$1, A as ArchiveBox, U as UserMenu, a as EmojiPicker, E as Emoji } from "./GarbageBin.js";
import "dequal";
import "./create.js";
/* empty css                                    */
import localizedFormat from "dayjs/plugin/localizedFormat.js";
import "./listDragHandlePlugin.js";
import { M as Modal, X as XMark } from "./Modal.js";
import { C as Collapsible } from "./Collapsible.js";
import "turndown";
import "@joplin/turndown-plugin-gfm";
import "@tiptap/starter-kit";
import "@tiptap/extension-table";
import "@tiptap/extension-list";
import "@tiptap/extensions";
import "@tiptap/extension-file-handler";
import "@tiptap/extension-typography";
import "@tiptap/extension-highlight";
import "@tiptap/extension-code-block-lowlight";
import "@tiptap/extension-mention";
/* empty css                */
import fileSaver from "file-saver";
import "panzoom";
/* empty css                                            */
import { S as Spinner } from "./Spinner.js";
import { S as Switch_1 } from "./Switch.js";
import { S as SensitiveInput } from "./SensitiveInput.js";
/* empty css                                          */
import { a as Suggestions, M as Messages } from "./Messages.js";
import { S as Selector } from "./Selector.js";
import { T as Tooltip } from "./Tooltip.js";
import { M as Menu_sub, a as Menu_sub_trigger, b as Menu_sub_content } from "./menu-sub-trigger.js";
import { M as Menu_content, f as flyAndScale, a as Menu_item } from "./menu-trigger.js";
import { D as Dropdown } from "./Dropdown.js";
import { a as Tags, T as Textarea } from "./Textarea.js";
import { C as Clipboard } from "./Clipboard.js";
import { F as Folder, a as FileItem, L as Loader } from "./FileItem.js";
/* empty css                                       */
/* empty css                                            */
import { D as Download, C as ChevronUp } from "./Download.js";
import "i18next";
import { B as Banner } from "./Banner.js";
import { S as Sidebar } from "./Sidebar.js";
import { E as EllipsisHorizontal } from "./EllipsisHorizontal.js";
import { P as Plus } from "./Plus.js";
import { S as SVGPanZoom, F as FullHeightIframe } from "./Markdown.js";
import { C as ConfirmDialog, h as html } from "./ConfirmDialog.js";
import { E as EyeSlash } from "./EyeSlash.js";
import { C as ChevronDown } from "./ChevronDown.js";
function Tags_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let chatId2 = fallback($$props["chatId"], "");
    let disabled = fallback($$props["disabled"], false);
    let tags$1 = [];
    Tags($$renderer2, {
      tags: tags$1,
      disabled,
      suggestionTags: store_get($$store_subs ??= {}, "$_tags", tags) ?? []
    });
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { chatId: chatId2, disabled });
  });
}
async function createOpenAITextStream(responseBody, splitLargeDeltas) {
  const eventStream = responseBody.pipeThrough(new TextDecoderStream()).pipeThrough(new EventSourceParserStream()).getReader();
  let iterator = openAIStreamToIterator(eventStream);
  if (splitLargeDeltas) {
    iterator = streamLargeDeltasAsRandomChunks(iterator);
  }
  return iterator;
}
async function* openAIStreamToIterator(reader) {
  while (true) {
    const { value, done } = await reader.read();
    if (done) {
      yield { done: true, value: "" };
      break;
    }
    if (!value) {
      continue;
    }
    const data = value.data;
    if (data.startsWith("[DONE]")) {
      yield { done: true, value: "" };
      break;
    }
    try {
      const parsedData = JSON.parse(data);
      /* @__PURE__ */ console.log(parsedData);
      if (parsedData.error) {
        yield { done: true, value: "", error: parsedData.error };
        break;
      }
      if (parsedData.sources) {
        yield { done: false, value: "", sources: parsedData.sources };
        continue;
      }
      if (parsedData.selected_model_id) {
        yield { done: false, value: "", selectedModelId: parsedData.selected_model_id };
        continue;
      }
      if (parsedData.usage) {
        yield { done: false, value: "", usage: parsedData.usage };
        continue;
      }
      yield {
        done: false,
        value: parsedData.choices?.[0]?.delta?.content ?? ""
      };
    } catch (e) {
    }
  }
}
async function* streamLargeDeltasAsRandomChunks(iterator) {
  for await (const textStreamUpdate of iterator) {
    if (textStreamUpdate.done) {
      yield textStreamUpdate;
      return;
    }
    if (textStreamUpdate.error) {
      yield textStreamUpdate;
      continue;
    }
    if (textStreamUpdate.sources) {
      yield textStreamUpdate;
      continue;
    }
    if (textStreamUpdate.selectedModelId) {
      yield textStreamUpdate;
      continue;
    }
    if (textStreamUpdate.usage) {
      yield textStreamUpdate;
      continue;
    }
    let content = textStreamUpdate.value;
    if (content.length < 5) {
      yield { done: false, value: content };
      continue;
    }
    while (content != "") {
      const chunkSize = Math.min(Math.floor(Math.random() * 3) + 1, content.length);
      const chunk = content.slice(0, chunkSize);
      yield { done: false, value: chunk };
      if (document?.visibilityState !== "hidden") {
        await sleep(5);
      }
      content = content.slice(chunkSize);
    }
  }
}
const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
const transcribeAudio = async (token2, file, language) => {
  const data = new FormData();
  data.append("file", file);
  if (language) {
    data.append("language", language);
  }
  let error = null;
  const res = await fetch(`${AUDIO_API_BASE_URL}/transcriptions`, {
    method: "POST",
    headers: {
      Accept: "application/json",
      authorization: `Bearer ${token2}`
    },
    body: data
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2.json();
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
const synthesizeOpenAISpeech = async (token2 = "", speaker = "alloy", text = "", model) => {
  let error = null;
  const res = await fetch(`${AUDIO_API_BASE_URL}/speech`, {
    method: "POST",
    headers: {
      Authorization: `Bearer ${token2}`,
      "Content-Type": "application/json"
    },
    body: JSON.stringify({
      input: text,
      voice: speaker,
      ...model
    })
  }).then(async (res2) => {
    if (!res2.ok) throw await res2.json();
    return res2;
  }).catch((err) => {
    error = err.detail;
    return null;
  });
  if (error) {
    throw error;
  }
  return res;
};
function Cube($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "2");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="m21 7.5-9-5.25L3 7.5m18 0-9 5.25m9-5.25v9l-9 5.25M3 7.5l9 5.25M3 7.5v9l9 5.25m0-9v9"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function AdvancedParams($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let onChange = fallback($$props["onChange"], () => {
    });
    let admin = fallback($$props["admin"], false);
    let custom = fallback($$props["custom"], false);
    const defaultParams = {
      // Advanced
      stream_response: null,
      // Set stream responses for this model individually
      stream_delta_chunk_size: null,
      // Set the chunk size for streaming responses
      function_calling: null,
      reasoning_tags: null,
      seed: null,
      stop: null,
      temperature: null,
      reasoning_effort: null,
      logit_bias: null,
      max_tokens: null,
      top_k: null,
      top_p: null,
      min_p: null,
      frequency_penalty: null,
      presence_penalty: null,
      mirostat: null,
      mirostat_eta: null,
      mirostat_tau: null,
      repeat_last_n: null,
      tfs_z: null,
      repeat_penalty: null,
      use_mmap: null,
      use_mlock: null,
      think: null,
      format: null,
      keep_alive: null,
      num_keep: null,
      num_ctx: null,
      num_batch: null,
      num_thread: null,
      num_gpu: null
    };
    let params = fallback($$props["params"], defaultParams);
    if (params) {
      onChange(params);
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="space-y-1 text-xs pb-safe-bottom"><div>`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("When enabled, the model will respond to each chat message in real-time, generating a response as soon as the user sends a message. This mode is useful for live chat applications, but may impact performance on slower hardware."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Stream Chat Response"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">`);
          if (params.stream_response === true) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("On"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            if (params.stream_response === false) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Off"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
            }
            $$renderer4.push(`<!--]-->`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div> `);
      if (admin) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div>`);
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("The stream delta chunk size for the model. Increasing the chunk size will make the model respond with larger pieces of text at once."),
          placement: "top-start",
          className: "inline-tooltip",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Stream Delta Chunk Size"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
            if ((params?.stream_delta_chunk_size ?? null) === null) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
            }
            $$renderer4.push(`<!--]--></button></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if ((params?.stream_delta_chunk_size ?? null) !== null) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="1" max="128" step="1"${attr("value", params.stream_delta_chunk_size)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.stream_delta_chunk_size)} type="number" class="bg-transparent text-center w-14" min="1" step="any"/></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div>`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Default mode works with a wider range of models by calling tools once before execution. Native mode leverages the model's built-in tool-calling capabilities, but requires the model to inherently support this feature."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Function Calling"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">`);
          if (params.function_calling === "native") {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Native"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t('Enable, disable, or customize the reasoning tags used by the model. "Enabled" uses default tags, "Disabled" turns off reasoning tags, and "Custom" lets you specify your own start and end tags.'),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Reasoning Tags"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.reasoning_tags ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            if ((params?.reasoning_tags ?? null) === true) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Enabled"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              if ((params?.reasoning_tags ?? null) === false) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Disabled"))}</span>`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]-->`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if (![true, false, null].includes(params?.reasoning_tags ?? null) && (params?.reasoning_tags ?? []).length === 2) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Start Tag"))}${attr("value", params.reasoning_tags[0])} autocomplete="off"/></div> <div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("End Tag"))}${attr("value", params.reasoning_tags[1])} autocomplete="off"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Sets the random number seed to use for generation. Setting this to a specific number will make the model generate the same text for the same prompt."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Seed"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.seed ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.seed ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="number"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter Seed"))}${attr("value", params.seed)} autocomplete="off" min="0"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Sets the stop sequences to use. When this pattern is encountered, the LLM will stop generating text and return. Multiple stop patterns may be set by specifying multiple separate stop parameters in a modelfile."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Stop Sequence"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.stop ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.stop ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter stop sequence"))}${attr("value", params.stop)} autocomplete="off"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("The temperature of the model. Increasing the temperature will make the model answer more creatively."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Temperature"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.temperature ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.temperature ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="2" step="0.05"${attr("value", params.temperature)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.temperature)} type="number" class="bg-transparent text-center w-14" min="0" max="2" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Constrains effort on reasoning for reasoning models. Only applicable to reasoning models from specific providers that support reasoning effort."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Reasoning Effort"))}</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.reasoning_effort ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.reasoning_effort ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter reasoning effort"))}${attr("value", params.reasoning_effort)} autocomplete="off"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Boosting or penalizing specific tokens for constrained responses. Bias values will be clamped between -100 and 100 (inclusive). (Default: none)"),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">logit_bias</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.logit_bias ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.logit_bias ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input class="text-sm w-full bg-transparent outline-hidden outline-none" type="text"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t('Enter comma-separated "token:bias_value" pairs (example: 5432:100, 413:-100)'))}${attr("value", params.logit_bias)} autocomplete="off"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("This option sets the maximum number of tokens the model can generate in its response. Increasing this limit allows the model to provide longer answers, but it may also increase the likelihood of unhelpful or irrelevant content being generated."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">max_tokens</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.max_tokens ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.max_tokens ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-2" max="131072" step="1"${attr("value", params.max_tokens)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.max_tokens)} type="number" class="bg-transparent text-center w-14" min="-2" step="1"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Reduces the probability of generating nonsense. A higher value (e.g. 100) will give more diverse answers, while a lower value (e.g. 10) will be more conservative."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">top_k</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.top_k ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.top_k ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="1000" step="0.5"${attr("value", params.top_k)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.top_k)} type="number" class="bg-transparent text-center w-14" min="0" max="100" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Works together with top-k. A higher value (e.g., 0.95) will lead to more diverse text, while a lower value (e.g., 0.5) will generate more focused and conservative text."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">top_p</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.top_p ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.top_p ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="1" step="0.05"${attr("value", params.top_p)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.top_p)} type="number" class="bg-transparent text-center w-14" min="0" max="1" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Alternative to the top_p, and aims to ensure a balance of quality and variety. The parameter p represents the minimum probability for a token to be considered, relative to the probability of the most likely token. For example, with p=0.05 and the most likely token having a probability of 0.9, logits with a value less than 0.045 are filtered out."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">min_p</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.min_p ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.min_p ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="1" step="0.05"${attr("value", params.min_p)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.min_p)} type="number" class="bg-transparent text-center w-14" min="0" max="1" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Sets a scaling bias against tokens to penalize repetitions, based on how many times they have appeared. A higher value (e.g., 1.5) will penalize repetitions more strongly, while a lower value (e.g., 0.9) will be more lenient. At 0, it is disabled."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">frequency_penalty</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.frequency_penalty ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.frequency_penalty ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-2" max="2" step="0.05"${attr("value", params.frequency_penalty)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.frequency_penalty)} type="number" class="bg-transparent text-center w-14" min="-2" max="2" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Sets a flat bias against tokens that have appeared at least once. A higher value (e.g., 1.5) will penalize repetitions more strongly, while a lower value (e.g., 0.9) will be more lenient. At 0, it is disabled."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">presence_penalty</div> <button class="p-1 px-3 text-xs flex rounded transition flex-shrink-0 outline-none" type="button">`);
          if ((params?.presence_penalty ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.presence_penalty ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-2" max="2" step="0.05"${attr("value", params.presence_penalty)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.presence_penalty)} type="number" class="bg-transparent text-center w-14" min="-2" max="2" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Enable Mirostat sampling for controlling perplexity."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">mirostat</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.mirostat ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.mirostat ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="2" step="1"${attr("value", params.mirostat)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.mirostat)} type="number" class="bg-transparent text-center w-14" min="0" max="2" step="1"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Influences how quickly the algorithm responds to feedback from the generated text. A lower learning rate will result in slower adjustments, while a higher learning rate will make the algorithm more responsive."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">mirostat_eta</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.mirostat_eta ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.mirostat_eta ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="1" step="0.05"${attr("value", params.mirostat_eta)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.mirostat_eta)} type="number" class="bg-transparent text-center w-14" min="0" max="1" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Controls the balance between coherence and diversity of the output. A lower value will result in more focused and coherent text."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">mirostat_tau</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.mirostat_tau ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.mirostat_tau ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="10" step="0.5"${attr("value", params.mirostat_tau)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.mirostat_tau)} type="number" class="bg-transparent text-center w-14" min="0" max="10" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Sets how far back for the model to look back to prevent repetition."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">repeat_last_n</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.repeat_last_n ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.repeat_last_n ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-1" max="128" step="1"${attr("value", params.repeat_last_n)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.repeat_last_n)} type="number" class="bg-transparent text-center w-14" min="-1" max="128" step="1"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Tail free sampling is used to reduce the impact of less probable tokens from the output. A higher value (e.g., 2.0) will reduce the impact more, while a value of 1.0 disables this setting."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">tfs_z</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.tfs_z ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.tfs_z ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="2" step="0.05"${attr("value", params.tfs_z)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.tfs_z)} type="number" class="bg-transparent text-center w-14" min="0" max="2" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Control the repetition of token sequences in the generated text. A higher value (e.g., 1.5) will penalize repetitions more strongly, while a lower value (e.g., 1.1) will be more lenient. At 1, it is disabled."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">repeat_penalty</div> <button class="p-1 px-3 text-xs flex rounded transition flex-shrink-0 outline-none" type="button">`);
          if ((params?.repeat_penalty ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.repeat_penalty ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-2" max="2" step="0.05"${attr("value", params.repeat_penalty)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.repeat_penalty)} type="number" class="bg-transparent text-center w-14" min="-2" max="2" step="any"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> `);
      if (admin) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="py-0.5 w-full justify-between">`);
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Enable Memory Mapping (mmap) to load model data. This option allows the system to use disk storage as an extension of RAM by treating disk files as if they were in RAM. This can improve model performance by allowing for faster data access. However, it may not work correctly with all systems and can consume a significant amount of disk space."),
          placement: "top-start",
          className: "inline-tooltip",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">use_mmap</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
            if ((params?.use_mmap ?? null) === null) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
            }
            $$renderer4.push(`<!--]--></button></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if ((params?.use_mmap ?? null) !== null) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex justify-between items-center mt-1"><div class="text-xs text-gray-500">${escape_html(params.use_mmap ? store_get($$store_subs ??= {}, "$i18n", i18n).t("Enabled") : store_get($$store_subs ??= {}, "$i18n", i18n).t("Disabled"))}</div> <div class="pr-2">`);
          Switch_1($$renderer3, {
            get state() {
              return params.use_mmap;
            },
            set state($$value) {
              params.use_mmap = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!----></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Enable Memory Locking (mlock) to prevent model data from being swapped out of RAM. This option locks the model's working set of pages into RAM, ensuring that they will not be swapped out to disk. This can help maintain performance by avoiding page faults and ensuring fast data access."),
          placement: "top-start",
          className: "inline-tooltip",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">use_mlock</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
            if ((params?.use_mlock ?? null) === null) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
            }
            $$renderer4.push(`<!--]--></button></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if ((params?.use_mlock ?? null) !== null) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex justify-between items-center mt-1"><div class="text-xs text-gray-500">${escape_html(params.use_mlock ? store_get($$store_subs ??= {}, "$i18n", i18n).t("Enabled") : store_get($$store_subs ??= {}, "$i18n", i18n).t("Disabled"))}</div> <div class="pr-2">`);
          Switch_1($$renderer3, {
            get state() {
              return params.use_mlock;
            },
            set state($$value) {
              params.use_mlock = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!----></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("This option enables or disables the use of the reasoning feature in Ollama, which allows the model to think before generating a response. When enabled, the model can take a moment to process the conversation context and generate a more thoughtful response."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">think (${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">`);
          if (params.think === true) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("On"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            if (params.think === false) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Off"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
            }
            $$renderer4.push(`<!--]-->`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("The format to return a response in. Format can be json or a JSON schema."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">format (${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">`);
          if ((params?.format ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("JSON"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.format ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2">`);
        Textarea($$renderer3, {
          className: "w-full  text-sm bg-transparent outline-hidden",
          placeholder: store_get($$store_subs ??= {}, "$i18n", i18n).t('e.g. "json" or a JSON schema'),
          get value() {
            return params.format;
          },
          set value($$value) {
            params.format = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("This option controls how many tokens are preserved when refreshing the context. For example, if set to 2, the last 2 tokens of the conversation context will be retained. Preserving context can help maintain the continuity of a conversation, but it may reduce the ability to respond to new topics."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">num_keep (${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.num_keep ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.num_keep ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-1" max="10240000" step="1"${attr("value", params.num_keep)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.num_keep)} type="number" class="bg-transparent text-center w-14" min="-1" step="1"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Sets the size of the context window used to generate the next token."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">num_ctx (${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.num_ctx ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.num_ctx ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="-1" max="10240000" step="1"${attr("value", params.num_ctx)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.num_ctx)} type="number" class="bg-transparent text-center w-14" min="-1" step="1"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
      Tooltip($$renderer3, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("The batch size determines how many text requests are processed together at once. A higher batch size can increase the performance and speed of the model, but it also requires more memory."),
        placement: "top-start",
        className: "inline-tooltip",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">num_batch (${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
          if ((params?.num_batch ?? null) === null) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer4.push(`<!--]--></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if ((params?.num_batch ?? null) !== null) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="256" max="8192" step="256"${attr("value", params.num_batch)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.num_batch)} type="number" class="bg-transparent text-center w-14" min="256" step="256"/></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> `);
      if (admin) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="py-0.5 w-full justify-between">`);
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Set the number of worker threads used for computation. This option controls how many threads are used to process incoming requests concurrently. Increasing this value can improve performance under high concurrency workloads but may also consume more CPU resources."),
          placement: "top-start",
          className: "inline-tooltip",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">num_thread (${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
            if ((params?.num_thread ?? null) === null) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
            }
            $$renderer4.push(`<!--]--></button></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if ((params?.num_thread ?? null) !== null) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="1" max="256" step="1"${attr("value", params.num_thread)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.num_thread)} type="number" class="bg-transparent text-center w-14" min="1" max="256" step="1"/></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Set the number of layers, which will be off-loaded to GPU. Increasing this value can significantly improve performance for models that are optimized for GPU acceleration but may also consume more power and GPU resources."),
          placement: "top-start",
          className: "inline-tooltip",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="flex w-full justify-between"><div class="self-center text-xs font-medium">num_gpu (${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">`);
            if ((params?.num_gpu ?? null) === null) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
            }
            $$renderer4.push(`<!--]--></button></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if ((params?.num_gpu ?? null) !== null) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><div class="flex-1"><input id="steps-range" type="range" min="0" max="256" step="1"${attr("value", params.num_gpu)} class="w-full h-2 rounded-lg appearance-none cursor-pointer dark:bg-gray-700"/></div> <div><input${attr("value", params.num_gpu)} type="number" class="bg-transparent text-center w-14" min="0" max="256" step="1"/></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div> <div class="py-0.5 w-full justify-between">`);
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("This option controls how long the model will stay loaded into memory following the request (default: 5m)"),
          placement: "top-start",
          className: "inline-tooltip",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="py-0.5 flex w-full justify-between"><div class="self-center text-xs font-medium">keep_alive (${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Ollama"))})</div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">`);
            if ((params?.keep_alive ?? null) === null) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}</span>`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
            }
            $$renderer4.push(`<!--]--></button></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if ((params?.keep_alive ?? null) !== null) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex mt-0.5 space-x-2"><input class="w-full text-sm bg-transparent outline-hidden" type="text"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("e.g. '30s','10m'. Valid time units are 's', 'm', 'h'."))}${attr("value", params.keep_alive)}/></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div> `);
        if (custom && admin) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex flex-col justify-center"><!--[-->`);
          const each_array = ensure_array_like(Object.keys(params?.custom_params ?? {}));
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let key = each_array[$$index];
            $$renderer3.push(`<div class="py-0.5 w-full justify-between mb-1"><div class="flex w-full justify-between"><div class="self-center text-xs font-medium"><input type="text" class="text-xs w-full bg-transparent outline-none"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom Parameter Name"))}${attr("value", key)}/></div> <button class="p-1 px-3 text-xs flex rounded-sm transition shrink-0 outline-hidden" type="button">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Remove"))}</button></div> <div class="flex mt-0.5 space-x-2"><div class="flex-1"><input${attr("value", params.custom_params[key])} type="text" class="text-sm w-full bg-transparent outline-hidden outline-none"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom Parameter Value"))}/></div></div></div>`);
          }
          $$renderer3.push(`<!--]--> <button class="flex gap-2 items-center w-full text-center justify-center mt-1 mb-5" type="button"><div>`);
          Plus($$renderer3, {});
          $$renderer3.push(`<!----></div> <div>${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Add Custom Parameter"))}</div></button></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { onChange, admin, custom, params });
  });
}
function Pane_resizer($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "disabled",
    "onDraggingChange",
    "tabIndex",
    "el",
    "id",
    "style"
  ]);
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let isDragging, style, attrs;
    let disabled = fallback($$props["disabled"], false);
    let onDraggingChange = fallback($$props["onDraggingChange"], () => void 0, true);
    let tabIndex = fallback($$props["tabIndex"], 0);
    let el = fallback($$props["el"], null);
    let idFromProps = fallback($$props["id"], () => void 0, true);
    let styleFromProps = fallback($$props["style"], () => void 0, true);
    const {
      methods: { registerResizeHandle, startDragging, stopDragging },
      states: { direction, dragState, groupId }
    } = getCtx("PaneResizer");
    const resizeHandleId = generateId(idFromProps);
    isDragging = store_get($$store_subs ??= {}, "$dragState", dragState)?.dragHandleId === resizeHandleId;
    if (disabled) ;
    else {
      registerResizeHandle(resizeHandleId);
    }
    style = styleToString({
      cursor: getCursorStyle(store_get($$store_subs ??= {}, "$direction", direction)),
      "touch-action": "none",
      "user-select": "none",
      "-webkit-user-select": "none",
      "-webkit-touch-callout": "none"
    }) + styleFromProps;
    attrs = {
      "data-direction": store_get($$store_subs ??= {}, "$direction", direction),
      "data-pane-group-id": store_get($$store_subs ??= {}, "$groupId", groupId),
      "data-active": isDragging ? "pointer" : void 0,
      "data-enabled": !disabled,
      "data-pane-resizer-id": resizeHandleId,
      "data-pane-resizer": ""
    };
    $$renderer2.push(`<div${attributes({
      role: "separator",
      style,
      tabindex: tabIndex,
      ...attrs,
      ...$$restProps
    })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      disabled,
      onDraggingChange,
      tabIndex,
      el,
      id: idFromProps,
      style: styleFromProps
    });
  });
}
function ToolServersModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let show = fallback($$props["show"], false);
    let selectedToolIds = fallback($$props["selectedToolIds"], () => [], true);
    let selectedTools = [];
    const i18n = getContext("i18n");
    selectedTools = (store_get($$store_subs ??= {}, "$tools", tools) ?? []).filter((tool) => selectedToolIds.includes(tool.id));
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        size: "md",
        get show() {
          return show;
        },
        set show($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-0.5"><div class="text-lg font-medium self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Available Tools"))}</div> <button class="self-center">`);
          XMark($$renderer4, { className: "size-5" });
          $$renderer4.push(`<!----></button></div> `);
          if (selectedTools.length > 0) {
            $$renderer4.push("<!--[-->");
            if (store_get($$store_subs ??= {}, "$toolServers", toolServers).length > 0) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="flex justify-between dark:text-gray-300 px-5 pb-1"><div class="text-base font-medium self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Tools"))}</div></div>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> <div class="px-5 pb-3 w-full flex flex-col justify-center"><div class="text-sm dark:text-gray-300 mb-1"><!--[-->`);
            const each_array = ensure_array_like(selectedTools);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let tool = each_array[$$index];
              Collapsible($$renderer4, {
                buttonClassName: "w-full mb-0.5",
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="truncate"><div class="text-sm font-medium dark:text-gray-100 text-gray-800 truncate">${escape_html(tool?.name)}</div> `);
                  if (tool?.meta?.description) {
                    $$renderer5.push("<!--[-->");
                    $$renderer5.push(`<div class="text-xs text-gray-500">${escape_html(tool?.meta?.description)}</div>`);
                  } else {
                    $$renderer5.push("<!--[!-->");
                  }
                  $$renderer5.push(`<!--]--></div>`);
                },
                $$slots: { default: true }
              });
            }
            $$renderer4.push(`<!--]--></div></div>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          if (store_get($$store_subs ??= {}, "$toolServers", toolServers).length > 0) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<div class="flex justify-between dark:text-gray-300 px-5 pb-0.5"><div class="text-base font-medium self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Tool Servers"))}</div></div> <div class="px-5 pb-5 w-full flex flex-col justify-center"><div class="text-xs text-gray-600 dark:text-gray-300 mb-2">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Open WebUI can use tools provided by any OpenAPI server."))} <br/><a class="underline" href="https://github.com/open-webui/openapi-servers" target="_blank">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Learn more about OpenAPI tool servers."))}</a></div> <div class="text-sm dark:text-gray-300 mb-1"><!--[-->`);
            const each_array_1 = ensure_array_like(store_get($$store_subs ??= {}, "$toolServers", toolServers));
            for (let $$index_2 = 0, $$length = each_array_1.length; $$index_2 < $$length; $$index_2++) {
              let toolServer = each_array_1[$$index_2];
              Collapsible($$renderer4, {
                buttonClassName: "w-full",
                chevron: true,
                children: ($$renderer5) => {
                  $$renderer5.push(`<div><div class="text-sm font-medium dark:text-gray-100 text-gray-800">${escape_html(toolServer?.openapi?.info?.title)} - v${escape_html(toolServer?.openapi?.info?.version)}</div> <div class="text-xs text-gray-500">${escape_html(toolServer?.openapi?.info?.description)}</div> <div class="text-xs text-gray-500">${escape_html(toolServer?.url)}</div></div>`);
                },
                $$slots: {
                  default: true,
                  content: ($$renderer5) => {
                    $$renderer5.push(`<div slot="content"><!--[-->`);
                    const each_array_2 = ensure_array_like(toolServer?.specs ?? []);
                    for (let $$index_1 = 0, $$length2 = each_array_2.length; $$index_1 < $$length2; $$index_1++) {
                      let tool_spec = each_array_2[$$index_1];
                      $$renderer5.push(`<div class="my-1"><div class="font-medium text-gray-800 dark:text-gray-100">${escape_html(tool_spec?.name)}</div> <div>${escape_html(tool_spec?.description)}</div></div>`);
                    }
                    $$renderer5.push(`<!--]--></div>`);
                  }
                }
              });
            }
            $$renderer4.push(`<!--]--></div></div>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show, selectedToolIds });
  });
}
function MapSelector($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let setViewLocation = fallback($$props["setViewLocation"], () => [51.505, -0.09], true);
    let points = fallback($$props["points"], () => [], true);
    let onClick = fallback($$props["onClick"], (e) => {
    });
    onDestroy(async () => {
    });
    $$renderer2.push(`<div class="z-10 w-full"><div class="h-96 z-10"></div></div>`);
    bind_props($$props, { setViewLocation, points, onClick });
  });
}
function InputVariablesModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let variables = fallback($$props["variables"], () => ({}), true);
    let onSave = fallback($$props["onSave"], (e) => {
    });
    let loading = false;
    let variableValues = {};
    const init = async () => {
      loading = true;
      variableValues = {};
      for (const variable of Object.keys(variables)) {
        if (variables[variable]?.default !== void 0) {
          variableValues[variable] = variables[variable].default;
        } else {
          variableValues[variable] = "";
        }
      }
      loading = false;
      await tick();
      const firstInputElement = document.getElementById("input-variable-0");
      if (firstInputElement) {
        /* @__PURE__ */ console.log("Focusing first input element:", firstInputElement);
        firstInputElement.focus();
      }
    };
    if (show) {
      init();
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        size: "md",
        get show() {
          return show;
        },
        set show($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-2"><div class="text-lg font-medium self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Input Variables"))}</div> <button class="self-center">`);
          XMark($$renderer4, { className: "size-5" });
          $$renderer4.push(`<!----></button></div> <div class="flex flex-col md:flex-row w-full px-5 pb-4 md:space-x-4 dark:text-gray-200"><div class="flex flex-col w-full sm:flex-row sm:justify-center sm:space-x-6"><form class="flex flex-col w-full"><div class="px-1">`);
          if (!loading) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<div class="flex flex-col gap-1"><!--[-->`);
            const each_array = ensure_array_like(Object.keys(variables));
            for (let idx = 0, $$length = each_array.length; idx < $$length; idx++) {
              let variable = each_array[idx];
              const { type, ...variableAttributes } = variables[variable] ?? {};
              $$renderer4.push(`<div class="py-0.5 w-full justify-between"><div class="flex w-full justify-between mb-1.5"><div class="self-center text-xs font-medium">${escape_html(variable)} `);
              if (variables[variable]?.required ?? false) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<span class="text-gray-500">*${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("required"))}</span>`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--></div></div> <div class="flex mt-0.5 mb-0.5 space-x-2"><div class="flex-1">`);
              if (variables[variable]?.type === "select") {
                $$renderer4.push("<!--[-->");
                const options = variableAttributes?.options ?? [];
                const placeholder = variableAttributes?.placeholder ?? "";
                $$renderer4.select(
                  {
                    class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                    value: variableValues[variable],
                    id: `input-variable-${stringify(idx)}`
                  },
                  ($$renderer5) => {
                    if (placeholder) {
                      $$renderer5.push("<!--[-->");
                      $$renderer5.option({ value: "", disabled: true, selected: true }, ($$renderer6) => {
                        $$renderer6.push(`${escape_html(placeholder)}`);
                      });
                    } else {
                      $$renderer5.push("<!--[!-->");
                    }
                    $$renderer5.push(`<!--]--><!--[-->`);
                    const each_array_1 = ensure_array_like(options);
                    for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
                      let option = each_array_1[$$index];
                      $$renderer5.option({ value: option, selected: option === variableValues[variable] }, ($$renderer6) => {
                        $$renderer6.push(`${escape_html(option)}`);
                      });
                    }
                    $$renderer5.push(`<!--]-->`);
                  }
                );
              } else {
                $$renderer4.push("<!--[!-->");
                if (variables[variable]?.type === "checkbox") {
                  $$renderer4.push("<!--[-->");
                  $$renderer4.push(`<div class="flex items-center space-x-2"><div class="relative flex justify-center items-center gap-2"><input${attributes(
                    {
                      type: "checkbox",
                      checked: variableValues[variable],
                      class: "size-3.5 rounded cursor-pointer border border-gray-200 dark:border-gray-700",
                      id: `input-variable-${stringify(idx)}`,
                      ...variableAttributes
                    },
                    void 0,
                    void 0,
                    void 0,
                    4
                  )}/> <label${attr("for", `input-variable-${stringify(idx)}`)} class="text-sm">${escape_html(variables[variable]?.label ?? variable)}</label></div> <input type="text" class="flex-1 py-1 text-sm dark:text-gray-300 bg-transparent outline-hidden"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter value (true/false)"))}${attr("value", variableValues[variable])} autocomplete="off"${attr("required", variables[variable]?.required ?? false, true)}/></div>`);
                } else {
                  $$renderer4.push("<!--[!-->");
                  if (variables[variable]?.type === "color") {
                    $$renderer4.push("<!--[-->");
                    $$renderer4.push(`<div class="flex items-center space-x-2"><div class="relative size-6"><input${attributes(
                      {
                        type: "color",
                        class: "size-6 rounded cursor-pointer border border-gray-200 dark:border-gray-700",
                        value: variableValues[variable],
                        id: `input-variable-${stringify(idx)}`,
                        ...variableAttributes
                      },
                      void 0,
                      void 0,
                      void 0,
                      4
                    )}/></div> <input type="text" class="flex-1 py-2 text-sm dark:text-gray-300 bg-transparent outline-hidden"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter hex color (e.g. #FF0000)"))}${attr("value", variableValues[variable])} autocomplete="off"${attr("required", variables[variable]?.required ?? false, true)}/></div>`);
                  } else {
                    $$renderer4.push("<!--[!-->");
                    if (variables[variable]?.type === "date") {
                      $$renderer4.push("<!--[-->");
                      $$renderer4.push(`<input${attributes(
                        {
                          type: "date",
                          class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                          placeholder: variables[variable]?.placeholder ?? "",
                          value: variableValues[variable],
                          autocomplete: "off",
                          id: `input-variable-${stringify(idx)}`,
                          required: variables[variable]?.required ?? false,
                          ...variableAttributes
                        },
                        void 0,
                        void 0,
                        void 0,
                        4
                      )}/>`);
                    } else {
                      $$renderer4.push("<!--[!-->");
                      if (variables[variable]?.type === "datetime-local") {
                        $$renderer4.push("<!--[-->");
                        $$renderer4.push(`<input${attributes(
                          {
                            type: "datetime-local",
                            class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                            placeholder: variables[variable]?.placeholder ?? "",
                            value: variableValues[variable],
                            autocomplete: "off",
                            id: `input-variable-${stringify(idx)}`,
                            required: variables[variable]?.required ?? false,
                            ...variableAttributes
                          },
                          void 0,
                          void 0,
                          void 0,
                          4
                        )}/>`);
                      } else {
                        $$renderer4.push("<!--[!-->");
                        if (variables[variable]?.type === "email") {
                          $$renderer4.push("<!--[-->");
                          $$renderer4.push(`<input${attributes(
                            {
                              type: "email",
                              class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                              placeholder: variables[variable]?.placeholder ?? "",
                              value: variableValues[variable],
                              autocomplete: "off",
                              id: `input-variable-${stringify(idx)}`,
                              required: variables[variable]?.required ?? false,
                              ...variableAttributes
                            },
                            void 0,
                            void 0,
                            void 0,
                            4
                          )}/>`);
                        } else {
                          $$renderer4.push("<!--[!-->");
                          if (variables[variable]?.type === "month") {
                            $$renderer4.push("<!--[-->");
                            $$renderer4.push(`<input${attributes(
                              {
                                type: "month",
                                class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                                placeholder: variables[variable]?.placeholder ?? "",
                                value: variableValues[variable],
                                autocomplete: "off",
                                id: `input-variable-${stringify(idx)}`,
                                required: variables[variable]?.required ?? false,
                                ...variableAttributes
                              },
                              void 0,
                              void 0,
                              void 0,
                              4
                            )}/>`);
                          } else {
                            $$renderer4.push("<!--[!-->");
                            if (variables[variable]?.type === "number") {
                              $$renderer4.push("<!--[-->");
                              $$renderer4.push(`<input${attributes(
                                {
                                  type: "number",
                                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                                  placeholder: variables[variable]?.placeholder ?? "",
                                  value: variableValues[variable],
                                  autocomplete: "off",
                                  id: `input-variable-${stringify(idx)}`,
                                  required: variables[variable]?.required ?? false,
                                  ...variableAttributes
                                },
                                void 0,
                                void 0,
                                void 0,
                                4
                              )}/>`);
                            } else {
                              $$renderer4.push("<!--[!-->");
                              if (variables[variable]?.type === "range") {
                                $$renderer4.push("<!--[-->");
                                $$renderer4.push(`<div class="flex items-center space-x-2"><div class="relative flex justify-center items-center gap-2 flex-1"><input${attributes(
                                  {
                                    type: "range",
                                    value: variableValues[variable],
                                    class: "w-full rounded-lg py-1 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                                    id: `input-variable-${stringify(idx)}`,
                                    ...variableAttributes
                                  },
                                  void 0,
                                  void 0,
                                  void 0,
                                  4
                                )}/></div> <input type="text" class="py-1 text-sm dark:text-gray-300 bg-transparent outline-hidden text-right"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter value"))}${attr("value", variableValues[variable])} autocomplete="off"${attr("required", variables[variable]?.required ?? false, true)}/></div>`);
                              } else {
                                $$renderer4.push("<!--[!-->");
                                if (variables[variable]?.type === "tel") {
                                  $$renderer4.push("<!--[-->");
                                  $$renderer4.push(`<input${attributes(
                                    {
                                      type: "tel",
                                      class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                                      placeholder: variables[variable]?.placeholder ?? "",
                                      value: variableValues[variable],
                                      autocomplete: "off",
                                      id: `input-variable-${stringify(idx)}`,
                                      required: variables[variable]?.required ?? false,
                                      ...variableAttributes
                                    },
                                    void 0,
                                    void 0,
                                    void 0,
                                    4
                                  )}/>`);
                                } else {
                                  $$renderer4.push("<!--[!-->");
                                  if (variables[variable]?.type === "text") {
                                    $$renderer4.push("<!--[-->");
                                    $$renderer4.push(`<input${attributes(
                                      {
                                        type: "text",
                                        class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                                        placeholder: variables[variable]?.placeholder ?? "",
                                        value: variableValues[variable],
                                        autocomplete: "off",
                                        id: `input-variable-${stringify(idx)}`,
                                        required: variables[variable]?.required ?? false,
                                        ...variableAttributes
                                      },
                                      void 0,
                                      void 0,
                                      void 0,
                                      4
                                    )}/>`);
                                  } else {
                                    $$renderer4.push("<!--[!-->");
                                    if (variables[variable]?.type === "time") {
                                      $$renderer4.push("<!--[-->");
                                      $$renderer4.push(`<input${attributes(
                                        {
                                          type: "time",
                                          class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                                          placeholder: variables[variable]?.placeholder ?? "",
                                          value: variableValues[variable],
                                          autocomplete: "off",
                                          id: `input-variable-${stringify(idx)}`,
                                          required: variables[variable]?.required ?? false,
                                          ...variableAttributes
                                        },
                                        void 0,
                                        void 0,
                                        void 0,
                                        4
                                      )}/>`);
                                    } else {
                                      $$renderer4.push("<!--[!-->");
                                      if (variables[variable]?.type === "url") {
                                        $$renderer4.push("<!--[-->");
                                        $$renderer4.push(`<input${attributes(
                                          {
                                            type: "url",
                                            class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                                            placeholder: variables[variable]?.placeholder ?? "",
                                            value: variableValues[variable],
                                            autocomplete: "off",
                                            id: `input-variable-${stringify(idx)}`,
                                            required: variables[variable]?.required ?? false,
                                            ...variableAttributes
                                          },
                                          void 0,
                                          void 0,
                                          void 0,
                                          4
                                        )}/>`);
                                      } else {
                                        $$renderer4.push("<!--[!-->");
                                        if (variables[variable]?.type === "map") {
                                          $$renderer4.push("<!--[-->");
                                          $$renderer4.push(`<div class="flex flex-col items-center gap-1">`);
                                          MapSelector($$renderer4, {
                                            setViewLocation: (variableValues[variable] ?? "").includes(",") ?? false ? variableValues[variable].split(",") : null,
                                            onClick: (value) => {
                                              variableValues[variable] = value;
                                            }
                                          });
                                          $$renderer4.push(`<!----> <input type="text" class="w-full py-1 text-left text-sm dark:text-gray-300 bg-transparent outline-hidden"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter coordinates (e.g. 51.505, -0.09)"))}${attr("value", variableValues[variable])} autocomplete="off"${attr("required", variables[variable]?.required ?? false, true)}/></div>`);
                                        } else {
                                          $$renderer4.push("<!--[!-->");
                                          $$renderer4.push(`<textarea class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30"${attr("placeholder", variables[variable]?.placeholder ?? "")} autocomplete="off"${attr("id", `input-variable-${stringify(idx)}`)}${attr("required", variables[variable]?.required ?? false, true)}>`);
                                          const $$body = escape_html(variableValues[variable]);
                                          if ($$body) {
                                            $$renderer4.push(`${$$body}`);
                                          }
                                          $$renderer4.push(`</textarea>`);
                                        }
                                        $$renderer4.push(`<!--]-->`);
                                      }
                                      $$renderer4.push(`<!--]-->`);
                                    }
                                    $$renderer4.push(`<!--]-->`);
                                  }
                                  $$renderer4.push(`<!--]-->`);
                                }
                                $$renderer4.push(`<!--]-->`);
                              }
                              $$renderer4.push(`<!--]-->`);
                            }
                            $$renderer4.push(`<!--]-->`);
                          }
                          $$renderer4.push(`<!--]-->`);
                        }
                        $$renderer4.push(`<!--]-->`);
                      }
                      $$renderer4.push(`<!--]-->`);
                    }
                    $$renderer4.push(`<!--]-->`);
                  }
                  $$renderer4.push(`<!--]-->`);
                }
                $$renderer4.push(`<!--]-->`);
              }
              $$renderer4.push(`<!--]--></div></div></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          } else {
            $$renderer4.push("<!--[!-->");
            Spinner($$renderer4, { className: "size-5" });
          }
          $$renderer4.push(`<!--]--></div> <div class="flex justify-end pt-3 text-sm font-medium"><button class="px-3.5 py-1.5 text-sm font-medium bg-white hover:bg-gray-100 text-black dark:bg-black dark:text-white dark:hover:bg-gray-900 transition rounded-full" type="button">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Cancel"))}</button> <button class="px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full" type="submit">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Save"))}</button></div></form></div></div></div>`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show, variables, onSave });
  });
}
function Knobs($$renderer, $$props) {
  let className = fallback($$props["className"], "w-4 h-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr_class(clsx(className))} aria-hidden="true"${attr("stroke-width", strokeWidth)} fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 1 1-3 0m3 0a1.5 1.5 0 1 0-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-9.75 0h9.75"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function Valves($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let valvesSpec = fallback($$props["valvesSpec"], null);
    let valves = fallback($$props["valves"], () => ({}), true);
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (valvesSpec && Object.keys(valvesSpec?.properties ?? {}).length) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<!--[-->`);
        const each_array = ensure_array_like(Object.keys(valvesSpec.properties));
        for (let idx = 0, $$length = each_array.length; idx < $$length; idx++) {
          let property = each_array[idx];
          $$renderer3.push(`<div class="py-0.5 w-full justify-between"><div class="flex w-full justify-between"><div class="self-center text-xs font-medium">${escape_html(valvesSpec.properties[property].title)} `);
          if ((valvesSpec?.required ?? []).includes(property)) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<span class="text-gray-500">*required</span>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div> <button class="p-1 px-3 text-xs flex rounded-sm transition" type="button">`);
          if ((valves[property] ?? null) === null) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<span class="ml-2 self-center">`);
            if ((valvesSpec?.required ?? []).includes(property)) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("None"))}`);
            } else {
              $$renderer3.push("<!--[!-->");
              $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Default"))}`);
            }
            $$renderer3.push(`<!--]--></span>`);
          } else {
            $$renderer3.push("<!--[!-->");
            $$renderer3.push(`<span class="ml-2 self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Custom"))}</span>`);
          }
          $$renderer3.push(`<!--]--></button></div> `);
          if ((valves[property] ?? null) !== null) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="flex mt-0.5 mb-0.5 space-x-2"><div class="flex-1">`);
            if (valvesSpec.properties[property]?.enum ?? null) {
              $$renderer3.push("<!--[-->");
              $$renderer3.select(
                {
                  class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                  value: valves[property]
                },
                ($$renderer4) => {
                  $$renderer4.push(`<!--[-->`);
                  const each_array_1 = ensure_array_like(valvesSpec.properties[property].enum);
                  for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
                    let option = each_array_1[$$index];
                    $$renderer4.option({ value: option, selected: option === valves[property] }, ($$renderer5) => {
                      $$renderer5.push(`${escape_html(option)}`);
                    });
                  }
                  $$renderer4.push(`<!--]-->`);
                }
              );
            } else {
              $$renderer3.push("<!--[!-->");
              if ((valvesSpec.properties[property]?.type ?? null) === "boolean") {
                $$renderer3.push("<!--[-->");
                $$renderer3.push(`<div class="flex justify-between items-center"><div class="text-xs text-gray-500">${escape_html(valves[property] ? store_get($$store_subs ??= {}, "$i18n", i18n).t("Enabled") : store_get($$store_subs ??= {}, "$i18n", i18n).t("Disabled"))}</div> <div class="pr-2">`);
                Switch_1($$renderer3, {
                  get state() {
                    return valves[property];
                  },
                  set state($$value) {
                    valves[property] = $$value;
                    $$settled = false;
                  }
                });
                $$renderer3.push(`<!----></div></div>`);
              } else {
                $$renderer3.push("<!--[!-->");
                if ((valvesSpec.properties[property]?.type ?? null) !== "string") {
                  $$renderer3.push("<!--[-->");
                  $$renderer3.push(`<input class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30" type="text"${attr("placeholder", valvesSpec.properties[property].title)}${attr("value", valves[property])} autocomplete="off" required/>`);
                } else {
                  $$renderer3.push("<!--[!-->");
                  if (valvesSpec.properties[property]?.input ?? null) {
                    $$renderer3.push("<!--[-->");
                    if (valvesSpec.properties[property]?.input?.type === "password") {
                      $$renderer3.push("<!--[-->");
                      $$renderer3.push(`<div class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 border border-gray-100/30 dark:border-gray-850/30">`);
                      SensitiveInput($$renderer3, {
                        id: `valve-${stringify(property)}`,
                        placeholder: valvesSpec.properties[property]?.description ?? "",
                        required: (valvesSpec?.required ?? []).includes(property),
                        get value() {
                          return valves[property];
                        },
                        set value($$value) {
                          valves[property] = $$value;
                          $$settled = false;
                        }
                      });
                      $$renderer3.push(`<!----></div>`);
                    } else {
                      $$renderer3.push("<!--[!-->");
                      if (valvesSpec.properties[property]?.input?.type === "select" && valvesSpec.properties[property]?.input?.options) {
                        $$renderer3.push("<!--[-->");
                        $$renderer3.select(
                          {
                            class: "w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30",
                            value: valves[property]
                          },
                          ($$renderer4) => {
                            $$renderer4.option({ value: "", disabled: true }, ($$renderer5) => {
                              $$renderer5.push(`${escape_html(valvesSpec.properties[property]?.description ?? store_get($$store_subs ??= {}, "$i18n", i18n).t("Select an option"))}`);
                            });
                            $$renderer4.push(`<!--[-->`);
                            const each_array_2 = ensure_array_like(valvesSpec.properties[property].input.options);
                            for (let $$index_1 = 0, $$length2 = each_array_2.length; $$index_1 < $$length2; $$index_1++) {
                              let option = each_array_2[$$index_1];
                              if (typeof option === "object" && option !== null) {
                                $$renderer4.push("<!--[-->");
                                $$renderer4.option(
                                  {
                                    value: option.value,
                                    selected: option.value === valves[property]
                                  },
                                  ($$renderer5) => {
                                    $$renderer5.push(`${escape_html(option.label ?? option.value)}`);
                                  }
                                );
                              } else {
                                $$renderer4.push("<!--[!-->");
                                $$renderer4.option({ value: option, selected: option === valves[property] }, ($$renderer5) => {
                                  $$renderer5.push(`${escape_html(option)}`);
                                });
                              }
                              $$renderer4.push(`<!--]-->`);
                            }
                            $$renderer4.push(`<!--]-->`);
                          }
                        );
                      } else {
                        $$renderer3.push("<!--[!-->");
                        if (valvesSpec.properties[property]?.input?.type === "color") {
                          $$renderer3.push("<!--[-->");
                          $$renderer3.push(`<div class="flex items-center space-x-2"><div class="relative size-6"><input type="color" class="size-6 rounded cursor-pointer border border-gray-200 dark:border-gray-700"${attr("value", valves[property] ?? "#000000")}/></div> <input type="text" class="flex-1 rounded-lg py-2 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter hex color (e.g. #FF0000)"))}${attr("value", valves[property])} autocomplete="off" disabled/></div>`);
                        } else {
                          $$renderer3.push("<!--[!-->");
                          if (valvesSpec.properties[property]?.input?.type === "map") {
                            $$renderer3.push("<!--[-->");
                            $$renderer3.push(`<div class="flex flex-col items-center gap-1">`);
                            MapSelector($$renderer3, {
                              setViewLocation: (valves[property] ?? "").includes(",") ?? false ? valves[property].split(",") : null,
                              onClick: (value) => {
                                valves[property] = value;
                              }
                            });
                            $$renderer3.push(`<!----> `);
                            if (valves[property]) {
                              $$renderer3.push("<!--[-->");
                              $$renderer3.push(`<input type="text" class="w-full rounded-lg py-1 text-left text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter coordinates (e.g. 51.505, -0.09)"))}${attr("value", valves[property])} autocomplete="off"/>`);
                            } else {
                              $$renderer3.push("<!--[!-->");
                            }
                            $$renderer3.push(`<!--]--></div>`);
                          } else {
                            $$renderer3.push("<!--[!-->");
                          }
                          $$renderer3.push(`<!--]-->`);
                        }
                        $$renderer3.push(`<!--]-->`);
                      }
                      $$renderer3.push(`<!--]-->`);
                    }
                    $$renderer3.push(`<!--]-->`);
                  } else {
                    $$renderer3.push("<!--[!-->");
                    $$renderer3.push(`<textarea class="w-full rounded-lg py-2 px-4 text-sm dark:text-gray-300 dark:bg-gray-850 outline-hidden border border-gray-100/30 dark:border-gray-850/30"${attr("placeholder", valvesSpec.properties[property].title)} autocomplete="off" required>`);
                    const $$body = escape_html(valves[property]);
                    if ($$body) {
                      $$renderer3.push(`${$$body}`);
                    }
                    $$renderer3.push(`</textarea>`);
                  }
                  $$renderer3.push(`<!--]-->`);
                }
                $$renderer3.push(`<!--]-->`);
              }
              $$renderer3.push(`<!--]-->`);
            }
            $$renderer3.push(`<!--]--></div></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if ((valvesSpec.properties[property]?.description ?? null) !== null) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="text-xs text-gray-500">${escape_html(valvesSpec.properties[property].description)}</div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div>`);
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<div class="text-xs">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("No valves"))}</div>`);
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { valvesSpec, valves });
  });
}
function ValvesModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let type = fallback($$props["type"], "tool");
    let id = fallback($$props["id"], null);
    let userValves = fallback($$props["userValves"], false);
    let saving = false;
    let loading = false;
    let valvesSpec = null;
    let valves = {};
    const initHandler = async () => {
      loading = true;
      valves = {};
      valvesSpec = null;
      try {
        if (userValves) {
          if (type === "tool") {
            valves = await getUserValvesById(localStorage.token, id);
            valvesSpec = await getUserValvesSpecById(localStorage.token, id);
          } else if (type === "function") {
            valves = await getUserValvesById$1(localStorage.token, id);
            valvesSpec = await getUserValvesSpecById$1(localStorage.token, id);
          }
        } else {
          if (type === "tool") {
            valves = await getToolValvesById(localStorage.token, id);
            valvesSpec = await getToolValvesSpecById(localStorage.token, id);
          } else if (type === "function") {
            valves = await getFunctionValvesById(localStorage.token, id);
            valvesSpec = await getFunctionValvesSpecById(localStorage.token, id);
          }
        }
        if (!valves) {
          valves = {};
        }
        if (valvesSpec) {
          for (const property in valvesSpec.properties) {
            if (valvesSpec.properties[property]?.type === "array") {
              if (valves[property] != null) {
                valves[property] = (Array.isArray(valves[property]) ? valves[property] : []).join(",");
              } else {
                valves[property] = null;
              }
            }
          }
        }
        loading = false;
      } catch (e) {
        toast.error(`Error fetching valves`);
        show = false;
      }
    };
    if (show) {
      initHandler();
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        size: "sm",
        get show() {
          return show;
        },
        set show($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div><div class="flex justify-between dark:text-gray-300 px-5 pt-4 pb-2"><div class="text-lg font-medium self-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Valves"))}</div> <button class="self-center">`);
          XMark($$renderer4, { className: "size-5" });
          $$renderer4.push(`<!----></button></div> <div class="flex flex-col md:flex-row w-full px-5 pb-4 md:space-x-4 dark:text-gray-200"><div class="flex flex-col w-full sm:flex-row sm:justify-center sm:space-x-6"><form class="flex flex-col w-full"><div class="px-1">`);
          if (!loading) {
            $$renderer4.push("<!--[-->");
            Valves($$renderer4, {
              valvesSpec,
              get valves() {
                return valves;
              },
              set valves($$value) {
                valves = $$value;
                $$settled = false;
              }
            });
          } else {
            $$renderer4.push("<!--[!-->");
            Spinner($$renderer4, { className: "size-5" });
          }
          $$renderer4.push(`<!--]--></div> <div class="flex justify-end pt-3 text-sm font-medium"><button${attr_class(`px-3.5 py-1.5 text-sm font-medium bg-black hover:bg-gray-900 text-white dark:bg-white dark:text-black dark:hover:bg-gray-100 transition rounded-full ${stringify("")}`)} type="submit"${attr("disabled", saving, true)}>${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Save"))} `);
          {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--></button></div></form></div></div></div>`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show, type, id, userValves });
  });
}
function InputModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let id = fallback($$props["id"], "input-modal");
    let show = fallback($$props["show"], false);
    let value = fallback($$props["value"], null);
    let inputContent = fallback($$props["inputContent"], null);
    let autocomplete = fallback($$props["autocomplete"], false);
    let generateAutoCompletion = fallback($$props["generateAutoCompletion"], null);
    let onChange = fallback($$props["onChange"], () => {
    });
    let onClose = fallback($$props["onClose"], () => {
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Drawer($$renderer3, {
        get show() {
          return show;
        },
        set show($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex h-full min-h-screen flex-col"><div class="sticky top-0 z-30 flex justify-between bg-white px-4.5 pt-3 pb-3 dark:bg-gray-900 dark:text-gray-100"><div class="font-primary self-center text-lg">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Input"))}</div> <button class="self-center" aria-label="Close"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="h-5 w-5"><path d="M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z"></path></svg></button></div> <div class="flex w-full px-4 dark:text-gray-200 min-h-full flex-1"><div class="flex-1 w-full min-h-full">`);
          RichTextInput($$renderer4, {
            id,
            onChange: (content) => {
              value = content.md;
              inputContent = content;
              onChange(content);
            },
            json: true,
            value: inputContent?.json,
            html: inputContent?.html,
            richText: store_get($$store_subs ??= {}, "$settings", settings)?.richTextInput ?? true,
            messageInput: true,
            showFormattingToolbar: store_get($$store_subs ??= {}, "$settings", settings)?.showFormattingToolbar ?? false,
            floatingMenuPlacement: "top-start",
            insertPromptAsRichText: store_get($$store_subs ??= {}, "$settings", settings)?.insertPromptAsRichText ?? false,
            autocomplete,
            generateAutoCompletion
          });
          $$renderer4.push(`<!----></div></div></div>`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      id,
      show,
      value,
      inputContent,
      autocomplete,
      generateAutoCompletion,
      onChange,
      onClose
    });
  });
}
function MessageInput($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    dayjs.extend(duration);
    dayjs.extend(relativeTime);
    const i18n = getContext("i18n");
    let onUpload = fallback($$props["onUpload"], (e) => {
    });
    let onChange = fallback($$props["onChange"], () => {
    });
    let createMessagePair = $$props["createMessagePair"];
    let stopResponse = $$props["stopResponse"];
    let autoScroll = fallback($$props["autoScroll"], false);
    let generating = fallback($$props["generating"], false);
    let atSelectedModel = fallback($$props["atSelectedModel"], void 0);
    let selectedModels = $$props["selectedModels"];
    let history = $$props["history"];
    let taskIds = fallback($$props["taskIds"], null);
    let prompt = fallback($$props["prompt"], "");
    let files = fallback($$props["files"], () => [], true);
    let selectedToolIds = fallback($$props["selectedToolIds"], () => [], true);
    let selectedFilterIds = fallback($$props["selectedFilterIds"], () => [], true);
    let imageGenerationEnabled = fallback($$props["imageGenerationEnabled"], false);
    let webSearchEnabled = fallback($$props["webSearchEnabled"], false);
    let codeInterpreterEnabled = fallback($$props["codeInterpreterEnabled"], false);
    let messageQueue = fallback($$props["messageQueue"], () => [], true);
    let onQueueSendNow = fallback($$props["onQueueSendNow"], () => {
    });
    let onQueueEdit = fallback($$props["onQueueEdit"], () => {
    });
    let onQueueDelete = fallback($$props["onQueueDelete"], () => {
    });
    let inputContent = null;
    let showInputVariablesModal = false;
    let inputVariablesModalCallback = (variableValues) => {
    };
    let inputVariables = {};
    let inputVariableValues = {};
    let showValvesModal = false;
    let selectedValvesType = "tool";
    const inputVariableHandler = async (text) => {
      inputVariables = extractInputVariables(text);
      if (Object.keys(inputVariables).length === 0) {
        return text;
      }
      showInputVariablesModal = true;
      return await new Promise((resolve) => {
        inputVariablesModalCallback = (variableValues) => {
          inputVariableValues = { ...inputVariableValues, ...variableValues };
          replaceVariables(inputVariableValues);
          showInputVariablesModal = false;
          resolve(text);
        };
      });
    };
    const textVariableHandler = async (text) => {
      if (text.includes("{{CLIPBOARD}}")) {
        const clipboardText = await navigator.clipboard.readText().catch((err) => {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to read clipboard contents"));
          return "{{CLIPBOARD}}";
        });
        const clipboardItems = await navigator.clipboard.read().catch((err) => {
          /* @__PURE__ */ console.error("Failed to read clipboard items:", err);
          return [];
        });
        for (const item of clipboardItems) {
          for (const type of item.types) {
            if (type.startsWith("image/")) {
              const blob = await item.getType(type);
              const file = new File([blob], `clipboard-image.${type.split("/")[1]}`, { type });
              inputFilesHandler([file]);
            }
          }
        }
        text = text.replaceAll("{{CLIPBOARD}}", clipboardText.replaceAll("\r\n", "\n"));
      }
      if (text.includes("{{USER_LOCATION}}")) {
        let location;
        try {
          location = await getUserPosition();
        } catch (error) {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Location access not allowed"));
          location = "LOCATION_UNKNOWN";
        }
        text = text.replaceAll("{{USER_LOCATION}}", String(location));
      }
      const sessionUser = await getSessionUser(localStorage.token);
      if (text.includes("{{USER_NAME}}")) {
        const name = sessionUser?.name || "User";
        text = text.replaceAll("{{USER_NAME}}", name);
      }
      if (text.includes("{{USER_EMAIL}}")) {
        const email = sessionUser?.email || "";
        if (email) {
          text = text.replaceAll("{{USER_EMAIL}}", email);
        }
      }
      if (text.includes("{{USER_BIO}}")) {
        const bio = sessionUser?.bio || "";
        if (bio) {
          text = text.replaceAll("{{USER_BIO}}", bio);
        }
      }
      if (text.includes("{{USER_GENDER}}")) {
        const gender = sessionUser?.gender || "";
        if (gender) {
          text = text.replaceAll("{{USER_GENDER}}", gender);
        }
      }
      if (text.includes("{{USER_BIRTH_DATE}}")) {
        const birthDate = sessionUser?.date_of_birth || "";
        if (birthDate) {
          text = text.replaceAll("{{USER_BIRTH_DATE}}", birthDate);
        }
      }
      if (text.includes("{{USER_AGE}}")) {
        const birthDate = sessionUser?.date_of_birth || "";
        if (birthDate) {
          const age = getAge(birthDate);
          text = text.replaceAll("{{USER_AGE}}", age);
        }
      }
      if (text.includes("{{USER_LANGUAGE}}")) {
        const language = localStorage.getItem("locale") || "en-US";
        text = text.replaceAll("{{USER_LANGUAGE}}", language);
      }
      if (text.includes("{{CURRENT_DATE}}")) {
        const date = getFormattedDate();
        text = text.replaceAll("{{CURRENT_DATE}}", date);
      }
      if (text.includes("{{CURRENT_TIME}}")) {
        const time = getFormattedTime();
        text = text.replaceAll("{{CURRENT_TIME}}", time);
      }
      if (text.includes("{{CURRENT_DATETIME}}")) {
        const dateTime = getCurrentDateTime();
        text = text.replaceAll("{{CURRENT_DATETIME}}", dateTime);
      }
      if (text.includes("{{CURRENT_TIMEZONE}}")) {
        const timezone = getUserTimezone();
        text = text.replaceAll("{{CURRENT_TIMEZONE}}", timezone);
      }
      if (text.includes("{{CURRENT_WEEKDAY}}")) {
        const weekday = getWeekday();
        text = text.replaceAll("{{CURRENT_WEEKDAY}}", weekday);
      }
      return text;
    };
    const replaceVariables = (variables) => {
      /* @__PURE__ */ console.log("Replacing variables:", variables);
      const chatInput = document.getElementById("chat-input");
      if (chatInput) {
        chatInputElement.replaceVariables(variables);
        chatInputElement.focus();
      }
    };
    const setText = async (text, cb) => {
      const chatInput = document.getElementById("chat-input");
      if (chatInput) {
        if (text !== "") {
          text = await textVariableHandler(text || "");
        }
        if (text !== "") {
          text = await inputVariableHandler(text);
        }
        await tick();
        if (cb) await cb(text);
      }
    };
    let command = "";
    let showCommands = fallback($$props["showCommands"], false);
    let showTools = false;
    let chatInputElement;
    let showInputModal = false;
    let dragged = false;
    let placeholder = fallback($$props["placeholder"], "");
    let visionCapableModels = [];
    let fileUploadCapableModels = [];
    let webSearchCapableModels = [];
    let imageGenerationCapableModels = [];
    let codeInterpreterCapableModels = [];
    const uploadFileHandler = async (file, process = true, itemData = {}) => {
      if (store_get($$store_subs ??= {}, "$_user", user)?.role !== "admin" && !(store_get($$store_subs ??= {}, "$_user", user)?.permissions?.chat?.file_upload ?? true)) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("You do not have permission to upload files."));
        return null;
      }
      if (fileUploadCapableModels.length !== selectedModels.length) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Model(s) do not support file upload"));
        return null;
      }
      const tempItemId = v4();
      const fileItem = {
        type: "file",
        file: "",
        id: null,
        url: "",
        name: file.name,
        collection_name: "",
        status: "uploading",
        size: file.size,
        error: "",
        itemId: tempItemId,
        ...itemData
      };
      if (fileItem.size == 0) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("You cannot upload an empty file."));
        return null;
      }
      files = [...files, fileItem];
      if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
        try {
          let metadata = null;
          if ((file.type.startsWith("audio/") || file.type.startsWith("video/")) && store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language) {
            metadata = {
              language: store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language
            };
          }
          const uploadedFile = await uploadFile(localStorage.token, file, metadata, process);
          if (uploadedFile) {
            /* @__PURE__ */ console.log("File upload completed:", {
              id: uploadedFile.id,
              name: fileItem.name,
              collection: uploadedFile?.meta?.collection_name
            });
            if (uploadedFile.error) {
              console.warn("File upload warning:", uploadedFile.error);
              toast.warning(uploadedFile.error);
            }
            fileItem.status = "uploaded";
            fileItem.file = uploadedFile;
            fileItem.id = uploadedFile.id;
            fileItem.collection_name = uploadedFile?.meta?.collection_name || uploadedFile?.collection_name;
            fileItem.content_type = uploadedFile.meta?.content_type || uploadedFile.content_type;
            fileItem.url = `${uploadedFile.id}`;
            files = files;
          } else {
            files = files.filter((item) => item?.itemId !== tempItemId);
          }
        } catch (e) {
          toast.error(`${e}`);
          files = files.filter((item) => item?.itemId !== tempItemId);
        }
      } else {
        const content = await extractContentFromFile(file).catch((error) => {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to extract content from the file: {{error}}", { error }));
          return null;
        });
        if (content === null) {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to extract content from the file."));
          files = files.filter((item) => item?.itemId !== tempItemId);
          return null;
        } else {
          /* @__PURE__ */ console.log("Extracted content from file:", { name: file.name, size: file.size, content });
          fileItem.status = "uploaded";
          fileItem.type = "text";
          fileItem.content = content;
          fileItem.id = v4();
          files = files;
        }
      }
    };
    const inputFilesHandler = async (inputFiles) => {
      /* @__PURE__ */ console.log("Input files handler called with:", inputFiles);
      if ((store_get($$store_subs ??= {}, "$config", config)?.file?.max_count ?? null) !== null && files.length + inputFiles.length > store_get($$store_subs ??= {}, "$config", config)?.file?.max_count) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`You can only chat with a maximum of {{maxCount}} file(s) at a time.`, {
          maxCount: store_get($$store_subs ??= {}, "$config", config)?.file?.max_count
        }));
        return;
      }
      inputFiles.forEach(async (file) => {
        /* @__PURE__ */ console.log("Processing file:", {
          name: file.name,
          type: file.type,
          size: file.size,
          extension: file.name.split(".").at(-1)
        });
        if ((store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? null) !== null && file.size > (store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? 0) * 1024 * 1024) {
          /* @__PURE__ */ console.log("File exceeds max size limit:", {
            fileSize: file.size,
            maxSize: (store_get($$store_subs ??= {}, "$config", config)?.file?.max_size ?? 0) * 1024 * 1024
          });
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`File size should not exceed {{maxSize}} MB.`, {
            maxSize: store_get($$store_subs ??= {}, "$config", config)?.file?.max_size
          }));
          return;
        }
        if (file["type"].startsWith("image/")) {
          if (visionCapableModels.length === 0) {
            toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Selected model(s) do not support image inputs"));
            return;
          }
          const compressImageHandler = async (imageUrl, settings2 = {}, config2 = {}) => {
            const settingsCompression = settings2?.imageCompression ?? false;
            const configWidth = config2?.file?.image_compression?.width ?? null;
            const configHeight = config2?.file?.image_compression?.height ?? null;
            if (!settingsCompression && !configWidth && !configHeight) {
              return imageUrl;
            }
            let width = null;
            let height = null;
            if (settingsCompression) {
              width = settings2?.imageCompressionSize?.width ?? null;
              height = settings2?.imageCompressionSize?.height ?? null;
            }
            if (configWidth && (width === null || width > configWidth)) {
              width = configWidth;
            }
            if (configHeight && (height === null || height > configHeight)) {
              height = configHeight;
            }
            if (width || height) {
              return await compressImage(imageUrl, width, height);
            }
            return imageUrl;
          };
          let reader = new FileReader();
          reader.onload = async (event) => {
            let imageUrl = event.target.result;
            imageUrl = await compressImageHandler(imageUrl, store_get($$store_subs ??= {}, "$settings", settings), store_get($$store_subs ??= {}, "$config", config));
            if (store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
              files = [...files, { type: "image", url: imageUrl }];
            } else {
              const blob = await (await fetch(imageUrl)).blob();
              const compressedFile = new File([blob], file.name, { type: file.type });
              uploadFileHandler(compressedFile, false);
            }
          };
          reader.readAsDataURL(file["type"] === "image/heic" ? await convertHeicToJpeg(file) : file);
        } else {
          uploadFileHandler(file);
        }
      });
    };
    const onDragOver = (e) => {
      e.preventDefault();
      if (e.dataTransfer?.types?.includes("Files")) {
        dragged = true;
      } else {
        dragged = false;
      }
    };
    const onDragLeave = () => {
      dragged = false;
    };
    const onDrop = async (e) => {
      e.preventDefault();
      /* @__PURE__ */ console.log(e);
      if (e.dataTransfer?.files) {
        const inputFiles = Array.from(e.dataTransfer?.files);
        if (inputFiles && inputFiles.length > 0) {
          /* @__PURE__ */ console.log(inputFiles);
          inputFilesHandler(inputFiles);
        }
      }
      dragged = false;
    };
    const onKeyDown = (e) => {
      if (e.key === "Shift") ;
      if (e.key === "Escape") {
        /* @__PURE__ */ console.log("Escape");
        dragged = false;
      }
    };
    const onKeyUp = (e) => {
      if (e.key === "Shift") ;
    };
    const onFocus = () => {
    };
    const onBlur = () => {
    };
    onDestroy(() => {
      /* @__PURE__ */ console.log("destroy");
      window.removeEventListener("keydown", onKeyDown);
      window.removeEventListener("keyup", onKeyUp);
      window.removeEventListener("focus", onFocus);
      window.removeEventListener("blur", onBlur);
      const dropzoneElement = document.getElementById("chat-container");
      if (dropzoneElement) {
        dropzoneElement?.removeEventListener("dragover", onDragOver);
        dropzoneElement?.removeEventListener("drop", onDrop);
        dropzoneElement?.removeEventListener("dragleave", onDragLeave);
      }
    });
    atSelectedModel !== void 0 ? [atSelectedModel.id] : selectedModels;
    onChange({
      prompt,
      files: files.filter((file) => file.type !== "image").map((file) => {
        return { ...file, user: void 0, access_grants: void 0 };
      }),
      selectedToolIds,
      selectedFilterIds,
      imageGenerationEnabled,
      webSearchEnabled,
      codeInterpreterEnabled
    });
    showCommands = ["/", "#", "@", "$"].includes(command?.charAt(0)) || "\\#" === command?.slice(0, 2);
    visionCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === model)?.info?.meta?.capabilities?.vision ?? true);
    fileUploadCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === model)?.info?.meta?.capabilities?.file_upload ?? true);
    webSearchCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === model)?.info?.meta?.capabilities?.web_search ?? true);
    imageGenerationCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === model)?.info?.meta?.capabilities?.image_generation ?? true);
    codeInterpreterCapableModels = (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).filter((model) => store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === model)?.info?.meta?.capabilities?.code_interpreter ?? true);
    (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).map((id) => (store_get($$store_subs ??= {}, "$models", models).find((model) => model.id === id) || {})?.filters ?? []).reduce((acc, filters) => acc.filter((f1) => filters.some((f2) => f2.id === f1.id)));
    (store_get($$store_subs ??= {}, "$tools", tools) ?? []).length > 0 || (store_get($$store_subs ??= {}, "$toolServers", toolServers) ?? []).length > 0;
    (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).length === webSearchCapableModels.length && store_get($$store_subs ??= {}, "$config", config)?.features?.enable_web_search && (store_get($$store_subs ??= {}, "$_user", user).role === "admin" || store_get($$store_subs ??= {}, "$_user", user)?.permissions?.features?.web_search);
    (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).length === imageGenerationCapableModels.length && store_get($$store_subs ??= {}, "$config", config)?.features?.enable_image_generation && (store_get($$store_subs ??= {}, "$_user", user).role === "admin" || store_get($$store_subs ??= {}, "$_user", user)?.permissions?.features?.image_generation);
    (atSelectedModel?.id ? [atSelectedModel.id] : selectedModels).length === codeInterpreterCapableModels.length && store_get($$store_subs ??= {}, "$config", config)?.features?.enable_code_interpreter && (store_get($$store_subs ??= {}, "$_user", user).role === "admin" || store_get($$store_subs ??= {}, "$_user", user)?.permissions?.features?.code_interpreter);
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      FilesOverlay($$renderer3, { show: dragged });
      $$renderer3.push(`<!----> `);
      ToolServersModal($$renderer3, {
        selectedToolIds,
        get show() {
          return showTools;
        },
        set show($$value) {
          showTools = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      InputVariablesModal($$renderer3, {
        variables: inputVariables,
        onSave: inputVariablesModalCallback,
        get show() {
          return showInputVariablesModal;
        },
        set show($$value) {
          showInputVariablesModal = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      ValvesModal($$renderer3, {
        userValves: true,
        type: selectedValvesType,
        id: null,
        get show() {
          return showValvesModal;
        },
        set show($$value) {
          showValvesModal = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      InputModal($$renderer3, {
        onChange: (content) => {
          /* @__PURE__ */ console.log(content);
        },
        onClose: async () => {
          await tick();
        },
        get show() {
          return showInputModal;
        },
        set show($$value) {
          showInputModal = $$value;
          $$settled = false;
        },
        get value() {
          return prompt;
        },
        set value($$value) {
          prompt = $$value;
          $$settled = false;
        },
        get inputContent() {
          return inputContent;
        },
        set inputContent($$value) {
          inputContent = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      onUpload,
      onChange,
      createMessagePair,
      stopResponse,
      autoScroll,
      generating,
      atSelectedModel,
      selectedModels,
      history,
      taskIds,
      prompt,
      files,
      selectedToolIds,
      selectedFilterIds,
      imageGenerationEnabled,
      webSearchEnabled,
      codeInterpreterEnabled,
      messageQueue,
      onQueueSendNow,
      onQueueEdit,
      onQueueDelete,
      showCommands,
      placeholder,
      setText
    });
  });
}
function ModelSelector($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let selectedModels = fallback($$props["selectedModels"], () => [""], true);
    let disabled = fallback($$props["disabled"], false);
    let showSetDefault = fallback($$props["showSetDefault"], true);
    const pinModelHandler = async (modelId) => {
      let pinnedModels = store_get($$store_subs ??= {}, "$settings", settings)?.pinnedModels ?? [];
      if (pinnedModels.includes(modelId)) {
        pinnedModels = pinnedModels.filter((id) => id !== modelId);
      } else {
        pinnedModels = [.../* @__PURE__ */ new Set([...pinnedModels, modelId])];
      }
      settings.set({
        ...store_get($$store_subs ??= {}, "$settings", settings),
        pinnedModels
      });
      await updateUserSettings(localStorage.token, { ui: store_get($$store_subs ??= {}, "$settings", settings) });
    };
    if (selectedModels.length > 0 && store_get($$store_subs ??= {}, "$models", models).length > 0) {
      const _selectedModels = selectedModels.map((model) => store_get($$store_subs ??= {}, "$models", models).map((m) => m.id).includes(model) ? model : "");
      if (JSON.stringify(_selectedModels) !== JSON.stringify(selectedModels)) {
        selectedModels = _selectedModels;
      }
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="flex flex-col w-full items-start"><!--[-->`);
      const each_array = ensure_array_like(selectedModels);
      for (let selectedModelIdx = 0, $$length = each_array.length; selectedModelIdx < $$length; selectedModelIdx++) {
        let selectedModel = each_array[selectedModelIdx];
        $$renderer3.push(`<div class="flex w-full max-w-fit"><div class="overflow-hidden w-full"><div${attr_class(`max-w-full ${stringify(store_get($$store_subs ??= {}, "$settings", settings)?.highContrastMode ?? false ? "m-1" : "mr-1")}`)}>`);
        Selector($$renderer3, {
          id: `${selectedModelIdx}`,
          placeholder: store_get($$store_subs ??= {}, "$i18n", i18n).t("Select a model"),
          items: store_get($$store_subs ??= {}, "$models", models).map((model) => ({ value: model.id, label: model.name, model })),
          pinModelHandler,
          get value() {
            return selectedModel;
          },
          set value($$value) {
            selectedModel = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----></div></div> `);
        if (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user)?.permissions?.chat?.multiple_models ?? true)) {
          $$renderer3.push("<!--[-->");
          if (selectedModelIdx === 0) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="self-center mx-1 disabled:text-gray-600 disabled:hover:text-gray-600 -translate-y-[0.5px]">`);
            Tooltip($$renderer3, {
              content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Add Model"),
              children: ($$renderer4) => {
                $$renderer4.push(`<button${attr("disabled", disabled, true)} aria-label="Add Model"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="M12 6v12m6-6H6"></path></svg></button>`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
            $$renderer3.push(`<div class="self-center mx-1 disabled:text-gray-600 disabled:hover:text-gray-600 -translate-y-[0.5px]">`);
            Tooltip($$renderer3, {
              content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Remove Model"),
              children: ($$renderer4) => {
                $$renderer4.push(`<button${attr("disabled", disabled, true)} aria-label="Remove Model"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="size-3"><path stroke-linecap="round" stroke-linejoin="round" d="M19.5 12h-15"></path></svg></button>`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div>`);
          }
          $$renderer3.push(`<!--]-->`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div>`);
      }
      $$renderer3.push(`<!--]--></div> `);
      if (showSetDefault) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="relative text-left mt-[1px] ml-1 text-[0.7rem] text-gray-600 dark:text-gray-400 font-primary"><button>${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Set as default"))}</button></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { selectedModels, disabled, showSetDefault });
  });
}
function AdjustmentsHorizontal($$renderer, $$props) {
  let className = fallback($$props["className"], "w-4 h-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke="currentColor" fill="currentColor"${attr_class(clsx(className))}${attr("stroke-width", strokeWidth)}><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 1 1-3 0m3 0a1.5 1.5 0 1 0-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-9.75 0h9.75"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function Menu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let shareEnabled = fallback($$props["shareEnabled"], false);
    let shareHandler = $$props["shareHandler"];
    let moveChatHandler = $$props["moveChatHandler"];
    let archiveChatHandler = $$props["archiveChatHandler"];
    let chat = $$props["chat"];
    let onClose = fallback($$props["onClose"], () => {
    });
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    Dropdown($$renderer2, {
      children: ($$renderer3) => {
        $$renderer3.push(`<!--[-->`);
        slot($$renderer3, $$props, "default", {}, null);
        $$renderer3.push(`<!--]-->`);
      },
      $$slots: {
        default: true,
        content: ($$renderer3) => {
          $$renderer3.push(`<div slot="content">`);
          Menu_content($$renderer3, {
            class: "w-full max-w-[200px] rounded-2xl px-1 py-1  border border-gray-100  dark:border-gray-800 z-50 bg-white dark:bg-gray-850 dark:text-white shadow-lg transition",
            sideOffset: 8,
            side: "bottom",
            align: "end",
            transition: flyAndScale,
            children: ($$renderer4) => {
              if (store_get($$store_subs ??= {}, "$mobile", mobile) && (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user)?.permissions.chat?.controls ?? true))) {
                $$renderer4.push("<!--[-->");
                Menu_item($$renderer4, {
                  class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                  id: "chat-controls-button",
                  children: ($$renderer5) => {
                    AdjustmentsHorizontal($$renderer5, { className: " size-4", strokeWidth: "1.5" });
                    $$renderer5.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Controls"))}</div>`);
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> `);
              Menu_item($$renderer4, {
                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                id: "chat-overview-button",
                children: ($$renderer5) => {
                  Map$1($$renderer5, { className: " size-4", strokeWidth: "1.5" });
                  $$renderer5.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Overview"))}</div>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              if ((store_get($$store_subs ??= {}, "$artifactContents", artifactContents) ?? []).length > 0) {
                $$renderer4.push("<!--[-->");
                Menu_item($$renderer4, {
                  class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                  id: "chat-overview-button",
                  children: ($$renderer5) => {
                    Cube($$renderer5, { className: " size-4", strokeWidth: "1.5" });
                    $$renderer5.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Artifacts"))}</div>`);
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> <hr class="border-gray-50/30 dark:border-gray-800/30 my-1"/> `);
              if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled) && (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user).permissions?.chat?.share ?? true))) {
                $$renderer4.push("<!--[-->");
                Menu_item($$renderer4, {
                  class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                  id: "chat-share-button",
                  children: ($$renderer5) => {
                    Share($$renderer5, { strokeWidth: "1.5" });
                    $$renderer5.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Share"))}</div>`);
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> `);
              Menu_sub($$renderer4, {
                children: ($$renderer5) => {
                  Menu_sub_trigger($$renderer5, {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                    children: ($$renderer6) => {
                      Download($$renderer6, { strokeWidth: "1.5" });
                      $$renderer6.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Download"))}</div>`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Menu_sub_content($$renderer5, {
                    class: "w-full rounded-2xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white border border-gray-100  dark:border-gray-800 shadow-lg max-h-52 overflow-y-auto scrollbar-hidden",
                    transition: flyAndScale,
                    sideOffset: 8,
                    children: ($$renderer6) => {
                      if (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user).permissions?.chat?.export ?? true)) {
                        $$renderer6.push("<!--[-->");
                        Menu_item($$renderer6, {
                          class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                          children: ($$renderer7) => {
                            $$renderer7.push(`<div class="flex items-center line-clamp-1">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Export chat (.json)"))}</div>`);
                          },
                          $$slots: { default: true }
                        });
                      } else {
                        $$renderer6.push("<!--[!-->");
                      }
                      $$renderer6.push(`<!--]--> `);
                      Menu_item($$renderer6, {
                        class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<div class="flex items-center line-clamp-1">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Plain text (.txt)"))}</div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Menu_item($$renderer6, {
                        class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<div class="flex items-center line-clamp-1">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("PDF document (.pdf)"))}</div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!---->`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Menu_item($$renderer4, {
                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                id: "chat-copy-button",
                children: ($$renderer5) => {
                  Clipboard($$renderer5, { className: " size-4", strokeWidth: "1.5" });
                  $$renderer5.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Copy"))}</div>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled) && chat?.id) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<hr class="border-gray-50/30 dark:border-gray-800/30 my-1"/> `);
                if (store_get($$store_subs ??= {}, "$folders", folders$1).length > 0) {
                  $$renderer4.push("<!--[-->");
                  Menu_sub($$renderer4, {
                    children: ($$renderer5) => {
                      Menu_sub_trigger($$renderer5, {
                        class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl select-none w-full",
                        children: ($$renderer6) => {
                          Folder($$renderer6, { strokeWidth: "1.5" });
                          $$renderer6.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Move"))}</div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer5.push(`<!----> `);
                      Menu_sub_content($$renderer5, {
                        class: "w-full rounded-2xl p-1 z-50 bg-white dark:bg-gray-850 dark:text-white border border-gray-100  dark:border-gray-800 shadow-lg max-h-52 overflow-y-auto scrollbar-hidden",
                        transition: flyAndScale,
                        sideOffset: 8,
                        children: ($$renderer6) => {
                          $$renderer6.push(`<!--[-->`);
                          const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$folders", folders$1).sort((a, b) => b.updated_at - a.updated_at));
                          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                            let folder = each_array[$$index];
                            if (folder?.id) {
                              $$renderer6.push("<!--[-->");
                              Menu_item($$renderer6, {
                                class: "flex gap-2 items-center px-3 py-1.5 text-sm cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                                children: ($$renderer7) => {
                                  Folder($$renderer7, { strokeWidth: "1.5" });
                                  $$renderer7.push(`<!----> <div class="flex items-center">${escape_html(folder.name ?? "Folder")}</div>`);
                                },
                                $$slots: { default: true }
                              });
                            } else {
                              $$renderer6.push("<!--[!-->");
                            }
                            $$renderer6.push(`<!--]-->`);
                          }
                          $$renderer6.push(`<!--]-->`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer5.push(`<!---->`);
                    },
                    $$slots: { default: true }
                  });
                } else {
                  $$renderer4.push("<!--[!-->");
                }
                $$renderer4.push(`<!--]--> `);
                Menu_item($$renderer4, {
                  class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-xl",
                  children: ($$renderer5) => {
                    ArchiveBox($$renderer5, { className: "size-4", strokeWidth: "1.5" });
                    $$renderer5.push(`<!----> <div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Archive"))}</div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> <hr class="border-gray-50/30 dark:border-gray-800/30 my-1"/> <div class="flex p-1">`);
                Tags_1($$renderer4, { chatId: chat.id });
                $$renderer4.push(`<!----></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div>`);
        }
      }
    });
    $$renderer2.push(`<!---->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      shareEnabled,
      shareHandler,
      moveChatHandler,
      archiveChatHandler,
      chat,
      onClose
    });
  });
}
function ChatBubbleDotted($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="2.5 3.5"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function ChatBubbleDottedChecked($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path d="M8 12L11 15L16 10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="2.5 3.5"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function ChatPlus($$renderer, $$props) {
  let className = fallback($$props["className"], "w-4 h-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path d="M9 12H12M15 12H12M12 12V9M12 12V15" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z" stroke-linecap="round" stroke-linejoin="round"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function ChatCheck($$renderer, $$props) {
  let className = fallback($$props["className"], "w-4 h-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path d="M8 12L11 15L16 10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 13.8214 2.48697 15.5291 3.33782 17L2.5 21.5L7 20.6622C8.47087 21.513 10.1786 22 12 22Z" stroke-linecap="round" stroke-linejoin="round"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function Navbar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let initNewChat = $$props["initNewChat"];
    let shareEnabled = fallback($$props["shareEnabled"], false);
    let scrollTop = fallback($$props["scrollTop"], 0);
    let chat = $$props["chat"];
    let history = $$props["history"];
    let selectedModels = $$props["selectedModels"];
    let showModelSelector = fallback($$props["showModelSelector"], true);
    let onSaveTempChat = $$props["onSaveTempChat"];
    let archiveChatHandler = $$props["archiveChatHandler"];
    let moveChatHandler = $$props["moveChatHandler"];
    let closedBannerIds = [];
    let showShareChatModal = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      ShareChatModal($$renderer3, {
        chatId: store_get($$store_subs ??= {}, "$chatId", chatId),
        get show() {
          return showShareChatModal;
        },
        set show($$value) {
          showShareChatModal = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> <button id="new-chat-button" class="hidden" aria-label="New Chat"></button> <nav${attr_class(`sticky top-0 z-30 w-full ${stringify(chat?.id ? "pt-0.5 pb-1" : "pt-1 pb-1")} -mb-12 flex flex-col items-center drag-region`)}><div class="flex items-center w-full pl-1.5 pr-1"><div id="navbar-bg-gradient-to-b"${attr_class(`${stringify(chat?.id ? "visible" : "invisible")} bg-linear-to-b via-40% to-97% from-white/90 via-white/50 to-transparent dark:from-gray-900/90 dark:via-gray-900/50 dark:to-transparent pointer-events-none absolute inset-0 -bottom-10 z-[-1]`)}></div> <div class="flex max-w-full w-full mx-auto px-1.5 md:px-2 pt-0.5 bg-transparent"><div class="flex items-center w-full max-w-full">`);
      if (store_get($$store_subs ??= {}, "$mobile", mobile) && !store_get($$store_subs ??= {}, "$showSidebar", showSidebar)) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="-translate-x-0.5 mr-1 mt-1 self-start flex flex-none items-center text-gray-600 dark:text-gray-400">`);
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? store_get($$store_subs ??= {}, "$i18n", i18n).t("Close Sidebar") : store_get($$store_subs ??= {}, "$i18n", i18n).t("Open Sidebar"),
          children: ($$renderer4) => {
            $$renderer4.push(`<button class="cursor-pointer flex rounded-lg hover:bg-gray-100 dark:hover:bg-gray-850 transition"><div class="self-center p-1.5">`);
            Sidebar($$renderer4, {});
            $$renderer4.push(`<!----></div></button>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div${attr_class(`flex-1 overflow-hidden max-w-full py-0.5 ${stringify(store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? "ml-1" : "")} `)}>`);
      if (showModelSelector) {
        $$renderer3.push("<!--[-->");
        ModelSelector($$renderer3, {
          showSetDefault: !shareEnabled,
          get selectedModels() {
            return selectedModels;
          },
          set selectedModels($$value) {
            selectedModels = $$value;
            $$settled = false;
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="self-start flex flex-none items-center text-gray-600 dark:text-gray-400">`);
      if (store_get($$store_subs ??= {}, "$user", user)?.role === "user" ? (store_get($$store_subs ??= {}, "$user", user)?.permissions?.chat?.temporary ?? true) && !(store_get($$store_subs ??= {}, "$user", user)?.permissions?.chat?.temporary_enforced ?? false) : true) {
        $$renderer3.push("<!--[-->");
        if (!chat?.id) {
          $$renderer3.push("<!--[-->");
          Tooltip($$renderer3, {
            content: store_get($$store_subs ??= {}, "$i18n", i18n).t(`Temporary Chat`),
            children: ($$renderer4) => {
              $$renderer4.push(`<button class="flex cursor-pointer px-2 py-2 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-850 transition" id="temporary-chat-button"><div class="m-auto self-center">`);
              if (store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
                $$renderer4.push("<!--[-->");
                ChatBubbleDottedChecked($$renderer4, { className: " size-4.5", strokeWidth: "1.5" });
              } else {
                $$renderer4.push("<!--[!-->");
                ChatBubbleDotted($$renderer4, { className: " size-4.5", strokeWidth: "1.5" });
              }
              $$renderer4.push(`<!--]--></div></button>`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
          if (store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
            $$renderer3.push("<!--[-->");
            Tooltip($$renderer3, {
              content: store_get($$store_subs ??= {}, "$i18n", i18n).t(`Save Chat`),
              children: ($$renderer4) => {
                $$renderer4.push(`<button class="flex cursor-pointer px-2 py-2 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-850 transition" id="save-temporary-chat-button"><div class="m-auto self-center">`);
                ChatCheck($$renderer4, { className: " size-4.5", strokeWidth: "1.5" });
                $$renderer4.push(`<!----></div></button>`);
              },
              $$slots: { default: true }
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (store_get($$store_subs ??= {}, "$mobile", mobile) && !store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled) && chat && chat.id) {
        $$renderer3.push("<!--[-->");
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("New Chat"),
          children: ($$renderer4) => {
            $$renderer4.push(`<button${attr_class(` flex ${stringify(store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? "md:hidden" : "")} cursor-pointer px-2 py-2 rounded-xl text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-gray-850 transition`)} aria-label="New Chat"><div class="m-auto self-center">`);
            ChatPlus($$renderer4, { className: " size-4.5", strokeWidth: "1.5" });
            $$renderer4.push(`<!----></div></button>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (shareEnabled && chat && (chat.id || store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled))) {
        $$renderer3.push("<!--[-->");
        Menu($$renderer3, {
          chat,
          shareEnabled,
          shareHandler: () => {
            showShareChatModal = !showShareChatModal;
          },
          archiveChatHandler: () => {
            archiveChatHandler(chat.id);
          },
          moveChatHandler,
          children: ($$renderer4) => {
            $$renderer4.push(`<button class="flex cursor-pointer px-2 py-2 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-850 transition" id="chat-context-menu-button"><div class="m-auto self-center">`);
            EllipsisHorizontal($$renderer4, { className: " size-5", strokeWidth: "1.5" });
            $$renderer4.push(`<!----></div></button>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user)?.permissions.chat?.controls ?? true)) {
        $$renderer3.push("<!--[-->");
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Controls"),
          children: ($$renderer4) => {
            $$renderer4.push(`<button class="flex cursor-pointer px-2 py-2 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-850 transition" aria-label="Controls"><div class="m-auto self-center">`);
            Knobs($$renderer4, { className: " size-5", strokeWidth: "1" });
            $$renderer4.push(`<!----></div></button>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (store_get($$store_subs ??= {}, "$user", user) !== void 0 && store_get($$store_subs ??= {}, "$user", user) !== null) {
        $$renderer3.push("<!--[-->");
        UserMenu($$renderer3, {
          className: "max-w-[240px]",
          role: store_get($$store_subs ??= {}, "$user", user)?.role,
          help: true,
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="select-none flex rounded-xl p-1.5 w-full hover:bg-gray-50 dark:hover:bg-gray-850 transition"><div class="self-center"><span class="sr-only">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("User menu"))}</span> <img${attr("src", `${WEBUI_API_BASE_URL}/users/${store_get($$store_subs ??= {}, "$user", user)?.id}/profile/image`)} class="size-6 object-cover rounded-full" alt="" draggable="false"/></div></div>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div></div></div></div> `);
      if (store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled) && (store_get($$store_subs ??= {}, "$chatId", chatId) ?? "").startsWith("local:")) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="w-full z-30 text-center"><div class="text-xs text-gray-500">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Temporary Chat"))}</div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="absolute top-[100%] left-0 right-0 h-fit">`);
      if (!history.currentId && !store_get($$store_subs ??= {}, "$chatId", chatId) && (store_get($$store_subs ??= {}, "$banners", banners).length > 0 || (store_get($$store_subs ??= {}, "$config", config)?.license_metadata?.type ?? null) === "trial" || (store_get($$store_subs ??= {}, "$config", config)?.license_metadata?.seats ?? null) !== null && store_get($$store_subs ??= {}, "$config", config)?.user_count > store_get($$store_subs ??= {}, "$config", config)?.license_metadata?.seats)) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="w-full z-30"><div class="flex flex-col gap-1 w-full">`);
        if ((store_get($$store_subs ??= {}, "$config", config)?.license_metadata?.type ?? null) === "trial") {
          $$renderer3.push("<!--[-->");
          Banner($$renderer3, {
            banner: {
              type: "info",
              title: "Trial License",
              content: store_get($$store_subs ??= {}, "$i18n", i18n).t("You are currently using a trial license. Please contact support to upgrade your license.")
            }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if ((store_get($$store_subs ??= {}, "$config", config)?.license_metadata?.seats ?? null) !== null && store_get($$store_subs ??= {}, "$config", config)?.user_count > store_get($$store_subs ??= {}, "$config", config)?.license_metadata?.seats) {
          $$renderer3.push("<!--[-->");
          Banner($$renderer3, {
            banner: {
              type: "error",
              title: "License Error",
              content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Exceeded the number of seats in your license. Please contact support to increase the number of seats.")
            }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> <!--[-->`);
        const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$banners", banners).filter((b) => ![
          ...JSON.parse(localStorage.getItem("dismissedBannerIds") ?? "[]"),
          ...closedBannerIds
        ].includes(b.id)));
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let banner = each_array[$$index];
          Banner($$renderer3, { banner });
        }
        $$renderer3.push(`<!--]--></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div></nav>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      initNewChat,
      shareEnabled,
      scrollTop,
      chat,
      history,
      selectedModels,
      showModelSelector,
      onSaveTempChat,
      archiveChatHandler,
      moveChatHandler
    });
  });
}
function Valves_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let tab = "tools";
    let selectedId = "";
    let loading = false;
    let valvesSpec = null;
    let valves = {};
    const getUserValves = async () => {
      loading = true;
      {
        valves = await getUserValvesById(localStorage.token, selectedId);
        valvesSpec = await getUserValvesSpecById(localStorage.token, selectedId);
      }
      if (valvesSpec) {
        for (const property in valvesSpec.properties) {
          if (valvesSpec.properties[property]?.type === "array") {
            valves[property] = (valves[property] ?? []).join(",");
          }
        }
      }
      loading = false;
    };
    const init = async () => {
      loading = true;
      if (store_get($$store_subs ??= {}, "$functions", functions) === null) {
        functions.set(await getFunctions(localStorage.token));
      }
      if (store_get($$store_subs ??= {}, "$tools", tools) === null) {
        tools.set(await getTools(localStorage.token));
      }
      loading = false;
    };
    {
      selectedId = "";
    }
    if (selectedId) {
      getUserValves();
    }
    if (show) {
      init();
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (show && !loading) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<form class="flex flex-col h-full justify-between space-y-3 text-sm"><div class="flex flex-col"><div class="space-y-1"><div class="flex gap-2"><div class="flex-1">`);
        $$renderer3.select(
          {
            class: "w-full rounded-sm text-xs py-2 px-1 bg-transparent outline-hidden",
            value: tab,
            placeholder: store_get($$store_subs ??= {}, "$i18n", i18n).t("Select")
          },
          ($$renderer4) => {
            $$renderer4.option({ value: "tools", class: "bg-gray-100 dark:bg-gray-800" }, ($$renderer5) => {
              $$renderer5.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Tools"))}`);
            });
            $$renderer4.option({ value: "functions", class: "bg-gray-100 dark:bg-gray-800" }, ($$renderer5) => {
              $$renderer5.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Functions"))}`);
            });
          }
        );
        $$renderer3.push(`</div> <div class="flex-1">`);
        $$renderer3.select(
          {
            class: "w-full rounded-sm py-2 px-1 text-xs bg-transparent outline-hidden",
            value: selectedId
          },
          ($$renderer4) => {
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.option(
                {
                  value: "",
                  selected: true,
                  disabled: true,
                  class: "bg-gray-100 dark:bg-gray-800"
                },
                ($$renderer5) => {
                  $$renderer5.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Select a tool"))}`);
                }
              );
              $$renderer4.push(` <!--[-->`);
              const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$tools", tools).filter((tool) => !tool?.id?.startsWith("server:")).sort((a, b) => (a.name ?? "").localeCompare(b.name ?? "")));
              for (let toolIdx = 0, $$length = each_array.length; toolIdx < $$length; toolIdx++) {
                let tool = each_array[toolIdx];
                $$renderer4.option({ value: tool.id, class: "bg-gray-100 dark:bg-gray-800" }, ($$renderer5) => {
                  $$renderer5.push(`${escape_html(tool.name)}`);
                });
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]-->`);
          }
        );
        $$renderer3.push(`</div></div></div> `);
        if (selectedId) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<hr class="border-gray-50/30 dark:border-gray-800/30 my-1 w-full"/> <div class="my-2 text-xs">`);
          if (!loading) {
            $$renderer3.push("<!--[-->");
            Valves($$renderer3, {
              valvesSpec,
              get valves() {
                return valves;
              },
              set valves($$value) {
                valves = $$value;
                $$settled = false;
              }
            });
          } else {
            $$renderer3.push("<!--[!-->");
            Spinner($$renderer3, { className: "size-5" });
          }
          $$renderer3.push(`<!--]--></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div></form>`);
      } else {
        $$renderer3.push("<!--[!-->");
        Spinner($$renderer3, { className: "size-4" });
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show });
  });
}
function Controls($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let models2 = fallback($$props["models"], () => [], true);
    let chatFiles = fallback($$props["chatFiles"], () => [], true);
    let params = fallback($$props["params"], () => ({}), true);
    let showValves = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="dark:text-white"><div class="flex items-center justify-between dark:text-gray-100 mb-2"><div class="text-lg font-medium self-center font-primary">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Chat Controls"))}</div> <button class="self-center">`);
      XMark($$renderer3, { className: "size-3.5" });
      $$renderer3.push(`<!----></button></div> `);
      if (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user)?.permissions.chat?.controls ?? true)) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="dark:text-gray-200 text-sm font-primary py-0.5 px-0.5">`);
        if (chatFiles.length > 0) {
          $$renderer3.push("<!--[-->");
          Collapsible($$renderer3, {
            title: store_get($$store_subs ??= {}, "$i18n", i18n).t("Files"),
            open: true,
            buttonClassName: "w-full",
            $$slots: {
              content: ($$renderer4) => {
                $$renderer4.push(`<div class="flex flex-col gap-1 mt-1.5" slot="content"><!--[-->`);
                const each_array = ensure_array_like(chatFiles);
                for (let fileIdx = 0, $$length = each_array.length; fileIdx < $$length; fileIdx++) {
                  let file = each_array[fileIdx];
                  FileItem($$renderer4, {
                    className: "w-full",
                    item: file,
                    edit: true,
                    url: file?.url ? file.url : null,
                    name: file.name,
                    type: file.type,
                    size: file?.size,
                    dismissible: true,
                    small: true
                  });
                }
                $$renderer4.push(`<!--]--></div>`);
              }
            }
          });
          $$renderer3.push(`<!----> <hr class="my-2 border-gray-50 dark:border-gray-700/10"/>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user)?.permissions.chat?.valves ?? true)) {
          $$renderer3.push("<!--[-->");
          Collapsible($$renderer3, {
            title: store_get($$store_subs ??= {}, "$i18n", i18n).t("Valves"),
            buttonClassName: "w-full",
            get open() {
              return showValves;
            },
            set open($$value) {
              showValves = $$value;
              $$settled = false;
            },
            $$slots: {
              content: ($$renderer4) => {
                $$renderer4.push(`<div class="text-sm" slot="content">`);
                Valves_1($$renderer4, { show: showValves });
                $$renderer4.push(`<!----></div>`);
              }
            }
          });
          $$renderer3.push(`<!----> <hr class="my-2 border-gray-50 dark:border-gray-700/10"/>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user)?.permissions.chat?.system_prompt ?? true)) {
          $$renderer3.push("<!--[-->");
          Collapsible($$renderer3, {
            title: store_get($$store_subs ??= {}, "$i18n", i18n).t("System Prompt"),
            open: true,
            buttonClassName: "w-full",
            $$slots: {
              content: ($$renderer4) => {
                $$renderer4.push(`<div slot="content"><textarea${attr_class(`w-full text-xs outline-hidden resize-vertical ${stringify(store_get($$store_subs ??= {}, "$settings", settings).highContrastMode ? "border-2 border-gray-300 dark:border-gray-700 rounded-lg bg-gray-50 dark:bg-gray-800 p-2.5" : "py-1.5 bg-transparent")}`)} rows="4"${attr("placeholder", store_get($$store_subs ??= {}, "$i18n", i18n).t("Enter system prompt"))}>`);
                const $$body = escape_html(params.system);
                if ($$body) {
                  $$renderer4.push(`${$$body}`);
                }
                $$renderer4.push(`</textarea></div>`);
              }
            }
          });
          $$renderer3.push(`<!----> <hr class="my-2 border-gray-50 dark:border-gray-700/10"/>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user)?.permissions.chat?.params ?? true)) {
          $$renderer3.push("<!--[-->");
          Collapsible($$renderer3, {
            title: store_get($$store_subs ??= {}, "$i18n", i18n).t("Advanced Params"),
            open: true,
            buttonClassName: "w-full",
            $$slots: {
              content: ($$renderer4) => {
                $$renderer4.push(`<div class="text-sm mt-1.5" slot="content"><div>`);
                AdvancedParams($$renderer4, {
                  admin: store_get($$store_subs ??= {}, "$user", user)?.role === "admin",
                  custom: true,
                  get params() {
                    return params;
                  },
                  set params($$value) {
                    params = $$value;
                    $$settled = false;
                  }
                });
                $$renderer4.push(`<!----></div></div>`);
              }
            }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { models: models2, chatFiles, params });
  });
}
function VideoInputMenu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    getContext("i18n");
    let onClose = fallback($$props["onClose"], () => {
    });
    let devices = $$props["devices"];
    let show = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Dropdown($$renderer3, {
        get show() {
          return show;
        },
        set show($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<!--[-->`);
          slot($$renderer4, $$props, "default", {}, null);
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: {
          default: true,
          content: ($$renderer4) => {
            $$renderer4.push(`<div slot="content">`);
            Menu_content($$renderer4, {
              class: "w-full max-w-[180px] rounded-lg p-1 border border-gray-100  dark:border-gray-800 z-9999 bg-white dark:bg-gray-900 dark:text-white shadow-xs",
              sideOffset: 6,
              side: "top",
              align: "start",
              transition: flyAndScale,
              children: ($$renderer5) => {
                $$renderer5.push(`<!--[-->`);
                const each_array = ensure_array_like(devices);
                for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                  let device = each_array[$$index];
                  Menu_item($$renderer5, {
                    class: "flex gap-2 items-center px-3 py-1.5 text-sm  cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-800 rounded-md",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<div class="flex items-center"><div class="line-clamp-1">${escape_html(device?.label ?? "Camera")}</div></div>`);
                    },
                    $$slots: { default: true }
                  });
                }
                $$renderer5.push(`<!--]-->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div>`);
          }
        }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { onClose, devices });
  });
}
function CallOverlay($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let eventTarget = $$props["eventTarget"];
    let submitPrompt = $$props["submitPrompt"];
    let stopResponse = $$props["stopResponse"];
    let files = $$props["files"];
    let chatId2 = $$props["chatId"];
    let modelId = $$props["modelId"];
    let model = null;
    let loading = false;
    let confirmed = false;
    let assistantSpeaking = false;
    let emoji = null;
    let camera = false;
    let cameraStream = null;
    let chatStreaming = false;
    let rmsLevel = 0;
    let hasStartedSpeaking = false;
    let mediaRecorder;
    let audioStream = null;
    let audioChunks = [];
    let videoInputDevices = [];
    const stopVideoStream = async () => {
      if (cameraStream) {
        const tracks = cameraStream.getTracks();
        tracks.forEach((track) => track.stop());
      }
      cameraStream = null;
    };
    const takeScreenshot = () => {
      const video = document.getElementById("camera-feed");
      const canvas = document.getElementById("camera-canvas");
      if (!canvas) {
        return;
      }
      const context = canvas.getContext("2d");
      canvas.width = video.videoWidth;
      canvas.height = video.videoHeight;
      context.drawImage(video, 0, 0, video.videoWidth, video.videoHeight);
      const dataURL = canvas.toDataURL("image/png");
      /* @__PURE__ */ console.log(dataURL);
      return dataURL;
    };
    const stopCamera = async () => {
      await stopVideoStream();
      camera = false;
    };
    const MIN_DECIBELS = -55;
    const transcribeHandler = async (audioBlob) => {
      await tick();
      const file = blobToFile(audioBlob, "recording.wav");
      const res = await transcribeAudio(localStorage.token, file, store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      if (res) {
        /* @__PURE__ */ console.log(res.text);
        if (res.text !== "") {
          const _responses = await submitPrompt(res.text, { _raw: true });
          /* @__PURE__ */ console.log(_responses);
        }
      }
    };
    const stopRecordingCallback = async (_continue = true) => {
      if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
        /* @__PURE__ */ console.log("%c%s", "color: red; font-size: 20px;", "🚨 stopRecordingCallback 🚨");
        const _audioChunks = audioChunks.slice(0);
        audioChunks = [];
        mediaRecorder = false;
        if (_continue) {
          startRecording();
        }
        if (confirmed) {
          loading = true;
          emoji = null;
          if (cameraStream) {
            const imageUrl = takeScreenshot();
            files = [{ type: "image", url: imageUrl }];
          }
          const audioBlob = new Blob(_audioChunks, { type: "audio/wav" });
          await transcribeHandler(audioBlob);
          confirmed = false;
          loading = false;
        }
      } else {
        audioChunks = [];
        mediaRecorder = false;
        if (audioStream) {
          const tracks = audioStream.getTracks();
          tracks.forEach((track) => track.stop());
        }
        audioStream = null;
      }
    };
    const startRecording = async () => {
      if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
        if (!audioStream) {
          audioStream = await navigator.mediaDevices.getUserMedia({
            audio: {
              echoCancellation: true,
              noiseSuppression: true,
              autoGainControl: true
            }
          });
        }
        mediaRecorder = new MediaRecorder(audioStream);
        mediaRecorder.onstart = () => {
          /* @__PURE__ */ console.log("Recording started");
          audioChunks = [];
        };
        mediaRecorder.ondataavailable = (event) => {
          if (hasStartedSpeaking) {
            audioChunks.push(event.data);
          }
        };
        mediaRecorder.onstop = (e) => {
          /* @__PURE__ */ console.log("Recording stopped", audioStream, e);
          stopRecordingCallback();
        };
        analyseAudio(audioStream);
      }
    };
    const stopAudioStream = async () => {
      try {
        if (mediaRecorder) {
          mediaRecorder.stop();
        }
      } catch (error) {
        /* @__PURE__ */ console.log("Error stopping audio stream:", error);
      }
      if (!audioStream) return;
      audioStream.getAudioTracks().forEach(function(track) {
        track.stop();
      });
      audioStream = null;
    };
    const calculateRMS = (data) => {
      let sumSquares = 0;
      for (let i = 0; i < data.length; i++) {
        const normalizedValue = (data[i] - 128) / 128;
        sumSquares += normalizedValue * normalizedValue;
      }
      return Math.sqrt(sumSquares / data.length);
    };
    const analyseAudio = (stream) => {
      const audioContext = new AudioContext();
      const audioStreamSource = audioContext.createMediaStreamSource(stream);
      const analyser = audioContext.createAnalyser();
      analyser.minDecibels = MIN_DECIBELS;
      audioStreamSource.connect(analyser);
      const bufferLength = analyser.frequencyBinCount;
      const domainData = new Uint8Array(bufferLength);
      const timeDomainData = new Uint8Array(analyser.fftSize);
      let lastSoundTime = Date.now();
      hasStartedSpeaking = false;
      /* @__PURE__ */ console.log("🔊 Sound detection started", lastSoundTime, hasStartedSpeaking);
      const detectSound = () => {
        const processFrame = () => {
          if (!mediaRecorder || !store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
            return;
          }
          if (assistantSpeaking && !(store_get($$store_subs ??= {}, "$settings", settings)?.voiceInterruption ?? false)) {
            analyser.maxDecibels = 0;
            analyser.minDecibels = -1;
          } else {
            analyser.minDecibels = MIN_DECIBELS;
            analyser.maxDecibels = -30;
          }
          analyser.getByteTimeDomainData(timeDomainData);
          analyser.getByteFrequencyData(domainData);
          rmsLevel = calculateRMS(timeDomainData);
          const hasSound = domainData.some((value) => value > 0);
          if (hasSound) {
            /* @__PURE__ */ console.log("%c%s", "color: red; font-size: 20px;", "🔊 Sound detected");
            if (mediaRecorder && mediaRecorder.state !== "recording") {
              mediaRecorder.start();
            }
            if (!hasStartedSpeaking) {
              hasStartedSpeaking = true;
              stopAllAudio();
            }
            lastSoundTime = Date.now();
          }
          if (hasStartedSpeaking) {
            if (Date.now() - lastSoundTime > 2e3) {
              confirmed = true;
              if (mediaRecorder) {
                /* @__PURE__ */ console.log("%c%s", "color: red; font-size: 20px;", "🔇 Silence detected");
                mediaRecorder.stop();
                return;
              }
            }
          }
          window.requestAnimationFrame(processFrame);
        };
        window.requestAnimationFrame(processFrame);
      };
      detectSound();
    };
    let finishedMessages = {};
    let currentMessageId = null;
    let currentUtterance = null;
    const getVoiceId = () => {
      if (store_get($$store_subs ??= {}, "$settings", settings)?.audio?.tts?.defaultVoice === store_get($$store_subs ??= {}, "$config", config).audio.tts.voice) {
        return store_get($$store_subs ??= {}, "$settings", settings)?.audio?.tts?.voice ?? store_get($$store_subs ??= {}, "$config", config)?.audio?.tts?.voice;
      }
      return store_get($$store_subs ??= {}, "$config", config)?.audio?.tts?.voice;
    };
    const speakSpeechSynthesisHandler = (content) => {
      if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
        return new Promise((resolve) => {
          let voices = [];
          const getVoicesLoop = setInterval(
            async () => {
              voices = await speechSynthesis.getVoices();
              if (voices.length > 0) {
                clearInterval(getVoicesLoop);
                const voiceId = getVoiceId();
                const voice = voices?.filter((v) => v.voiceURI === voiceId)?.at(0) ?? void 0;
                currentUtterance = new SpeechSynthesisUtterance(content);
                currentUtterance.rate = store_get($$store_subs ??= {}, "$settings", settings).audio?.tts?.playbackRate ?? 1;
                if (voice) {
                  currentUtterance.voice = voice;
                }
                speechSynthesis.speak(currentUtterance);
                currentUtterance.onend = async (e) => {
                  await new Promise((r) => setTimeout(r, 200));
                  resolve(e);
                };
              }
            },
            100
          );
        });
      } else {
        return Promise.resolve();
      }
    };
    const playAudio = (audio) => {
      if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
        return new Promise((resolve) => {
          const audioElement = document.getElementById("audioElement");
          if (audioElement) {
            audioElement.src = audio.src;
            audioElement.muted = true;
            audioElement.playbackRate = store_get($$store_subs ??= {}, "$settings", settings).audio?.tts?.playbackRate ?? 1;
            audioElement.play().then(() => {
              audioElement.muted = false;
            }).catch((error) => {
              /* @__PURE__ */ console.error(error);
            });
            audioElement.onended = async (e) => {
              await new Promise((r) => setTimeout(r, 100));
              resolve(e);
            };
          }
        });
      } else {
        return Promise.resolve();
      }
    };
    const stopAllAudio = async () => {
      assistantSpeaking = false;
      if (chatStreaming) {
        stopResponse();
      }
      if (currentUtterance) {
        speechSynthesis.cancel();
        currentUtterance = null;
      }
      const audioElement = document.getElementById("audioElement");
      if (audioElement) {
        audioElement.muted = true;
        audioElement.pause();
        audioElement.currentTime = 0;
      }
    };
    let audioAbortController = new AbortController();
    const audioCache = /* @__PURE__ */ new Map();
    const emojiCache = /* @__PURE__ */ new Map();
    const fetchAudio = async (content) => {
      if (!audioCache.has(content)) {
        try {
          if (store_get($$store_subs ??= {}, "$settings", settings)?.showEmojiInCall ?? false) {
            const emoji2 = await generateEmoji(localStorage.token, modelId, content, chatId2);
            if (emoji2) {
              emojiCache.set(content, emoji2);
            }
          }
          if (store_get($$store_subs ??= {}, "$settings", settings).audio?.tts?.engine === "browser-kokoro") {
            const url2 = await store_get($$store_subs ??= {}, "$TTSWorker", TTSWorker).generate({ text: content, voice: getVoiceId() }).catch((error) => {
              /* @__PURE__ */ console.error(error);
              toast.error(`${error}`);
            });
            if (url2) {
              audioCache.set(content, new Audio(url2));
            }
          } else if (store_get($$store_subs ??= {}, "$config", config).audio.tts.engine !== "") {
            const res = await synthesizeOpenAISpeech(localStorage.token, getVoiceId(), content).catch((error) => {
              /* @__PURE__ */ console.error(error);
              return null;
            });
            if (res) {
              const blob = await res.blob();
              const blobUrl = URL.createObjectURL(blob);
              audioCache.set(content, new Audio(blobUrl));
            }
          } else {
            audioCache.set(content, true);
          }
        } catch (error) {
          /* @__PURE__ */ console.error("Error synthesizing speech:", error);
        }
      }
      return audioCache.get(content);
    };
    let messages = {};
    const monitorAndPlayAudio = async (id, signal) => {
      while (!signal.aborted) {
        if (messages[id] && messages[id].length > 0) {
          const content = messages[id].shift();
          if (audioCache.has(content)) {
            if ((store_get($$store_subs ??= {}, "$settings", settings)?.showEmojiInCall ?? false) && emojiCache.has(content)) {
              emoji = emojiCache.get(content);
            } else {
              emoji = null;
            }
            if (store_get($$store_subs ??= {}, "$config", config).audio.tts.engine !== "") {
              try {
                /* @__PURE__ */ console.log("%c%s", "color: red; font-size: 20px;", `Playing audio for content: ${content}`);
                const audio = audioCache.get(content);
                await playAudio(audio);
                /* @__PURE__ */ console.log(`Played audio for content: ${content}`);
                await new Promise((resolve) => setTimeout(resolve, 200));
              } catch (error) {
                /* @__PURE__ */ console.error("Error playing audio:", error);
              }
            } else {
              await speakSpeechSynthesisHandler(content);
            }
          } else {
            messages[id].unshift(content);
            /* @__PURE__ */ console.log(`Audio for "${content}" not yet available in the cache, re-queued...`);
            await new Promise((resolve) => setTimeout(resolve, 200));
          }
        } else if (finishedMessages[id] && messages[id] && messages[id].length === 0) {
          assistantSpeaking = false;
          break;
        } else {
          await new Promise((resolve) => setTimeout(resolve, 200));
        }
      }
      /* @__PURE__ */ console.log(`Audio monitoring and playing stopped for message ID ${id}`);
    };
    const chatStartHandler = async (e) => {
      const { id } = e.detail;
      chatStreaming = true;
      if (currentMessageId !== id) {
        /* @__PURE__ */ console.log(`Received chat start event for message ID ${id}`);
        currentMessageId = id;
        if (audioAbortController) {
          audioAbortController.abort();
        }
        audioAbortController = new AbortController();
        assistantSpeaking = true;
        monitorAndPlayAudio(id, audioAbortController.signal);
      }
    };
    const chatEventHandler = async (e) => {
      const { id, content } = e.detail;
      if (currentMessageId === id) {
        /* @__PURE__ */ console.log(`Received chat event for message ID ${id}: ${content}`);
        try {
          if (messages[id] === void 0) {
            messages[id] = [content];
          } else {
            messages[id].push(content);
          }
          /* @__PURE__ */ console.log(content);
          fetchAudio(content);
        } catch (error) {
          /* @__PURE__ */ console.error("Failed to fetch or play audio:", error);
        }
      }
    };
    const chatFinishHandler = async (e) => {
      const { id, content } = e.detail;
      finishedMessages[id] = true;
      chatStreaming = false;
    };
    onDestroy(async () => {
      await stopAllAudio();
      await stopRecordingCallback(false);
      await stopCamera();
      await stopAudioStream();
      eventTarget.removeEventListener("chat:start", chatStartHandler);
      eventTarget.removeEventListener("chat", chatEventHandler);
      eventTarget.removeEventListener("chat:finish", chatFinishHandler);
      audioAbortController.abort();
      await tick();
      await stopAllAudio();
    });
    if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="max-w-lg w-full h-full max-h-[100dvh] flex flex-col justify-between p-3 md:p-6">`);
      if (camera) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button type="button" class="flex justify-center items-center w-full h-20 min-h-20">`);
        if (emoji) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<div class="transition-all rounded-full"${attr_style(`font-size:${stringify(rmsLevel * 100 > 4 ? "4.5" : rmsLevel * 100 > 2 ? "4.25" : rmsLevel * 100 > 1 ? "3.75" : "3.5")}rem;width: 100%; text-align:center;`)}>${escape_html(emoji)}</div>`);
        } else {
          $$renderer2.push("<!--[!-->");
          if (loading || assistantSpeaking) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<svg class="size-12 text-gray-900 dark:text-gray-400" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><style>
							.spinner_qM83 {
								animation: spinner_8HQG 1.05s infinite;
							}
							.spinner_oXPr {
								animation-delay: 0.1s;
							}
							.spinner_ZTLf {
								animation-delay: 0.2s;
							}
							@keyframes spinner_8HQG {
								0%,
								57.14% {
									animation-timing-function: cubic-bezier(0.33, 0.66, 0.66, 1);
									transform: translate(0);
								}
								28.57% {
									animation-timing-function: cubic-bezier(0.33, 0, 0.66, 0.33);
									transform: translateY(-6px);
								}
								100% {
									transform: translate(0);
								}
							}
						</style><circle class="spinner_qM83" cx="4" cy="12" r="3"></circle><circle class="spinner_qM83 spinner_oXPr" cx="12" cy="12" r="3"></circle><circle class="spinner_qM83 spinner_ZTLf" cx="20" cy="12" r="3"></circle></svg>`);
          } else {
            $$renderer2.push("<!--[!-->");
            $$renderer2.push(`<div${attr_class(` ${stringify(rmsLevel * 100 > 4 ? " size-[4.5rem]" : rmsLevel * 100 > 2 ? " size-16" : rmsLevel * 100 > 1 ? "size-14" : "size-12")} transition-all rounded-full bg-cover bg-center bg-no-repeat`)}${attr_style(`background-image: url('${WEBUI_API_BASE_URL}/models/model/profile/image?id=${model?.id}&lang=${store_get($$store_subs ??= {}, "$i18n", i18n).language}&voice=true');`)}></div>`);
          }
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]--></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <div class="flex justify-center items-center flex-1 h-full w-full max-h-full">`);
      if (!camera) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button type="button">`);
        if (emoji) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<div class="transition-all rounded-full"${attr_style(`font-size:${stringify(rmsLevel * 100 > 4 ? "13" : rmsLevel * 100 > 2 ? "12" : rmsLevel * 100 > 1 ? "11.5" : "11")}rem;width:100%;text-align:center;`)}>${escape_html(emoji)}</div>`);
        } else {
          $$renderer2.push("<!--[!-->");
          if (loading || assistantSpeaking) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<svg class="size-44 text-gray-900 dark:text-gray-400" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><style>
								.spinner_qM83 {
									animation: spinner_8HQG 1.05s infinite;
								}
								.spinner_oXPr {
									animation-delay: 0.1s;
								}
								.spinner_ZTLf {
									animation-delay: 0.2s;
								}
								@keyframes spinner_8HQG {
									0%,
									57.14% {
										animation-timing-function: cubic-bezier(0.33, 0.66, 0.66, 1);
										transform: translate(0);
									}
									28.57% {
										animation-timing-function: cubic-bezier(0.33, 0, 0.66, 0.33);
										transform: translateY(-6px);
									}
									100% {
										transform: translate(0);
									}
								}
							</style><circle class="spinner_qM83" cx="4" cy="12" r="3"></circle><circle class="spinner_qM83 spinner_oXPr" cx="12" cy="12" r="3"></circle><circle class="spinner_qM83 spinner_ZTLf" cx="20" cy="12" r="3"></circle></svg>`);
          } else {
            $$renderer2.push("<!--[!-->");
            $$renderer2.push(`<div${attr_class(` ${stringify(rmsLevel * 100 > 4 ? " size-52" : rmsLevel * 100 > 2 ? "size-48" : rmsLevel * 100 > 1 ? "size-44" : "size-40")} transition-all rounded-full bg-cover bg-center bg-no-repeat`)}${attr_style(`background-image: url('${WEBUI_API_BASE_URL}/models/model/profile/image?id=${model?.id}&lang=${store_get($$store_subs ??= {}, "$i18n", i18n).language}&voice=true');`)}></div>`);
          }
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]--></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="relative flex video-container w-full max-h-full pt-2 pb-4 md:py-6 px-2 h-full"><video id="camera-feed" autoplay class="rounded-2xl h-full min-w-full object-cover object-center" playsinline></video> <canvas id="camera-canvas" style="display:none;"></canvas> <div class="absolute top-4 md:top-8 left-4"><button type="button" class="p-1.5 text-white cursor-pointer backdrop-blur-xl bg-black/10 rounded-full"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="size-6"><path d="M5.28 4.22a.75.75 0 0 0-1.06 1.06L6.94 8l-2.72 2.72a.75.75 0 1 0 1.06 1.06L8 9.06l2.72 2.72a.75.75 0 1 0 1.06-1.06L9.06 8l2.72-2.72a.75.75 0 0 0-1.06-1.06L8 6.94 5.28 4.22Z"></path></svg></button></div></div>`);
      }
      $$renderer2.push(`<!--]--></div> <div class="flex justify-between items-center pb-2 w-full"><div>`);
      if (camera) {
        $$renderer2.push("<!--[-->");
        VideoInputMenu($$renderer2, {
          devices: videoInputDevices,
          children: ($$renderer3) => {
            $$renderer3.push(`<button class="p-3 rounded-full bg-gray-50 dark:bg-gray-900" type="button"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5"><path fill-rule="evenodd" d="M15.312 11.424a5.5 5.5 0 0 1-9.201 2.466l-.312-.311h2.433a.75.75 0 0 0 0-1.5H3.989a.75.75 0 0 0-.75.75v4.242a.75.75 0 0 0 1.5 0v-2.43l.31.31a7 7 0 0 0 11.712-3.138.75.75 0 0 0-1.449-.39Zm1.23-3.723a.75.75 0 0 0 .219-.53V2.929a.75.75 0 0 0-1.5 0V5.36l-.31-.31A7 7 0 0 0 3.239 8.188a.75.75 0 1 0 1.448.389A5.5 5.5 0 0 1 13.89 6.11l.311.31h-2.432a.75.75 0 0 0 0 1.5h4.243a.75.75 0 0 0 .53-.219Z" clip-rule="evenodd"></path></svg></button>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer2.push("<!--[!-->");
        Tooltip($$renderer2, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Camera"),
          children: ($$renderer3) => {
            $$renderer3.push(`<button class="p-3 rounded-full bg-gray-50 dark:bg-gray-900" type="button"><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5"><path stroke-linecap="round" stroke-linejoin="round" d="M6.827 6.175A2.31 2.31 0 0 1 5.186 7.23c-.38.054-.757.112-1.134.175C2.999 7.58 2.25 8.507 2.25 9.574V18a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 18V9.574c0-1.067-.75-1.994-1.802-2.169a47.865 47.865 0 0 0-1.134-.175 2.31 2.31 0 0 1-1.64-1.055l-.822-1.316a2.192 2.192 0 0 0-1.736-1.039 48.774 48.774 0 0 0-5.232 0 2.192 2.192 0 0 0-1.736 1.039l-.821 1.316Z"></path><path stroke-linecap="round" stroke-linejoin="round" d="M16.5 12.75a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM18.75 10.5h.008v.008h-.008V10.5Z"></path></svg></button>`);
          },
          $$slots: { default: true }
        });
      }
      $$renderer2.push(`<!--]--></div> <div><button type="button"><div class="line-clamp-1 text-sm font-medium">`);
      if (loading) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Thinking..."))}`);
      } else {
        $$renderer2.push("<!--[!-->");
        if (assistantSpeaking) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Tap to interrupt"))}`);
        } else {
          $$renderer2.push("<!--[!-->");
          $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Listening..."))}`);
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--></div></button></div> <div><button class="p-3 rounded-full bg-gray-50 dark:bg-gray-900" type="button"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5"><path d="M6.28 5.22a.75.75 0 0 0-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 1 0 1.06 1.06L10 11.06l3.72 3.72a.75.75 0 1 0 1.06-1.06L11.06 10l3.72-3.72a.75.75 0 0 0-1.06-1.06L10 8.94 6.28 5.22Z"></path></svg></button></div></div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      eventTarget,
      submitPrompt,
      stopResponse,
      files,
      chatId: chatId2,
      modelId
    });
  });
}
function ArrowsPointingOut($$renderer, $$props) {
  let className = fallback($$props["className"], "size-4");
  let strokeWidth = fallback($$props["strokeWidth"], "1.5");
  $$renderer.push(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"${attr("stroke-width", strokeWidth)} stroke="currentColor"${attr_class(clsx(className))}><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3.75v4.5m0-4.5h4.5m-4.5 0L9 9M3.75 20.25v-4.5m0 4.5h4.5m-4.5 0L9 15M20.25 3.75h-4.5m4.5 0v4.5m0-4.5L15 9m5.25 11.25h-4.5m4.5 0v-4.5m0 4.5L15 15"></path></svg>`);
  bind_props($$props, { className, strokeWidth });
}
function Artifacts($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let overlay = fallback($$props["overlay"], false);
    let contents = [];
    let selectedContentIdx = 0;
    $$renderer2.push(`<div class="w-full h-full relative flex flex-col bg-white dark:bg-gray-850" id="artifacts-container"><div class="w-full h-full flex flex-col flex-1 relative">`);
    if (contents.length > 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="pointer-events-auto z-20 flex justify-between items-center p-2.5 font-primar text-gray-900 dark:text-white"><div class="flex-1 flex items-center justify-between pr-1"><div class="flex items-center space-x-2"><div class="flex items-center gap-0.5 self-center min-w-fit" dir="ltr"><button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition disabled:cursor-not-allowed"${attr("disabled", contents.length <= 1, true)}><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5"></path></svg></button> <div class="text-xs self-center dark:text-gray-100 min-w-fit">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Version {{selectedVersion}} of {{totalVersions}}", {
        selectedVersion: selectedContentIdx + 1,
        totalVersions: contents.length
      }))}</div> <button class="self-center p-1 hover:bg-black/5 dark:hover:bg-white/5 dark:hover:text-white hover:text-black rounded-md transition disabled:cursor-not-allowed"${attr("disabled", contents.length <= 1, true)}><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5" class="size-3.5"><path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5"></path></svg></button></div></div> <div class="flex items-center gap-1.5"><button class="copy-code-button bg-none border-none text-xs bg-gray-50 hover:bg-gray-100 dark:bg-gray-850 dark:hover:bg-gray-800 transition rounded-md px-1.5 py-0.5">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Copy"))}</button> `);
      Tooltip($$renderer2, {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Download"),
        children: ($$renderer3) => {
          $$renderer3.push(`<button class="bg-none border-none text-xs bg-gray-50 hover:bg-gray-100 dark:bg-gray-850 dark:hover:bg-gray-800 transition rounded-md p-0.5">`);
          Download($$renderer3, { className: "size-3.5" });
          $$renderer3.push(`<!----></button>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      if (contents[selectedContentIdx].type === "iframe") {
        $$renderer2.push("<!--[-->");
        Tooltip($$renderer2, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("Open in full screen"),
          children: ($$renderer3) => {
            $$renderer3.push(`<button class="bg-none border-none text-xs bg-gray-50 hover:bg-gray-100 dark:bg-gray-850 dark:hover:bg-gray-800 transition rounded-md p-0.5">`);
            ArrowsPointingOut($$renderer3, { className: "size-3.5" });
            $$renderer3.push(`<!----></button>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div></div> <button class="self-center pointer-events-auto p-1 rounded-full bg-white dark:bg-gray-850">`);
      XMark($$renderer2, { className: "size-3.5 text-gray-900 dark:text-white" });
      $$renderer2.push(`<!----></button></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (overlay) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="absolute top-0 left-0 right-0 bottom-0 z-10"></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="flex-1 w-full h-full"><div class="h-full flex flex-col">`);
    if (contents.length > 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="max-w-full w-full h-full">`);
      if (contents[selectedContentIdx].type === "iframe") {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<iframe title="Content"${attr("srcdoc", contents[selectedContentIdx].content)} class="w-full border-0 h-full rounded-none"${attr("sandbox", `allow-scripts allow-downloads${stringify(store_get($$store_subs ??= {}, "$settings", settings)?.iframeSandboxAllowForms ?? false ? " allow-forms" : "")}${stringify(store_get($$store_subs ??= {}, "$settings", settings)?.iframeSandboxAllowSameOrigin ?? false ? " allow-same-origin" : "")}`)}></iframe>`);
      } else {
        $$renderer2.push("<!--[!-->");
        if (contents[selectedContentIdx].type === "svg") {
          $$renderer2.push("<!--[-->");
          SVGPanZoom($$renderer2, {
            className: " w-full h-full max-h-full overflow-hidden",
            svg: contents[selectedContentIdx].content
          });
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div class="m-auto font-medium text-xs text-gray-900 dark:text-white">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("No HTML, CSS, or JavaScript content found."))}</div>`);
    }
    $$renderer2.push(`<!--]--></div></div></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { overlay });
  });
}
function Embeds($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let overlay = fallback($$props["overlay"], false);
    const getSrcUrl = (url2, chatId2, messageId, sourceId) => {
      try {
        const parsed = new URL(url2);
        if (chatId2) {
          parsed.searchParams.set("chat_id", chatId2);
        }
        if (messageId) {
          parsed.searchParams.set("message_id", messageId);
        }
        if (sourceId) {
          parsed.searchParams.set("source_id", sourceId);
        }
        return parsed.toString();
      } catch {
        const hasQuery = url2.includes("?");
        const parts = [];
        if (chatId2) parts.push(`chat_id=${encodeURIComponent(chatId2)}`);
        if (messageId) parts.push(`message_id=${encodeURIComponent(messageId)}`);
        if (sourceId) parts.push(`source_id=${encodeURIComponent(sourceId)}`);
        if (parts.length === 0) return url2;
        return url2 + (hasQuery ? "&" : "?") + parts.join("&");
      }
    };
    if (store_get($$store_subs ??= {}, "$embed", embed)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="h-full w-full"><div class="pointer-events-auto z-20 flex justify-between items-center py-3 px-2 font-primar text-gray-900 dark:text-white"><div class="flex-1 flex items-center justify-between pl-2"><a class="flex items-center space-x-2 hover:underline"${attr("href", store_get($$store_subs ??= {}, "$embed", embed)?.url)} target="_blank" rel="noopener noreferrer">${escape_html(store_get($$store_subs ??= {}, "$embed", embed)?.title ?? "Embedded Content")}</a></div> <button class="self-center pointer-events-auto p-1 rounded-full bg-white dark:bg-gray-850">`);
      XMark($$renderer2, { className: "size-3.5 text-gray-900 dark:text-white" });
      $$renderer2.push(`<!----></button></div> <div class="w-full h-full relative">`);
      if (overlay) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="absolute top-0 left-0 right-0 bottom-0 z-10"></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      FullHeightIframe($$renderer2, {
        src: getSrcUrl(store_get($$store_subs ??= {}, "$embed", embed)?.url ?? "", store_get($$store_subs ??= {}, "$embed", embed)?.chatId, store_get($$store_subs ??= {}, "$embed", embed)?.messageId, store_get($$store_subs ??= {}, "$embed", embed)?.sourceId),
        payload: store_get($$store_subs ??= {}, "$embed", embed)?.source ?? null,
        iframeClassName: "w-full h-full"
      });
      $$renderer2.push(`<!----></div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { overlay });
  });
}
function ChatControls($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let history = $$props["history"];
    let models2 = fallback($$props["models"], () => [], true);
    let chatId2 = fallback($$props["chatId"], null);
    let chatFiles = fallback($$props["chatFiles"], () => [], true);
    let params = fallback($$props["params"], () => ({}), true);
    let eventTarget = $$props["eventTarget"];
    let submitPrompt = $$props["submitPrompt"];
    let stopResponse = $$props["stopResponse"];
    let showMessage = $$props["showMessage"];
    let files = $$props["files"];
    let modelId = $$props["modelId"];
    let pane = $$props["pane"];
    let mediaQuery;
    let largeScreen = false;
    let dragged = false;
    let minSize = 0;
    const openPane = () => {
      if (parseInt(localStorage?.chatControlsSize)) {
        const container = document.getElementById("chat-container");
        let size = Math.floor(parseInt(localStorage?.chatControlsSize) / container.clientWidth * 100);
        pane.resize(size);
      } else {
        pane.resize(minSize);
      }
    };
    const handleMediaQuery = async (e) => {
      if (e.matches) {
        largeScreen = true;
        if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
          showCallOverlay.set(false);
          await tick();
          showCallOverlay.set(true);
        }
      } else {
        largeScreen = false;
        if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
          showCallOverlay.set(false);
          await tick();
          showCallOverlay.set(true);
        }
        pane = null;
      }
    };
    const onMouseDown = (event) => {
      dragged = true;
    };
    const onMouseUp = (event) => {
      dragged = false;
    };
    onDestroy(() => {
      showControls.set(false);
      mediaQuery.removeEventListener("change", handleMediaQuery);
      document.removeEventListener("mousedown", onMouseDown);
      document.removeEventListener("mouseup", onMouseUp);
    });
    const closeHandler = () => {
      showControls.set(false);
      showOverview.set(false);
      showArtifacts.set(false);
      showEmbeds.set(false);
      if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
        showCallOverlay.set(false);
      }
    };
    if (!chatId2) {
      closeHandler();
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (!largeScreen) {
        $$renderer3.push("<!--[-->");
        if (store_get($$store_subs ??= {}, "$showControls", showControls)) {
          $$renderer3.push("<!--[-->");
          Drawer($$renderer3, {
            show: store_get($$store_subs ??= {}, "$showControls", showControls),
            onClose: () => {
              showControls.set(false);
            },
            children: ($$renderer4) => {
              $$renderer4.push(`<div${attr_class(` ${stringify(store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay) || store_get($$store_subs ??= {}, "$showOverview", showOverview) || store_get($$store_subs ??= {}, "$showArtifacts", showArtifacts) || store_get($$store_subs ??= {}, "$showEmbeds", showEmbeds) ? " h-screen  w-full" : "px-4 py-3")} h-full`)}>`);
              if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div class="h-full max-h-[100dvh] bg-white text-gray-700 dark:bg-black dark:text-gray-300 flex justify-center">`);
                CallOverlay($$renderer4, {
                  submitPrompt,
                  stopResponse,
                  modelId,
                  chatId: chatId2,
                  eventTarget,
                  get files() {
                    return files;
                  },
                  set files($$value) {
                    files = $$value;
                    $$settled = false;
                  }
                });
                $$renderer4.push(`<!----></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
                if (store_get($$store_subs ??= {}, "$showEmbeds", showEmbeds)) {
                  $$renderer4.push("<!--[-->");
                  Embeds($$renderer4, {});
                } else {
                  $$renderer4.push("<!--[!-->");
                  if (store_get($$store_subs ??= {}, "$showArtifacts", showArtifacts)) {
                    $$renderer4.push("<!--[-->");
                    Artifacts($$renderer4, { history });
                  } else {
                    $$renderer4.push("<!--[!-->");
                    if (store_get($$store_subs ??= {}, "$showOverview", showOverview)) {
                      $$renderer4.push("<!--[-->");
                      await_block($$renderer4, import("./Overview.js"), () => {
                      }, ({ default: Overview }) => {
                        Overview($$renderer4, {
                          history,
                          onNodeClick: (e) => {
                            const node = e.node;
                            showMessage(node.data.message, true);
                          },
                          onClose: () => {
                            showControls.set(false);
                          }
                        });
                      });
                      $$renderer4.push(`<!--]-->`);
                    } else {
                      $$renderer4.push("<!--[!-->");
                      Controls($$renderer4, {
                        models: models2,
                        get chatFiles() {
                          return chatFiles;
                        },
                        set chatFiles($$value) {
                          chatFiles = $$value;
                          $$settled = false;
                        },
                        get params() {
                          return params;
                        },
                        set params($$value) {
                          params = $$value;
                          $$settled = false;
                        }
                      });
                    }
                    $$renderer4.push(`<!--]-->`);
                  }
                  $$renderer4.push(`<!--]-->`);
                }
                $$renderer4.push(`<!--]-->`);
              }
              $$renderer4.push(`<!--]--></div>`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
        if (store_get($$store_subs ??= {}, "$showControls", showControls)) {
          $$renderer3.push("<!--[-->");
          Pane_resizer($$renderer3, {
            class: "relative flex items-center justify-center group border-l border-gray-50 dark:border-gray-850/30 hover:border-gray-200 dark:hover:border-gray-800  transition z-20",
            id: "controls-resizer",
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="absolute -left-1.5 -right-1.5 -top-0 -bottom-0 z-20 cursor-col-resize bg-transparent"></div>`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        Pane($$renderer3, {
          defaultSize: 0,
          onResize: (size) => {
            if (store_get($$store_subs ??= {}, "$showControls", showControls) && pane.isExpanded()) {
              if (size < minSize) {
                pane.resize(minSize);
              }
              if (size < minSize) {
                localStorage.chatControlsSize = 0;
              } else {
                const container = document.getElementById("chat-container");
                localStorage.chatControlsSize = Math.floor(size / 100 * container.clientWidth);
              }
            }
          },
          onCollapse: () => {
            showControls.set(false);
          },
          collapsible: true,
          class: " z-10 bg-white dark:bg-gray-850",
          get pane() {
            return pane;
          },
          set pane($$value) {
            pane = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            if (store_get($$store_subs ??= {}, "$showControls", showControls)) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="flex max-h-full min-h-full"><div${attr_class(`w-full ${stringify((store_get($$store_subs ??= {}, "$showOverview", showOverview) || store_get($$store_subs ??= {}, "$showArtifacts", showArtifacts) || store_get($$store_subs ??= {}, "$showEmbeds", showEmbeds)) && !store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay) ? " " : "px-4 py-3 bg-white dark:shadow-lg dark:bg-gray-850 ")} z-40 pointer-events-auto overflow-y-auto scrollbar-hidden`)} id="controls-container">`);
              if (store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div class="w-full h-full flex justify-center">`);
                CallOverlay($$renderer4, {
                  submitPrompt,
                  stopResponse,
                  modelId,
                  chatId: chatId2,
                  eventTarget,
                  get files() {
                    return files;
                  },
                  set files($$value) {
                    files = $$value;
                    $$settled = false;
                  }
                });
                $$renderer4.push(`<!----></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
                if (store_get($$store_subs ??= {}, "$showEmbeds", showEmbeds)) {
                  $$renderer4.push("<!--[-->");
                  Embeds($$renderer4, { overlay: dragged });
                } else {
                  $$renderer4.push("<!--[!-->");
                  if (store_get($$store_subs ??= {}, "$showArtifacts", showArtifacts)) {
                    $$renderer4.push("<!--[-->");
                    Artifacts($$renderer4, { history, overlay: dragged });
                  } else {
                    $$renderer4.push("<!--[!-->");
                    if (store_get($$store_subs ??= {}, "$showOverview", showOverview)) {
                      $$renderer4.push("<!--[-->");
                      await_block($$renderer4, import("./Overview.js"), () => {
                      }, ({ default: Overview }) => {
                        Overview($$renderer4, {
                          history,
                          onNodeClick: (e) => {
                            const node = e.node;
                            if (node?.data?.message?.favorite) {
                              history.messages[node.data.message.id].favorite = true;
                            } else {
                              history.messages[node.data.message.id].favorite = null;
                            }
                            showMessage(node.data.message, true);
                          },
                          onClose: () => {
                            showControls.set(false);
                          }
                        });
                      });
                      $$renderer4.push(`<!--]-->`);
                    } else {
                      $$renderer4.push("<!--[!-->");
                      Controls($$renderer4, {
                        models: models2,
                        get chatFiles() {
                          return chatFiles;
                        },
                        set chatFiles($$value) {
                          chatFiles = $$value;
                          $$settled = false;
                        },
                        get params() {
                          return params;
                        },
                        set params($$value) {
                          params = $$value;
                          $$settled = false;
                        }
                      });
                    }
                    $$renderer4.push(`<!--]-->`);
                  }
                  $$renderer4.push(`<!--]-->`);
                }
                $$renderer4.push(`<!--]-->`);
              }
              $$renderer4.push(`<!--]--></div></div>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      history,
      models: models2,
      chatId: chatId2,
      chatFiles,
      params,
      eventTarget,
      submitPrompt,
      stopResponse,
      showMessage,
      files,
      modelId,
      pane,
      openPane
    });
  });
}
function ChatList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    dayjs.extend(localizedFormat);
    let chats2 = fallback($$props["chats"], () => [], true);
    let chatListLoading = fallback($$props["chatListLoading"], false);
    let allChatsLoaded = fallback($$props["allChatsLoaded"], false);
    let loadHandler = fallback($$props["loadHandler"], null);
    let chatList = null;
    const init = async () => {
      if (chats2.length === 0) {
        chatList = [];
      } else {
        chatList = chats2.map((chat) => ({ ...chat, time_range: getTimeRange(chat.updated_at) }));
        chatList.sort((a, b) => {
          {
            return a[orderBy] < b[orderBy] ? 1 : -1;
          }
        });
      }
    };
    let orderBy = "updated_at";
    if (chats2) {
      init();
    }
    if (chatList) {
      $$renderer2.push("<!--[-->");
      if (chatList.length > 0) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="flex text-xs font-medium mb-1 items-center -mr-0.5"><button class="px-1.5 py-1 cursor-pointer select-none basis-3/5"><div class="flex gap-1.5 items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Title"))} `);
        {
          $$renderer2.push("<!--[!-->");
          $$renderer2.push(`<span class="invisible">`);
          ChevronUp($$renderer2, { className: "size-2" });
          $$renderer2.push(`<!----></span>`);
        }
        $$renderer2.push(`<!--]--></div></button> <button class="px-1.5 py-1 cursor-pointer select-none hidden sm:flex sm:basis-2/5 justify-end"><div class="flex gap-1.5 items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Updated at"))} `);
        {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<span class="font-normal">`);
          {
            $$renderer2.push("<!--[!-->");
            ChevronDown($$renderer2, { className: "size-2" });
          }
          $$renderer2.push(`<!--]--></span>`);
        }
        $$renderer2.push(`<!--]--></div></button></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <div class="text-left text-sm w-full mb-3">`);
      if (chatList.length === 0) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="text-xs text-gray-500 dark:text-gray-400 text-center px-5 min-h-20 w-full h-full flex justify-center items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("No chats found"))}</div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <!--[-->`);
      const each_array = ensure_array_like(chatList);
      for (let idx = 0, $$length = each_array.length; idx < $$length; idx++) {
        let chat = each_array[idx];
        if ((idx === 0 || idx > 0 && chat.time_range !== chatList[idx - 1].time_range) && chat?.time_range) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<div${attr_class(`w-full text-xs text-gray-500 dark:text-gray-500 font-medium ${stringify(idx === 0 ? "" : "pt-5")} pb-2 px-2`)}>${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t(chat.time_range))}</div>`);
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]--> <a class="w-full flex justify-between items-center rounded-lg text-sm py-2 px-3 hover:bg-gray-50 dark:hover:bg-gray-850" draggable="false"${attr("href", `/c/${chat.id}`)}><div class="text-ellipsis line-clamp-1 w-full sm:basis-3/5">${escape_html(chat?.title)}</div> <div class="hidden sm:flex sm:basis-2/5 items-center justify-end"><div class="text-gray-500 dark:text-gray-400 text-xs">${escape_html(dayjs(chat?.updated_at * 1e3).calendar())}</div></div></a>`);
      }
      $$renderer2.push(`<!--]--> `);
      if (!allChatsLoaded && loadHandler) {
        $$renderer2.push("<!--[-->");
        Loader($$renderer2, {
          children: ($$renderer3) => {
            $$renderer3.push(`<div class="w-full flex justify-center py-1 text-xs animate-pulse items-center gap-2">`);
            Spinner($$renderer3, { className: " size-4" });
            $$renderer3.push(`<!----> <div>Loading...</div></div>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { chats: chats2, chatListLoading, allChatsLoaded, loadHandler });
  });
}
function FolderPlaceholder($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    getContext("i18n");
    let folder = fallback($$props["folder"], null);
    let page2 = 1;
    let chats2 = null;
    let chatListLoading = false;
    let allChatsLoaded = false;
    const loadChats = async () => {
      chatListLoading = true;
      page2 += 1;
      let newChatList = [];
      newChatList = await getChatListByFolderId(localStorage.token, folder.id, page2).catch((error) => {
        /* @__PURE__ */ console.error(error);
        return [];
      });
      allChatsLoaded = newChatList.length === 0;
      chats2 = [...chats2 || [], ...newChatList || []];
      chatListLoading = false;
    };
    const setChatList = async () => {
      chats2 = null;
      page2 = 1;
      allChatsLoaded = false;
      chatListLoading = false;
      if (folder && folder.id) {
        const res = await getChatListByFolderId(localStorage.token, folder.id, page2);
        if (res) {
          chats2 = res;
        } else {
          chats2 = [];
        }
      } else {
        chats2 = [];
      }
    };
    if (folder) {
      setChatList();
    }
    $$renderer2.push(`<div><div>`);
    {
      $$renderer2.push("<!--[!-->");
      {
        $$renderer2.push("<!--[-->");
        if (chats2 !== null) {
          $$renderer2.push("<!--[-->");
          ChatList($$renderer2, {
            chats: chats2,
            chatListLoading,
            allChatsLoaded,
            loadHandler: loadChats
          });
        } else {
          $$renderer2.push("<!--[!-->");
          $$renderer2.push(`<div class="py-10">`);
          Spinner($$renderer2, {});
          $$renderer2.push(`<!----></div>`);
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></div></div>`);
    bind_props($$props, { folder });
  });
}
function FolderTitle($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    const { saveAs } = fileSaver;
    let folder = fallback($$props["folder"], null);
    let onUpdate = fallback($$props["onUpdate"], (folderId2) => {
    });
    let onDelete = fallback($$props["onDelete"], (folderId2) => {
    });
    let showFolderModal = false;
    let showDeleteConfirm = false;
    let deleteFolderContents = true;
    const updateHandler = async ({ name, meta, data }) => {
      if (name === "") {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Folder name cannot be empty."));
        return;
      }
      const currentName = folder.name;
      name = name.trim();
      folder.name = name;
      const res = await updateFolderById(localStorage.token, folder.id, { name, ...meta ? { meta } : {}, ...data ? { data } : {} }).catch((error) => {
        toast.error(`${error}`);
        folder.name = currentName;
        return null;
      });
      if (res) {
        folder.name = name;
        if (data) {
          folder.data = data;
        }
        toast.success(store_get($$store_subs ??= {}, "$i18n", i18n).t("Folder updated successfully"));
        const _folder = await getFolderById(localStorage.token, folder.id).catch((error) => {
          toast.error(`${error}`);
          return null;
        });
        await selectedFolder.set(_folder);
        onUpdate(_folder);
      }
    };
    const updateIconHandler = async (iconName) => {
      const res = await updateFolderById(localStorage.token, folder.id, { meta: { icon: iconName } }).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      if (res) {
        folder.meta = { ...folder.meta, icon: iconName };
        toast.success(store_get($$store_subs ??= {}, "$i18n", i18n).t("Folder updated successfully"));
        const _folder = await getFolderById(localStorage.token, folder.id).catch((error) => {
          toast.error(`${error}`);
          return null;
        });
        await selectedFolder.set(_folder);
        onUpdate(_folder);
      }
    };
    const exportHandler = async () => {
      const chats2 = await getChatsByFolderId(localStorage.token, folder.id).catch((error) => {
        toast.error(`${error}`);
        return null;
      });
      if (!chats2) {
        return;
      }
      const blob = new Blob([JSON.stringify(chats2)], { type: "application/json" });
      saveAs(blob, `folder-${folder.name}-export-${Date.now()}.json`);
    };
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (folder) {
        $$renderer3.push("<!--[-->");
        FolderModal($$renderer3, {
          edit: true,
          folderId: folder.id,
          onSubmit: updateHandler,
          get show() {
            return showFolderModal;
          },
          set show($$value) {
            showFolderModal = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        ConfirmDialog($$renderer3, {
          title: store_get($$store_subs ??= {}, "$i18n", i18n).t("Delete folder?"),
          get show() {
            return showDeleteConfirm;
          },
          set show($$value) {
            showDeleteConfirm = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="text-sm text-gray-700 dark:text-gray-300 flex-1 line-clamp-3 mb-2">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t(`Are you sure you want to delete "{{NAME}}"?`, { NAME: folders[folderId].name }))}</div> <div class="flex items-center gap-1.5"><input type="checkbox"${attr("checked", deleteFolderContents, true)}/> <div class="text-xs text-gray-500">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Delete all contents inside this folder"))}</div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> <div class="mb-3 px-6 @md:max-w-3xl justify-between w-full flex relative group items-center"><div class="text-center flex gap-3.5 items-center">`);
        EmojiPicker($$renderer3, {
          onClose: () => {
          },
          onSubmit: (name) => {
            /* @__PURE__ */ console.log(name);
            updateIconHandler(name);
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<button class="rounded-full bg-gray-50 dark:bg-gray-800 size-11 flex justify-center items-center">`);
            if (folder?.meta?.icon) {
              $$renderer4.push("<!--[-->");
              Emoji($$renderer4, { className: "size-6", shortCode: folder.meta.icon });
            } else {
              $$renderer4.push("<!--[!-->");
              Folder($$renderer4, { className: "size-4.5", strokeWidth: "2" });
            }
            $$renderer4.push(`<!--]--></button>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> <div class="text-3xl line-clamp-1">${escape_html(folder.name)}</div></div> <div class="flex items-center translate-x-2.5">`);
        FolderMenu($$renderer3, {
          align: "end",
          onEdit: () => {
            showFolderModal = true;
          },
          onDelete: () => {
            showDeleteConfirm = true;
          },
          onExport: () => {
            exportHandler();
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<button class="p-1.5 dark:hover:bg-gray-850 rounded-full touch-auto">`);
            EllipsisHorizontal($$renderer4, { className: "size-4", strokeWidth: "2.5" });
            $$renderer4.push(`<!----></button>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { folder, onUpdate, onDelete });
  });
}
function Placeholder($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let createMessagePair = $$props["createMessagePair"];
    let stopResponse = $$props["stopResponse"];
    let autoScroll = fallback($$props["autoScroll"], false);
    let atSelectedModel = $$props["atSelectedModel"];
    let selectedModels = $$props["selectedModels"];
    let history = $$props["history"];
    let prompt = fallback($$props["prompt"], "");
    let files = fallback($$props["files"], () => [], true);
    let messageInput = fallback($$props["messageInput"], null);
    let selectedToolIds = fallback($$props["selectedToolIds"], () => [], true);
    let selectedFilterIds = fallback($$props["selectedFilterIds"], () => [], true);
    let showCommands = fallback($$props["showCommands"], false);
    let imageGenerationEnabled = fallback($$props["imageGenerationEnabled"], false);
    let codeInterpreterEnabled = fallback($$props["codeInterpreterEnabled"], false);
    let webSearchEnabled = fallback($$props["webSearchEnabled"], false);
    let onUpload = fallback($$props["onUpload"], (e) => {
    });
    let onSelect = fallback($$props["onSelect"], (e) => {
    });
    let onChange = fallback($$props["onChange"], (e) => {
    });
    let toolServers2 = fallback($$props["toolServers"], () => [], true);
    let models$1 = [];
    let selectedModelIdx = 0;
    models$1 = selectedModels.map((id) => store_get($$store_subs ??= {}, "$_models", models).find((m) => m.id === id));
    if (selectedModels.length > 0) {
      selectedModelIdx = models$1.length - 1;
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="m-auto w-full max-w-6xl px-2 @2xl:px-20 translate-y-6 py-24 text-center">`);
      if (store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
        $$renderer3.push("<!--[-->");
        Tooltip($$renderer3, {
          content: store_get($$store_subs ??= {}, "$i18n", i18n).t("This chat won't appear in history and your messages will not be saved."),
          className: "w-full flex justify-center mb-0.5",
          placement: "top",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="flex items-center gap-2 text-gray-500 text-base my-2 w-fit">`);
            EyeSlash($$renderer4, { strokeWidth: "2.5", className: "size-4" });
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Temporary Chat"))}</div>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="w-full text-3xl text-gray-800 dark:text-gray-100 text-center flex items-center gap-4 font-primary"><div class="w-full flex flex-col justify-center items-center">`);
      if (store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)) {
        $$renderer3.push("<!--[-->");
        FolderTitle($$renderer3, {
          folder: store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder),
          onUpdate: async (folder) => {
            await chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
            currentChatPage.set(1);
          },
          onDelete: async () => {
            await chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
            currentChatPage.set(1);
            selectedFolder.set(null);
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<div class="flex flex-row justify-center gap-3 @sm:gap-3.5 w-fit px-5 max-w-xl"><div class="flex shrink-0 justify-center"><div class="flex -space-x-4 mb-0.5"><!--[-->`);
        const each_array = ensure_array_like(models$1);
        for (let modelIdx = 0, $$length = each_array.length; modelIdx < $$length; modelIdx++) {
          let model = each_array[modelIdx];
          Tooltip($$renderer3, {
            content: (models$1[modelIdx]?.info?.meta?.tags ?? []).map((tag) => tag.name.toUpperCase()).join(", "),
            placement: "top",
            children: ($$renderer4) => {
              $$renderer4.push(`<button${attr("aria-hidden", models$1.length <= 1)}${attr("aria-label", store_get($$store_subs ??= {}, "$i18n", i18n).t("Get information on {{name}} in the UI", { name: models$1[modelIdx]?.name }))}><img${attr("src", `${WEBUI_API_BASE_URL}/models/model/profile/image?id=${model?.id}&lang=${store_get($$store_subs ??= {}, "$i18n", i18n).language}`)} class="size-9 @sm:size-10 rounded-full border-[1px] border-gray-100 dark:border-none" aria-hidden="true" draggable="false"/></button>`);
            },
            $$slots: { default: true }
          });
        }
        $$renderer3.push(`<!--]--></div></div> <div class="text-3xl @sm:text-3xl line-clamp-1 flex items-center">`);
        if (models$1[selectedModelIdx]?.name) {
          $$renderer3.push("<!--[-->");
          Tooltip($$renderer3, {
            content: models$1[selectedModelIdx]?.name,
            placement: "top",
            className: " flex items-center ",
            children: ($$renderer4) => {
              $$renderer4.push(`<span class="line-clamp-1">${escape_html(models$1[selectedModelIdx]?.name)}</span>`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Hello, {{name}}", { name: store_get($$store_subs ??= {}, "$user", user)?.name }))}`);
        }
        $$renderer3.push(`<!--]--></div></div> <div class="flex mt-1 mb-2"><div>`);
        if (models$1[selectedModelIdx]?.info?.meta?.description ?? null) {
          $$renderer3.push("<!--[-->");
          Tooltip($$renderer3, {
            className: " w-fit",
            content: marked.parse(sanitizeResponseContent(models$1[selectedModelIdx]?.info?.meta?.description ?? "").replaceAll("\n", "<br>")),
            placement: "top",
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="mt-0.5 px-2 text-sm font-normal text-gray-500 dark:text-gray-400 line-clamp-2 max-w-xl markdown">${html(marked.parse(sanitizeResponseContent(models$1[selectedModelIdx]?.info?.meta?.description ?? "").replaceAll("\n", "<br>")))}</div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          if (models$1[selectedModelIdx]?.info?.meta?.user) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="mt-0.5 text-sm font-normal text-gray-400 dark:text-gray-500">By `);
            if (models$1[selectedModelIdx]?.info?.meta?.user.community) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<a${attr("href", `https://openwebui.com/m/${stringify(models$1[selectedModelIdx]?.info?.meta?.user.username)}`)}>${escape_html(models$1[selectedModelIdx]?.info?.meta?.user.name ? models$1[selectedModelIdx]?.info?.meta?.user.name : `@${models$1[selectedModelIdx]?.info?.meta?.user.username}`)}</a>`);
            } else {
              $$renderer3.push("<!--[!-->");
              $$renderer3.push(`${escape_html(models$1[selectedModelIdx]?.info?.meta?.user.name)}`);
            }
            $$renderer3.push(`<!--]--></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div></div>`);
      }
      $$renderer3.push(`<!--]--> <div${attr_class(`text-base font-normal @md:max-w-3xl w-full py-3 ${stringify(atSelectedModel ? "mt-2" : "")}`)}>`);
      MessageInput($$renderer3, {
        history,
        selectedModels,
        toolServers: toolServers2,
        stopResponse,
        createMessagePair,
        placeholder: store_get($$store_subs ??= {}, "$i18n", i18n).t("How can I help you today?"),
        onChange,
        onUpload,
        get files() {
          return files;
        },
        set files($$value) {
          files = $$value;
          $$settled = false;
        },
        get prompt() {
          return prompt;
        },
        set prompt($$value) {
          prompt = $$value;
          $$settled = false;
        },
        get autoScroll() {
          return autoScroll;
        },
        set autoScroll($$value) {
          autoScroll = $$value;
          $$settled = false;
        },
        get selectedToolIds() {
          return selectedToolIds;
        },
        set selectedToolIds($$value) {
          selectedToolIds = $$value;
          $$settled = false;
        },
        get selectedFilterIds() {
          return selectedFilterIds;
        },
        set selectedFilterIds($$value) {
          selectedFilterIds = $$value;
          $$settled = false;
        },
        get imageGenerationEnabled() {
          return imageGenerationEnabled;
        },
        set imageGenerationEnabled($$value) {
          imageGenerationEnabled = $$value;
          $$settled = false;
        },
        get codeInterpreterEnabled() {
          return codeInterpreterEnabled;
        },
        set codeInterpreterEnabled($$value) {
          codeInterpreterEnabled = $$value;
          $$settled = false;
        },
        get webSearchEnabled() {
          return webSearchEnabled;
        },
        set webSearchEnabled($$value) {
          webSearchEnabled = $$value;
          $$settled = false;
        },
        get atSelectedModel() {
          return atSelectedModel;
        },
        set atSelectedModel($$value) {
          atSelectedModel = $$value;
          $$settled = false;
        },
        get showCommands() {
          return showCommands;
        },
        set showCommands($$value) {
          showCommands = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----></div></div></div> `);
      if (store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="mx-auto px-4 md:max-w-3xl md:px-6 font-primary min-h-62">`);
        FolderPlaceholder($$renderer3, {
          folder: store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)
        });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<div class="mx-auto max-w-2xl font-primary mt-2"><div class="mx-5">`);
        Suggestions($$renderer3, {
          suggestionPrompts: atSelectedModel?.info?.meta?.suggestion_prompts ?? models$1[selectedModelIdx]?.info?.meta?.suggestion_prompts ?? store_get($$store_subs ??= {}, "$config", config)?.default_prompt_suggestions ?? [],
          inputValue: prompt,
          onSelect
        });
        $$renderer3.push(`<!----></div></div>`);
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      createMessagePair,
      stopResponse,
      autoScroll,
      atSelectedModel,
      selectedModels,
      history,
      prompt,
      files,
      messageInput,
      selectedToolIds,
      selectedFilterIds,
      showCommands,
      imageGenerationEnabled,
      codeInterpreterEnabled,
      webSearchEnabled,
      onUpload,
      onSelect,
      onChange,
      toolServers: toolServers2
    });
  });
}
function Chat($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let chatIdProp = fallback($$props["chatIdProp"], "");
    let loading = true;
    const eventTarget = new EventTarget();
    let controlPane;
    let messageInput;
    let autoScroll = true;
    let showEventConfirmation = false;
    let eventConfirmationTitle = "";
    let eventConfirmationMessage = "";
    let eventConfirmationInput = false;
    let eventConfirmationInputPlaceholder = "";
    let eventConfirmationInputValue = "";
    let chatIdUnsubscriber;
    let selectedModels = [""];
    let atSelectedModel;
    let selectedModelIds = [];
    let selectedToolIds = [];
    let selectedFilterIds = [];
    let imageGenerationEnabled = false;
    let webSearchEnabled = false;
    let codeInterpreterEnabled = false;
    let showCommands = false;
    let generating = false;
    let generationController = null;
    let chat = null;
    let history = { messages: {}, currentId: null };
    let taskIds = null;
    let prompt = "";
    let chatFiles = [];
    let files = [];
    let params = {};
    let messageQueue = [];
    const navigateHandler = async () => {
      loading = true;
      if (messageQueue.length > 0 && store_get($$store_subs ??= {}, "$chatId", chatId)) {
        sessionStorage.setItem(`chat-queue-${store_get($$store_subs ??= {}, "$chatId", chatId)}`, JSON.stringify(messageQueue));
      }
      prompt = "";
      messageInput?.setText("");
      files = [];
      messageQueue = [];
      selectedToolIds = [];
      selectedFilterIds = [];
      webSearchEnabled = false;
      imageGenerationEnabled = false;
      const storageChatInput = sessionStorage.getItem(`chat-input${chatIdProp ? `-${chatIdProp}` : ""}`);
      if (chatIdProp && await loadChat()) {
        await tick();
        loading = false;
        window.setTimeout(() => scrollToBottom(), 0);
        await tick();
        const storedQueueData = sessionStorage.getItem(`chat-queue-${chatIdProp}`);
        if (storedQueueData) {
          try {
            const restoredQueue = JSON.parse(storedQueueData);
            if (restoredQueue.length > 0) {
              sessionStorage.removeItem(`chat-queue-${chatIdProp}`);
              const hasPendingTask = taskIds !== null && taskIds.length > 0;
              if (!hasPendingTask) {
                files = restoredQueue.flatMap((m) => m.files);
                await tick();
                const combinedPrompt = restoredQueue.map((m) => m.prompt).join("\n\n");
                await submitPrompt(combinedPrompt);
              } else {
                messageQueue = restoredQueue;
              }
            }
          } catch (e) {
          }
        }
        if (storageChatInput) {
          try {
            const input = JSON.parse(storageChatInput);
            if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
              messageInput?.setText(input.prompt);
              files = input.files;
              selectedToolIds = input.selectedToolIds;
              selectedFilterIds = input.selectedFilterIds;
              webSearchEnabled = input.webSearchEnabled;
              imageGenerationEnabled = input.imageGenerationEnabled;
              codeInterpreterEnabled = input.codeInterpreterEnabled;
            }
          } catch (e) {
          }
        } else {
          await setDefaults();
        }
        const chatInput = document.getElementById("chat-input");
        chatInput?.focus();
      } else {
        await goto();
      }
    };
    const onSelect = async (e) => {
      const { type, data } = e;
      if (type === "prompt") {
        messageInput?.setText(data, async () => {
          if (!(store_get($$store_subs ??= {}, "$settings", settings)?.insertSuggestionPrompt ?? false)) {
            await tick();
            submitPrompt(prompt);
          }
        });
      }
    };
    const saveSessionSelectedModels = () => {
      const selectedModelsString = JSON.stringify(selectedModels);
      if (selectedModels.length === 0 || selectedModels.length === 1 && selectedModels[0] === "" || sessionStorage.selectedModels === selectedModelsString) {
        return;
      }
      sessionStorage.selectedModels = selectedModelsString;
      /* @__PURE__ */ console.log("saveSessionSelectedModels", selectedModels, sessionStorage.selectedModels);
    };
    let oldSelectedModelIds = [""];
    const onSelectedModelIdsChange = () => {
      resetInput();
      oldSelectedModelIds = JSON.parse(JSON.stringify(selectedModelIds));
    };
    const resetInput = () => {
      selectedToolIds = [];
      selectedFilterIds = [];
      webSearchEnabled = false;
      imageGenerationEnabled = false;
      codeInterpreterEnabled = false;
      if (selectedModelIds.filter((id) => id).length > 0) {
        setDefaults();
      }
    };
    const setDefaults = async () => {
      if (!store_get($$store_subs ??= {}, "$tools", tools)) {
        tools.set(await getTools(localStorage.token));
      }
      if (!store_get($$store_subs ??= {}, "$functions", functions)) {
        functions.set(await getFunctions(localStorage.token));
      }
      if (selectedModels.length !== 1 && !atSelectedModel) {
        return;
      }
      const model = atSelectedModel ?? store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === selectedModels[0]);
      if (model) {
        if (model?.info?.meta?.toolIds) {
          selectedToolIds = [
            ...new Set([...model?.info?.meta?.toolIds ?? []].filter((id) => store_get($$store_subs ??= {}, "$tools", tools).find((t) => t.id === id)))
          ];
        }
        if (model?.info?.meta?.defaultFilterIds) {
          selectedFilterIds = model.info.meta.defaultFilterIds.filter((id) => model?.filters?.find((f) => f.id === id));
        }
        if (model?.info?.meta?.defaultFeatureIds) {
          if (model.info?.meta?.capabilities?.["image_generation"]) {
            imageGenerationEnabled = model.info.meta.defaultFeatureIds.includes("image_generation");
          }
          if (model.info?.meta?.capabilities?.["web_search"]) {
            webSearchEnabled = model.info.meta.defaultFeatureIds.includes("web_search");
          }
          if (model.info?.meta?.capabilities?.["code_interpreter"]) {
            codeInterpreterEnabled = model.info.meta.defaultFeatureIds.includes("code_interpreter");
          }
        }
      }
    };
    const showMessage = async (message, ignoreSettings = false) => {
      await tick();
      const _chatId = JSON.parse(JSON.stringify(store_get($$store_subs ??= {}, "$chatId", chatId)));
      let _messageId = JSON.parse(JSON.stringify(message.id));
      let messageChildrenIds = [];
      if (_messageId === null) {
        messageChildrenIds = Object.keys(history.messages).filter((id) => history.messages[id].parentId === null);
      } else {
        messageChildrenIds = history.messages[_messageId].childrenIds;
      }
      while (messageChildrenIds.length !== 0) {
        _messageId = messageChildrenIds.at(-1);
        messageChildrenIds = history.messages[_messageId].childrenIds;
      }
      history.currentId = _messageId;
      await tick();
      await tick();
      await tick();
      if ((store_get($$store_subs ??= {}, "$settings", settings)?.scrollOnBranchChange ?? true) || ignoreSettings) {
        const messageElement = document.getElementById(`message-${message.id}`);
        if (messageElement) {
          messageElement.scrollIntoView({ behavior: "smooth" });
        }
      }
      await tick();
      saveChatHandler(_chatId, history);
    };
    const chatEventHandler = async (event, cb) => {
      /* @__PURE__ */ console.log(event);
      if (event.chat_id === store_get($$store_subs ??= {}, "$chatId", chatId)) {
        await tick();
        let message = history.messages[event.message_id];
        if (message) {
          const type = event?.data?.type ?? null;
          const data = event?.data?.data ?? null;
          if (type === "status") {
            if (message?.statusHistory) {
              message.statusHistory.push(data);
            } else {
              message.statusHistory = [data];
            }
          } else if (type === "chat:completion") {
            chatCompletionEventHandler(data, message, event.chat_id);
          } else if (type === "chat:tasks:cancel") {
            taskIds = null;
            const responseMessage = history.messages[history.currentId];
            for (const messageId of history.messages[responseMessage.parentId].childrenIds) {
              history.messages[messageId].done = true;
            }
          } else if (type === "chat:message:delta" || type === "message") {
            message.content += data.content;
          } else if (type === "chat:message" || type === "replace") {
            message.content = data.content;
          } else if (type === "chat:message:files" || type === "files") {
            message.files = data.files;
          } else if (type === "chat:message:embeds" || type === "embeds") {
            message.embeds = data.embeds;
          } else if (type === "chat:message:error") {
            message.error = data.error;
          } else if (type === "chat:message:follow_ups") {
            message.followUps = data.follow_ups;
            if (autoScroll) {
              scrollToBottom("smooth");
            }
          } else if (type === "chat:message:favorite") {
            message.favorite = data.favorite;
          } else if (type === "chat:title") {
            chatTitle.set(data);
            currentChatPage.set(1);
            await chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
          } else if (type === "chat:tags") {
            chat = await getChatById(localStorage.token, store_get($$store_subs ??= {}, "$chatId", chatId));
            tags.set(await getAllTags(localStorage.token));
          } else if (type === "source" || type === "citation") {
            if (data?.type === "code_execution") {
              if (!message?.code_executions) {
                message.code_executions = [];
              }
              const existingCodeExecutionIndex = message.code_executions.findIndex((execution) => execution.id === data.id);
              if (existingCodeExecutionIndex !== -1) {
                message.code_executions[existingCodeExecutionIndex] = data;
              } else {
                message.code_executions.push(data);
              }
              message.code_executions = message.code_executions;
            } else {
              if (message?.sources) {
                message.sources.push(data);
              } else {
                message.sources = [data];
              }
            }
          } else if (type === "notification") {
            const toastType = data?.type ?? "info";
            const toastContent = data?.content ?? "";
            if (toastType === "success") {
              toast.success(toastContent);
            } else if (toastType === "error") {
              toast.error(toastContent);
            } else if (toastType === "warning") {
              toast.warning(toastContent);
            } else {
              toast.info(toastContent);
            }
          } else if (type === "confirmation") {
            eventConfirmationInput = false;
            showEventConfirmation = true;
            eventConfirmationTitle = data.title;
            eventConfirmationMessage = data.message;
          } else if (type === "execute") {
            try {
              const asyncFunction = new Function(`return (async () => { ${data.code} })()`);
              const result = await asyncFunction();
              if (cb) {
                cb(result);
              }
            } catch (error) {
              /* @__PURE__ */ console.error("Error executing code:", error);
            }
          } else if (type === "input") {
            eventConfirmationInput = true;
            showEventConfirmation = true;
            eventConfirmationTitle = data.title;
            eventConfirmationMessage = data.message;
            eventConfirmationInputPlaceholder = data.placeholder;
            eventConfirmationInputValue = data?.value ?? "";
          } else {
            /* @__PURE__ */ console.log("Unknown message type", data);
          }
          history.messages[event.message_id] = message;
        }
      }
    };
    const onMessageHandler = async (event) => {
      if (event.origin !== window.origin) {
        return;
      }
      if (event.data.type === "action:submit") {
        /* @__PURE__ */ console.debug(event.data.text);
        if (prompt !== "") {
          await tick();
          submitPrompt(prompt);
        }
      }
      if (event.data.type === "input:prompt") {
        /* @__PURE__ */ console.debug(event.data.text);
        const inputElement = document.getElementById("chat-input");
        if (inputElement) {
          messageInput?.setText(event.data.text);
          inputElement.focus();
        }
      }
      if (event.data.type === "input:prompt:submit") {
        /* @__PURE__ */ console.debug(event.data.text);
        if (event.data.text !== "") {
          await tick();
          submitPrompt(event.data.text);
        }
      }
    };
    const savedModelIds = async () => {
      if (store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder) && selectedModels.filter((modelId) => modelId !== "").length > 0 && JSON.stringify(store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)?.data?.model_ids) !== JSON.stringify(selectedModels)) {
        await updateFolderById(localStorage.token, store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder).id, { data: { model_ids: selectedModels } });
      }
    };
    let pageSubscribe = null;
    let showControlsSubscribe = null;
    let selectedFolderSubscribe = null;
    onDestroy(() => {
      try {
        pageSubscribe();
        showControlsSubscribe();
        selectedFolderSubscribe();
        chatIdUnsubscriber?.();
        window.removeEventListener("message", onMessageHandler);
        store_get($$store_subs ??= {}, "$socket", socket)?.off("events", chatEventHandler);
        store_get($$store_subs ??= {}, "$audioQueue", audioQueue)?.destroy();
      } catch (e) {
        /* @__PURE__ */ console.error(e);
      }
    });
    const uploadGoogleDriveFile = async (fileData) => {
      /* @__PURE__ */ console.log("Starting uploadGoogleDriveFile with:", {
        id: fileData.id,
        name: fileData.name,
        url: fileData.url,
        headers: { Authorization: `Bearer ${token}` }
      });
      if (!fileData?.id || !fileData?.name || !fileData?.url || !fileData?.headers?.Authorization) {
        throw new Error("Invalid file data provided");
      }
      const tempItemId = v4();
      const fileItem = {
        type: "file",
        file: "",
        id: null,
        url: fileData.url,
        name: fileData.name,
        collection_name: "",
        status: "uploading",
        error: "",
        itemId: tempItemId,
        size: 0
      };
      try {
        files = [...files, fileItem];
        /* @__PURE__ */ console.log("Processing web file with URL:", fileData.url);
        const fetchOptions = {
          headers: { Authorization: fileData.headers.Authorization, Accept: "*/*" },
          method: "GET"
        };
        /* @__PURE__ */ console.log("Fetching file content from Google Drive...");
        const fileResponse = await fetch(fileData.url, fetchOptions);
        if (!fileResponse.ok) {
          const errorText = await fileResponse.text();
          throw new Error(`Failed to fetch file (${fileResponse.status}): ${errorText}`);
        }
        const contentType = fileResponse.headers.get("content-type") || "application/octet-stream";
        /* @__PURE__ */ console.log("Response received with content-type:", contentType);
        /* @__PURE__ */ console.log("Converting response to blob...");
        const fileBlob = await fileResponse.blob();
        if (fileBlob.size === 0) {
          throw new Error("Retrieved file is empty");
        }
        /* @__PURE__ */ console.log("Blob created:", { size: fileBlob.size, type: fileBlob.type || contentType });
        const file = new File([fileBlob], fileData.name, { type: fileBlob.type || contentType });
        /* @__PURE__ */ console.log("File object created:", { name: file.name, size: file.size, type: file.type });
        if (file.size === 0) {
          throw new Error("Created file is empty");
        }
        let metadata = null;
        if ((file.type.startsWith("audio/") || file.type.startsWith("video/")) && store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language) {
          metadata = {
            language: store_get($$store_subs ??= {}, "$settings", settings)?.audio?.stt?.language
          };
        }
        /* @__PURE__ */ console.log("Uploading file to server...");
        const uploadedFile = await uploadFile(localStorage.token, file, metadata);
        if (!uploadedFile) {
          throw new Error("Server returned null response for file upload");
        }
        /* @__PURE__ */ console.log("File uploaded successfully:", uploadedFile);
        fileItem.status = "uploaded";
        fileItem.file = uploadedFile;
        fileItem.id = uploadedFile.id;
        fileItem.size = file.size;
        fileItem.collection_name = uploadedFile?.meta?.collection_name;
        fileItem.url = `${uploadedFile.id}`;
        files = files;
        toast.success(store_get($$store_subs ??= {}, "$i18n", i18n).t("File uploaded successfully"));
      } catch (e) {
        /* @__PURE__ */ console.error("Error uploading file:", e);
        files = files.filter((f) => f.itemId !== tempItemId);
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Error uploading file: {{error}}", { error: e.message || "Unknown error" }));
      }
    };
    const uploadWeb = async (urls) => {
      if (!Array.isArray(urls)) {
        urls = [urls];
      }
      const fileItems = urls.map((url2) => ({
        type: "text",
        name: url2,
        collection_name: "",
        status: "uploading",
        context: "full",
        url: url2,
        error: ""
      }));
      files = [...files, ...fileItems];
      for (const fileItem of fileItems) {
        try {
          const res = isYoutubeUrl(fileItem.url) ? await processYoutubeVideo(localStorage.token, fileItem.url) : await processWeb(localStorage.token, "", fileItem.url);
          if (res) {
            fileItem.status = "uploaded";
            fileItem.collection_name = res.collection_name;
            fileItem.file = { ...res.file, ...fileItem.file };
          }
          files = [...files];
        } catch (e) {
          files = files.filter((f) => f.name !== url);
          toast.error(`${e}`);
        }
      }
    };
    const onUpload = async (event) => {
      const { type, data } = event;
      if (type === "google-drive") {
        await uploadGoogleDriveFile(data);
      } else if (type === "web") {
        await uploadWeb(data);
      }
    };
    const getContents = () => {
      const messages = history ? createMessagesList(history, history.currentId) : [];
      let contents = [];
      messages.forEach((message) => {
        if (message?.role !== "user" && message?.content) {
          const {
            codeBlocks,
            html: htmlContent,
            css: cssContent,
            js: jsContent
          } = getCodeBlockContents(message.content);
          if (htmlContent || cssContent || jsContent) {
            const renderedContent = `
                        <!DOCTYPE html>
                        <html lang="en">
                        <head>
                            <meta charset="UTF-8">
                            <meta name="viewport" content="width=device-width, initial-scale=1.0">
							<${""}style>
								body {
									background-color: white; /* Ensure the iframe has a white background */
								}

								${cssContent}
							</${""}style>
                        </head>
                        <body>
                            ${htmlContent}

							<${""}script>
                            	${jsContent}
							</${""}script>
                        </body>
                        </html>
                    `;
            contents = [...contents, { type: "iframe", content: renderedContent }];
          } else {
            for (const block of codeBlocks) {
              if (block.lang === "svg" || block.lang === "xml" && block.code.includes("<svg")) {
                contents = [...contents, { type: "svg", content: block.code }];
              }
            }
          }
        }
      });
      artifactContents.set(contents);
    };
    const initNewChat = async () => {
      /* @__PURE__ */ console.log("initNewChat");
      if (store_get($$store_subs ??= {}, "$user", user)?.role !== "admin" && store_get($$store_subs ??= {}, "$user", user)?.permissions?.chat?.temporary_enforced) {
        await temporaryChatEnabled.set(true);
      }
      if (store_get($$store_subs ??= {}, "$settings", settings)?.temporaryChatByDefault ?? false) {
        if (store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled) === false) {
          await temporaryChatEnabled.set(true);
        } else if (store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled) === null) {
          await temporaryChatEnabled.set(false);
        }
      }
      if (store_get($$store_subs ??= {}, "$user", user)?.role !== "admin" && !store_get($$store_subs ??= {}, "$user", user)?.permissions?.chat?.temporary) {
        await temporaryChatEnabled.set(false);
      }
      const availableModels = store_get($$store_subs ??= {}, "$models", models).filter((m) => !(m?.info?.meta?.hidden ?? false)).map((m) => m.id);
      const defaultModels = store_get($$store_subs ??= {}, "$config", config)?.default_models ? store_get($$store_subs ??= {}, "$config", config)?.default_models.split(",") : [];
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("models") || store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("model")) {
        const urlModels = (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("models") || store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("model") || "")?.split(",");
        if (urlModels.length === 1) {
          if (!store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === urlModels[0])) {
            const modelSelectorButton = document.getElementById("model-selector-0-button");
            if (modelSelectorButton) {
              modelSelectorButton.click();
              await tick();
              const modelSelectorInput = document.getElementById("model-search-input");
              if (modelSelectorInput) {
                modelSelectorInput.focus();
                modelSelectorInput.value = urlModels[0];
                modelSelectorInput.dispatchEvent(new Event("input"));
              }
            }
          } else {
            selectedModels = urlModels;
          }
        } else {
          selectedModels = urlModels;
        }
        selectedModels = selectedModels.filter((modelId) => store_get($$store_subs ??= {}, "$models", models).map((m) => m.id).includes(modelId));
      } else {
        if (store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)?.data?.model_ids) {
          selectedModels = store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)?.data?.model_ids;
        } else {
          if (sessionStorage.selectedModels) {
            selectedModels = JSON.parse(sessionStorage.selectedModels);
            sessionStorage.removeItem("selectedModels");
          } else {
            if (store_get($$store_subs ??= {}, "$settings", settings)?.models) {
              selectedModels = store_get($$store_subs ??= {}, "$settings", settings)?.models;
            } else if (defaultModels && defaultModels.length > 0) {
              selectedModels = defaultModels;
            }
          }
        }
        selectedModels = selectedModels.filter((modelId) => availableModels.includes(modelId));
      }
      if (selectedModels.length === 0 || selectedModels.length === 1 && selectedModels[0] === "") {
        if (availableModels.length > 0) {
          if (defaultModels && defaultModels.length > 0) {
            selectedModels = defaultModels.filter((modelId) => availableModels.includes(modelId));
          }
          selectedModels = [availableModels?.at(0) ?? ""];
        } else {
          selectedModels = [""];
        }
      }
      await showControls.set(false);
      await showCallOverlay.set(false);
      await showOverview.set(false);
      await showArtifacts.set(false);
      if (store_get($$store_subs ??= {}, "$page", page).url.pathname.includes("/c/")) {
        window.history.replaceState(history.state, "", `/`);
      }
      autoScroll = true;
      resetInput();
      await chatId.set("");
      await chatTitle.set("");
      history = { messages: {}, currentId: null };
      chatFiles = [];
      params = {};
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("youtube")) {
        await uploadWeb(`https://www.youtube.com/watch?v=${store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("youtube")}`);
      }
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("load-url")) {
        await uploadWeb(store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("load-url"));
      }
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("web-search") === "true") {
        webSearchEnabled = true;
      }
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("image-generation") === "true") {
        imageGenerationEnabled = true;
      }
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("code-interpreter") === "true") {
        codeInterpreterEnabled = true;
      }
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("tools")) {
        selectedToolIds = store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("tools")?.split(",").map((id) => id.trim()).filter((id) => id);
      } else if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("tool-ids")) {
        selectedToolIds = store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("tool-ids")?.split(",").map((id) => id.trim()).filter((id) => id);
      }
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("call") === "true") {
        showCallOverlay.set(true);
        showControls.set(true);
      }
      if (store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("q")) {
        const q = store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("q") ?? "";
        messageInput?.setText(q);
        if (q) {
          if ((store_get($$store_subs ??= {}, "$page", page).url.searchParams.get("submit") ?? "true") === "true") {
            await tick();
            submitPrompt(q);
          }
        }
      }
      selectedModels = selectedModels.map((modelId) => store_get($$store_subs ??= {}, "$models", models).map((m) => m.id).includes(modelId) ? modelId : "");
      const chatInput = document.getElementById("chat-input");
      setTimeout(() => chatInput?.focus(), 0);
    };
    const loadChat = async () => {
      chatId.set(chatIdProp);
      if (store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
        temporaryChatEnabled.set(false);
      }
      chat = await getChatById(localStorage.token, store_get($$store_subs ??= {}, "$chatId", chatId)).catch(async (error) => {
        await goto();
        return null;
      });
      if (chat) {
        await getTagsById(localStorage.token, store_get($$store_subs ??= {}, "$chatId", chatId)).catch(async (error) => {
          return [];
        });
        const chatContent = chat.chat;
        if (chatContent) {
          /* @__PURE__ */ console.log(chatContent);
          selectedModels = (chatContent?.models ?? void 0) !== void 0 ? chatContent.models : [chatContent.models ?? ""];
          if (!(store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || (store_get($$store_subs ??= {}, "$user", user)?.permissions?.chat?.multiple_models ?? true))) {
            selectedModels = selectedModels.length > 0 ? [selectedModels[0]] : [""];
          }
          oldSelectedModelIds = JSON.parse(JSON.stringify(selectedModels));
          history = (chatContent?.history ?? void 0) !== void 0 ? chatContent.history : convertMessagesToHistory(chatContent.messages);
          chatTitle.set(chatContent.title);
          params = chatContent?.params ?? {};
          chatFiles = chatContent?.files ?? [];
          autoScroll = true;
          await tick();
          if (history.currentId) {
            for (const message of Object.values(history.messages)) {
              if (message && message.role === "assistant") {
                message.done = true;
              }
            }
          }
          const taskRes = await getTaskIdsByChatId(localStorage.token, store_get($$store_subs ??= {}, "$chatId", chatId)).catch((error) => {
            return null;
          });
          if (taskRes) {
            taskIds = taskRes.task_ids;
          }
          await tick();
          return true;
        } else {
          return null;
        }
      }
    };
    const scrollToBottom = async (behavior = "auto") => {
      await tick();
    };
    const chatCompletedHandler = async (_chatId, modelId, responseMessageId, messages) => {
      const res = await chatCompleted(localStorage.token, {
        model: modelId,
        messages: messages.map((m) => ({
          id: m.id,
          role: m.role,
          content: m.content,
          info: m.info ? m.info : void 0,
          timestamp: m.timestamp,
          ...m.usage ? { usage: m.usage } : {},
          ...m.sources ? { sources: m.sources } : {}
        })),
        filter_ids: selectedFilterIds.length > 0 ? selectedFilterIds : void 0,
        model_item: store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === modelId),
        chat_id: _chatId,
        session_id: store_get($$store_subs ??= {}, "$socket", socket)?.id,
        id: responseMessageId
      }).catch((error) => {
        toast.error(`${error}`);
        messages.at(-1).error = { content: error };
        return null;
      });
      if (res !== null && res.messages) {
        for (const message of res.messages) {
          if (message?.id) {
            history.messages[message.id] = {
              ...history.messages[message.id],
              ...history.messages[message.id].content !== message.content ? { originalContent: history.messages[message.id].content } : {},
              ...message
            };
          }
        }
      }
      await tick();
      if (store_get($$store_subs ??= {}, "$chatId", chatId) == _chatId) {
        if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
          chat = await updateChatById(localStorage.token, _chatId, {
            models: selectedModels,
            messages,
            history,
            params,
            files: chatFiles
          });
          currentChatPage.set(1);
          await chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
        }
      }
      taskIds = null;
      if (messageQueue.length > 0) {
        const combinedPrompt = messageQueue.map((m) => m.prompt).join("\n\n");
        const combinedFiles = messageQueue.flatMap((m) => m.files);
        messageQueue = [];
        files = combinedFiles;
        await tick();
        await submitPrompt(combinedPrompt);
      }
    };
    const chatActionHandler = async (_chatId, actionId, modelId, responseMessageId, event = null) => {
      const messages = createMessagesList(history, responseMessageId);
      const res = await chatAction(localStorage.token, actionId, {
        model: modelId,
        messages: messages.map((m) => ({
          id: m.id,
          role: m.role,
          content: m.content,
          info: m.info ? m.info : void 0,
          timestamp: m.timestamp,
          ...m.sources ? { sources: m.sources } : {}
        })),
        ...event ? { event } : {},
        model_item: store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === modelId),
        chat_id: _chatId,
        session_id: store_get($$store_subs ??= {}, "$socket", socket)?.id,
        id: responseMessageId
      }).catch((error) => {
        toast.error(`${error}`);
        messages.at(-1).error = { content: error };
        return null;
      });
      if (res !== null && res.messages) {
        for (const message of res.messages) {
          history.messages[message.id] = {
            ...history.messages[message.id],
            ...history.messages[message.id].content !== message.content ? { originalContent: history.messages[message.id].content } : {},
            ...message
          };
        }
      }
      if (store_get($$store_subs ??= {}, "$chatId", chatId) == _chatId) {
        if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
          chat = await updateChatById(localStorage.token, _chatId, {
            models: selectedModels,
            messages,
            history,
            params,
            files: chatFiles
          });
          currentChatPage.set(1);
          await chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
        }
      }
    };
    const getChatEventEmitter = async (modelId, chatId2 = "") => {
      return setInterval(
        () => {
          store_get($$store_subs ??= {}, "$socket", socket)?.emit("usage", { action: "chat", model: modelId, chat_id: chatId2 });
        },
        1e3
      );
    };
    const createMessagePair = async (userPrompt) => {
      messageInput?.setText("");
      if (selectedModels.length === 0) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Model not selected"));
      } else {
        const modelId = selectedModels[0];
        const model = store_get($$store_subs ??= {}, "$models", models).filter((m) => m.id === modelId).at(0);
        if (!model) {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Model not found"));
          return;
        }
        const messages = createMessagesList(history, history.currentId);
        const parentMessage = messages.length !== 0 ? messages.at(-1) : null;
        const userMessageId = v4();
        const responseMessageId = v4();
        const userMessage = {
          id: userMessageId,
          parentId: parentMessage ? parentMessage.id : null,
          childrenIds: [responseMessageId],
          role: "user",
          content: userPrompt ? userPrompt : `[PROMPT] ${userMessageId}`,
          timestamp: Math.floor(Date.now() / 1e3)
        };
        const responseMessage = {
          id: responseMessageId,
          parentId: userMessageId,
          childrenIds: [],
          role: "assistant",
          content: `[RESPONSE] ${responseMessageId}`,
          done: true,
          model: modelId,
          modelName: model.name ?? model.id,
          modelIdx: 0,
          timestamp: Math.floor(Date.now() / 1e3)
        };
        if (parentMessage) {
          parentMessage.childrenIds.push(userMessageId);
          history.messages[parentMessage.id] = parentMessage;
        }
        history.messages[userMessageId] = userMessage;
        history.messages[responseMessageId] = responseMessage;
        history.currentId = responseMessageId;
        await tick();
        if (autoScroll) {
          scrollToBottom();
        }
        if (messages.length === 0) {
          await initChatHandler(history);
        } else {
          await saveChatHandler(store_get($$store_subs ??= {}, "$chatId", chatId), history);
        }
      }
    };
    const addMessages = async ({ modelId, parentId, messages }) => {
      const model = store_get($$store_subs ??= {}, "$models", models).filter((m) => m.id === modelId).at(0);
      let parentMessage = history.messages[parentId];
      let currentParentId = parentMessage ? parentMessage.id : null;
      for (const message of messages) {
        let messageId = v4();
        if (message.role === "user") {
          const userMessage = {
            id: messageId,
            parentId: currentParentId,
            childrenIds: [],
            timestamp: Math.floor(Date.now() / 1e3),
            ...message
          };
          if (parentMessage) {
            parentMessage.childrenIds.push(messageId);
            history.messages[parentMessage.id] = parentMessage;
          }
          history.messages[messageId] = userMessage;
          parentMessage = userMessage;
          currentParentId = messageId;
        } else {
          const responseMessage = {
            id: messageId,
            parentId: currentParentId,
            childrenIds: [],
            done: true,
            model: model.id,
            modelName: model.name ?? model.id,
            modelIdx: 0,
            timestamp: Math.floor(Date.now() / 1e3),
            ...message
          };
          if (parentMessage) {
            parentMessage.childrenIds.push(messageId);
            history.messages[parentMessage.id] = parentMessage;
          }
          history.messages[messageId] = responseMessage;
          parentMessage = responseMessage;
          currentParentId = messageId;
        }
      }
      history.currentId = currentParentId;
      await tick();
      if (autoScroll) {
        scrollToBottom();
      }
      if (messages.length === 0) {
        await initChatHandler(history);
      } else {
        await saveChatHandler(store_get($$store_subs ??= {}, "$chatId", chatId), history);
      }
    };
    const chatCompletionEventHandler = async (data, message, chatId2) => {
      const {
        id,
        done,
        choices,
        content,
        output,
        sources,
        selected_model_id,
        error,
        usage
      } = data;
      if (output) {
        message.output = output;
      }
      if (error) {
        await handleOpenAIError(error, message);
      }
      if (sources && !message?.sources) {
        message.sources = sources;
      }
      if (choices) {
        if (choices[0]?.message?.content) {
          message.content += choices[0]?.message?.content;
        } else {
          let value = choices[0]?.delta?.content ?? "";
          if (message.content == "" && value == "\n") {
            /* @__PURE__ */ console.log("Empty response");
          } else {
            message.content += value;
            if (navigator.vibrate && (store_get($$store_subs ??= {}, "$settings", settings)?.hapticFeedback ?? false)) {
              navigator.vibrate(5);
            }
            const messageContentParts = getMessageContentParts(removeAllDetails(message.content), store_get($$store_subs ??= {}, "$config", config)?.audio?.tts?.split_on ?? "punctuation");
            messageContentParts.pop();
            if (messageContentParts.length > 0 && messageContentParts[messageContentParts.length - 1] !== message.lastSentence) {
              message.lastSentence = messageContentParts[messageContentParts.length - 1];
              eventTarget.dispatchEvent(new CustomEvent("chat", {
                detail: {
                  id: message.id,
                  content: messageContentParts[messageContentParts.length - 1]
                }
              }));
            }
          }
        }
      }
      if (content) {
        message.content = content;
        if (navigator.vibrate && (store_get($$store_subs ??= {}, "$settings", settings)?.hapticFeedback ?? false)) {
          navigator.vibrate(5);
        }
        const messageContentParts = getMessageContentParts(removeAllDetails(message.content), store_get($$store_subs ??= {}, "$config", config)?.audio?.tts?.split_on ?? "punctuation");
        messageContentParts.pop();
        if (messageContentParts.length > 0 && messageContentParts[messageContentParts.length - 1] !== message.lastSentence) {
          message.lastSentence = messageContentParts[messageContentParts.length - 1];
          eventTarget.dispatchEvent(new CustomEvent("chat", {
            detail: {
              id: message.id,
              content: messageContentParts[messageContentParts.length - 1]
            }
          }));
        }
      }
      if (selected_model_id) {
        message.selectedModelId = selected_model_id;
        message.arena = true;
      }
      if (usage) {
        message.usage = usage;
      }
      history.messages[message.id] = message;
      if (done) {
        message.done = true;
        if (store_get($$store_subs ??= {}, "$settings", settings).responseAutoCopy) {
          copyToClipboard(message.content);
        }
        if (store_get($$store_subs ??= {}, "$settings", settings).responseAutoPlayback && !store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay)) {
          await tick();
          document.getElementById(`speak-button-${message.id}`)?.click();
        }
        let lastMessageContentPart = getMessageContentParts(removeAllDetails(message.content), store_get($$store_subs ??= {}, "$config", config)?.audio?.tts?.split_on ?? "punctuation")?.at(-1) ?? "";
        if (lastMessageContentPart) {
          eventTarget.dispatchEvent(new CustomEvent("chat", { detail: { id: message.id, content: lastMessageContentPart } }));
        }
        eventTarget.dispatchEvent(new CustomEvent("chat:finish", { detail: { id: message.id, content: message.content } }));
        history.messages[message.id] = message;
        await tick();
        if (autoScroll) {
          scrollToBottom();
        }
        await chatCompletedHandler(chatId2, message.model, message.id, createMessagesList(history, message.id));
      }
      /* @__PURE__ */ console.log(data);
      await tick();
      if (autoScroll) {
        scrollToBottom();
      }
    };
    const submitPrompt = async (userPrompt, { _raw = false } = {}) => {
      /* @__PURE__ */ console.log("submitPrompt", userPrompt, store_get($$store_subs ??= {}, "$chatId", chatId));
      const _selectedModels = selectedModels.map((modelId) => store_get($$store_subs ??= {}, "$models", models).map((m) => m.id).includes(modelId) ? modelId : "");
      if (JSON.stringify(selectedModels) !== JSON.stringify(_selectedModels)) {
        selectedModels = _selectedModels;
      }
      if (userPrompt === "" && files.length === 0) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Please enter a prompt"));
        return;
      }
      if (selectedModels.includes("")) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Model not selected"));
        return;
      }
      if (files.length > 0 && files.filter((file) => file.type !== "image" && file.status === "uploading").length > 0) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`Oops! There are files still uploading. Please wait for the upload to complete.`));
        return;
      }
      if ((store_get($$store_subs ??= {}, "$config", config)?.file?.max_count ?? null) !== null && files.length + chatFiles.length > store_get($$store_subs ??= {}, "$config", config)?.file?.max_count) {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`You can only chat with a maximum of {{maxCount}} file(s) at a time.`, {
          maxCount: store_get($$store_subs ??= {}, "$config", config)?.file?.max_count
        }));
        return;
      }
      if (taskIds !== null && taskIds.length > 0) {
        if (store_get($$store_subs ??= {}, "$settings", settings)?.enableMessageQueue ?? true) {
          const _files2 = JSON.parse(JSON.stringify(files));
          messageQueue = [
            ...messageQueue,
            { id: v4(), prompt: userPrompt, files: _files2 }
          ];
          messageInput?.setText("");
          prompt = "";
          files = [];
          return;
        } else {
          await stopResponse();
          await tick();
        }
      }
      if (history?.currentId) {
        const lastMessage = history.messages[history.currentId];
        if (lastMessage.error && !lastMessage.content) {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`Oops! There was an error in the previous response.`));
          return;
        }
      }
      messageInput?.setText("");
      prompt = "";
      const messages = createMessagesList(history, history.currentId);
      const _files = JSON.parse(JSON.stringify(files));
      chatFiles.push(..._files.filter((item) => ["doc", "text", "note", "chat", "folder", "collection"].includes(item.type) || item.type === "file" && !(item?.content_type ?? "").startsWith("image/")));
      chatFiles = chatFiles.filter(
        // Remove duplicates
        (item, index, array) => array.findIndex((i) => JSON.stringify(i) === JSON.stringify(item)) === index
      );
      files = [];
      messageInput?.setText("");
      let userMessageId = v4();
      let userMessage = {
        id: userMessageId,
        parentId: messages.length !== 0 ? messages.at(-1).id : null,
        childrenIds: [],
        role: "user",
        content: userPrompt,
        files: _files.length > 0 ? _files : void 0,
        timestamp: Math.floor(Date.now() / 1e3),
        // Unix epoch
        models: selectedModels
      };
      history.messages[userMessageId] = userMessage;
      history.currentId = userMessageId;
      if (messages.length !== 0) {
        history.messages[messages.at(-1).id].childrenIds.push(userMessageId);
      }
      const chatInput = document.getElementById("chat-input");
      chatInput?.focus();
      saveSessionSelectedModels();
      await sendMessage(history, userMessageId, { newChat: true });
    };
    const sendMessage = async (_history, parentId, {
      messages = null,
      modelId = null,
      modelIdx = null,
      newChat = false
    } = {}) => {
      if (autoScroll) {
        scrollToBottom();
      }
      let _chatId = JSON.parse(JSON.stringify(store_get($$store_subs ??= {}, "$chatId", chatId)));
      _history = JSON.parse(JSON.stringify(_history));
      const responseMessageIds = {};
      let selectedModelIds2 = modelId ? [modelId] : atSelectedModel !== void 0 ? [atSelectedModel.id] : selectedModels;
      for (const [_modelIdx, modelId2] of selectedModelIds2.entries()) {
        const model = store_get($$store_subs ??= {}, "$models", models).filter((m) => m.id === modelId2).at(0);
        if (model) {
          let responseMessageId = v4();
          let responseMessage = {
            parentId,
            id: responseMessageId,
            childrenIds: [],
            role: "assistant",
            content: "",
            model: model.id,
            modelName: model.name ?? model.id,
            modelIdx: modelIdx ? modelIdx : _modelIdx,
            timestamp: Math.floor(Date.now() / 1e3)
            // Unix epoch
          };
          history.messages[responseMessageId] = responseMessage;
          history.currentId = responseMessageId;
          if (parentId !== null && history.messages[parentId]) {
            history.messages[parentId].childrenIds = [...history.messages[parentId].childrenIds, responseMessageId];
          }
          responseMessageIds[`${modelId2}-${modelIdx ? modelIdx : _modelIdx}`] = responseMessageId;
        }
      }
      history = history;
      if (newChat && _history.messages[_history.currentId].parentId === null) {
        _chatId = await initChatHandler(_history);
      }
      await tick();
      _history = JSON.parse(JSON.stringify(history));
      await saveChatHandler(_chatId, _history);
      await Promise.all(selectedModelIds2.map(async (modelId2, _modelIdx) => {
        /* @__PURE__ */ console.log("modelId", modelId2);
        const model = store_get($$store_subs ??= {}, "$models", models).filter((m) => m.id === modelId2).at(0);
        if (model) {
          const hasImages = createMessagesList(_history, parentId).some((message) => message.files?.some((file) => file.type === "image" || (file?.content_type ?? "").startsWith("image/")));
          if (hasImages && !(model.info?.meta?.capabilities?.vision ?? true) && !imageGenerationEnabled) {
            toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Model {{modelName}} is not vision capable", { modelName: model.name ?? model.id }));
          }
          let responseMessageId = responseMessageIds[`${modelId2}-${modelIdx ? modelIdx : _modelIdx}`];
          const chatEventEmitter = await getChatEventEmitter(model.id, _chatId);
          scrollToBottom();
          await sendMessageSocket(
            model,
            messages && messages.length > 0 ? messages : createMessagesList(_history, responseMessageId),
            _history,
            responseMessageId
          );
          if (chatEventEmitter) clearInterval(chatEventEmitter);
        } else {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t(`Model {{modelId}} not found`, { modelId: modelId2 }));
        }
      }));
      currentChatPage.set(1);
      chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
    };
    const getFeatures = () => {
      let features = {};
      if (store_get($$store_subs ??= {}, "$config", config)?.features) features = {
        voice: store_get($$store_subs ??= {}, "$showCallOverlay", showCallOverlay),
        image_generation: store_get($$store_subs ??= {}, "$config", config)?.features?.enable_image_generation && (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || store_get($$store_subs ??= {}, "$user", user)?.permissions?.features?.image_generation) ? imageGenerationEnabled : false,
        code_interpreter: store_get($$store_subs ??= {}, "$config", config)?.features?.enable_code_interpreter && (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || store_get($$store_subs ??= {}, "$user", user)?.permissions?.features?.code_interpreter) ? codeInterpreterEnabled : false,
        web_search: store_get($$store_subs ??= {}, "$config", config)?.features?.enable_web_search && (store_get($$store_subs ??= {}, "$user", user)?.role === "admin" || store_get($$store_subs ??= {}, "$user", user)?.permissions?.features?.web_search) ? webSearchEnabled : false
      };
      const currentModels = atSelectedModel?.id ? [atSelectedModel.id] : selectedModels;
      if (currentModels.filter((model) => store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === model)?.info?.meta?.capabilities?.web_search ?? true).length === currentModels.length) {
        if (store_get($$store_subs ??= {}, "$config", config)?.features?.enable_web_search && (store_get($$store_subs ??= {}, "$settings", settings)?.webSearch ?? false) === "always") {
          features = { ...features, web_search: true };
        }
      }
      if (store_get($$store_subs ??= {}, "$settings", settings)?.memory ?? false) {
        features = { ...features, memory: true };
      }
      return features;
    };
    const sendMessageSocket = async (model, _messages, _history, responseMessageId, _chatId) => {
      const responseMessage = _history.messages[responseMessageId];
      const userMessage = _history.messages[responseMessage.parentId];
      const chatMessageFiles = _messages.filter((message) => message.files).flatMap((message) => message.files);
      chatFiles = chatFiles.filter((item) => {
        const fileExists = chatMessageFiles.some((messageFile) => messageFile.id === item.id);
        return fileExists;
      });
      let files2 = JSON.parse(JSON.stringify(chatFiles));
      files2.push(...(userMessage?.files ?? []).filter((item) => ["doc", "text", "note", "chat", "collection"].includes(item.type) || item.type === "file" && !(item?.content_type ?? "").startsWith("image/")));
      files2 = files2.filter((item, index, array) => array.findIndex((i) => JSON.stringify(i) === JSON.stringify(item)) === index);
      scrollToBottom();
      eventTarget.dispatchEvent(new CustomEvent("chat:start", { detail: { id: responseMessageId } }));
      await tick();
      let userLocation;
      if (store_get($$store_subs ??= {}, "$settings", settings)?.userLocation) {
        userLocation = await getAndUpdateUserLocation(localStorage.token).catch((err) => {
          /* @__PURE__ */ console.error(err);
          return void 0;
        });
      }
      const stream = model?.info?.params?.stream_response ?? store_get($$store_subs ??= {}, "$settings", settings)?.params?.stream_response ?? params?.stream_response ?? true;
      let messages = [
        params?.system || store_get($$store_subs ??= {}, "$settings", settings).system ? {
          role: "system",
          content: `${params?.system ?? store_get($$store_subs ??= {}, "$settings", settings)?.system ?? ""}`
        } : void 0,
        ..._messages.map((message) => ({
          ...message,
          content: processDetails(message.content),
          // Include output for temp chats (backend will use it and strip before LLM)
          ...message.output ? { output: message.output } : {}
        }))
      ].filter((message) => message);
      messages = messages.map((message, idx, arr) => {
        const imageFiles = (message?.files ?? []).filter((file) => file.type === "image" || (file?.content_type ?? "").startsWith("image/"));
        return {
          role: message.role,
          ...message.role === "user" && imageFiles.length > 0 ? {
            content: [
              {
                type: "text",
                text: message?.merged?.content ?? message.content
              },
              ...imageFiles.map((file) => ({ type: "image_url", image_url: { url: file.url } }))
            ]
          } : { content: message?.merged?.content ?? message.content }
        };
      }).filter((message) => message?.role === "user" || message?.content?.trim());
      const toolIds = [];
      const toolServerIds = [];
      for (const toolId of selectedToolIds) {
        if (toolId.startsWith("direct_server:")) {
          let serverId = toolId.replace("direct_server:", "");
          if (!isNaN(parseInt(serverId))) {
            toolServerIds.push(parseInt(serverId));
          } else {
            toolServerIds.push(serverId);
          }
        } else {
          toolIds.push(toolId);
        }
      }
      const skillMentionRegex = /<\$([^|>]+)\|?[^>]*>/g;
      const skillIds = [];
      for (const message of messages) {
        const content = typeof message.content === "string" ? message.content : message.content?.[0]?.text ?? "";
        for (const match of content.matchAll(skillMentionRegex)) {
          if (!skillIds.includes(match[1])) {
            skillIds.push(match[1]);
          }
        }
      }
      if (skillIds.length > 0) {
        messages = messages.map((message) => {
          if (typeof message.content === "string") {
            return {
              ...message,
              content: message.content.replace(/<\$[^>]+>/g, "").trim()
            };
          } else if (Array.isArray(message.content)) {
            return {
              ...message,
              content: message.content.map((part) => part.type === "text" ? { ...part, text: part.text.replace(/<\$[^>]+>/g, "").trim() } : part)
            };
          }
          return message;
        });
      }
      const res = await generateOpenAIChatCompletion(
        localStorage.token,
        {
          stream,
          model: model.id,
          messages,
          params: {
            ...store_get($$store_subs ??= {}, "$settings", settings)?.params,
            ...params,
            stop: params?.stop ?? store_get($$store_subs ??= {}, "$settings", settings)?.params?.stop ?? void 0 ? (params?.stop.split(",").map((token2) => token2.trim()) ?? store_get($$store_subs ??= {}, "$settings", settings).params.stop).map((str) => decodeURIComponent(JSON.parse('"' + str.replace(/\"/g, '\\"') + '"'))) : void 0
          },
          files: (files2?.length ?? 0) > 0 ? files2 : void 0,
          filter_ids: selectedFilterIds.length > 0 ? selectedFilterIds : void 0,
          tool_ids: toolIds.length > 0 ? toolIds : void 0,
          skill_ids: skillIds.length > 0 ? skillIds : void 0,
          tool_servers: (store_get($$store_subs ??= {}, "$toolServers", toolServers) ?? []).filter((server, idx) => toolServerIds.includes(idx) || toolServerIds.includes(server?.id)),
          features: getFeatures(),
          variables: {
            ...getPromptVariables(store_get($$store_subs ??= {}, "$user", user)?.name, store_get($$store_subs ??= {}, "$settings", settings)?.userLocation ? userLocation : void 0, store_get($$store_subs ??= {}, "$user", user)?.email)
          },
          model_item: store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === model.id),
          session_id: store_get($$store_subs ??= {}, "$socket", socket)?.id,
          chat_id: store_get($$store_subs ??= {}, "$chatId", chatId),
          id: responseMessageId,
          parent_id: userMessage?.id ?? null,
          parent_message: userMessage,
          background_tasks: {
            ...!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled) && (messages.length == 1 || messages.length == 2 && messages.at(0)?.role === "system" && messages.at(1)?.role === "user") && (selectedModels[0] === model.id || atSelectedModel !== void 0) ? {
              title_generation: store_get($$store_subs ??= {}, "$settings", settings)?.title?.auto ?? true,
              tags_generation: store_get($$store_subs ??= {}, "$settings", settings)?.autoTags ?? true
            } : {},
            follow_up_generation: store_get($$store_subs ??= {}, "$settings", settings)?.autoFollowUps ?? true
          },
          ...stream && (model.info?.meta?.capabilities?.usage ?? false) ? { stream_options: { include_usage: true } } : {}
        },
        `${WEBUI_BASE_URL}/api`
      ).catch(async (error) => {
        /* @__PURE__ */ console.log(error);
        let errorMessage = error;
        if (error?.error?.message) {
          errorMessage = error.error.message;
        } else if (error?.message) {
          errorMessage = error.message;
        }
        if (typeof errorMessage === "object") {
          errorMessage = store_get($$store_subs ??= {}, "$i18n", i18n).t(`Uh-oh! There was an issue with the response.`);
        }
        toast.error(`${errorMessage}`);
        responseMessage.error = { content: error };
        responseMessage.done = true;
        history.messages[responseMessageId] = responseMessage;
        history.currentId = responseMessageId;
        return null;
      });
      if (res) {
        if (res.error) {
          await handleOpenAIError(res.error, responseMessage);
        } else {
          if (taskIds) {
            taskIds.push(res.task_id);
          } else {
            taskIds = [res.task_id];
          }
        }
      }
      await tick();
      scrollToBottom();
    };
    const handleOpenAIError = async (error, responseMessage) => {
      let errorMessage = "";
      let innerError;
      if (error) {
        innerError = error;
      }
      /* @__PURE__ */ console.error(innerError);
      if ("detail" in innerError) {
        toast.error(innerError.detail);
        errorMessage = innerError.detail;
      } else if ("error" in innerError) {
        if ("message" in innerError.error) {
          toast.error(innerError.error.message);
          errorMessage = innerError.error.message;
        } else {
          toast.error(innerError.error);
          errorMessage = innerError.error;
        }
      } else if ("message" in innerError) {
        toast.error(innerError.message);
        errorMessage = innerError.message;
      }
      responseMessage.error = {
        content: store_get($$store_subs ??= {}, "$i18n", i18n).t(`Uh-oh! There was an issue with the response.`) + "\n" + errorMessage
      };
      responseMessage.done = true;
      if (responseMessage.statusHistory) {
        responseMessage.statusHistory = responseMessage.statusHistory.filter((status) => status.action !== "knowledge_search");
      }
      history.messages[responseMessage.id] = responseMessage;
    };
    const stopResponse = async () => {
      if (taskIds) {
        for (const taskId of taskIds) {
          await stopTask(localStorage.token, taskId).catch((error) => {
            toast.error(`${error}`);
            return null;
          });
        }
        taskIds = null;
        const responseMessage = history.messages[history.currentId];
        if (responseMessage.parentId && history.messages[responseMessage.parentId]) {
          for (const messageId of history.messages[responseMessage.parentId].childrenIds) {
            history.messages[messageId].done = true;
          }
        }
        history.messages[history.currentId] = responseMessage;
        if (autoScroll) {
          scrollToBottom();
        }
      }
      if (generating) {
        generating = false;
        generationController?.abort();
        generationController = null;
      }
    };
    const submitMessage = async (parentId, prompt2) => {
      let userPrompt = prompt2;
      let userMessageId = v4();
      let userMessage = {
        id: userMessageId,
        parentId,
        childrenIds: [],
        role: "user",
        content: userPrompt,
        models: selectedModels,
        timestamp: Math.floor(Date.now() / 1e3)
        // Unix epoch
      };
      if (parentId !== null) {
        history.messages[parentId].childrenIds = [...history.messages[parentId].childrenIds, userMessageId];
      }
      history.messages[userMessageId] = userMessage;
      history.currentId = userMessageId;
      await tick();
      if (autoScroll) {
        scrollToBottom();
      }
      await sendMessage(history, userMessageId);
    };
    const regenerateResponse = async (message, suggestionPrompt = null) => {
      /* @__PURE__ */ console.log("regenerateResponse");
      if (history.currentId) {
        let userMessage = history.messages[message.parentId];
        if (!userMessage) {
          toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Parent message not found"));
          return;
        }
        if (autoScroll) {
          scrollToBottom();
        }
        await sendMessage(history, userMessage.id, {
          ...suggestionPrompt ? {
            messages: [
              ...createMessagesList(history, message.id),
              { role: "user", content: suggestionPrompt }
            ]
          } : {},
          ...(userMessage?.models ?? [...selectedModels]).length > 1 ? {
            // If multiple models are selected, use the model from the message
            modelId: message.model,
            modelIdx: message.modelIdx
          } : {}
        });
      }
    };
    const continueResponse = async () => {
      /* @__PURE__ */ console.log("continueResponse");
      JSON.parse(JSON.stringify(store_get($$store_subs ??= {}, "$chatId", chatId)));
      if (history.currentId && history.messages[history.currentId].done == true) {
        const responseMessage = history.messages[history.currentId];
        responseMessage.done = false;
        await tick();
        const model = store_get($$store_subs ??= {}, "$models", models).filter((m) => m.id === (responseMessage?.selectedModelId ?? responseMessage.model)).at(0);
        if (model) {
          await sendMessageSocket(model, createMessagesList(history, responseMessage.id), history, responseMessage.id);
        }
      }
    };
    const mergeResponses = async (messageId, responses, _chatId) => {
      /* @__PURE__ */ console.log("mergeResponses", messageId, responses);
      const message = history.messages[messageId];
      const mergedResponse = { status: true, content: "" };
      message.merged = mergedResponse;
      history.messages[messageId] = message;
      try {
        generating = true;
        const [res, controller] = await generateMoACompletion(localStorage.token, message.model ?? "", message.parentId ? history.messages[message.parentId].content : "", responses);
        if (res && res.ok && res.body && generating) {
          generationController = controller;
          const textStream = await createOpenAITextStream(res.body, Boolean(store_get($$store_subs ??= {}, "$settings", settings)?.splitLargeChunks ?? false));
          for await (const update of textStream) {
            const { value, done, sources, error, usage } = update;
            if (error || done) {
              generating = false;
              generationController = null;
              break;
            }
            if (mergedResponse.content == "" && value == "\n") {
              continue;
            } else {
              mergedResponse.content += value;
              history.messages[messageId] = message;
            }
            if (autoScroll) {
              scrollToBottom();
            }
          }
          await saveChatHandler(_chatId, history);
        } else {
          /* @__PURE__ */ console.error(res);
        }
      } catch (e) {
        /* @__PURE__ */ console.error(e);
      }
    };
    const initChatHandler = async (history2) => {
      let _chatId = store_get($$store_subs ??= {}, "$chatId", chatId);
      if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
        chat = await createNewChat(
          localStorage.token,
          {
            id: _chatId,
            title: store_get($$store_subs ??= {}, "$i18n", i18n).t("New Chat"),
            models: selectedModels,
            system: store_get($$store_subs ??= {}, "$settings", settings).system ?? void 0,
            params,
            history: history2,
            messages: createMessagesList(history2, history2.currentId),
            tags: [],
            timestamp: Date.now()
          },
          store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)?.id
        );
        _chatId = chat.id;
        await chatId.set(_chatId);
        window.history.replaceState(history2.state, "", `/c/${_chatId}`);
        await tick();
        await chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
        currentChatPage.set(1);
        selectedFolder.set(null);
      } else {
        _chatId = `local:${store_get($$store_subs ??= {}, "$socket", socket)?.id}`;
        await chatId.set(_chatId);
      }
      await tick();
      return _chatId;
    };
    const saveChatHandler = async (_chatId, history2) => {
      if (store_get($$store_subs ??= {}, "$chatId", chatId) == _chatId) {
        if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
          chat = await updateChatById(localStorage.token, _chatId, {
            models: selectedModels,
            history: history2,
            messages: createMessagesList(history2, history2.currentId),
            params,
            files: chatFiles
          });
          currentChatPage.set(1);
          await chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
        }
      }
    };
    const MAX_DRAFT_LENGTH = 5e3;
    let saveDraftTimeout = null;
    const saveDraft = async (draft, chatId2 = null) => {
      if (saveDraftTimeout) {
        clearTimeout(saveDraftTimeout);
      }
      if (draft.prompt !== null && draft.prompt.length < MAX_DRAFT_LENGTH) {
        saveDraftTimeout = setTimeout(
          async () => {
            await sessionStorage.setItem(`chat-input${chatId2 ? `-${chatId2}` : ""}`, JSON.stringify(draft));
          },
          500
        );
      } else {
        sessionStorage.removeItem(`chat-input${chatId2 ? `-${chatId2}` : ""}`);
      }
    };
    const moveChatHandler = async (chatId2, folderId2) => {
      if (chatId2 && folderId2) {
        const res = await updateChatFolderIdById(localStorage.token, chatId2, folderId2).catch((error) => {
          toast.error(`${error}`);
          return null;
        });
        if (res) {
          currentChatPage.set(1);
          await chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
          await pinnedChats.set(await getPinnedChatList(localStorage.token));
          toast.success(store_get($$store_subs ??= {}, "$i18n", i18n).t("Chat moved successfully"));
        }
      } else {
        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to move chat"));
      }
    };
    if (atSelectedModel !== void 0) {
      selectedModelIds = [atSelectedModel.id];
    } else {
      selectedModelIds = selectedModels;
    }
    if (chatIdProp) {
      navigateHandler();
    }
    if (selectedModels && chatIdProp !== "") {
      saveSessionSelectedModels();
    }
    if (JSON.stringify(selectedModelIds) !== JSON.stringify(oldSelectedModelIds)) {
      onSelectedModelIdsChange();
    }
    if (selectedModels !== null) {
      savedModelIds();
    }
    if (history) {
      getContents();
    } else {
      artifactContents.set([]);
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>
		${escape_html(store_get($$store_subs ??= {}, "$settings", settings).showChatTitleInTab !== false && store_get($$store_subs ??= {}, "$chatTitle", chatTitle) ? `${store_get($$store_subs ??= {}, "$chatTitle", chatTitle).length > 30 ? `${store_get($$store_subs ??= {}, "$chatTitle", chatTitle).slice(0, 30)}...` : store_get($$store_subs ??= {}, "$chatTitle", chatTitle)} • ${store_get($$store_subs ??= {}, "$WEBUI_NAME", WEBUI_NAME)}` : `${store_get($$store_subs ??= {}, "$WEBUI_NAME", WEBUI_NAME)}`)}
	</title>`);
        });
      });
      $$renderer3.push(`<audio id="audioElement" src="" style="display: none;" class="svelte-vhdo11"></audio> `);
      ConfirmDialog($$renderer3, {
        title: eventConfirmationTitle,
        message: eventConfirmationMessage,
        input: eventConfirmationInput,
        inputPlaceholder: eventConfirmationInputPlaceholder,
        inputValue: eventConfirmationInputValue,
        get show() {
          return showEventConfirmation;
        },
        set show($$value) {
          showEventConfirmation = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> <div${attr_class(`h-screen max-h-[100dvh] transition-width duration-200 ease-in-out ${stringify(store_get($$store_subs ??= {}, "$showSidebar", showSidebar) ? "  md:max-w-[calc(100%-var(--sidebar-width))]" : " ")} w-full max-w-full flex flex-col`, "svelte-vhdo11")} id="chat-container">`);
      if (!loading) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="w-full h-full flex flex-col svelte-vhdo11">`);
        if (store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder) && store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)?.meta?.background_image_url) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="absolute top-0 left-0 w-full h-full bg-cover bg-center bg-no-repeat svelte-vhdo11"${attr_style(`background-image: url(${stringify(store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder)?.meta?.background_image_url)}) `)}></div> <div class="absolute top-0 left-0 w-full h-full bg-linear-to-t from-white to-white/85 dark:from-gray-900 dark:to-gray-900/90 z-0 svelte-vhdo11"></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          if (store_get($$store_subs ??= {}, "$settings", settings)?.backgroundImageUrl ?? store_get($$store_subs ??= {}, "$config", config)?.license_metadata?.background_image_url ?? null) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="absolute top-0 left-0 w-full h-full bg-cover bg-center bg-no-repeat svelte-vhdo11"${attr_style(`background-image: url(${stringify(store_get($$store_subs ??= {}, "$settings", settings)?.backgroundImageUrl ?? store_get($$store_subs ??= {}, "$config", config)?.license_metadata?.background_image_url)}) `)}></div> <div class="absolute top-0 left-0 w-full h-full bg-linear-to-t from-white to-white/85 dark:from-gray-900 dark:to-gray-900/90 z-0 svelte-vhdo11"></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]--> `);
        Pane_group($$renderer3, {
          direction: "horizontal",
          class: "w-full h-full",
          children: ($$renderer4) => {
            Pane($$renderer4, {
              defaultSize: 50,
              minSize: 30,
              class: "h-full flex relative max-w-full flex-col",
              children: ($$renderer5) => {
                Navbar($$renderer5, {
                  chat: {
                    id: store_get($$store_subs ??= {}, "$chatId", chatId),
                    chat: {
                      title: store_get($$store_subs ??= {}, "$chatTitle", chatTitle),
                      models: selectedModels,
                      system: store_get($$store_subs ??= {}, "$settings", settings).system ?? void 0,
                      params,
                      history,
                      timestamp: Date.now()
                    }
                  },
                  history,
                  title: store_get($$store_subs ??= {}, "$chatTitle", chatTitle),
                  shareEnabled: !!history.currentId,
                  initNewChat,
                  archiveChatHandler: () => {
                  },
                  moveChatHandler,
                  onSaveTempChat: async () => {
                    try {
                      if (!history?.currentId || !Object.keys(history.messages).length) {
                        toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("No conversation to save"));
                        return;
                      }
                      const messages = createMessagesList(history, history.currentId);
                      const title = messages.find((m) => m.role === "user")?.content ?? store_get($$store_subs ??= {}, "$i18n", i18n).t("New Chat");
                      const savedChat = await createNewChat(
                        localStorage.token,
                        {
                          id: v4(),
                          title: title.length > 50 ? `${title.slice(0, 50)}...` : title,
                          models: selectedModels,
                          history,
                          messages,
                          timestamp: Date.now()
                        },
                        null
                      );
                      if (savedChat) {
                        temporaryChatEnabled.set(false);
                        chatId.set(savedChat.id);
                        chats.set(await getChatList(localStorage.token, store_get($$store_subs ??= {}, "$currentChatPage", currentChatPage)));
                        await goto(`/c/${savedChat.id}`);
                        toast.success(store_get($$store_subs ??= {}, "$i18n", i18n).t("Conversation saved successfully"));
                      }
                    } catch (error) {
                      /* @__PURE__ */ console.error("Error saving conversation:", error);
                      toast.error(store_get($$store_subs ??= {}, "$i18n", i18n).t("Failed to save conversation"));
                    }
                  },
                  get selectedModels() {
                    return selectedModels;
                  },
                  set selectedModels($$value) {
                    selectedModels = $$value;
                    $$settled = false;
                  }
                });
                $$renderer5.push(`<!----> <div class="flex flex-col flex-auto z-10 w-full @container overflow-auto svelte-vhdo11">`);
                if (store_get($$store_subs ??= {}, "$settings", settings)?.landingPageMode === "chat" && !store_get($$store_subs ??= {}, "$selectedFolder", selectedFolder) || createMessagesList(history, history.currentId).length > 0) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`<div class="pb-2.5 flex flex-col justify-between w-full flex-auto overflow-auto h-0 max-w-full z-10 scrollbar-hidden svelte-vhdo11" id="messages-container"><div class="h-full w-full flex flex-col svelte-vhdo11">`);
                  Messages($$renderer5, {
                    chatId: store_get($$store_subs ??= {}, "$chatId", chatId),
                    setInputText: (text) => {
                      messageInput?.setText(text);
                    },
                    selectedModels,
                    atSelectedModel,
                    sendMessage,
                    showMessage,
                    submitMessage,
                    continueResponse,
                    regenerateResponse,
                    mergeResponses,
                    chatActionHandler,
                    addMessages,
                    topPadding: true,
                    bottomPadding: files.length > 0,
                    onSelect,
                    get history() {
                      return history;
                    },
                    set history($$value) {
                      history = $$value;
                      $$settled = false;
                    },
                    get autoScroll() {
                      return autoScroll;
                    },
                    set autoScroll($$value) {
                      autoScroll = $$value;
                      $$settled = false;
                    },
                    get prompt() {
                      return prompt;
                    },
                    set prompt($$value) {
                      prompt = $$value;
                      $$settled = false;
                    }
                  });
                  $$renderer5.push(`<!----></div></div> <div class="pb-2 z-10 svelte-vhdo11">`);
                  MessageInput($$renderer5, {
                    history,
                    taskIds,
                    selectedModels,
                    toolServers: store_get($$store_subs ??= {}, "$toolServers", toolServers),
                    generating,
                    stopResponse,
                    createMessagePair,
                    onUpload,
                    messageQueue,
                    onQueueSendNow: async (id) => {
                      const item = messageQueue.find((m) => m.id === id);
                      if (item) {
                        messageQueue = messageQueue.filter((m) => m.id !== id);
                        await stopResponse();
                        await tick();
                        files = item.files;
                        await tick();
                        await submitPrompt(item.prompt);
                      }
                    },
                    onQueueEdit: (id) => {
                      const item = messageQueue.find((m) => m.id === id);
                      if (item) {
                        messageQueue = messageQueue.filter((m) => m.id !== id);
                        files = item.files;
                        messageInput?.setText(item.prompt);
                      }
                    },
                    onQueueDelete: (id) => {
                      messageQueue = messageQueue.filter((m) => m.id !== id);
                    },
                    onChange: (data) => {
                      if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
                        saveDraft(data, store_get($$store_subs ??= {}, "$chatId", chatId));
                      }
                    },
                    get files() {
                      return files;
                    },
                    set files($$value) {
                      files = $$value;
                      $$settled = false;
                    },
                    get prompt() {
                      return prompt;
                    },
                    set prompt($$value) {
                      prompt = $$value;
                      $$settled = false;
                    },
                    get autoScroll() {
                      return autoScroll;
                    },
                    set autoScroll($$value) {
                      autoScroll = $$value;
                      $$settled = false;
                    },
                    get selectedToolIds() {
                      return selectedToolIds;
                    },
                    set selectedToolIds($$value) {
                      selectedToolIds = $$value;
                      $$settled = false;
                    },
                    get selectedFilterIds() {
                      return selectedFilterIds;
                    },
                    set selectedFilterIds($$value) {
                      selectedFilterIds = $$value;
                      $$settled = false;
                    },
                    get imageGenerationEnabled() {
                      return imageGenerationEnabled;
                    },
                    set imageGenerationEnabled($$value) {
                      imageGenerationEnabled = $$value;
                      $$settled = false;
                    },
                    get codeInterpreterEnabled() {
                      return codeInterpreterEnabled;
                    },
                    set codeInterpreterEnabled($$value) {
                      codeInterpreterEnabled = $$value;
                      $$settled = false;
                    },
                    get webSearchEnabled() {
                      return webSearchEnabled;
                    },
                    set webSearchEnabled($$value) {
                      webSearchEnabled = $$value;
                      $$settled = false;
                    },
                    get atSelectedModel() {
                      return atSelectedModel;
                    },
                    set atSelectedModel($$value) {
                      atSelectedModel = $$value;
                      $$settled = false;
                    },
                    get showCommands() {
                      return showCommands;
                    },
                    set showCommands($$value) {
                      showCommands = $$value;
                      $$settled = false;
                    }
                  });
                  $$renderer5.push(`<!----> <div class="absolute bottom-1 text-xs text-gray-500 text-center line-clamp-1 right-0 left-0 svelte-vhdo11"></div></div>`);
                } else {
                  $$renderer5.push("<!--[!-->");
                  $$renderer5.push(`<div class="flex items-center h-full svelte-vhdo11">`);
                  Placeholder($$renderer5, {
                    history,
                    selectedModels,
                    toolServers: store_get($$store_subs ??= {}, "$toolServers", toolServers),
                    stopResponse,
                    createMessagePair,
                    onSelect,
                    onUpload,
                    onChange: (data) => {
                      if (!store_get($$store_subs ??= {}, "$temporaryChatEnabled", temporaryChatEnabled)) {
                        saveDraft(data);
                      }
                    },
                    get messageInput() {
                      return messageInput;
                    },
                    set messageInput($$value) {
                      messageInput = $$value;
                      $$settled = false;
                    },
                    get files() {
                      return files;
                    },
                    set files($$value) {
                      files = $$value;
                      $$settled = false;
                    },
                    get prompt() {
                      return prompt;
                    },
                    set prompt($$value) {
                      prompt = $$value;
                      $$settled = false;
                    },
                    get autoScroll() {
                      return autoScroll;
                    },
                    set autoScroll($$value) {
                      autoScroll = $$value;
                      $$settled = false;
                    },
                    get selectedToolIds() {
                      return selectedToolIds;
                    },
                    set selectedToolIds($$value) {
                      selectedToolIds = $$value;
                      $$settled = false;
                    },
                    get selectedFilterIds() {
                      return selectedFilterIds;
                    },
                    set selectedFilterIds($$value) {
                      selectedFilterIds = $$value;
                      $$settled = false;
                    },
                    get imageGenerationEnabled() {
                      return imageGenerationEnabled;
                    },
                    set imageGenerationEnabled($$value) {
                      imageGenerationEnabled = $$value;
                      $$settled = false;
                    },
                    get codeInterpreterEnabled() {
                      return codeInterpreterEnabled;
                    },
                    set codeInterpreterEnabled($$value) {
                      codeInterpreterEnabled = $$value;
                      $$settled = false;
                    },
                    get webSearchEnabled() {
                      return webSearchEnabled;
                    },
                    set webSearchEnabled($$value) {
                      webSearchEnabled = $$value;
                      $$settled = false;
                    },
                    get atSelectedModel() {
                      return atSelectedModel;
                    },
                    set atSelectedModel($$value) {
                      atSelectedModel = $$value;
                      $$settled = false;
                    },
                    get showCommands() {
                      return showCommands;
                    },
                    set showCommands($$value) {
                      showCommands = $$value;
                      $$settled = false;
                    }
                  });
                  $$renderer5.push(`<!----></div>`);
                }
                $$renderer5.push(`<!--]--></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            ChatControls($$renderer4, {
              chatId: store_get($$store_subs ??= {}, "$chatId", chatId),
              modelId: selectedModelIds?.at(0) ?? null,
              models: selectedModelIds.reduce(
                (a, e, i, arr) => {
                  const model = store_get($$store_subs ??= {}, "$models", models).find((m) => m.id === e);
                  if (model) {
                    return [...a, model];
                  }
                  return a;
                },
                []
              ),
              submitPrompt,
              stopResponse,
              showMessage,
              eventTarget,
              get history() {
                return history;
              },
              set history($$value) {
                history = $$value;
                $$settled = false;
              },
              get chatFiles() {
                return chatFiles;
              },
              set chatFiles($$value) {
                chatFiles = $$value;
                $$settled = false;
              },
              get params() {
                return params;
              },
              set params($$value) {
                params = $$value;
                $$settled = false;
              },
              get files() {
                return files;
              },
              set files($$value) {
                files = $$value;
                $$settled = false;
              },
              get pane() {
                return controlPane;
              },
              set pane($$value) {
                controlPane = $$value;
                $$settled = false;
              }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
        if (loading) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex items-center justify-center h-full w-full svelte-vhdo11"><div class="m-auto svelte-vhdo11">`);
          Spinner($$renderer3, { className: "size-5" });
          $$renderer3.push(`<!----></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { chatIdProp });
  });
}
export {
  Chat as C
};
//# sourceMappingURL=Chat.js.map
