import { b as bind_props, h as slot, j as escape_html, s as store_get, u as unsubscribe_stores } from "./index.js";
import "dequal";
import "./create.js";
import { Z as getContext, Y as fallback } from "./context.js";
import "clsx";
import { e as Menu, g as Menu_trigger, M as Menu_content, f as flyAndScale, a as Menu_item } from "./menu-trigger.js";
function Dropdown($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const i18n = getContext("i18n");
    let show = fallback($$props["show"], false);
    let side = fallback($$props["side"], "bottom");
    let align = fallback($$props["align"], "start");
    let closeOnOutsideClick = fallback($$props["closeOnOutsideClick"], true);
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Menu($$renderer3, {
        closeFocus: false,
        closeOnOutsideClick,
        onOpenChange: (state) => {
        },
        typeahead: false,
        get open() {
          return show;
        },
        set open($$value) {
          show = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          Menu_trigger($$renderer4, {
            children: ($$renderer5) => {
              $$renderer5.push(`<!--[-->`);
              slot($$renderer5, $$props, "default", {}, null);
              $$renderer5.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> <!--[-->`);
          slot($$renderer4, $$props, "content", {}, () => {
            Menu_content($$renderer4, {
              class: "w-full max-w-[130px] rounded-lg p-1 border border-gray-900 z-50 bg-gray-850 text-white",
              sideOffset: 8,
              side,
              align,
              transition: flyAndScale,
              children: ($$renderer5) => {
                Menu_item($$renderer5, {
                  class: "flex items-center px-3 py-2 text-sm  font-medium",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Profile"))}</div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Menu_item($$renderer5, {
                  class: "flex items-center px-3 py-2 text-sm  font-medium",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Profile"))}</div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Menu_item($$renderer5, {
                  class: "flex items-center px-3 py-2 text-sm  font-medium",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="flex items-center">${escape_html(store_get($$store_subs ??= {}, "$i18n", i18n).t("Profile"))}</div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
          });
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { show, side, align, closeOnOutsideClick });
  });
}
export {
  Dropdown as D
};
//# sourceMappingURL=Dropdown.js.map
