"use strict";
exports.id = 10591;
exports.ids = [10591];
exports.modules = {

/***/ 10591:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_hooks_useClickOutside__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12965);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);





const ConfirmButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  onClick,
  children,
  confirmText,
  className
}, parentRef) => {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
  (0,_app_hooks_useClickOutside__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(ref, () => setIsClicked(false));
  const {
    0: isClicked,
    1: setIsClicked
  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
    ref: parentRef,
    buttonType: "danger",
    className: `relative overflow-hidden ${className}`,
    onClick: e => {
      e.preventDefault();

      if (!isClicked) {
        setIsClicked(true);
      } else {
        onClick();
      }
    },
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      ref: ref,
      className: `relative inset-0 flex h-full w-full transform-gpu items-center justify-center transition duration-300 ${isClicked ? '-translate-y-full opacity-0' : 'translate-y-0 opacity-100'}`,
      children: children
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      ref: ref,
      className: `absolute inset-0 flex h-full w-full transform-gpu items-center justify-center transition duration-300 ${isClicked ? 'translate-y-0 opacity-100' : 'translate-y-full opacity-0'}`,
      children: confirmText
    })]
  });
});
ConfirmButton.displayName = 'ConfirmButton';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ConfirmButton);

/***/ })

};
;