"use strict";
exports.id = 17004;
exports.ids = [17004];
exports.modules = {

/***/ 62086:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
var _path, _path2;
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var SvgRadarr = function SvgRadarr(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
    viewBox: "0 0 1000 1115.2",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
    d: "m120.015 174.916-1.433 810.916C50.198 993.53-.595 958.758.245 890.481L0 216.126C2.624 2.76 199.555-46.036 317.994 40.776l601.67 357.383c84.615 60.794 100.32 171.956 56.7 248.25-7.799-59.85-32.984-94.304-83.773-129.073l-678.066-392.46c-50.79-34.768-93.568-26.758-94.513 50.056zm-61.707 852.847c51 17.7 102.314 9.794 145.3-15.285L908.5 611.405c41.94 60.268 32.671 119.903-18.958 153.414L296.44 1098.972c-85.873 41.624-196.297-2.414-238.138-71.217z",
    fill: "#fff"
  })), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
    d: "m272.941 797.285 414.225-245.888L273.7 327.762z",
    fill: "#ffc230"
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgRadarr);

/***/ }),

/***/ 17486:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
var _path, _path2, _g;
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var SvgSonarr = function SvgSonarr(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
    viewBox: "0 0 216.7 216.9",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
    d: "M216.7 108.45c0 29.833-10.533 55.4-31.6 76.7-.7.833-1.483 1.6-2.35 2.3a92.767 92.767 0 0 1-11 9.25c-18.267 13.467-39.367 20.2-63.3 20.2-23.967 0-45.033-6.733-63.2-20.2-4.8-3.4-9.3-7.25-13.5-11.55-16.367-16.266-26.417-35.167-30.15-56.7-.733-4.2-1.217-8.467-1.45-12.8-.1-2.4-.15-4.8-.15-7.2 0-2.533.05-4.95.15-7.25 0-.233.066-.467.2-.7 1.567-26.6 12.033-49.583 31.4-68.95C53.05 10.517 78.617 0 108.45 0c29.933 0 55.484 10.517 76.65 31.55 21.067 21.433 31.6 47.067 31.6 76.9z",
    clipRule: "evenodd",
    fill: "#EEE",
    fillRule: "evenodd"
  })), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
    d: "m194.65 42.5-22.4 22.4C159.152 77.998 158 89.4 158 109.5c0 17.934 2.852 34.352 16.2 47.7 9.746 9.746 19 18.95 19 18.95-2.5 3.067-5.2 6.067-8.1 9-.7.833-1.483 1.6-2.35 2.3a90.601 90.601 0 0 1-7.9 6.95l-17.55-17.55c-15.598-15.6-27.996-17.1-48.6-17.1-19.77 0-33.223 1.822-47.7 16.3-8.647 8.647-18.55 18.6-18.55 18.6a95.782 95.782 0 0 1-10.7-9.5c-2.8-2.8-5.417-5.667-7.85-8.6 0 0 9.798-9.848 19.15-19.2 13.852-13.853 16.1-29.916 16.1-47.85 0-17.5-2.874-33.823-15.6-46.55-8.835-8.836-21.05-21-21.05-21 2.833-3.6 5.917-7.067 9.25-10.4a134.482 134.482 0 0 1 9-8.05L61.1 43.85C74.102 56.852 90.767 60.2 108.7 60.2c18.467 0 35.077-3.577 48.6-17.1 8.32-8.32 19.3-19.25 19.3-19.25 2.9 2.367 5.733 4.933 8.5 7.7a121.188 121.188 0 0 1 9.55 10.95z",
    clipRule: "evenodd",
    fill: "#3A3F51",
    fillRule: "evenodd"
  })), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
    clipRule: "evenodd"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
    d: "M78.7 114c-.2-1.167-.332-2.35-.4-3.55a39.613 39.613 0 0 1 0-4c0-.067.018-.133.05-.2.435-7.367 3.334-13.733 8.7-19.1 5.9-5.833 12.984-8.75 21.25-8.75 8.3 0 15.384 2.917 21.25 8.75 5.834 5.934 8.75 13.033 8.75 21.3 0 8.267-2.916 15.35-8.75 21.25-.2.233-.416.45-.65.65a27.364 27.364 0 0 1-3.05 2.55c-5.065 3.733-10.916 5.6-17.55 5.6s-12.466-1.866-17.5-5.6a26.29 26.29 0 0 1-3.75-3.2c-4.532-4.5-7.316-9.734-8.35-15.7z",
    fill: "#0CF",
    fillRule: "evenodd"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
    d: "m157.8 59.75-15 14.65M30.785 32.526 71.65 73.25m84.6 84.25 27.808 28.78m1.855-153.894L157.8 59.75m-125.45 126 27.35-27.4",
    fill: "none",
    stroke: "#0CF",
    strokeMiterlimit: 1,
    strokeWidth: 2
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
    d: "m157.8 59.75-16.95 17.2M58.97 60.604l17.2 17.15M59.623 158.43l16.75-17.4m61.928-1.396 18.028 17.945",
    fill: "none",
    stroke: "#0CF",
    strokeMiterlimit: 1,
    strokeWidth: 7
  }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgSonarr);

/***/ }),

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 62599:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22796);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61903);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80210);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(61929);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__, _headlessui_react__WEBPACK_IMPORTED_MODULE_3__, axios__WEBPACK_IMPORTED_MODULE_4__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__, _headlessui_react__WEBPACK_IMPORTED_MODULE_3__, axios__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_7__.defineMessages)({
  createradarr: {
    "id": "components.Settings.RadarrModal.createradarr",
    "defaultMessage": 'Add New Radarr Server'
  },
  create4kradarr: {
    "id": "components.Settings.RadarrModal.create4kradarr",
    "defaultMessage": 'Add New 4K Radarr Server'
  },
  editradarr: {
    "id": "components.Settings.RadarrModal.editradarr",
    "defaultMessage": 'Edit Radarr Server'
  },
  edit4kradarr: {
    "id": "components.Settings.RadarrModal.edit4kradarr",
    "defaultMessage": 'Edit 4K Radarr Server'
  },
  validationNameRequired: {
    "id": "components.Settings.RadarrModal.validationNameRequired",
    "defaultMessage": 'You must provide a server name'
  },
  validationHostnameRequired: {
    "id": "components.Settings.RadarrModal.validationHostnameRequired",
    "defaultMessage": 'You must provide a valid hostname or IP address'
  },
  validationPortRequired: {
    "id": "components.Settings.RadarrModal.validationPortRequired",
    "defaultMessage": 'You must provide a valid port number'
  },
  validationApiKeyRequired: {
    "id": "components.Settings.RadarrModal.validationApiKeyRequired",
    "defaultMessage": 'You must provide an API key'
  },
  validationRootFolderRequired: {
    "id": "components.Settings.RadarrModal.validationRootFolderRequired",
    "defaultMessage": 'You must select a root folder'
  },
  validationProfileRequired: {
    "id": "components.Settings.RadarrModal.validationProfileRequired",
    "defaultMessage": 'You must select a quality profile'
  },
  validationMinimumAvailabilityRequired: {
    "id": "components.Settings.RadarrModal.validationMinimumAvailabilityRequired",
    "defaultMessage": 'You must select a minimum availability'
  },
  toastRadarrTestSuccess: {
    "id": "components.Settings.RadarrModal.toastRadarrTestSuccess",
    "defaultMessage": 'Radarr connection established successfully!'
  },
  toastRadarrTestFailure: {
    "id": "components.Settings.RadarrModal.toastRadarrTestFailure",
    "defaultMessage": 'Failed to connect to Radarr.'
  },
  add: {
    "id": "components.Settings.RadarrModal.add",
    "defaultMessage": 'Add Server'
  },
  defaultserver: {
    "id": "components.Settings.RadarrModal.defaultserver",
    "defaultMessage": 'Default Server'
  },
  default4kserver: {
    "id": "components.Settings.RadarrModal.default4kserver",
    "defaultMessage": 'Default 4K Server'
  },
  servername: {
    "id": "components.Settings.RadarrModal.servername",
    "defaultMessage": 'Server Name'
  },
  hostname: {
    "id": "components.Settings.RadarrModal.hostname",
    "defaultMessage": 'Hostname or IP Address'
  },
  port: {
    "id": "components.Settings.RadarrModal.port",
    "defaultMessage": 'Port'
  },
  ssl: {
    "id": "components.Settings.RadarrModal.ssl",
    "defaultMessage": 'Use SSL'
  },
  apiKey: {
    "id": "components.Settings.RadarrModal.apiKey",
    "defaultMessage": 'API Key'
  },
  baseUrl: {
    "id": "components.Settings.RadarrModal.baseUrl",
    "defaultMessage": 'URL Base'
  },
  syncEnabled: {
    "id": "components.Settings.RadarrModal.syncEnabled",
    "defaultMessage": 'Enable Scan'
  },
  externalUrl: {
    "id": "components.Settings.RadarrModal.externalUrl",
    "defaultMessage": 'External URL'
  },
  qualityprofile: {
    "id": "components.Settings.RadarrModal.qualityprofile",
    "defaultMessage": 'Quality Profile'
  },
  rootfolder: {
    "id": "components.Settings.RadarrModal.rootfolder",
    "defaultMessage": 'Root Folder'
  },
  minimumAvailability: {
    "id": "components.Settings.RadarrModal.minimumAvailability",
    "defaultMessage": 'Minimum Availability'
  },
  server4k: {
    "id": "components.Settings.RadarrModal.server4k",
    "defaultMessage": '4K Server'
  },
  selectQualityProfile: {
    "id": "components.Settings.RadarrModal.selectQualityProfile",
    "defaultMessage": 'Select quality profile'
  },
  selectRootFolder: {
    "id": "components.Settings.RadarrModal.selectRootFolder",
    "defaultMessage": 'Select root folder'
  },
  selectMinimumAvailability: {
    "id": "components.Settings.RadarrModal.selectMinimumAvailability",
    "defaultMessage": 'Select minimum availability'
  },
  loadingprofiles: {
    "id": "components.Settings.RadarrModal.loadingprofiles",
    "defaultMessage": 'Loading quality profiles…'
  },
  testFirstQualityProfiles: {
    "id": "components.Settings.RadarrModal.testFirstQualityProfiles",
    "defaultMessage": 'Test connection to load quality profiles'
  },
  loadingrootfolders: {
    "id": "components.Settings.RadarrModal.loadingrootfolders",
    "defaultMessage": 'Loading root folders…'
  },
  testFirstRootFolders: {
    "id": "components.Settings.RadarrModal.testFirstRootFolders",
    "defaultMessage": 'Test connection to load root folders'
  },
  loadingTags: {
    "id": "components.Settings.RadarrModal.loadingTags",
    "defaultMessage": 'Loading tags…'
  },
  testFirstTags: {
    "id": "components.Settings.RadarrModal.testFirstTags",
    "defaultMessage": 'Test connection to load tags'
  },
  tags: {
    "id": "components.Settings.RadarrModal.tags",
    "defaultMessage": 'Tags'
  },
  enableSearch: {
    "id": "components.Settings.RadarrModal.enableSearch",
    "defaultMessage": 'Enable Automatic Search'
  },
  tagRequests: {
    "id": "components.Settings.RadarrModal.tagRequests",
    "defaultMessage": 'Tag Requests'
  },
  tagRequestsInfo: {
    "id": "components.Settings.RadarrModal.tagRequestsInfo",
    "defaultMessage": "Automatically add an additional tag with the requester's user ID & display name"
  },
  validationApplicationUrl: {
    "id": "components.Settings.RadarrModal.validationApplicationUrl",
    "defaultMessage": 'You must provide a valid URL'
  },
  validationApplicationUrlTrailingSlash: {
    "id": "components.Settings.RadarrModal.validationApplicationUrlTrailingSlash",
    "defaultMessage": 'URL must not end in a trailing slash'
  },
  validationBaseUrlLeadingSlash: {
    "id": "components.Settings.RadarrModal.validationBaseUrlLeadingSlash",
    "defaultMessage": 'URL base must have a leading slash'
  },
  validationBaseUrlTrailingSlash: {
    "id": "components.Settings.RadarrModal.validationBaseUrlTrailingSlash",
    "defaultMessage": 'URL base must not end in a trailing slash'
  },
  notagoptions: {
    "id": "components.Settings.RadarrModal.notagoptions",
    "defaultMessage": 'No tags.'
  },
  selecttags: {
    "id": "components.Settings.RadarrModal.selecttags",
    "defaultMessage": 'Select tags'
  },
  announced: {
    "id": "components.Settings.RadarrModal.announced",
    "defaultMessage": 'Announced'
  },
  inCinemas: {
    "id": "components.Settings.RadarrModal.inCinemas",
    "defaultMessage": 'In Cinemas'
  },
  released: {
    "id": "components.Settings.RadarrModal.released",
    "defaultMessage": 'Released'
  }
});

const RadarrModal = ({
  onClose,
  radarr,
  onSave
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_7__.useIntl)();
  const initialLoad = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(false);
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__.useToasts)();
  const {
    0: isValidated,
    1: setIsValidated
  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(radarr ? true : false);
  const {
    0: isTesting,
    1: setIsTesting
  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const {
    0: testResponse,
    1: setTestResponse
  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)({
    profiles: [],
    rootFolders: [],
    tags: []
  });
  const RadarrSettingsSchema = yup__WEBPACK_IMPORTED_MODULE_10__.object().shape({
    name: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationNameRequired)),
    hostname: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationHostnameRequired)).matches(/^(((([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])):((([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))@)?(([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])$/i, intl.formatMessage(messages.validationHostnameRequired)),
    port: yup__WEBPACK_IMPORTED_MODULE_10__.number().nullable().required(intl.formatMessage(messages.validationPortRequired)),
    apiKey: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationApiKeyRequired)),
    rootFolder: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationRootFolderRequired)),
    activeProfileId: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationProfileRequired)),
    minimumAvailability: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationMinimumAvailabilityRequired)),
    externalUrl: yup__WEBPACK_IMPORTED_MODULE_10__.string().url(intl.formatMessage(messages.validationApplicationUrl)).test('no-trailing-slash', intl.formatMessage(messages.validationApplicationUrlTrailingSlash), value => !value || !value.endsWith('/')),
    baseUrl: yup__WEBPACK_IMPORTED_MODULE_10__.string().test('leading-slash', intl.formatMessage(messages.validationBaseUrlLeadingSlash), value => !value || value.startsWith('/')).test('no-trailing-slash', intl.formatMessage(messages.validationBaseUrlTrailingSlash), value => !value || !value.endsWith('/'))
  });
  const testConnection = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(async ({
    hostname,
    port,
    apiKey,
    baseUrl,
    useSsl = false
  }) => {
    setIsTesting(true);

    try {
      const response = await axios__WEBPACK_IMPORTED_MODULE_4__["default"].post('/api/v1/settings/radarr/test', {
        hostname,
        apiKey,
        port: Number(port),
        baseUrl,
        useSsl
      });
      setIsValidated(true);
      setTestResponse(response.data);

      if (initialLoad.current) {
        addToast(intl.formatMessage(messages.toastRadarrTestSuccess), {
          appearance: 'success',
          autoDismiss: true
        });
      }
    } catch (e) {
      setIsValidated(false);

      if (initialLoad.current) {
        addToast(intl.formatMessage(messages.toastRadarrTestFailure), {
          appearance: 'error',
          autoDismiss: true
        });
      }
    } finally {
      setIsTesting(false);
      initialLoad.current = true;
    }
  }, [addToast, intl]);
  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (radarr) {
      testConnection({
        apiKey: radarr.apiKey,
        hostname: radarr.hostname,
        port: radarr.port,
        baseUrl: radarr.baseUrl,
        useSsl: radarr.useSsl
      });
    }
  }, [radarr, testConnection]);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Transition, {
    as: "div",
    appear: true,
    show: true,
    enter: "transition-opacity ease-in-out duration-300",
    enterFrom: "opacity-0",
    enterTo: "opacity-100",
    leave: "transition-opacity ease-in-out duration-300",
    leaveFrom: "opacity-100",
    leaveTo: "opacity-0",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Formik, {
      initialValues: {
        name: radarr?.name,
        hostname: radarr?.hostname,
        port: radarr?.port ?? 7878,
        ssl: radarr?.useSsl ?? false,
        apiKey: radarr?.apiKey,
        baseUrl: radarr?.baseUrl,
        activeProfileId: radarr?.activeProfileId,
        rootFolder: radarr?.activeDirectory,
        minimumAvailability: radarr?.minimumAvailability ?? 'released',
        tags: radarr?.tags ?? [],
        isDefault: radarr?.isDefault ?? false,
        is4k: radarr?.is4k ?? false,
        externalUrl: radarr?.externalUrl,
        syncEnabled: radarr?.syncEnabled ?? false,
        enableSearch: !radarr?.preventSearch,
        tagRequests: radarr?.tagRequests ?? false
      },
      validationSchema: RadarrSettingsSchema,
      onSubmit: async values => {
        try {
          const profileName = testResponse.profiles.find(profile => profile.id === Number(values.activeProfileId))?.name;
          const submission = {
            name: values.name,
            hostname: values.hostname,
            port: Number(values.port),
            apiKey: values.apiKey,
            useSsl: values.ssl,
            baseUrl: values.baseUrl,
            activeProfileId: Number(values.activeProfileId),
            activeProfileName: profileName,
            activeDirectory: values.rootFolder,
            is4k: values.is4k,
            minimumAvailability: values.minimumAvailability,
            tags: values.tags,
            isDefault: values.isDefault,
            externalUrl: values.externalUrl,
            syncEnabled: values.syncEnabled,
            preventSearch: !values.enableSearch,
            tagRequests: values.tagRequests
          };

          if (!radarr) {
            await axios__WEBPACK_IMPORTED_MODULE_4__["default"].post('/api/v1/settings/radarr', submission);
          } else {
            await axios__WEBPACK_IMPORTED_MODULE_4__["default"].put(`/api/v1/settings/radarr/${radarr.id}`, submission);
          }

          onSave();
        } catch (e) {// set error here
        }
      },
      children: ({
        errors,
        touched,
        values,
        handleSubmit,
        setFieldValue,
        isSubmitting,
        isValid
      }) => {
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          onCancel: onClose,
          okButtonType: "primary",
          okText: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].saving */ .Z.saving) : radarr ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].save */ .Z.save) : intl.formatMessage(messages.add),
          secondaryButtonType: "warning",
          secondaryText: isTesting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].testing */ .Z.testing) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].test */ .Z.test),
          onSecondary: () => {
            if (values.apiKey && values.hostname && values.port) {
              testConnection({
                apiKey: values.apiKey,
                baseUrl: values.baseUrl,
                hostname: values.hostname,
                port: values.port,
                useSsl: values.ssl
              });

              if (!values.baseUrl || values.baseUrl === '/') {
                setFieldValue('baseUrl', testResponse.urlBase);
              }
            }
          },
          secondaryDisabled: !values.apiKey || !values.hostname || !values.port || isTesting || isSubmitting,
          okDisabled: !isValidated || isSubmitting || isTesting || !isValid,
          onOk: () => handleSubmit(),
          title: !radarr ? intl.formatMessage(values.is4k ? messages.create4kradarr : messages.createradarr) : intl.formatMessage(values.is4k ? messages.edit4kradarr : messages.editradarr),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "mb-6",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "isDefault",
                className: "checkbox-label",
                children: intl.formatMessage(values.is4k ? messages.default4kserver : messages.defaultserver)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "isDefault",
                  name: "isDefault"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "is4k",
                className: "checkbox-label",
                children: intl.formatMessage(messages.server4k)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "is4k",
                  name: "is4k"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "name",
                className: "text-label",
                children: [intl.formatMessage(messages.servername), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    id: "name",
                    name: "name",
                    type: "text",
                    autoComplete: "off",
                    "data-1pignore": "true",
                    "data-lpignore": "true",
                    "data-bwignore": "true",
                    onChange: e => {
                      setIsValidated(false);
                      setFieldValue('name', e.target.value);
                    }
                  })
                }), errors.name && touched.name && typeof errors.name === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.name
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "hostname",
                className: "text-label",
                children: [intl.formatMessage(messages.hostname), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "form-input-field",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                    className: "protocol",
                    children: values.ssl ? 'https://' : 'http://'
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    id: "hostname",
                    name: "hostname",
                    type: "text",
                    inputMode: "url",
                    onChange: e => {
                      setIsValidated(false);
                      setFieldValue('hostname', e.target.value);
                    },
                    className: "rounded-r-only"
                  })]
                }), errors.hostname && touched.hostname && typeof errors.hostname === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.hostname
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "port",
                className: "text-label",
                children: [intl.formatMessage(messages.port), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  id: "port",
                  name: "port",
                  type: "text",
                  inputMode: "numeric",
                  className: "short",
                  onChange: e => {
                    setIsValidated(false);
                    setFieldValue('port', e.target.value);
                  }
                }), errors.port && touched.port && typeof errors.port === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.port
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "ssl",
                className: "checkbox-label",
                children: intl.formatMessage(messages.ssl)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "ssl",
                  name: "ssl",
                  onChange: () => {
                    setIsValidated(false);
                    setFieldValue('ssl', !values.ssl);
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "apiKey",
                className: "text-label",
                children: [intl.formatMessage(messages.apiKey), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    as: "field",
                    id: "apiKey",
                    name: "apiKey",
                    onChange: e => {
                      setIsValidated(false);
                      setFieldValue('apiKey', e.target.value);
                    }
                  })
                }), errors.apiKey && touched.apiKey && typeof errors.apiKey === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.apiKey
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "baseUrl",
                className: "text-label",
                children: intl.formatMessage(messages.baseUrl)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    id: "baseUrl",
                    name: "baseUrl",
                    type: "text",
                    inputMode: "url",
                    onChange: e => {
                      setIsValidated(false);
                      setFieldValue('baseUrl', e.target.value);
                    }
                  })
                }), errors.baseUrl && touched.baseUrl && typeof errors.baseUrl === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.baseUrl
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "activeProfileId",
                className: "text-label",
                children: [intl.formatMessage(messages.qualityprofile), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "activeProfileId",
                    name: "activeProfileId",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "",
                      children: isTesting ? intl.formatMessage(messages.loadingprofiles) : !isValidated ? intl.formatMessage(messages.testFirstQualityProfiles) : intl.formatMessage(messages.selectQualityProfile)
                    }), testResponse.profiles.length > 0 && testResponse.profiles.map(profile => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: profile.id,
                      children: profile.name
                    }, `loaded-profile-${profile.id}`))]
                  })
                }), errors.activeProfileId && touched.activeProfileId && typeof errors.activeProfileId === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.activeProfileId
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "rootFolder",
                className: "text-label",
                children: [intl.formatMessage(messages.rootfolder), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "rootFolder",
                    name: "rootFolder",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "",
                      children: isTesting ? intl.formatMessage(messages.loadingrootfolders) : !isValidated ? intl.formatMessage(messages.testFirstRootFolders) : intl.formatMessage(messages.selectRootFolder)
                    }), testResponse.rootFolders.length > 0 && testResponse.rootFolders.map(folder => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: folder.path,
                      children: folder.path
                    }, `loaded-profile-${folder.id}`))]
                  })
                }), errors.rootFolder && touched.rootFolder && typeof errors.rootFolder === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.rootFolder
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "minimumAvailability",
                className: "text-label",
                children: [intl.formatMessage(messages.minimumAvailability), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "minimumAvailability",
                    name: "minimumAvailability",
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "announced",
                      children: intl.formatMessage(messages.announced)
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "inCinemas",
                      children: intl.formatMessage(messages.inCinemas)
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "released",
                      children: intl.formatMessage(messages.released)
                    })]
                  })
                }), errors.minimumAvailability && touched.minimumAvailability && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.minimumAvailability
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "tags",
                className: "text-label",
                children: intl.formatMessage(messages.tags)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx((react_select__WEBPACK_IMPORTED_MODULE_8___default()), {
                  options: isValidated ? testResponse.tags.map(tag => ({
                    label: tag.label,
                    value: tag.id
                  })) : [],
                  isMulti: true,
                  isDisabled: !isValidated || isTesting,
                  placeholder: !isValidated ? intl.formatMessage(messages.testFirstTags) : isTesting ? intl.formatMessage(messages.loadingTags) : intl.formatMessage(messages.selecttags),
                  className: "react-select-container",
                  classNamePrefix: "react-select",
                  value: values.tags.map(tagId => {
                    const foundTag = testResponse.tags.find(tag => tag.id === tagId);

                    if (!foundTag) {
                      return undefined;
                    }

                    return {
                      value: foundTag.id,
                      label: foundTag.label
                    };
                  }).filter(option => option !== undefined),
                  onChange: value => {
                    setFieldValue('tags', value.map(option => option.value));
                  },
                  noOptionsMessage: () => intl.formatMessage(messages.notagoptions)
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "externalUrl",
                className: "text-label",
                children: intl.formatMessage(messages.externalUrl)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    id: "externalUrl",
                    name: "externalUrl",
                    type: "text",
                    inputMode: "url"
                  })
                }), errors.externalUrl && touched.externalUrl && typeof errors.externalUrl === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.externalUrl
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "syncEnabled",
                className: "checkbox-label",
                children: intl.formatMessage(messages.syncEnabled)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "syncEnabled",
                  name: "syncEnabled"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "enableSearch",
                className: "checkbox-label",
                children: intl.formatMessage(messages.enableSearch)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "enableSearch",
                  name: "enableSearch"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "tagRequests",
                className: "checkbox-label",
                children: [intl.formatMessage(messages.tagRequests), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.tagRequestsInfo)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "tagRequests",
                  name: "tagRequests"
                })
              })]
            })]
          })
        });
      }
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RadarrModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 17004:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_services_radarr_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62086);
/* harmony import */ var _app_assets_services_sonarr_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17486);
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(22796);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Settings_RadarrModal__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(62599);
/* harmony import */ var _app_components_Settings_SonarrModal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(88796);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(80210);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_6__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_7__, _app_components_Settings_RadarrModal__WEBPACK_IMPORTED_MODULE_8__, _app_components_Settings_SonarrModal__WEBPACK_IMPORTED_MODULE_9__, _headlessui_react__WEBPACK_IMPORTED_MODULE_11__, axios__WEBPACK_IMPORTED_MODULE_13__, swr__WEBPACK_IMPORTED_MODULE_16__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_6__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_7__, _app_components_Settings_RadarrModal__WEBPACK_IMPORTED_MODULE_8__, _app_components_Settings_SonarrModal__WEBPACK_IMPORTED_MODULE_9__, _headlessui_react__WEBPACK_IMPORTED_MODULE_11__, axios__WEBPACK_IMPORTED_MODULE_13__, swr__WEBPACK_IMPORTED_MODULE_16__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.defineMessages)({
  services: {
    "id": "components.Settings.services",
    "defaultMessage": 'Services'
  },
  radarrsettings: {
    "id": "components.Settings.radarrsettings",
    "defaultMessage": 'Radarr Settings'
  },
  sonarrsettings: {
    "id": "components.Settings.sonarrsettings",
    "defaultMessage": 'Sonarr Settings'
  },
  serviceSettingsDescription: {
    "id": "components.Settings.serviceSettingsDescription",
    "defaultMessage": 'Configure your {serverType} server(s) below. You can connect multiple {serverType} servers, but only two of them can be marked as defaults (one non-4K and one 4K). Administrators are able to override the server used to process new requests prior to approval.'
  },
  deleteserverconfirm: {
    "id": "components.Settings.deleteserverconfirm",
    "defaultMessage": 'Are you sure you want to delete this server?'
  },
  ssl: {
    "id": "components.Settings.ssl",
    "defaultMessage": 'SSL'
  },
  default: {
    "id": "components.Settings.default",
    "defaultMessage": 'Default'
  },
  default4k: {
    "id": "components.Settings.default4k",
    "defaultMessage": 'Default 4K'
  },
  is4k: {
    "id": "components.Settings.is4k",
    "defaultMessage": '4K'
  },
  address: {
    "id": "components.Settings.address",
    "defaultMessage": 'Address'
  },
  activeProfile: {
    "id": "components.Settings.activeProfile",
    "defaultMessage": 'Active Profile'
  },
  addradarr: {
    "id": "components.Settings.addradarr",
    "defaultMessage": 'Add Radarr Server'
  },
  addsonarr: {
    "id": "components.Settings.addsonarr",
    "defaultMessage": 'Add Sonarr Server'
  },
  noDefaultServer: {
    "id": "components.Settings.noDefaultServer",
    "defaultMessage": 'At least one {serverType} server must be marked as default in order for {mediaType} requests to be processed.'
  },
  noDefaultNon4kServer: {
    "id": "components.Settings.noDefaultNon4kServer",
    "defaultMessage": 'If you only have a single {serverType} server for both non-4K and 4K content (or if you only download 4K content), your {serverType} server should <strong>NOT</strong> be designated as a 4K server.'
  },
  noDefault4kServer: {
    "id": "components.Settings.noDefault4kServer",
    "defaultMessage": 'A 4K {serverType} server must be marked as default in order to enable users to submit 4K {mediaType} requests.'
  },
  mediaTypeMovie: {
    "id": "components.Settings.mediaTypeMovie",
    "defaultMessage": 'movie'
  },
  mediaTypeSeries: {
    "id": "components.Settings.mediaTypeSeries",
    "defaultMessage": 'series'
  },
  deleteServer: {
    "id": "components.Settings.deleteServer",
    "defaultMessage": 'Delete {serverType} Server'
  }
});

const ServerInstance = ({
  name,
  hostname,
  port,
  profileName,
  is4k = false,
  isDefault = false,
  isSSL = false,
  isSonarr = false,
  externalUrl,
  onEdit,
  onDelete
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const internalUrl = (isSSL ? 'https://' : 'http://') + hostname + ':' + String(port);
  const serviceUrl = externalUrl ?? internalUrl;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("li", {
    className: "col-span-1 rounded-lg bg-gray-800 shadow ring-1 ring-gray-500",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
      className: "flex w-full items-center justify-between space-x-6 p-6",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
        className: "flex-1 truncate",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
          className: "mb-2 flex items-center space-x-2",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("h3", {
            className: "truncate font-medium leading-5 text-white",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("a", {
              href: serviceUrl,
              target: "_blank",
              rel: "noopener noreferrer",
              className: "transition duration-300 hover:text-white hover:underline",
              children: name
            })
          }), isDefault && !is4k && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            children: intl.formatMessage(messages.default)
          }), isDefault && is4k && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            children: intl.formatMessage(messages.default4k)
          }), !isDefault && is4k && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            badgeType: "warning",
            children: intl.formatMessage(messages.is4k)
          }), isSSL && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            badgeType: "success",
            children: intl.formatMessage(messages.ssl)
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("p", {
          className: "mt-1 truncate text-sm leading-5 text-gray-300",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("span", {
            className: "mr-2 font-bold",
            children: intl.formatMessage(messages.address)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("a", {
            href: internalUrl,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "transition duration-300 hover:text-white hover:underline",
            children: internalUrl
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("p", {
          className: "mt-1 truncate text-sm leading-5 text-gray-300",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("span", {
            className: "mr-2 font-bold",
            children: intl.formatMessage(messages.activeProfile)
          }), profileName]
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("a", {
        href: serviceUrl,
        target: "_blank",
        rel: "noopener noreferrer",
        className: "opacity-50 hover:opacity-100",
        children: isSonarr ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_assets_services_sonarr_svg__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          className: "h-10 w-10 flex-shrink-0"
        }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_assets_services_radarr_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          className: "h-10 w-10 flex-shrink-0"
        })
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("div", {
      className: "border-t border-gray-500",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
        className: "-mt-px flex",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("div", {
          className: "flex w-0 flex-1 border-r border-gray-500",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("button", {
            onClick: () => onEdit(),
            className: "focus:ring-blue relative -mr-px inline-flex w-0 flex-1 items-center justify-center rounded-bl-lg border border-transparent py-4 text-sm font-medium leading-5 text-gray-200 transition duration-150 ease-in-out hover:text-white focus:z-10 focus:border-gray-500 focus:outline-none",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.PencilIcon, {
              className: "mr-2 h-5 w-5"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("span", {
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_10__/* ["default"].edit */ .Z.edit)
            })]
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("div", {
          className: "-ml-px flex w-0 flex-1",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("button", {
            onClick: () => onDelete(),
            className: "focus:ring-blue relative inline-flex w-0 flex-1 items-center justify-center rounded-br-lg border border-transparent py-4 text-sm font-medium leading-5 text-gray-200 transition duration-150 ease-in-out hover:text-white focus:z-10 focus:border-gray-500 focus:outline-none",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.TrashIcon, {
              className: "mr-2 h-5 w-5"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("span", {
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_10__/* ["default"]["delete"] */ .Z["delete"])
            })]
          })
        })]
      })
    })]
  });
};

const SettingsServices = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    data: radarrData,
    error: radarrError,
    mutate: revalidateRadarr
  } = (0,swr__WEBPACK_IMPORTED_MODULE_16__["default"])('/api/v1/settings/radarr');
  const {
    data: sonarrData,
    error: sonarrError,
    mutate: revalidateSonarr
  } = (0,swr__WEBPACK_IMPORTED_MODULE_16__["default"])('/api/v1/settings/sonarr');
  const {
    0: editRadarrModal,
    1: setEditRadarrModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)({
    open: false,
    radarr: null
  });
  const {
    0: editSonarrModal,
    1: setEditSonarrModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)({
    open: false,
    sonarr: null
  });
  const {
    0: deleteServerModal,
    1: setDeleteServerModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)({
    open: false,
    type: 'radarr',
    serverId: null
  });

  const deleteServer = async () => {
    await axios__WEBPACK_IMPORTED_MODULE_13__["default"]["delete"](`/api/v1/settings/${deleteServerModal.type}/${deleteServerModal.serverId}`);
    setDeleteServerModal({
      open: false,
      serverId: null,
      type: 'radarr'
    });
    revalidateRadarr();
    revalidateSonarr();
    (0,swr__WEBPACK_IMPORTED_MODULE_16__.mutate)('/api/v1/settings/public');
  };

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.services), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_10__/* ["default"].settings */ .Z.settings)]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
      className: "mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.radarrsettings)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.serviceSettingsDescription, {
          serverType: 'Radarr'
        })
      })]
    }), editRadarrModal.open && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Settings_RadarrModal__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
      radarr: editRadarrModal.radarr,
      onClose: () => setEditRadarrModal({
        open: false,
        radarr: null
      }),
      onSave: () => {
        revalidateRadarr();
        (0,swr__WEBPACK_IMPORTED_MODULE_16__.mutate)('/api/v1/settings/public');
        setEditRadarrModal({
          open: false,
          radarr: null
        });
      }
    }), editSonarrModal.open && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Settings_SonarrModal__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
      sonarr: editSonarrModal.sonarr,
      onClose: () => setEditSonarrModal({
        open: false,
        sonarr: null
      }),
      onSave: () => {
        revalidateSonarr();
        (0,swr__WEBPACK_IMPORTED_MODULE_16__.mutate)('/api/v1/settings/public');
        setEditSonarrModal({
          open: false,
          sonarr: null
        });
      }
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_11__.Transition, {
      as: react__WEBPACK_IMPORTED_MODULE_14__.Fragment,
      show: deleteServerModal.open,
      enter: "transition-opacity ease-in-out duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity ease-in-out duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
        okText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_10__/* ["default"]["delete"] */ .Z["delete"]),
        okButtonType: "danger",
        onOk: () => deleteServer(),
        onCancel: () => setDeleteServerModal({
          open: false,
          serverId: null,
          type: 'radarr'
        }),
        title: intl.formatMessage(messages.deleteServer, {
          serverType: deleteServerModal.type === 'radarr' ? 'Radarr' : 'Sonarr'
        }),
        children: intl.formatMessage(messages.deleteserverconfirm)
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
      className: "section",
      children: [!radarrData && !radarrError && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {}), radarrData && !radarrError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.Fragment, {
        children: [radarrData.length > 0 && (!radarrData.some(radarr => radarr.isDefault) ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.noDefaultServer, {
            serverType: 'Radarr',
            mediaType: intl.formatMessage(messages.mediaTypeMovie)
          })
        }) : !radarrData.some(radarr => radarr.isDefault && !radarr.is4k) ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.noDefaultNon4kServer, {
            serverType: 'Radarr',
            strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("strong", {
              className: "font-semibold text-white",
              children: msg
            })
          })
        }) : radarrData.some(radarr => radarr.is4k) && !radarrData.some(radarr => radarr.isDefault && radarr.is4k) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.noDefault4kServer, {
            serverType: 'Radarr',
            mediaType: intl.formatMessage(messages.mediaTypeMovie)
          })
        })), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("ul", {
          className: "grid max-w-6xl grid-cols-1 gap-6 lg:grid-cols-2 xl:grid-cols-3",
          children: [radarrData.map(radarr => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(ServerInstance, {
            name: radarr.name,
            hostname: radarr.hostname,
            port: radarr.port,
            profileName: radarr.activeProfileName,
            isSSL: radarr.useSsl,
            isDefault: radarr.isDefault,
            is4k: radarr.is4k,
            externalUrl: radarr.externalUrl,
            onEdit: () => setEditRadarrModal({
              open: true,
              radarr
            }),
            onDelete: () => setDeleteServerModal({
              open: true,
              serverId: radarr.id,
              type: 'radarr'
            })
          }, `radarr-config-${radarr.id}`)), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("li", {
            className: "col-span-1 h-32 rounded-lg border-2 border-dashed border-gray-400 shadow sm:h-44",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("div", {
              className: "flex h-full w-full items-center justify-center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                buttonType: "ghost",
                className: "mt-3 mb-3",
                onClick: () => setEditRadarrModal({
                  open: true,
                  radarr: null
                }),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.PlusIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("span", {
                  children: intl.formatMessage(messages.addradarr)
                })]
              })
            })
          })]
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
      className: "mt-10 mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.sonarrsettings)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.serviceSettingsDescription, {
          serverType: 'Sonarr'
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
      className: "section",
      children: [!sonarrData && !sonarrError && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {}), sonarrData && !sonarrError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.Fragment, {
        children: [sonarrData.length > 0 && (!sonarrData.some(sonarr => sonarr.isDefault) ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.noDefaultServer, {
            serverType: 'Sonarr',
            mediaType: intl.formatMessage(messages.mediaTypeSeries)
          })
        }) : !sonarrData.some(sonarr => sonarr.isDefault && !sonarr.is4k) ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.noDefaultNon4kServer, {
            serverType: 'Sonarr',
            strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("strong", {
              className: "font-semibold text-white",
              children: msg
            })
          })
        }) : sonarrData.some(sonarr => sonarr.is4k) && !sonarrData.some(sonarr => sonarr.isDefault && sonarr.is4k) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.noDefault4kServer, {
            serverType: 'Sonarr',
            mediaType: intl.formatMessage(messages.mediaTypeSeries)
          })
        })), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("ul", {
          className: "grid max-w-6xl grid-cols-1 gap-6 lg:grid-cols-2 xl:grid-cols-3",
          children: [sonarrData.map(sonarr => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(ServerInstance, {
            name: sonarr.name,
            hostname: sonarr.hostname,
            port: sonarr.port,
            profileName: sonarr.activeProfileName,
            isSSL: sonarr.useSsl,
            isSonarr: true,
            isDefault: sonarr.isDefault,
            is4k: sonarr.is4k,
            externalUrl: sonarr.externalUrl,
            onEdit: () => setEditSonarrModal({
              open: true,
              sonarr
            }),
            onDelete: () => setDeleteServerModal({
              open: true,
              serverId: sonarr.id,
              type: 'sonarr'
            })
          }, `sonarr-config-${sonarr.id}`)), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("li", {
            className: "col-span-1 h-32 rounded-lg border-2 border-dashed border-gray-400 shadow sm:h-44",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("div", {
              className: "flex h-full w-full items-center justify-center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                buttonType: "ghost",
                onClick: () => setEditSonarrModal({
                  open: true,
                  sonarr: null
                }),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.PlusIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx("span", {
                  children: intl.formatMessage(messages.addsonarr)
                })]
              })
            })
          })]
        })]
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsServices);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 88796:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22796);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61903);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80210);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(61929);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__, _headlessui_react__WEBPACK_IMPORTED_MODULE_3__, axios__WEBPACK_IMPORTED_MODULE_4__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__, _headlessui_react__WEBPACK_IMPORTED_MODULE_3__, axios__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_7__.defineMessages)({
  createsonarr: {
    "id": "components.Settings.SonarrModal.createsonarr",
    "defaultMessage": 'Add New Sonarr Server'
  },
  create4ksonarr: {
    "id": "components.Settings.SonarrModal.create4ksonarr",
    "defaultMessage": 'Add New 4K Sonarr Server'
  },
  editsonarr: {
    "id": "components.Settings.SonarrModal.editsonarr",
    "defaultMessage": 'Edit Sonarr Server'
  },
  edit4ksonarr: {
    "id": "components.Settings.SonarrModal.edit4ksonarr",
    "defaultMessage": 'Edit 4K Sonarr Server'
  },
  validationNameRequired: {
    "id": "components.Settings.SonarrModal.validationNameRequired",
    "defaultMessage": 'You must provide a server name'
  },
  validationHostnameRequired: {
    "id": "components.Settings.SonarrModal.validationHostnameRequired",
    "defaultMessage": 'You must provide a valid hostname or IP address'
  },
  validationPortRequired: {
    "id": "components.Settings.SonarrModal.validationPortRequired",
    "defaultMessage": 'You must provide a valid port number'
  },
  validationApiKeyRequired: {
    "id": "components.Settings.SonarrModal.validationApiKeyRequired",
    "defaultMessage": 'You must provide an API key'
  },
  validationRootFolderRequired: {
    "id": "components.Settings.SonarrModal.validationRootFolderRequired",
    "defaultMessage": 'You must select a root folder'
  },
  validationProfileRequired: {
    "id": "components.Settings.SonarrModal.validationProfileRequired",
    "defaultMessage": 'You must select a quality profile'
  },
  validationLanguageProfileRequired: {
    "id": "components.Settings.SonarrModal.validationLanguageProfileRequired",
    "defaultMessage": 'You must select a language profile'
  },
  toastSonarrTestSuccess: {
    "id": "components.Settings.SonarrModal.toastSonarrTestSuccess",
    "defaultMessage": 'Sonarr connection established successfully!'
  },
  toastSonarrTestFailure: {
    "id": "components.Settings.SonarrModal.toastSonarrTestFailure",
    "defaultMessage": 'Failed to connect to Sonarr.'
  },
  add: {
    "id": "components.Settings.SonarrModal.add",
    "defaultMessage": 'Add Server'
  },
  defaultserver: {
    "id": "components.Settings.SonarrModal.defaultserver",
    "defaultMessage": 'Default Server'
  },
  default4kserver: {
    "id": "components.Settings.SonarrModal.default4kserver",
    "defaultMessage": 'Default 4K Server'
  },
  servername: {
    "id": "components.Settings.SonarrModal.servername",
    "defaultMessage": 'Server Name'
  },
  hostname: {
    "id": "components.Settings.SonarrModal.hostname",
    "defaultMessage": 'Hostname or IP Address'
  },
  port: {
    "id": "components.Settings.SonarrModal.port",
    "defaultMessage": 'Port'
  },
  ssl: {
    "id": "components.Settings.SonarrModal.ssl",
    "defaultMessage": 'Use SSL'
  },
  apiKey: {
    "id": "components.Settings.SonarrModal.apiKey",
    "defaultMessage": 'API Key'
  },
  baseUrl: {
    "id": "components.Settings.SonarrModal.baseUrl",
    "defaultMessage": 'URL Base'
  },
  qualityprofile: {
    "id": "components.Settings.SonarrModal.qualityprofile",
    "defaultMessage": 'Quality Profile'
  },
  languageprofile: {
    "id": "components.Settings.SonarrModal.languageprofile",
    "defaultMessage": 'Language Profile'
  },
  rootfolder: {
    "id": "components.Settings.SonarrModal.rootfolder",
    "defaultMessage": 'Root Folder'
  },
  seriesType: {
    "id": "components.Settings.SonarrModal.seriesType",
    "defaultMessage": 'Series Type'
  },
  animeSeriesType: {
    "id": "components.Settings.SonarrModal.animeSeriesType",
    "defaultMessage": 'Anime Series Type'
  },
  animequalityprofile: {
    "id": "components.Settings.SonarrModal.animequalityprofile",
    "defaultMessage": 'Anime Quality Profile'
  },
  animelanguageprofile: {
    "id": "components.Settings.SonarrModal.animelanguageprofile",
    "defaultMessage": 'Anime Language Profile'
  },
  animerootfolder: {
    "id": "components.Settings.SonarrModal.animerootfolder",
    "defaultMessage": 'Anime Root Folder'
  },
  seasonfolders: {
    "id": "components.Settings.SonarrModal.seasonfolders",
    "defaultMessage": 'Season Folders'
  },
  server4k: {
    "id": "components.Settings.SonarrModal.server4k",
    "defaultMessage": '4K Server'
  },
  selectQualityProfile: {
    "id": "components.Settings.SonarrModal.selectQualityProfile",
    "defaultMessage": 'Select quality profile'
  },
  selectRootFolder: {
    "id": "components.Settings.SonarrModal.selectRootFolder",
    "defaultMessage": 'Select root folder'
  },
  selectLanguageProfile: {
    "id": "components.Settings.SonarrModal.selectLanguageProfile",
    "defaultMessage": 'Select language profile'
  },
  loadingprofiles: {
    "id": "components.Settings.SonarrModal.loadingprofiles",
    "defaultMessage": 'Loading quality profiles…'
  },
  testFirstQualityProfiles: {
    "id": "components.Settings.SonarrModal.testFirstQualityProfiles",
    "defaultMessage": 'Test connection to load quality profiles'
  },
  loadingrootfolders: {
    "id": "components.Settings.SonarrModal.loadingrootfolders",
    "defaultMessage": 'Loading root folders…'
  },
  testFirstRootFolders: {
    "id": "components.Settings.SonarrModal.testFirstRootFolders",
    "defaultMessage": 'Test connection to load root folders'
  },
  loadinglanguageprofiles: {
    "id": "components.Settings.SonarrModal.loadinglanguageprofiles",
    "defaultMessage": 'Loading language profiles…'
  },
  testFirstLanguageProfiles: {
    "id": "components.Settings.SonarrModal.testFirstLanguageProfiles",
    "defaultMessage": 'Test connection to load language profiles'
  },
  loadingTags: {
    "id": "components.Settings.SonarrModal.loadingTags",
    "defaultMessage": 'Loading tags…'
  },
  testFirstTags: {
    "id": "components.Settings.SonarrModal.testFirstTags",
    "defaultMessage": 'Test connection to load tags'
  },
  syncEnabled: {
    "id": "components.Settings.SonarrModal.syncEnabled",
    "defaultMessage": 'Enable Scan'
  },
  externalUrl: {
    "id": "components.Settings.SonarrModal.externalUrl",
    "defaultMessage": 'External URL'
  },
  enableSearch: {
    "id": "components.Settings.SonarrModal.enableSearch",
    "defaultMessage": 'Enable Automatic Search'
  },
  tagRequests: {
    "id": "components.Settings.SonarrModal.tagRequests",
    "defaultMessage": 'Tag Requests'
  },
  tagRequestsInfo: {
    "id": "components.Settings.SonarrModal.tagRequestsInfo",
    "defaultMessage": "Automatically add an additional tag with the requester's user ID & display name"
  },
  validationApplicationUrl: {
    "id": "components.Settings.SonarrModal.validationApplicationUrl",
    "defaultMessage": 'You must provide a valid URL'
  },
  validationApplicationUrlTrailingSlash: {
    "id": "components.Settings.SonarrModal.validationApplicationUrlTrailingSlash",
    "defaultMessage": 'URL must not end in a trailing slash'
  },
  validationBaseUrlLeadingSlash: {
    "id": "components.Settings.SonarrModal.validationBaseUrlLeadingSlash",
    "defaultMessage": 'Base URL must have a leading slash'
  },
  validationBaseUrlTrailingSlash: {
    "id": "components.Settings.SonarrModal.validationBaseUrlTrailingSlash",
    "defaultMessage": 'Base URL must not end in a trailing slash'
  },
  tags: {
    "id": "components.Settings.SonarrModal.tags",
    "defaultMessage": 'Tags'
  },
  animeTags: {
    "id": "components.Settings.SonarrModal.animeTags",
    "defaultMessage": 'Anime Tags'
  },
  notagoptions: {
    "id": "components.Settings.SonarrModal.notagoptions",
    "defaultMessage": 'No tags.'
  },
  selecttags: {
    "id": "components.Settings.SonarrModal.selecttags",
    "defaultMessage": 'Select tags'
  }
});

const SonarrModal = ({
  onClose,
  sonarr,
  onSave
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_7__.useIntl)();
  const initialLoad = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(false);
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__.useToasts)();
  const {
    0: isValidated,
    1: setIsValidated
  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(sonarr ? true : false);
  const {
    0: isTesting,
    1: setIsTesting
  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const {
    0: testResponse,
    1: setTestResponse
  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)({
    profiles: [],
    rootFolders: [],
    languageProfiles: [],
    tags: []
  });
  const SonarrSettingsSchema = yup__WEBPACK_IMPORTED_MODULE_10__.object().shape({
    name: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationNameRequired)),
    hostname: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationHostnameRequired)).matches(/^(((([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])):((([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))@)?(([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])$/i, intl.formatMessage(messages.validationHostnameRequired)),
    port: yup__WEBPACK_IMPORTED_MODULE_10__.number().nullable().required(intl.formatMessage(messages.validationPortRequired)),
    apiKey: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationApiKeyRequired)),
    rootFolder: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationRootFolderRequired)),
    activeProfileId: yup__WEBPACK_IMPORTED_MODULE_10__.string().required(intl.formatMessage(messages.validationProfileRequired)),
    activeLanguageProfileId: yup__WEBPACK_IMPORTED_MODULE_10__.number().required(intl.formatMessage(messages.validationLanguageProfileRequired)),
    externalUrl: yup__WEBPACK_IMPORTED_MODULE_10__.string().url(intl.formatMessage(messages.validationApplicationUrl)).test('no-trailing-slash', intl.formatMessage(messages.validationApplicationUrlTrailingSlash), value => !value || !value.endsWith('/')),
    baseUrl: yup__WEBPACK_IMPORTED_MODULE_10__.string().test('leading-slash', intl.formatMessage(messages.validationBaseUrlLeadingSlash), value => !value || value.startsWith('/')).test('no-trailing-slash', intl.formatMessage(messages.validationBaseUrlTrailingSlash), value => !value || !value.endsWith('/'))
  });
  const testConnection = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(async ({
    hostname,
    port,
    apiKey,
    baseUrl,
    useSsl = false
  }) => {
    setIsTesting(true);

    try {
      const response = await axios__WEBPACK_IMPORTED_MODULE_4__["default"].post('/api/v1/settings/sonarr/test', {
        hostname,
        apiKey,
        port: Number(port),
        baseUrl,
        useSsl
      });
      setIsValidated(true);
      setTestResponse(response.data);

      if (initialLoad.current) {
        addToast(intl.formatMessage(messages.toastSonarrTestSuccess), {
          appearance: 'success',
          autoDismiss: true
        });
      }
    } catch (e) {
      setIsValidated(false);

      if (initialLoad.current) {
        addToast(intl.formatMessage(messages.toastSonarrTestFailure), {
          appearance: 'error',
          autoDismiss: true
        });
      }
    } finally {
      setIsTesting(false);
      initialLoad.current = true;
    }
  }, [addToast, intl]);
  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (sonarr) {
      testConnection({
        apiKey: sonarr.apiKey,
        hostname: sonarr.hostname,
        port: sonarr.port,
        baseUrl: sonarr.baseUrl,
        useSsl: sonarr.useSsl
      });
    }
  }, [sonarr, testConnection]);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Transition, {
    as: "div",
    appear: true,
    show: true,
    enter: "transition-opacity ease-in-out duration-300",
    enterFrom: "opacity-0",
    enterTo: "opacity-100",
    leave: "transition-opacity ease-in-out duration-300",
    leaveFrom: "opacity-100",
    leaveTo: "opacity-0",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Formik, {
      initialValues: {
        name: sonarr?.name,
        hostname: sonarr?.hostname,
        port: sonarr?.port ?? 8989,
        ssl: sonarr?.useSsl ?? false,
        apiKey: sonarr?.apiKey,
        baseUrl: sonarr?.baseUrl,
        activeProfileId: sonarr?.activeProfileId,
        activeLanguageProfileId: sonarr?.activeLanguageProfileId,
        rootFolder: sonarr?.activeDirectory,
        seriesType: sonarr?.seriesType,
        animeSeriesType: sonarr?.animeSeriesType,
        activeAnimeProfileId: sonarr?.activeAnimeProfileId,
        activeAnimeLanguageProfileId: sonarr?.activeAnimeLanguageProfileId,
        activeAnimeRootFolder: sonarr?.activeAnimeDirectory,
        tags: sonarr?.tags ?? [],
        animeTags: sonarr?.animeTags ?? [],
        isDefault: sonarr?.isDefault ?? false,
        is4k: sonarr?.is4k ?? false,
        enableSeasonFolders: sonarr?.enableSeasonFolders ?? false,
        externalUrl: sonarr?.externalUrl,
        syncEnabled: sonarr?.syncEnabled ?? false,
        enableSearch: !sonarr?.preventSearch,
        tagRequests: sonarr?.tagRequests ?? false
      },
      validationSchema: SonarrSettingsSchema,
      onSubmit: async values => {
        try {
          const profileName = testResponse.profiles.find(profile => profile.id === Number(values.activeProfileId))?.name;
          const animeProfileName = testResponse.profiles.find(profile => profile.id === Number(values.activeAnimeProfileId))?.name;
          const submission = {
            name: values.name,
            hostname: values.hostname,
            port: Number(values.port),
            apiKey: values.apiKey,
            useSsl: values.ssl,
            baseUrl: values.baseUrl,
            activeProfileId: Number(values.activeProfileId),
            activeLanguageProfileId: values.activeLanguageProfileId ? Number(values.activeLanguageProfileId) : undefined,
            activeProfileName: profileName,
            activeDirectory: values.rootFolder,
            seriesType: values.seriesType,
            animeSeriesType: values.animeSeriesType,
            activeAnimeProfileId: values.activeAnimeProfileId ? Number(values.activeAnimeProfileId) : undefined,
            activeAnimeLanguageProfileId: values.activeAnimeLanguageProfileId ? Number(values.activeAnimeLanguageProfileId) : undefined,
            activeAnimeProfileName: animeProfileName ?? undefined,
            activeAnimeDirectory: values.activeAnimeRootFolder,
            tags: values.tags,
            animeTags: values.animeTags,
            is4k: values.is4k,
            isDefault: values.isDefault,
            enableSeasonFolders: values.enableSeasonFolders,
            externalUrl: values.externalUrl,
            syncEnabled: values.syncEnabled,
            preventSearch: !values.enableSearch,
            tagRequests: values.tagRequests
          };

          if (!sonarr) {
            await axios__WEBPACK_IMPORTED_MODULE_4__["default"].post('/api/v1/settings/sonarr', submission);
          } else {
            await axios__WEBPACK_IMPORTED_MODULE_4__["default"].put(`/api/v1/settings/sonarr/${sonarr.id}`, submission);
          }

          onSave();
        } catch (e) {// set error here
        }
      },
      children: ({
        errors,
        touched,
        values,
        handleSubmit,
        setFieldValue,
        isSubmitting,
        isValid
      }) => {
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          onCancel: onClose,
          okButtonType: "primary",
          okText: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].saving */ .Z.saving) : sonarr ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].save */ .Z.save) : intl.formatMessage(messages.add),
          secondaryButtonType: "warning",
          secondaryText: isTesting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].testing */ .Z.testing) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].test */ .Z.test),
          onSecondary: () => {
            if (values.apiKey && values.hostname && values.port) {
              testConnection({
                apiKey: values.apiKey,
                baseUrl: values.baseUrl,
                hostname: values.hostname,
                port: values.port,
                useSsl: values.ssl
              });

              if (!values.baseUrl || values.baseUrl === '/') {
                setFieldValue('baseUrl', testResponse.urlBase);
              }
            }
          },
          secondaryDisabled: !values.apiKey || !values.hostname || !values.port || isTesting || isSubmitting,
          okDisabled: !isValidated || isSubmitting || isTesting || !isValid,
          onOk: () => handleSubmit(),
          title: !sonarr ? intl.formatMessage(values.is4k ? messages.create4ksonarr : messages.createsonarr) : intl.formatMessage(values.is4k ? messages.edit4ksonarr : messages.editsonarr),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "mb-6",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "isDefault",
                className: "checkbox-label",
                children: intl.formatMessage(values.is4k ? messages.default4kserver : messages.defaultserver)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "isDefault",
                  name: "isDefault"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "is4k",
                className: "checkbox-label",
                children: intl.formatMessage(messages.server4k)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "is4k",
                  name: "is4k"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "name",
                className: "text-label",
                children: [intl.formatMessage(messages.servername), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    id: "name",
                    name: "name",
                    type: "text",
                    autoComplete: "off",
                    "data-1pignore": "true",
                    "data-lpignore": "true",
                    "data-bwignore": "true",
                    onChange: e => {
                      setIsValidated(false);
                      setFieldValue('name', e.target.value);
                    }
                  })
                }), errors.name && touched.name && typeof errors.name === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.name
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "hostname",
                className: "text-label",
                children: [intl.formatMessage(messages.hostname), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                  className: "form-input-field",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                    className: "protocol",
                    children: values.ssl ? 'https://' : 'http://'
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    id: "hostname",
                    name: "hostname",
                    type: "text",
                    inputMode: "url",
                    onChange: e => {
                      setIsValidated(false);
                      setFieldValue('hostname', e.target.value);
                    },
                    className: "rounded-r-only"
                  })]
                }), errors.hostname && touched.hostname && typeof errors.hostname === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.hostname
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "port",
                className: "text-label",
                children: [intl.formatMessage(messages.port), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  id: "port",
                  name: "port",
                  type: "text",
                  inputMode: "numeric",
                  className: "short",
                  onChange: e => {
                    setIsValidated(false);
                    setFieldValue('port', e.target.value);
                  }
                }), errors.port && touched.port && typeof errors.port === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.port
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "ssl",
                className: "checkbox-label",
                children: intl.formatMessage(messages.ssl)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "ssl",
                  name: "ssl",
                  onChange: () => {
                    setIsValidated(false);
                    setFieldValue('ssl', !values.ssl);
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "apiKey",
                className: "text-label",
                children: [intl.formatMessage(messages.apiKey), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    as: "field",
                    id: "apiKey",
                    name: "apiKey",
                    onChange: e => {
                      setIsValidated(false);
                      setFieldValue('apiKey', e.target.value);
                    }
                  })
                }), errors.apiKey && touched.apiKey && typeof errors.apiKey === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.apiKey
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "baseUrl",
                className: "text-label",
                children: intl.formatMessage(messages.baseUrl)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    id: "baseUrl",
                    name: "baseUrl",
                    type: "text",
                    inputMode: "url",
                    onChange: e => {
                      setIsValidated(false);
                      setFieldValue('baseUrl', e.target.value);
                    }
                  })
                }), errors.baseUrl && touched.baseUrl && typeof errors.baseUrl === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.baseUrl
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "seriesType",
                className: "text-label",
                children: intl.formatMessage(messages.seriesType)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "seriesType",
                    name: "seriesType",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "standard",
                      children: "Standard"
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "daily",
                      children: "Daily"
                    })]
                  })
                })
              }), errors.seriesType && touched.seriesType && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "error",
                children: errors.seriesType
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "activeProfileId",
                className: "text-label",
                children: [intl.formatMessage(messages.qualityprofile), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "activeProfileId",
                    name: "activeProfileId",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "",
                      children: isTesting ? intl.formatMessage(messages.loadingprofiles) : !isValidated ? intl.formatMessage(messages.testFirstQualityProfiles) : intl.formatMessage(messages.selectQualityProfile)
                    }), testResponse.profiles.length > 0 && testResponse.profiles.map(profile => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: profile.id,
                      children: profile.name
                    }, `loaded-profile-${profile.id}`))]
                  })
                }), errors.activeProfileId && touched.activeProfileId && typeof errors.activeProfileId === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.activeProfileId
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "rootFolder",
                className: "text-label",
                children: [intl.formatMessage(messages.rootfolder), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "rootFolder",
                    name: "rootFolder",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "",
                      children: isTesting ? intl.formatMessage(messages.loadingrootfolders) : !isValidated ? intl.formatMessage(messages.testFirstRootFolders) : intl.formatMessage(messages.selectRootFolder)
                    }), testResponse.rootFolders.length > 0 && testResponse.rootFolders.map(folder => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: folder.path,
                      children: folder.path
                    }, `loaded-profile-${folder.id}`))]
                  })
                }), errors.rootFolder && touched.rootFolder && typeof errors.rootFolder === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.rootFolder
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "activeLanguageProfileId",
                className: "text-label",
                children: [intl.formatMessage(messages.languageprofile), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "activeLanguageProfileId",
                    name: "activeLanguageProfileId",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "",
                      children: isTesting ? intl.formatMessage(messages.loadinglanguageprofiles) : !isValidated ? intl.formatMessage(messages.testFirstLanguageProfiles) : intl.formatMessage(messages.selectLanguageProfile)
                    }), testResponse.languageProfiles.length > 0 && testResponse.languageProfiles.map(language => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: language.id,
                      children: language.name
                    }, `loaded-profile-${language.id}`))]
                  })
                }), errors.activeLanguageProfileId && touched.activeLanguageProfileId && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.activeLanguageProfileId
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "tags",
                className: "text-label",
                children: intl.formatMessage(messages.tags)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx((react_select__WEBPACK_IMPORTED_MODULE_8___default()), {
                  options: isValidated ? testResponse.tags.map(tag => ({
                    label: tag.label,
                    value: tag.id
                  })) : [],
                  isMulti: true,
                  isDisabled: !isValidated || isTesting,
                  placeholder: !isValidated ? intl.formatMessage(messages.testFirstTags) : isTesting ? intl.formatMessage(messages.loadingTags) : intl.formatMessage(messages.selecttags),
                  isLoading: isTesting,
                  className: "react-select-container",
                  classNamePrefix: "react-select",
                  value: isTesting ? [] : values.tags.map(tagId => {
                    const foundTag = testResponse.tags.find(tag => tag.id === tagId);

                    if (!foundTag) {
                      return undefined;
                    }

                    return {
                      value: foundTag.id,
                      label: foundTag.label
                    };
                  }).filter(option => option !== undefined),
                  onChange: value => {
                    setFieldValue('tags', value.map(option => option.value));
                  },
                  noOptionsMessage: () => intl.formatMessage(messages.notagoptions)
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "animeSeriesType",
                className: "text-label",
                children: intl.formatMessage(messages.animeSeriesType)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "animeSeriesType",
                    name: "animeSeriesType",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "standard",
                      children: "Standard"
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "anime",
                      children: "Anime"
                    })]
                  })
                })
              }), errors.animeSeriesType && touched.animeSeriesType && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "error",
                children: errors.animeSeriesType
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "activeAnimeProfileId",
                className: "text-label",
                children: intl.formatMessage(messages.animequalityprofile)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "activeAnimeProfileId",
                    name: "activeAnimeProfileId",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "",
                      children: isTesting ? intl.formatMessage(messages.loadingprofiles) : !isValidated ? intl.formatMessage(messages.testFirstQualityProfiles) : intl.formatMessage(messages.selectQualityProfile)
                    }), testResponse.profiles.length > 0 && testResponse.profiles.map(profile => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: profile.id,
                      children: profile.name
                    }, `loaded-profile-${profile.id}`))]
                  })
                }), errors.activeAnimeProfileId && touched.activeAnimeProfileId && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.activeAnimeProfileId
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "activeAnimeRootFolder",
                className: "text-label",
                children: intl.formatMessage(messages.animerootfolder)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "activeAnimeRootFolder",
                    name: "activeAnimeRootFolder",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "",
                      children: isTesting ? intl.formatMessage(messages.loadingrootfolders) : !isValidated ? intl.formatMessage(messages.testFirstRootFolders) : intl.formatMessage(messages.selectRootFolder)
                    }), testResponse.rootFolders.length > 0 && testResponse.rootFolders.map(folder => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: folder.path,
                      children: folder.path
                    }, `loaded-profile-${folder.id}`))]
                  })
                }), errors.activeAnimeRootFolder && touched.activeAnimeRootFolder && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.rootFolder
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "activeAnimeLanguageProfileId",
                className: "text-label",
                children: intl.formatMessage(messages.animelanguageprofile)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    as: "select",
                    id: "activeAnimeLanguageProfileId",
                    name: "activeAnimeLanguageProfileId",
                    disabled: !isValidated || isTesting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: "",
                      children: isTesting ? intl.formatMessage(messages.loadinglanguageprofiles) : !isValidated ? intl.formatMessage(messages.testFirstLanguageProfiles) : intl.formatMessage(messages.selectLanguageProfile)
                    }), testResponse.languageProfiles.length > 0 && testResponse.languageProfiles.map(language => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
                      value: language.id,
                      children: language.name
                    }, `loaded-profile-${language.id}`))]
                  })
                }), errors.activeAnimeLanguageProfileId && touched.activeAnimeLanguageProfileId && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.activeAnimeLanguageProfileId
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "tags",
                className: "text-label",
                children: intl.formatMessage(messages.animeTags)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx((react_select__WEBPACK_IMPORTED_MODULE_8___default()), {
                  options: isValidated ? testResponse.tags.map(tag => ({
                    label: tag.label,
                    value: tag.id
                  })) : [],
                  isMulti: true,
                  isDisabled: !isValidated,
                  placeholder: !isValidated ? intl.formatMessage(messages.testFirstTags) : isTesting ? intl.formatMessage(messages.loadingTags) : intl.formatMessage(messages.selecttags),
                  isLoading: isTesting,
                  className: "react-select-container",
                  classNamePrefix: "react-select",
                  value: isTesting ? [] : values.animeTags.map(tagId => {
                    const foundTag = testResponse.tags.find(tag => tag.id === tagId);

                    if (!foundTag) {
                      return undefined;
                    }

                    return {
                      value: foundTag.id,
                      label: foundTag.label
                    };
                  }).filter(option => option !== undefined),
                  onChange: value => {
                    setFieldValue('animeTags', value.map(option => option.value));
                  },
                  noOptionsMessage: () => intl.formatMessage(messages.notagoptions)
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "enableSeasonFolders",
                className: "checkbox-label",
                children: intl.formatMessage(messages.seasonfolders)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "enableSeasonFolders",
                  name: "enableSeasonFolders"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "externalUrl",
                className: "text-label",
                children: intl.formatMessage(messages.externalUrl)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                    id: "externalUrl",
                    name: "externalUrl",
                    type: "text",
                    inputMode: "url"
                  })
                }), errors.externalUrl && touched.externalUrl && typeof errors.externalUrl === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                  className: "error",
                  children: errors.externalUrl
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "syncEnabled",
                className: "checkbox-label",
                children: intl.formatMessage(messages.syncEnabled)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "syncEnabled",
                  name: "syncEnabled"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
                htmlFor: "enableSearch",
                className: "checkbox-label",
                children: intl.formatMessage(messages.enableSearch)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "enableSearch",
                  name: "enableSearch"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("label", {
                htmlFor: "tagRequests",
                className: "checkbox-label",
                children: [intl.formatMessage(messages.tagRequests), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.tagRequestsInfo)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  type: "checkbox",
                  id: "tagRequests",
                  name: "tagRequests"
                })
              })]
            })]
          })
        });
      }
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SonarrModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;