"use strict";
exports.id = 31601;
exports.ids = [31601];
exports.modules = {

/***/ 31601:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7292);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(63145);
/* harmony import */ var _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(42040);
/* harmony import */ var _app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12001);
/* harmony import */ var _app_hooks_useDeepLinks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(44627);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80210);
/* harmony import */ var _app_utils_refreshIntervalHelper__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(28299);
/* harmony import */ var _app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(66234);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(59147);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(99648);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react_intersection_observer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(44009);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__, _app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_11__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_14__, swr__WEBPACK_IMPORTED_MODULE_17__]);
([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__, _app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_11__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_14__, swr__WEBPACK_IMPORTED_MODULE_17__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);























const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.defineMessages)({
  seasons: {
    "id": "components.RequestCard.seasons",
    "defaultMessage": '{seasonCount, plural, one {Season} other {Seasons}}'
  },
  failedretry: {
    "id": "components.RequestCard.failedretry",
    "defaultMessage": 'Something went wrong while retrying the request.'
  },
  mediaerror: {
    "id": "components.RequestCard.mediaerror",
    "defaultMessage": '{mediaType} Not Found'
  },
  tmdbid: {
    "id": "components.RequestCard.tmdbid",
    "defaultMessage": 'TMDB ID'
  },
  tvdbid: {
    "id": "components.RequestCard.tvdbid",
    "defaultMessage": 'TheTVDB ID'
  },
  approverequest: {
    "id": "components.RequestCard.approverequest",
    "defaultMessage": 'Approve Request'
  },
  declinerequest: {
    "id": "components.RequestCard.declinerequest",
    "defaultMessage": 'Decline Request'
  },
  editrequest: {
    "id": "components.RequestCard.editrequest",
    "defaultMessage": 'Edit Request'
  },
  cancelrequest: {
    "id": "components.RequestCard.cancelrequest",
    "defaultMessage": 'Cancel Request'
  },
  deleterequest: {
    "id": "components.RequestCard.deleterequest",
    "defaultMessage": 'Delete Request'
  },
  unknowntitle: {
    "id": "components.RequestCard.unknowntitle",
    "defaultMessage": 'Unknown Title'
  }
});

const isMovie = movie => {
  return movie.title !== undefined;
};

const RequestCardPlaceholder = () => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
    className: "relative w-72 animate-pulse rounded-xl bg-gray-700 p-4 sm:w-96",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: "w-20 sm:w-28",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
        className: "w-full",
        style: {
          paddingBottom: '150%'
        }
      })
    })
  });
};

const RequestCardError = ({
  requestData
}) => {
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .useUser */ .aF)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    plexUrl,
    plexUrl4k
  } = (0,_app_hooks_useDeepLinks__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)({
    plexUrl: requestData?.media?.plexUrl,
    plexUrl4k: requestData?.media?.plexUrl4k,
    iOSPlexUrl: requestData?.media?.iOSPlexUrl,
    iOSPlexUrl4k: requestData?.media?.iOSPlexUrl4k
  });

  const deleteRequest = async () => {
    await axios__WEBPACK_IMPORTED_MODULE_11__["default"]["delete"](`/api/v1/media/${requestData?.media.id}`);
    (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/media?filter=allavailable&take=20&sort=mediaAdded');
    (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/request?filter=all&take=10&sort=modified&skip=0');
    (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/request/count');
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
    className: "relative flex w-72 overflow-hidden rounded-xl bg-gray-800 p-4 text-gray-400 shadow ring-1 ring-red-500 sm:w-96",
    "data-testid": "request-card",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: "w-20 sm:w-28",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
        className: "w-full",
        style: {
          paddingBottom: '150%'
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
          className: "absolute inset-0 z-10 flex min-w-0 flex-1 flex-col p-4",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
            className: "whitespace-normal text-base font-bold text-white sm:text-lg",
            "data-testid": "request-card-title",
            children: intl.formatMessage(messages.mediaerror, {
              mediaType: intl.formatMessage(requestData?.type ? requestData?.type === 'movie' ? _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].movie */ .Z.movie : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].tvshow */ .Z.tvshow : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].request */ .Z.request)
            })
          }), requestData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
            children: [hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_VIEW */ .y3.REQUEST_VIEW], {
              type: 'or'
            }) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
              className: "card-field !hidden sm:!block",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
                href: `/users/${requestData.requestedBy.id}`,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("a", {
                  className: "group flex items-center",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("img", {
                    src: requestData.requestedBy.avatar,
                    alt: "",
                    className: "avatar-sm"
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                    className: "truncate group-hover:underline",
                    children: requestData.requestedBy.displayName
                  })]
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
              className: "mt-2 flex items-center text-sm sm:mt-1",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "mr-2 hidden font-bold sm:block",
                children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].status */ .Z.status)
              }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED || requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.FAILED */ .pi.FAILED ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                badgeType: "danger",
                children: requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].declined */ .Z.declined) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].failed */ .Z.failed)
              }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                status: requestData.media[requestData.is4k ? 'status4k' : 'status'],
                downloadItem: requestData.media[requestData.is4k ? 'downloadStatus4k' : 'downloadStatus'],
                title: intl.formatMessage(messages.unknowntitle),
                inProgress: (requestData.media[requestData.is4k ? 'downloadStatus4k' : 'downloadStatus'] ?? []).length > 0,
                is4k: requestData.is4k,
                mediaType: requestData.type,
                plexUrl: requestData.is4k ? plexUrl4k : plexUrl,
                serviceUrl: requestData.is4k ? requestData.media.serviceUrl4k : requestData.media.serviceUrl
              })]
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
            className: "flex flex-1 items-end space-x-2",
            children: hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && requestData?.media.id && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                buttonType: "danger",
                buttonSize: "sm",
                className: "mt-4 hidden sm:block",
                onClick: () => deleteRequest(),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.TrashIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"]["delete"] */ .Z["delete"])
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                content: intl.formatMessage(messages.deleterequest),
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  buttonType: "danger",
                  buttonSize: "sm",
                  className: "mt-4 sm:hidden",
                  onClick: () => deleteRequest(),
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.TrashIcon, {})
                })
              })]
            })
          })]
        })
      })
    })
  });
};

const RequestCard = ({
  request,
  onTitleData
}) => {
  const {
    ref,
    inView
  } = (0,react_intersection_observer__WEBPACK_IMPORTED_MODULE_14__.useInView)({
    triggerOnce: true
  });
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    user,
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .useUser */ .aF)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__.useToasts)();
  const {
    0: isRetrying,
    1: setRetrying
  } = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)(false);
  const {
    0: showEditModal,
    1: setShowEditModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)(false);
  const url = request.type === 'movie' ? `/api/v1/movie/${request.media.tmdbId}` : `/api/v1/tv/${request.media.tmdbId}`;
  const {
    data: title,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])(inView ? `${url}` : null);
  const {
    data: requestData,
    error: requestError,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])(`/api/v1/request/${request.id}`, {
    fallbackData: request,
    refreshInterval: (0,_app_utils_refreshIntervalHelper__WEBPACK_IMPORTED_MODULE_19__/* .refreshIntervalHelper */ .v)({
      downloadStatus: request.media.downloadStatus,
      downloadStatus4k: request.media.downloadStatus4k
    }, 15000)
  });
  const {
    plexUrl,
    plexUrl4k
  } = (0,_app_hooks_useDeepLinks__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)({
    plexUrl: requestData?.media?.plexUrl,
    plexUrl4k: requestData?.media?.plexUrl4k,
    iOSPlexUrl: requestData?.media?.iOSPlexUrl,
    iOSPlexUrl4k: requestData?.media?.iOSPlexUrl4k
  });

  const modifyRequest = async type => {
    const response = await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post(`/api/v1/request/${request.id}/${type}`);

    if (response) {
      revalidate();
      (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/request/count');
    }
  };

  const deleteRequest = async () => {
    await axios__WEBPACK_IMPORTED_MODULE_11__["default"]["delete"](`/api/v1/request/${request.id}`);
    (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/request?filter=all&take=10&sort=modified&skip=0');
    (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/request/count');
  };

  const retryRequest = async () => {
    setRetrying(true);

    try {
      const response = await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post(`/api/v1/request/${request.id}/retry`);

      if (response) {
        revalidate();
      }
    } catch (e) {
      addToast(intl.formatMessage(messages.failedretry), {
        autoDismiss: true,
        appearance: 'error'
      });
    } finally {
      setRetrying(false);
    }
  };

  (0,react__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    if (title && onTitleData) {
      onTitleData(request.id, title);
    }
  }, [title, onTitleData, request]);

  if (!title && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      ref: ref,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(RequestCardPlaceholder, {})
    });
  }

  if (!requestData && !requestError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(RequestCardError, {});
  }

  if (!title || !requestData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(RequestCardError, {
      requestData: requestData
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      show: showEditModal,
      tmdbId: request.media.tmdbId,
      type: request.type,
      is4k: request.is4k,
      editRequest: request,
      onCancel: () => setShowEditModal(false),
      onComplete: () => {
        revalidate();
        setShowEditModal(false);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      className: "relative flex w-72 overflow-hidden rounded-xl bg-gray-800 bg-cover bg-center p-4 text-gray-400 shadow ring-1 ring-gray-700 sm:w-96",
      "data-testid": "request-card",
      children: [title.backdropPath && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: "absolute inset-0 z-0",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          alt: "",
          src: `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${title.backdropPath}`,
          layout: "fill",
          objectFit: "cover"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "absolute inset-0",
          style: {
            backgroundImage: 'linear-gradient(135deg, rgba(17, 24, 39, 0.47) 0%, rgba(17, 24, 39, 1) 75%)'
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: "relative z-10 flex min-w-0 flex-1 flex-col pr-4",
        "data-testid": "request-card-title",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "hidden text-xs font-medium text-white sm:flex",
          children: (isMovie(title) ? title.releaseDate : title.firstAirDate)?.slice(0, 4)
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
          href: request.type === 'movie' ? `/movie/${requestData.media.tmdbId}` : `/tv/${requestData.media.tmdbId}`,
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("a", {
            className: "overflow-hidden overflow-ellipsis whitespace-nowrap text-base font-bold text-white hover:underline sm:text-lg",
            children: isMovie(title) ? title.title : title.name
          })
        }), hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_VIEW */ .y3.REQUEST_VIEW], {
          type: 'or'
        }) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "card-field",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
            href: `/users/${requestData.requestedBy.id}`,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("a", {
              className: "group flex items-center",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("img", {
                src: requestData.requestedBy.avatar,
                alt: "",
                className: "avatar-sm object-cover"
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "truncate font-semibold group-hover:text-white group-hover:underline",
                children: requestData.requestedBy.displayName
              })]
            })
          })
        }), !isMovie(title) && request.seasons.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
          className: "my-0.5 hidden items-center text-sm sm:my-1 sm:flex",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
            className: "mr-2 font-bold ",
            children: intl.formatMessage(messages.seasons, {
              seasonCount: title.seasons.length === request.seasons.length ? 0 : request.seasons.length
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
            className: "hide-scrollbar overflow-x-scroll",
            children: request.seasons.map(season => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "mr-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                children: season.seasonNumber === 0 ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].specials */ .Z.specials) : season.seasonNumber
              })
            }, `season-${season.id}`))
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
          className: "mt-2 flex items-center text-sm sm:mt-1",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
            className: "mr-2 hidden font-bold sm:block",
            children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].status */ .Z.status)
          }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            badgeType: "danger",
            children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].declined */ .Z.declined)
          }) : requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.FAILED */ .pi.FAILED ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            badgeType: "danger",
            href: `/${requestData.type}/${requestData.media.tmdbId}?manage=1`,
            children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].failed */ .Z.failed)
          }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
            status: requestData.media[requestData.is4k ? 'status4k' : 'status'],
            downloadItem: requestData.media[requestData.is4k ? 'downloadStatus4k' : 'downloadStatus'],
            title: isMovie(title) ? title.title : title.name,
            inProgress: (requestData.media[requestData.is4k ? 'downloadStatus4k' : 'downloadStatus'] ?? []).length > 0,
            is4k: requestData.is4k,
            tmdbId: requestData.media.tmdbId,
            mediaType: requestData.type,
            plexUrl: requestData.is4k ? plexUrl4k : plexUrl,
            serviceUrl: requestData.is4k ? requestData.media.serviceUrl4k : requestData.media.serviceUrl
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
          className: "flex flex-1 items-end space-x-2",
          children: [requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.FAILED */ .pi.FAILED && hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            buttonType: "primary",
            buttonSize: "sm",
            disabled: isRetrying,
            onClick: () => retryRequest(),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.ArrowPathIcon, {
              className: isRetrying ? 'animate-spin' : '',
              style: {
                marginRight: '0',
                animationDirection: 'reverse'
              }
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "ml-1.5 hidden sm:block",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].retry */ .Z.retry)
            })]
          }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.PENDING */ .pi.PENDING && hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                buttonType: "success",
                buttonSize: "sm",
                className: "hidden sm:block",
                onClick: () => modifyRequest('approve'),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.CheckIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].approve */ .Z.approve)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                content: intl.formatMessage(messages.approverequest),
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  buttonType: "success",
                  buttonSize: "sm",
                  className: "sm:hidden",
                  onClick: () => modifyRequest('approve'),
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.CheckIcon, {})
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                buttonType: "danger",
                buttonSize: "sm",
                className: "hidden sm:block",
                onClick: () => modifyRequest('decline'),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.XMarkIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].decline */ .Z.decline)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                content: intl.formatMessage(messages.declinerequest),
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  buttonType: "danger",
                  buttonSize: "sm",
                  className: "sm:hidden",
                  onClick: () => modifyRequest('decline'),
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.XMarkIcon, {})
                })
              })]
            })]
          }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.PENDING */ .pi.PENDING && !hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && requestData.requestedBy.id === user?.id && (requestData.type === 'tv' || hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y3.REQUEST_ADVANCED)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            children: [!hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              buttonType: "primary",
              buttonSize: "sm",
              className: "hidden sm:block",
              onClick: () => setShowEditModal(true),
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.PencilIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].edit */ .Z.edit)
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
              content: intl.formatMessage(messages.editrequest),
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                buttonType: "primary",
                buttonSize: "sm",
                className: "sm:hidden",
                onClick: () => setShowEditModal(true),
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.PencilIcon, {})
              })
            })]
          }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.PENDING */ .pi.PENDING && !hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && requestData.requestedBy.id === user?.id && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              buttonType: "danger",
              buttonSize: "sm",
              className: "hidden sm:block",
              onClick: () => deleteRequest(),
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.XMarkIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].cancel */ .Z.cancel)
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
              content: intl.formatMessage(messages.cancelrequest),
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                buttonType: "danger",
                buttonSize: "sm",
                className: "sm:hidden",
                onClick: () => deleteRequest(),
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.XMarkIcon, {})
              })
            })]
          })]
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
        href: request.type === 'movie' ? `/movie/${requestData.media.tmdbId}` : `/tv/${requestData.media.tmdbId}`,
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("a", {
          className: "w-20 flex-shrink-0 scale-100 transform-gpu cursor-pointer overflow-hidden rounded-md shadow-sm transition duration-300 hover:scale-105 hover:shadow-md sm:w-28",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
            src: title.posterPath ? `https://image.tmdb.org/t/p/w600_and_h900_bestv2${title.posterPath}` : '/images/overseerr_poster_not_found.png',
            alt: "",
            layout: "responsive",
            width: 600,
            height: 900
          })
        })
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_20__/* .withProperties */ .W)(RequestCard, {
  Placeholder: RequestCardPlaceholder
}));
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 44627:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const useDeepLinks = ({
  plexUrl,
  plexUrl4k,
  iOSPlexUrl,
  iOSPlexUrl4k
}) => {
  const {
    0: returnedPlexUrl,
    1: setReturnedPlexUrl
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(plexUrl);
  const {
    0: returnedPlexUrl4k,
    1: setReturnedPlexUrl4k
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(plexUrl4k);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (/iPad|iPhone|iPod/.test(navigator.userAgent) || navigator.userAgent.includes('Mac') && navigator.maxTouchPoints > 1) {
      setReturnedPlexUrl(iOSPlexUrl);
      setReturnedPlexUrl4k(iOSPlexUrl4k);
    } else {
      setReturnedPlexUrl(plexUrl);
      setReturnedPlexUrl4k(plexUrl4k);
    }
  }, [iOSPlexUrl, iOSPlexUrl4k, plexUrl, plexUrl4k]);
  return {
    plexUrl: returnedPlexUrl,
    plexUrl4k: returnedPlexUrl4k
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDeepLinks);

/***/ })

};
;