"use strict";
exports.id = 35266;
exports.ids = [35266];
exports.modules = {

/***/ 35266:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Header__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76631);
/* harmony import */ var _app_components_Common_ListView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5339);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74449);
/* harmony import */ var _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38242);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86799);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(35635);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_ListView__WEBPACK_IMPORTED_MODULE_1__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, _app_pages_error__WEBPACK_IMPORTED_MODULE_5__]);
([_app_components_Common_ListView__WEBPACK_IMPORTED_MODULE_1__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, _app_pages_error__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);












const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.defineMessages)({
  discoverwatchlist: {
    "id": "components.Discover.DiscoverWatchlist.discoverwatchlist",
    "defaultMessage": 'Your Plex Watchlist'
  },
  watchlist: {
    "id": "components.Discover.DiscoverWatchlist.watchlist",
    "defaultMessage": 'Plex Watchlist'
  }
});

const DiscoverWatchlist = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.useIntl)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_7__.useRouter)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    user: currentUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .useUser */ .aF)();
  const {
    isLoadingInitialData,
    isEmpty,
    isLoadingMore,
    isReachingEnd,
    titles,
    fetchMore,
    error
  } = (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(`/api/v1/${router.pathname.startsWith('/profile') ? `user/${currentUser?.id}` : router.query.userId ? `user/${router.query.userId}` : 'discover'}/watchlist`);

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_5__["default"], {
      statusCode: 500
    });
  }

  const title = intl.formatMessage(router.query.userId ? messages.watchlist : messages.discoverwatchlist);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      title: [title, router.query.userId ? user?.displayName : '']
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
      className: "mt-1 mb-5",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Header__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        subtext: router.query.userId ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx((next_link__WEBPACK_IMPORTED_MODULE_6___default()), {
          href: `/users/${user?.id}`,
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("a", {
            className: "hover:underline",
            children: user?.displayName
          })
        }) : '',
        children: title
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_ListView__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      plexItems: titles,
      isEmpty: isEmpty,
      isLoading: isLoadingInitialData || isLoadingMore && (titles?.length ?? 0) > 0,
      isReachingEnd: isReachingEnd,
      onScrollBottom: fetchMore
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscoverWatchlist);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;