"use strict";
exports.id = 41466;
exports.ids = [41466];
exports.modules = {

/***/ 41466:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80210);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61929);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_5__]);
swr__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }








const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_3__.defineMessages)({
  originalLanguageDefault: {
    "id": "components.LanguageSelector.originalLanguageDefault",
    "defaultMessage": 'All Languages'
  },
  languageServerDefault: {
    "id": "components.LanguageSelector.languageServerDefault",
    "defaultMessage": 'Default ({language})'
  }
});
const selectStyles = {
  multiValueLabel: (base, props) => {
    return props.data?.isFixed ? _objectSpread(_objectSpread({}, base), {}, {
      paddingRight: 6
    }) : base;
  },
  multiValueRemove: (base, props) => {
    return props.data?.isFixed ? _objectSpread(_objectSpread({}, base), {}, {
      display: 'none'
    }) : base;
  }
};

const LanguageSelector = ({
  value,
  setFieldValue,
  serverValue,
  isUserSettings = false
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_3__.useIntl)();
  const {
    data: languages
  } = (0,swr__WEBPACK_IMPORTED_MODULE_5__["default"])('/api/v1/languages');
  const sortedLanguages = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
    languages?.forEach(language => {
      language.name = intl.formatDisplayName(language.iso_639_1, {
        type: 'language',
        fallback: 'none'
      }) ?? language.english_name;
    });
    return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.sortBy)(languages, 'name');
  }, [intl, languages]);

  const languageName = languageCode => sortedLanguages?.find(language => language.iso_639_1 === languageCode)?.name ?? languageCode;

  const options = sortedLanguages?.map(language => ({
    label: language.name,
    value: language.iso_639_1
  })) ?? [];

  if (isUserSettings) {
    options.unshift({
      value: 'server',
      label: intl.formatMessage(messages.languageServerDefault, {
        language: serverValue ? serverValue.split('|').map(value => languageName(value)).reduce((prev, curr) => intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_0__/* ["default"].delimitedlist */ .Z.delimitedlist, {
          a: prev,
          b: curr
        })) : intl.formatMessage(messages.originalLanguageDefault)
      }),
      isFixed: true
    });
  }

  options.unshift({
    value: 'all',
    label: intl.formatMessage(messages.originalLanguageDefault),
    isFixed: true
  });
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx((react_select__WEBPACK_IMPORTED_MODULE_4___default()), {
    options: options,
    isMulti: true,
    className: "react-select-container",
    classNamePrefix: "react-select",
    value: isUserSettings && value === 'all' || !isUserSettings && !value ? {
      value: 'all',
      label: intl.formatMessage(messages.originalLanguageDefault),
      isFixed: true
    } : (value === '' || !value || value === 'server') && isUserSettings ? {
      value: 'server',
      label: intl.formatMessage(messages.languageServerDefault, {
        language: serverValue ? serverValue.split('|').map(value => languageName(value)).reduce((prev, curr) => intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_0__/* ["default"].delimitedlist */ .Z.delimitedlist, {
          a: prev,
          b: curr
        })) : intl.formatMessage(messages.originalLanguageDefault)
      }),
      isFixed: true
    } : value?.split('|').map(code => {
      const matchedLanguage = sortedLanguages?.find(lang => lang.iso_639_1 === code);

      if (!matchedLanguage) {
        return undefined;
      }

      return {
        label: matchedLanguage.name,
        value: matchedLanguage.iso_639_1
      };
    }).filter(option => option !== undefined),
    onChange: (value, options) => {
      if (options && options.action === 'select-option' && options.option?.value === 'server' || value.every(v => v.value === 'server')) {
        return setFieldValue('originalLanguage', '');
      }

      if (options && options.action === 'select-option' && options.option?.value === 'all' || value.every(v => v.value === 'all')) {
        return setFieldValue('originalLanguage', isUserSettings ? 'all' : '');
      }

      setFieldValue('originalLanguage', value.map(lang => lang.value).filter(v => v !== 'all').join('|'));
    },
    styles: selectStyles
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguageSelector);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;